/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.report.form;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.tmc.fbp.common.enums.ReportOrgQueryWayEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public abstract class AbstractTmcOrgViewRptFormPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(AbstractTmcOrgViewRptFormPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getView().getControl(this.getFilterOrgField());
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit orgView = (BasedataEdit)this.getView().getControl(this.getFilterOrgViewField());
        orgView.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (ReportOrgQueryWayEnum.ORG.getValue().equals(this.getModel().getValue("filter_queryway"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{this.getFilterOrgViewField()});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{this.getFilterOrgViewField()});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("filter_queryway".equals(name)) {
            this.setOrgPropVisible();
        } else if (this.getFilterOrgViewField().equals(name)) {
            this.getModel().setValue(this.getFilterOrgField(), null);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String propKey = event.getProperty().getName();
        Long userId = RequestContext.get().getCurrUserId();
        ReportShowParameter parameter = (ReportShowParameter)this.getView().getFormShowParameter();
        ListShowParameter sp = (ListShowParameter)event.getFormShowParameter();
        if (propKey.equals(this.getFilterOrgViewField())) {
            QFilter filter = TmcOrgDataHelper.getBankOrgViewQFilter((Long)userId, (String)parameter.getAppId(), (String)parameter.getFormId(), (String)"47150e89000000ac");
            sp.getListFilterParameter().getQFilters().add(filter);
        } else if (propKey.equals(this.getFilterOrgField())) {
            String queryWay = (String)this.getModel().getValue("filter_queryway");
            if (ReportOrgQueryWayEnum.ORGVIEW.getValue().equals(queryWay)) {
                if (TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)this.getFilterOrgViewField())) {
                    Long orgViewId = ((DynamicObject)this.getModel().getValue(this.getFilterOrgViewField())).getLong("id");
                    List orgIds = TmcOrgDataHelper.getAllOrgIdsByViewId((Long)orgViewId);
                    logger.info("\u5f53\u524d\u7ec4\u7ec7\u89c6\u56fe\u7684\u6240\u6709\u7ec4\u7ec7:" + orgIds.toString());
                    List id = TmcOrgDataHelper.getAuthorizedBankOrgFromCache((Long)userId, (String)parameter.getAppId(), (String)parameter.getFormId(), (String)"47150e89000000ac").stream().map(s -> s.getLong("id")).collect(Collectors.toList());
                    logger.info("\u6709\u6743\u9650\u7684\u6240\u6709\u7ec4\u7ec7id:" + id.toString());
                    orgIds.retainAll(id);
                    logger.info("\u89c6\u56fe\u4e2d\u6709\u6743\u9650\u7684\u7ec4\u7ec7id:" + orgIds.toString());
                    QFilter filter = new QFilter("id", "in", (Object)orgIds);
                    sp.getListFilterParameter().getQFilters().add(filter);
                    DynamicObject orgview = (DynamicObject)this.getModel().getValue("filter_orgview");
                    if (EmptyUtil.isNoEmpty((DynamicObject)orgview)) {
                        sp.setCustomParam("orgViewSchemeNumber", (Object)orgview.getString("number"));
                    }
                } else {
                    event.setCancel(true);
                }
            } else if (ReportOrgQueryWayEnum.ORG.getValue().equals(queryWay)) {
                QFilter filter = TmcOrgDataHelper.getAuthorizedBankOrgFilter((Long)userId, (String)parameter.getAppId(), (String)parameter.getFormId(), (String)"47150e89000000ac");
                sp.getListFilterParameter().getQFilters().add(filter);
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        if (!TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"filter_queryway")) {
            return false;
        }
        ReportShowParameter parameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Long userId = RequestContext.get().getCurrUserId();
        if (ReportOrgQueryWayEnum.ORGVIEW.getValue().equals(this.getModel().getValue("filter_queryway"))) {
            Set selectOrgIds;
            BasedataProp basedataProp = (BasedataProp)this.getModel().getDataEntityType().getProperties().get((Object)this.getFilterOrgViewField());
            String displayName = basedataProp.getDisplayName().getLocaleValue();
            DynamicObject orgView = (DynamicObject)this.getModel().getValue(this.getFilterOrgViewField());
            if (basedataProp.isMustInput() && EmptyUtil.isEmpty((DynamicObject)orgView)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9%s\u3002", (String)"TmcTreeReportFormPlugin_0", (String)"tmc-fbp-report", (Object[])new Object[]{displayName}));
                return false;
            }
            List orgViewIdList = TmcOrgDataHelper.getAuthorizedBankOrgViewIds((Long)userId, (String)parameter.getAppId(), (String)parameter.getFormId(), (String)"47150e89000000ac");
            if (EmptyUtil.isEmpty((DynamicObject)orgView)) {
                return true;
            }
            HashSet orgViewIdSet = new HashSet(orgViewIdList);
            Long orgViewId = orgView.getLong("id");
            if (!orgViewIdSet.contains(orgViewId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u8be5\u7ec4\u7ec7\u89c6\u56fe\u6743\u9650\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TmcTreeReportFormPlugin_1", (String)"tmc-fbp-report", (Object[])new Object[0]));
                return false;
            }
            HashSet orgIds = new HashSet(TmcOrgDataHelper.getAllOrgIdsByViewId((Long)orgViewId));
            Set id = TmcOrgDataHelper.getAuthorizedBankOrgFromCache((Long)userId, (String)parameter.getAppId(), (String)parameter.getFormId(), (String)"47150e89000000ac").stream().map(s -> s.getLong("id")).collect(Collectors.toSet());
            orgIds.retainAll(id);
            DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue(this.getFilterOrgField());
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)orgs) && !orgIds.containsAll(selectOrgIds = orgs.stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet()))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6240\u9009\u8d44\u91d1\u7ec4\u7ec7\u6743\u9650\u6216\u6240\u9009\u8d44\u91d1\u7ec4\u7ec7\u5df2\u4e0d\u5728\u89c6\u56fe\u4e2d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u8d44\u91d1\u7ec4\u7ec7\u3002", (String)"TmcTreeReportFormPlugin_2", (String)"tmc-fbp-report", (Object[])new Object[0]));
                return false;
            }
        } else {
            Set selectOrgIds;
            Set orgIds = TmcOrgDataHelper.getAuthorizedBankOrgFromCache((Long)userId, (String)parameter.getAppId(), (String)parameter.getFormId(), (String)"47150e89000000ac").stream().map(s -> s.getLong("id")).collect(Collectors.toSet());
            DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue(this.getFilterOrgField());
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)orgs) && !orgIds.containsAll(selectOrgIds = orgs.stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet()))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6240\u9009\u8d44\u91d1\u7ec4\u7ec7\u6743\u9650\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TmcTreeReportFormPlugin_3", (String)"tmc-fbp-report", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        this.initToOrgIds(queryParam);
    }

    private void initToOrgIds(ReportQueryParam queryParam) {
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue(this.getFilterOrgField());
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)orgs)) {
            List orgIds = orgs.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
            queryParam.getFilter().getFilterItem(this.getFilterOrgField()).setValue(orgIds);
        }
    }

    private void setOrgPropVisible() {
        if (ReportOrgQueryWayEnum.ORG.getValue().equals(this.getModel().getValue("filter_queryway"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{this.getFilterOrgViewField()});
            TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{this.getFilterOrgViewField()});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{this.getFilterOrgViewField()});
            TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{this.getFilterOrgField()});
        }
    }

    protected abstract String getFilterOrgField();

    protected abstract String getFilterOrgViewField();
}

