/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.report.qing.data;

import com.alibaba.fastjson.JSON;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoException;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.qing.EntryEntity;
import kd.bos.entity.qing.Field;
import kd.bos.entity.qing.IQingDataProvider;
import kd.bos.entity.qing.QingData;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.entity.qing.QingMeta;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.sdk.tmc.fbp.extpoint.IQingReportSDKService;
import kd.tmc.fbp.common.enums.RptDateRangeEnum;
import kd.tmc.fbp.common.helper.SnapDataHelper;
import kd.tmc.fbp.common.snap.IDataSnapExecute;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractQingAnlsDataPlugin
extends AbstractFormPlugin
implements IQingDataProvider,
IDataSnapExecute {
    private static final Log logger = LogFactory.getLog(AbstractQingAnlsDataPlugin.class);
    protected static final String QING_SORT = "qingsort";

    public QingData getData(String qingPageId, int start, int limit) {
        IFormView view = SessionManager.getCurrent().getViewNoPlugin(qingPageId);
        SnapDataHelper.saveQueryParam((String)view.getFormShowParameter().getFormId(), null, (String)((Object)((Object)this)).getClass().getName(), (boolean)false);
        QingData qingData = new QingData();
        qingData.setDataindex(this.createDataIndex());
        String filterstr = this.getPageCache().get("qFilter");
        LinkedList<Object[]> data = new LinkedList<Object[]>();
        if (!EmptyUtil.isEmpty((String)filterstr)) {
            DataSet ds;
            Map filterParam = (Map)JSON.parseObject((String)filterstr, Map.class);
            filterParam = this.initSnapParam(filterParam);
            String snapItem = null;
            if (filterParam.containsKey("snapItem")) {
                snapItem = (String)filterParam.get("snapItem");
            }
            if (!EmptyUtil.isEmpty((Object)(ds = this.getQueryDataSet(qingPageId, filterParam, snapItem, start - 1, limit))) && ds.hasNext()) {
                Iterator it = ds.iterator();
                int sort = 0;
                List<Object[]> columns = this.getAllColumnItems();
                while (it.hasNext()) {
                    Row rs = (Row)it.next();
                    Object[] row = new Object[columns.size()];
                    for (int index = 0; index < columns.size(); ++index) {
                        Object[] column = columns.get(index);
                        String filed = (String)column[0];
                        if (QING_SORT.equals(filed)) {
                            row[index] = sort++;
                            continue;
                        }
                        Object value = rs.get(filed);
                        if (value != null && QingFieldType.Date.toNumber() == ((Integer)column[2]).intValue()) {
                            Date date = (Date)rs.get(filed);
                            value = date.getTime();
                        }
                        value = this.translateCellDisplay(filed, value, rs);
                        this.dealRowOtherValue(columns, rs);
                        row[index] = value;
                    }
                    data.add(row);
                }
            }
        }
        qingData.setRows(data);
        return qingData;
    }

    protected DataSet getQueryDataSet(String qingPageId, Map<String, Object> filterParam, String snapItem, int start, int limit) {
        if (EmptyUtil.isEmpty((String)snapItem)) {
            logger.info("-----------\u6267\u884c\u5b9e\u65f6\u8868\u6570\u636e\u67e5\u8be2-----------");
            return this.queryDataSet(qingPageId, filterParam, start, limit);
        }
        logger.info("-----------\u6267\u884c\u62a5\u8868\u5feb\u7167\u6570\u636e\u67e5\u8be2-----------");
        String formid = this.getView().getFormShowParameter().getFormId();
        return this.querySnapDataSet(formid, qingPageId, filterParam, snapItem, start, limit);
    }

    protected DataSet queryDataSet(String qingPageId, Map<String, Object> filterParam, int start, int limit) {
        CachedDataSet ds;
        if (start == 0) {
            ds = this.createCachedDataSet(qingPageId, filterParam);
        } else {
            try {
                ds = Algo.getCacheDataSet((String)qingPageId);
            }
            catch (AlgoException e) {
                ds = this.createCachedDataSet(qingPageId, filterParam);
            }
        }
        if (start == 0 && limit == 0) {
            return ds.toDataSet(Algo.create((String)"tmcQingAnlsDataSet"), false);
        }
        DataSetBuilder dataSetBuilder = Algo.create((String)"tmcQingAnlsDataSet").createDataSetBuilder(ds.getRowMeta());
        List dsList = ds.getList(start, limit);
        if (EmptyUtil.isEmpty((Collection)dsList)) {
            ds.close();
        }
        for (Row row : dsList) {
            dataSetBuilder.append(row);
        }
        return dataSetBuilder.build();
    }

    private CachedDataSet createCachedDataSet(String qingPageId, Map<String, Object> filterParam) {
        DataSet dataSet = this.getDataSetResult(filterParam);
        CacheHint hint = new CacheHint();
        hint.setTimeout((long)SnapDataHelper.getSnapCacheTime());
        hint.setCacheId(qingPageId);
        try {
            CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)qingPageId);
            cacheDataSet.close();
        }
        catch (Exception e) {
            logger.info("cacheDataSet is close");
        }
        return dataSet.cache(hint);
    }

    protected Map<String, Integer> createDataIndex() {
        List<Object[]> columnItems = this.getAllColumnItems();
        int presize = columnItems.size();
        HashMap<String, Integer> index = new HashMap<String, Integer>(presize);
        for (int k = 0; k < presize; ++k) {
            Object[] column = columnItems.get(k);
            index.put((String)column[0], k);
        }
        return index;
    }

    public QingMeta getMeta(String qingPageId) {
        QingMeta qingMeta = this.createColumnItems();
        return qingMeta;
    }

    private QingMeta createColumnItems() {
        QingMeta qingMeta = new QingMeta();
        qingMeta.addEntryEntity(this.createEntityMetas());
        for (Object[] column : this.getAllColumnItems()) {
            qingMeta.addColumn(this.createField((String)column[0], (String)column[1], (Integer)column[2], (Boolean)column[3]));
        }
        return qingMeta;
    }

    protected EntryEntity createEntityMetas() {
        EntryEntity entity = new EntryEntity();
        entity.setKey(this.getEntityName());
        entity.setName(new LocaleString(this.getEntityName()));
        entity.setPkFieldName(this.getFieldPK());
        return entity;
    }

    private Field createField(String key, String name, int fieldType, boolean hide) {
        Field field = new Field();
        field.setEntity(this.getEntityName());
        field.setKey(key);
        field.setName(new LocaleString(name));
        field.setFieldType(fieldType);
        field.setHide(hide);
        return field;
    }

    protected Map getQueryDate() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        String dateRange = (String)this.getModel().getValue("dateranges");
        if (!RptDateRangeEnum.CUSTOM.getValue().equals(dateRange)) {
            Date endDate = DateUtils.getNextDay((Date)DateUtils.getCurrentDate(), (int)1);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(endDate);
            if (RptDateRangeEnum.THISMONTH.getValue().equals(dateRange)) {
                calendar.add(2, -1);
            } else if (RptDateRangeEnum.THISQUARTER.getValue().equals(dateRange)) {
                calendar.add(2, -3);
            } else if (RptDateRangeEnum.SIXMONTH.getValue().equals(dateRange)) {
                calendar.add(2, -6);
            } else if (RptDateRangeEnum.ONEYEAR.getValue().equals(dateRange)) {
                calendar.add(1, -1);
            } else if (RptDateRangeEnum.TWOYEAR.getValue().equals(dateRange)) {
                calendar.add(1, -2);
            } else if (RptDateRangeEnum.THREEYEAR.getValue().equals(dateRange)) {
                calendar.add(1, -3);
            }
            Date beginDate = DateUtils.getDataFormat((Date)calendar.getTime(), (boolean)true);
            paramMap.put("startdate", beginDate);
            paramMap.put("enddate", endDate);
        } else {
            String beginDate = (String)this.getModel().getValue("dateranges_startdate");
            String endDate = (String)this.getModel().getValue("dateranges_enddate");
            paramMap.put("startdate", beginDate);
            paramMap.put("enddate", endDate);
        }
        return paramMap;
    }

    protected List<Object[]> getAllColumnItems() {
        PluginProxy pluginProxy = PluginProxy.create(IQingReportSDKService.class, (String)"kd.sdk.tmc.fbp.extpoint.IQingReportSDKService");
        List lists = pluginProxy.callReplace(p -> p.reBuildQingColumnItems(((Object)((Object)this)).getClass().getName(), this.getColumnItems()));
        if (EmptyUtil.isNoEmpty((Object)lists) && lists.size() > 0 && EmptyUtil.isNoEmpty(lists.get(0))) {
            return (List)lists.get(0);
        }
        return this.getColumnItems();
    }

    protected DataSet getDataSetResult(Map<String, Object> paramMap) {
        DataSet finalDataSet;
        DataSet dataSet = this.getDataSet(paramMap);
        PluginProxy pluginProxy = PluginProxy.create(IQingReportSDKService.class, (String)"kd.sdk.tmc.fbp.extpoint.IQingReportSDKService");
        List dataSetList = pluginProxy.callReplace(arg_0 -> this.lambda$getDataSetResult$1(finalDataSet = dataSet, paramMap, arg_0));
        if (EmptyUtil.isNoEmpty((Object)dataSetList) && dataSetList.size() > 0 && EmptyUtil.isNoEmpty(dataSetList.get(0))) {
            dataSet = (DataSet)dataSetList.get(0);
        }
        return dataSet;
    }

    protected abstract List<Object[]> getColumnItems();

    protected abstract DataSet getDataSet(Map<String, Object> var1);

    protected Map initSnapParam(Map<String, Object> paramMap) {
        return paramMap;
    }

    protected Object translateCellDisplay(String Field2, Object value, Row rs) {
        return value;
    }

    protected void dealRowOtherValue(List<Object[]> columns, Row rs) {
    }

    protected String getEntityName() {
        return this.getModel().getDataEntityType().getName();
    }

    protected String getFieldPK() {
        return "id";
    }

    public String getFilterParameter() {
        return this.getPageCache().get("qFilter");
    }

    public void setFilterParameter(String filterParameter) {
        this.getPageCache().put("qFilter", filterParameter);
    }

    public DataSet data(String formid, String schemeid, QFilter[] filters) throws Exception {
        logger.info("-----------\u6570\u636e\u5feb\u7167\u53d6\u6570\u63a5\u53e3 formid=" + formid + "; schemeid=" + schemeid);
        ReportQueryParam param = this.getQueryParam(formid, schemeid, "query");
        param = this.setFilter(param, filters);
        DataSet ds = this.getDataSetResult(SnapDataHelper.transQueryParam((ReportQueryParam)param));
        logger.info("-----------\u6570\u636e\u5feb\u7167\u53d6\u6570\u63a5\u53e3\u7ed3\u675f formid=" + formid + "; schemeid=" + schemeid);
        return ds;
    }

    public DataSet data(QFilter[] filters) throws Exception {
        logger.info("-----------\u53cd\u5c04\u8c03\u7528\u53d6\u6570\u63a5\u53e3\u5f00\u59cb");
        ReportQueryParam param = new ReportQueryParam();
        param = this.setFilter(param, filters);
        DataSet ds = this.getDataSetResult(SnapDataHelper.transQueryParam((ReportQueryParam)param));
        logger.info("-----------\u53cd\u5c04\u8c03\u7528\u53d6\u6570\u63a5\u53e3\u7ed3\u675f");
        return ds;
    }

    public void execute(String formid, String schemeid, QFilter[] filters, String batchno) throws Exception {
        logger.info("-----------\u6570\u636e\u5feb\u7167\u53d6\u6570\u63a5\u53e3 formid=" + formid + "; schemeid=" + schemeid + "; batchno=" + batchno);
        ReportQueryParam param = this.getQueryParam(formid, schemeid, batchno);
        param = this.setFilter(param, filters);
        DataSet ds = this.getDataSetResult(SnapDataHelper.transQueryParam((ReportQueryParam)param));
        Long orgId = ((DynamicObject)param.getFilter().getFilterItem("org").getValue()).getLong("id");
        SnapDataHelper.saveDataSet((String)formid, (Long)orgId, (String)batchno, (DataSet)ds, null);
        logger.info("-----------\u6570\u636e\u5feb\u7167\u53d6\u6570\u63a5\u53e3\u7ed3\u675f formid=" + formid + "; schemeid=" + schemeid + "; batchno=" + batchno);
    }

    protected ReportQueryParam getQueryParam(String formid, String schemeid, String batchno) throws Exception {
        return SnapDataHelper.getReportQueryParam((String)formid, (String)schemeid, (String)batchno);
    }

    protected ReportQueryParam setFilter(ReportQueryParam param, QFilter[] filters) {
        return param;
    }

    public DataSet querySnapDataSet(String formid, String qingPageId, Map<String, Object> filterParam, String snapItem, int start, int limit) {
        long beginTime = System.currentTimeMillis();
        logger.info("-----------formid:" + formid + ";  start:" + start + ";  limit-----------");
        DynamicObject org = null;
        Date queryDate = null;
        if (filterParam.containsKey("org")) {
            org = (DynamicObject)filterParam.get("org");
        }
        if (filterParam.containsKey("querydate")) {
            queryDate = (Date)filterParam.get("querydate");
        }
        Pair cacheData = SnapDataHelper.createCacheDataSet((String)formid, (Long)(org != null ? org.getLong("id") : 0L), (String)snapItem, (Date)queryDate);
        CachedDataSet ds = (CachedDataSet)cacheData.getRight();
        this.addTdaLogDesc((String)cacheData.getLeft());
        if (EmptyUtil.isEmpty((Object)ds)) {
            return this.queryDataSet(qingPageId, filterParam, start, limit);
        }
        DataSet snapDs = this.filterSnapDataSet(qingPageId, ds, start, limit);
        long endTime = System.currentTimeMillis();
        logger.info("-----------formid:" + formid + "; start:" + start + "; limit" + limit + "; \u8017\u65f6\uff1a" + (endTime - beginTime) + "ms-----------");
        return snapDs;
    }

    protected void addTdaLogDesc(String desc) {
    }

    protected DataSet filterSnapDataSet(String qingPageId, CachedDataSet snapDs, int start, int limit) {
        DataSet ds = snapDs.toDataSet(Algo.create((String)"filterSnapDataSet"), false);
        return ds.limit(start, limit);
    }

    private /* synthetic */ DataSet lambda$getDataSetResult$1(DataSet finalDataSet, Map paramMap, IQingReportSDKService p) {
        return p.reBuildQingDataSet(((Object)((Object)this)).getClass().getName(), finalDataSet, paramMap);
    }
}

