/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.bean;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.field.ComboItem;

public class EntityPropInfo {
    private String code;
    private String name;
    private String parentCode;
    private Set<EntityPropInfo> props = new LinkedHashSet<EntityPropInfo>(8);

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getParentCode() {
        return this.parentCode;
    }

    public EntityPropInfo setParentCode(String parentCode) {
        this.parentCode = parentCode;
        return this;
    }

    public ComboItem convertComboItem() {
        return new ComboItem(new LocaleString(String.format("%s(%s)", this.name, this.code)), this.code);
    }

    public static EntityPropInfo build(String code, String name) {
        return EntityPropInfo.build(null, code, name);
    }

    public static EntityPropInfo build(String parentCode, String code, String name) {
        EntityPropInfo info = new EntityPropInfo();
        info.parentCode = parentCode;
        info.code = code;
        info.name = name;
        return info;
    }

    public EntityPropInfo addProp(String number, String name) {
        this.props.add(EntityPropInfo.build(number, name));
        return this;
    }

    public String getQueryProps() {
        return this.props.stream().map(p -> p.getCode() + " as " + p.getName()).collect(Collectors.joining(","));
    }

    public Set<EntityPropInfo> getProps() {
        return this.props;
    }
}

