/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.compare.api.transfer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.fbp.common.compare.api.bean.CompareRuleBean;
import kd.tmc.fbp.common.compare.api.bean.CompareRuleConfigBean;
import kd.tmc.fbp.common.compare.api.loader.CompareDataLoaderFactory;
import kd.tmc.fbp.common.compare.api.loader.ICompareDataLoader;
import kd.tmc.fbp.common.compare.config.CompareRuleEnum;
import kd.tmc.fbp.common.compare.data.CompareRule;
import kd.tmc.fbp.common.util.DateUtils;

public class CompareDataTransfer {
    private CompareRuleBean compareRule;

    public CompareDataTransfer(CompareRuleBean compareRule) {
        this.compareRule = compareRule;
    }

    public List<List<CompareRule>> transCompareRule() {
        return this.compareRule.getConfigList().stream().map(o -> o.stream().map(t -> {
            CompareRule rule = new CompareRule();
            rule.setPropNameSrc(t.getSrcProp());
            rule.setPropNameTgt(t.getTarProp());
            rule.setExtraVal(t.getExtraVal());
            rule.setNullMatch(t.isNullMatch());
            if (t.isAllNullMatch() != null) {
                rule.setAllNullMatch(t.isAllNullMatch());
            } else if (t.isNullMatch()) {
                rule.setAllNullMatch(true);
            }
            rule.setSymbol(CompareRuleEnum.fromVal(t.getRelation()).getSymbol());
            return rule;
        }).collect(Collectors.toList())).collect(Collectors.toList());
    }

    public List<Map<String, Object>> transSrcData(List<Object> idList) {
        List<List<CompareRuleConfigBean>> configList = this.compareRule.getConfigList();
        Set<String> fieldSet = configList.stream().flatMap(Collection::stream).map(CompareRuleConfigBean::getSrcProp).collect(Collectors.toSet());
        return this.transData(this.compareRule.getSrcEntityType(), idList, fieldSet);
    }

    public List<Map<String, Object>> transTarData(List<Object> idList) {
        List<List<CompareRuleConfigBean>> configList = this.compareRule.getConfigList();
        Set<String> fieldSet = configList.stream().flatMap(Collection::stream).map(CompareRuleConfigBean::getTarProp).collect(Collectors.toSet());
        return this.transData(this.compareRule.getTarEntityType(), idList, fieldSet);
    }

    private List<Map<String, Object>> transData(String entityType, List<Object> idList, Set<String> fieldList) {
        fieldList.add("id");
        ICompareDataLoader dataLoader = CompareDataLoaderFactory.create(idList.size());
        List<DynamicObject> dataList = dataLoader.loadData(entityType, idList, fieldList);
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(dataList.size());
        for (DynamicObject data : dataList) {
            HashMap<String, Object> result = new HashMap<String, Object>(fieldList.size());
            for (String field : fieldList) {
                Object fieldVal = data.get(field);
                if (fieldVal instanceof Date) {
                    fieldVal = DateUtils.formatString((Date)fieldVal, "yyyy-MM-dd");
                }
                result.put(field, fieldVal);
            }
            resultList.add(result);
        }
        return resultList;
    }
}

