/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.compare.comparator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.compare.comparator.AbstractComparator;
import kd.tmc.fbp.common.compare.data.ComparePropValue;
import kd.tmc.fbp.common.compare.data.CompareRule;
import kd.tmc.fbp.common.compare.result.CompareResult;
import kd.tmc.fbp.common.compare.result.CompareUnitResult;
import kd.tmc.fbp.common.enums.MatchRelEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class AmountEqualsComparator
extends AbstractComparator {
    private static final Log logger = LogFactory.getLog(AmountEqualsComparator.class);

    @Override
    public List<CompareUnitResult> compare(Set<ComparePropValue> srcValList, Set<ComparePropValue> tarValList, CompareRule rule) {
        Set<Object> srcIdSet = srcValList.stream().map(ComparePropValue::getId).collect(Collectors.toSet());
        Set<Object> tarIdSet = tarValList.stream().map(ComparePropValue::getId).collect(Collectors.toSet());
        CompareUnitResult compareResult = new CompareUnitResult(srcIdSet, tarIdSet);
        ArrayList<CompareUnitResult> results = new ArrayList<CompareUnitResult>(10);
        results.add(compareResult);
        return results;
    }

    public List<CompareResult> notOneToOneCompare(Set<ComparePropValue> srcValList, Set<ComparePropValue> tarValList, String matchRel) {
        logger.info("matchRel: {}, \u5904\u74061\u5bf9\u591a\u3001\u591a\u5bf91\u7ed3\u679c\u96c6\uff0csrcValList: {}, tarValList: {}", new Object[]{matchRel, srcValList, tarValList});
        ArrayList<CompareResult> resultList = new ArrayList<CompareResult>();
        if (MatchRelEnum.ONE_TO_MANY.getValue().equals(matchRel)) {
            this.doCompare(srcValList, tarValList, resultList, false);
        } else if (MatchRelEnum.MANY_TO_ONE.getValue().equals(matchRel)) {
            this.doCompare(tarValList, srcValList, resultList, true);
        }
        logger.info("matchRel: {}, \u5904\u74061\u5bf9\u591a\u3001\u591a\u5bf91\u7ed3\u679c\u96c6\uff1a{}", (Object)matchRel, resultList);
        return resultList;
    }

    private void doCompare(Set<ComparePropValue> srcValList, Set<ComparePropValue> tarValList, List<CompareResult> resultList, boolean isReverse) {
        if (srcValList.size() > 0) {
            CompareResult unitResult;
            BigDecimal value;
            ArrayList<ComparePropValue> succSrcValues = new ArrayList<ComparePropValue>(srcValList.size());
            for (ComparePropValue srcVal : srcValList) {
                value = this.getBigDecimalValue(srcVal.getData());
                ComparePropValue sameValueTar = tarValList.stream().filter(v -> value.compareTo(new BigDecimal(String.valueOf(v.getData()))) == 0).findAny().orElse(null);
                if (!EmptyUtil.isNoEmpty(sameValueTar)) continue;
                unitResult = new CompareResult();
                if (isReverse) {
                    unitResult.setSrcIdSet(Collections.singleton(sameValueTar.getId()));
                    unitResult.setTarIdSet(Collections.singleton(srcVal.getId()));
                } else {
                    unitResult.setSrcIdSet(Collections.singleton(srcVal.getId()));
                    unitResult.setTarIdSet(Collections.singleton(sameValueTar.getId()));
                }
                succSrcValues.add(srcVal);
                tarValList.remove(sameValueTar);
                resultList.add(unitResult);
            }
            succSrcValues.forEach(srcValList::remove);
            for (ComparePropValue srcVal : srcValList) {
                BigDecimal totalAmount;
                value = this.getBigDecimalValue(srcVal.getData());
                if (value.compareTo(totalAmount = tarValList.stream().map(o -> new BigDecimal(String.valueOf(o.getData()))).reduce(BigDecimal.ZERO, BigDecimal::add)) != 0) continue;
                unitResult = new CompareResult();
                if (isReverse) {
                    unitResult.setSrcIdSet(tarValList.stream().map(ComparePropValue::getId).collect(Collectors.toSet()));
                    unitResult.setTarIdSet(Collections.singleton(srcVal.getId()));
                } else {
                    unitResult.setSrcIdSet(Collections.singleton(srcVal.getId()));
                    unitResult.setTarIdSet(tarValList.stream().map(ComparePropValue::getId).collect(Collectors.toSet()));
                }
                resultList.add(unitResult);
            }
        }
    }

    private BigDecimal getBigDecimalValue(Object val) {
        return null != val ? new BigDecimal(val.toString()) : BigDecimal.ZERO;
    }
}

