/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.compare.comparator;

import kd.bos.dataentity.resource.ResManager;
import kd.tmc.fbp.common.compare.CompareException;
import kd.tmc.fbp.common.compare.comparator.AmountEqualsComparator;
import kd.tmc.fbp.common.compare.comparator.ConstComparator;
import kd.tmc.fbp.common.compare.comparator.DateDiffComparator;
import kd.tmc.fbp.common.compare.comparator.IComparator;
import kd.tmc.fbp.common.compare.comparator.StringEqualsComparator;
import kd.tmc.fbp.common.compare.comparator.TrieComparator;
import kd.tmc.fbp.common.compare.data.CompareRule;
import kd.tmc.fbp.common.enums.MatchRelEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ComparatorFactory {
    public static IComparator getComparator(CompareRule rule) {
        return ComparatorFactory.getComparator(rule, null);
    }

    public static IComparator getComparator(CompareRule rule, String matchRel) {
        switch (rule.getSymbol()) {
            case DATE_DIFF: {
                return new DateDiffComparator();
            }
            case STR_MATCH: {
                return new TrieComparator();
            }
            case EQUALS: {
                if (rule.isAmountMatch() && EmptyUtil.isNoEmpty(matchRel) && !MatchRelEnum.ONE_TO_ONE.getValue().equals(matchRel)) {
                    return new AmountEqualsComparator();
                }
                return new StringEqualsComparator();
            }
            case CONST: {
                return new ConstComparator();
            }
        }
        throw new CompareException(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u7684\u8868\u8fbe\u7b26\u7c7b\u578b\u3002", (String)"ComparatorFactory_0", (String)"tmc-fbp-common", (Object[])new Object[0]));
    }
}

