/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.compare.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.common.compare.CompareException;

public class MultiThreadOperationExecutor<T, R> {
    private static Log logger = LogFactory.getLog(MultiThreadOperationExecutor.class);
    private static ExecutorService service = ThreadPools.newCachedExecutorService((String)MultiThreadOperationExecutor.class.getName());
    private static final int MAX_THREAD_CNT = 8;

    public List<R> doBatchOperation(List<T> dataList, int threadCnt, MultiThreadOperation<T, R> operation) {
        logger.info("\u6267\u884c\u591a\u7ebf\u7a0b\u8ba1\u7b97, \u7ebf\u7a0b\u6570:" + threadCnt + ", \u6570\u636e\u603b\u91cf:" + dataList.size());
        threadCnt = Math.min(threadCnt, 8);
        ArrayList resultList = new ArrayList();
        int totalSize = dataList.size();
        threadCnt = totalSize < threadCnt ? totalSize : threadCnt;
        int perSize = totalSize / threadCnt;
        if (totalSize % threadCnt > 0) {
            ++perSize;
        }
        int startIndex = 0;
        ArrayList<Future<List>> futureList = new ArrayList<Future<List>>(threadCnt);
        for (int i = 0; i < threadCnt; ++i) {
            int n = i == threadCnt - 1 ? totalSize : (startIndex + perSize > totalSize ? totalSize : startIndex + perSize);
            List<T> currList = dataList.subList(startIndex, n);
            RequestContext context = RequestContext.get();
            Future<List> future = service.submit(() -> {
                RequestContext.copyAndSet((RequestContext)context);
                List result = operation.doOperation(currList);
                return result;
            });
            futureList.add(future);
            startIndex = n;
        }
        try {
            for (Future future : futureList) {
                List results = (List)future.get();
                if (results == null) continue;
                resultList.addAll(results);
            }
            return resultList;
        }
        catch (Exception e) {
            throw new CompareException(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    public static interface MultiThreadOperation<T, R> {
        public List<R> doOperation(List<T> var1);
    }
}

