/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.compare.config;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.ComboItem;
import kd.tmc.fbp.common.compare.data.CompareRule;
import kd.tmc.fbp.common.enums.MultiLangEnumBridge;

public enum CompareRuleEnum {
    EQUALS(new MultiLangEnumBridge("\u7b49\u4e8e", "CompareRuleEnum_0", "tmc-fbp-common"), "equals", new MultiLangEnumBridge("\u7b49\u4e8e", "CompareRuleEnum_0", "tmc-fbp-common"), CompareRule.Symbol.EQUALS),
    LIKE(new MultiLangEnumBridge("\u6a21\u7cca\u5339\u914d", "CompareRuleEnum_1", "tmc-fbp-common"), "like", new MultiLangEnumBridge("\u6a21\u7cca\u5339\u914d", "CompareRuleEnum_1", "tmc-fbp-common"), CompareRule.Symbol.STR_MATCH),
    DIFF(new MultiLangEnumBridge("\u76f8\u5dee\u5c0f\u4e8e", "CompareRuleEnum_2", "tmc-fbp-common"), "diff", new MultiLangEnumBridge("\u76f8\u5dee\u5c0f\u4e8e%s\u5929", "CompareRuleEnum_4", "tmc-fbp-common"), CompareRule.Symbol.DATE_DIFF);

    private MultiLangEnumBridge nameBridge;
    private String value;
    private MultiLangEnumBridge formatBridge;
    private CompareRule.Symbol symbol;

    private CompareRuleEnum(MultiLangEnumBridge nameBridge, String value, MultiLangEnumBridge formatBridge, CompareRule.Symbol symbol) {
        this.nameBridge = nameBridge;
        this.value = value;
        this.formatBridge = formatBridge;
        this.symbol = symbol;
    }

    public static List<ComboItem> transToComboItems() {
        return Arrays.stream(CompareRuleEnum.values()).map(o -> new ComboItem(new LocaleString(o.getName()), o.value)).collect(Collectors.toList());
    }

    public static CompareRuleEnum fromVal(String value) {
        if (value == null) {
            return null;
        }
        return Arrays.stream(CompareRuleEnum.values()).filter(o -> o.value.equals(value)).findFirst().orElseGet(() -> null);
    }

    public String getFormatName(Object ... extraVal) {
        if (extraVal == null || extraVal.length == 1 && extraVal[0] == null) {
            return this.formatBridge.loadKDString();
        }
        return String.format(this.formatBridge.loadKDString(), extraVal);
    }

    public void validateExtraVal(String extraVal) {
        if (DIFF == this) {
            boolean isLegal = true;
            try {
                int val = Integer.parseInt(extraVal);
                if (val <= 0 || val > 30) {
                    isLegal = false;
                }
            }
            catch (Exception e) {
                isLegal = false;
            }
            if (!isLegal) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u5dee\u89c4\u5219\u4ec5\u652f\u6301\u8f93\u51651-30\u7684\u53c2\u6570\u503c", (String)"CompareRuleEnum_3", (String)"tmc-fbp-common", (Object[])new Object[0]));
            }
        }
    }

    public String getName() {
        return this.nameBridge.loadKDString();
    }

    public String getValue() {
        return this.value;
    }

    public CompareRule.Symbol getSymbol() {
        return this.symbol;
    }
}

