/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.compare.result;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.tmc.fbp.common.compare.CompareUnit;
import kd.tmc.fbp.common.compare.StopWatchWithSummary;
import kd.tmc.fbp.common.compare.concurrent.MultiThreadOperationExecutor;
import kd.tmc.fbp.common.compare.result.CompareUnitResult;

public class CompareUnitResultCalcModel {
    private List<CompareUnitResult> resultList;
    private Map<Object, List<Integer>> srcIndexMap;

    private CompareUnitResultCalcModel(List<CompareUnitResult> resultList) {
        this.resultList = resultList;
    }

    public static Map<Object, Set<Object>> calc(List<CompareUnit> compareUnitList) {
        StopWatchWithSummary watch = StopWatchWithSummary.createUnstarted();
        watch.start(ResManager.loadKDString((String)"\u521b\u5efa\u5408\u5e76\u7ed3\u679c\u96c6\u7b97\u6cd5\u6a21\u578b", (String)"CompareUnitResultCalcModel_0", (String)"tmc-fbp-common", (Object[])new Object[0]));
        ArrayList<CompareUnitResultCalcModel> calcList = new ArrayList<CompareUnitResultCalcModel>(compareUnitList.size());
        for (CompareUnit compareUnit : compareUnitList) {
            List<CompareUnitResult> unitResult = compareUnit.getResult();
            CompareUnitResultCalcModel calcModel = new CompareUnitResultCalcModel(unitResult);
            calcModel.buildSrcIndex();
            calcList.add(calcModel);
        }
        calcList.sort(Comparator.comparingInt(CompareUnitResultCalcModel::getWeight));
        HashMap<Object, Set<Object>> resultMap = new HashMap<Object, Set<Object>>();
        watch.nextStep(ResManager.loadKDString((String)"\u5408\u5e76\u7ed3\u679c\u96c6", (String)"CompareUnitResultCalcModel_1", (String)"tmc-fbp-common", (Object[])new Object[0]));
        if (calcList.size() > 0) {
            List<Map<Object, Set<Object>>> resultList;
            CompareUnitResultCalcModel firstModel = (CompareUnitResultCalcModel)calcList.get(0);
            Map<Object, List<Integer>> srcIndexMap = firstModel.getSrcIndexMap();
            ArrayList<Object> tarIdList = new ArrayList<Object>(srcIndexMap.keySet());
            if (tarIdList.size() > 3000) {
                int threadCnt = Runtime.getRuntime().availableProcessors() * 2;
                resultList = new MultiThreadOperationExecutor().doBatchOperation(tarIdList, threadCnt, dataList -> {
                    Map<Object, Set<Object>> result = CompareUnitResultCalcModel.combine(dataList, calcList);
                    return Collections.singletonList(result);
                });
            } else {
                resultList = Collections.singletonList(CompareUnitResultCalcModel.combine(tarIdList, calcList));
            }
            for (Map<Object, Set<Object>> result : resultList) {
                resultMap.putAll(result);
            }
        }
        watch.printSummary();
        return resultMap;
    }

    private static Map<Object, Set<Object>> combine(List<Object> keySet, List<CompareUnitResultCalcModel> calcList) {
        HashMap<Object, Set<Object>> resultMap = new HashMap<Object, Set<Object>>();
        block0: for (Object key : keySet) {
            LinkedList<Set> waitIntersectSrcSetList = new LinkedList<Set>();
            for (CompareUnitResultCalcModel model : calcList) {
                List<Integer> srcIndexList = model.getSrcIndexMap().get(key);
                if (srcIndexList == null) continue block0;
                int totalCnt = 0;
                for (Integer index : srcIndexList) {
                    Set<Object> currSrcSet = model.getResultList().get(index).getSrcIdSet();
                    totalCnt += currSrcSet.size();
                }
                HashSet<Object> srcSet = new HashSet<Object>(totalCnt);
                for (Integer index : srcIndexList) {
                    Set<Object> currSrcSet = model.getResultList().get(index).getSrcIdSet();
                    srcSet.addAll(currSrcSet);
                }
                waitIntersectSrcSetList.add(srcSet);
            }
            waitIntersectSrcSetList.sort(Comparator.comparingInt(Set::size));
            Iterator it = waitIntersectSrcSetList.iterator();
            if (!it.hasNext()) continue;
            Set firstSet = (Set)it.next();
            if (!it.hasNext()) continue;
            while (it.hasNext()) {
                firstSet.retainAll((Collection)it.next());
            }
            if (firstSet.size() <= 0) continue;
            resultMap.put(key, firstSet);
        }
        return resultMap;
    }

    private Map<Object, List<Integer>> getSrcIndexMap() {
        return this.srcIndexMap;
    }

    private int getWeight() {
        return this.srcIndexMap.size();
    }

    private void buildSrcIndex() {
        int cnt = 0;
        for (CompareUnitResult result : this.resultList) {
            cnt += result.getTarIdSet().size();
        }
        this.srcIndexMap = new HashMap<Object, List<Integer>>(cnt);
        for (int i = 0; i < this.resultList.size(); ++i) {
            CompareUnitResult result;
            result = this.resultList.get(i);
            Set<Object> tarIdSet = result.getTarIdSet();
            for (Object tarId : tarIdSet) {
                List indexList = this.srcIndexMap.computeIfAbsent(tarId, t -> new ArrayList());
                if (tarIdSet.size() == 0) continue;
                indexList.add(i);
            }
        }
    }

    public List<CompareUnitResult> getResultList() {
        return this.resultList;
    }
}

