/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.compare.strategy;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.compare.result.CompareResult;

public class MultiResultHandler {
    private static MultiResultHandler instance;

    private MultiResultHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MultiResultHandler getInstance() {
        Class<MultiResultHandler> clazz = MultiResultHandler.class;
        synchronized (MultiResultHandler.class) {
            if (instance == null) {
                instance = new MultiResultHandler();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void main(String[] args) {
    }

    public void handleMultiResult(List<CompareResult> resultList) {
        HashMap<Object, Set> srcResultMap = new HashMap<Object, Set>();
        HashMap<Object, Set> tarResultMap = new HashMap<Object, Set>();
        for (CompareResult compareResult : resultList) {
            Set comparedIdSet;
            Set<Object> set = compareResult.getSrcIdSet();
            Set<Object> tarIdSet = compareResult.getTarIdSet();
            for (Object srcId : set) {
                comparedIdSet = srcResultMap.computeIfAbsent(srcId, o -> new HashSet());
                comparedIdSet.addAll(tarIdSet);
            }
            for (Object tarId : tarIdSet) {
                comparedIdSet = tarResultMap.computeIfAbsent(tarId, o -> new HashSet());
                comparedIdSet.addAll(set);
            }
        }
        HashSet<MultiResult> multiResultSet = new HashSet<MultiResult>(10);
        for (Map.Entry entry : tarResultMap.entrySet()) {
            Set srcIdSet = (Set)entry.getValue();
            if (srcIdSet.size() <= 1) continue;
            ArrayList<CalcModel> calcModelList = new ArrayList<CalcModel>();
            for (Object srcId : srcIdSet) {
                Set tarIdSet = (Set)srcResultMap.get(srcId);
                if (tarIdSet == null || tarIdSet.size() <= 0) continue;
                calcModelList.add(new CalcModel(srcId, tarIdSet));
            }
            MultiResult multiResult = this.computeMaxMultiResult(calcModelList);
            multiResult.savePath();
            multiResultSet.add(multiResult);
        }
        LinkedList<MultiResult> linkedList = new LinkedList<MultiResult>(multiResultSet);
        ArrayList<MultiResult> arrayList = new ArrayList<MultiResult>(10);
        boolean hasMore = linkedList.stream().anyMatch(o -> o.getSize() > 1);
        linkedList.sort(Comparator.comparingInt(MultiResult::getSize).reversed());
        while (hasMore) {
            MultiResult maxRes = (MultiResult)linkedList.pop();
            arrayList.add(maxRes);
            for (MultiResult res : linkedList) {
                Set<Object> srcSet = res.getSrcIdSet();
                Set<Object> tarSet = res.getTarIdSet();
                srcSet.removeAll(maxRes.getSrcIdSet());
                tarSet.removeAll(maxRes.getTarIdSet());
            }
            linkedList.removeIf(o -> o.getSize() <= 1);
            hasMore = linkedList.size() > 0;
        }
        ArrayList<CompareResult> waitRemoveResultList = new ArrayList<CompareResult>();
        HashSet<Object> srcIdSet = new HashSet<Object>();
        HashSet<Object> tarIdSet = new HashSet<Object>();
        for (MultiResult multiResult : arrayList) {
            srcIdSet.addAll(multiResult.getSrcIdSet());
            tarIdSet.addAll(multiResult.getTarIdSet());
        }
        for (CompareResult compareResult : resultList) {
            compareResult.getSrcIdSet().removeAll(srcIdSet);
            compareResult.getTarIdSet().removeAll(tarIdSet);
            if (compareResult.getSrcIdSet().size() != 0 && compareResult.getTarIdSet().size() != 0) continue;
            waitRemoveResultList.add(compareResult);
        }
        resultList.removeAll(waitRemoveResultList);
        resultList.addAll(arrayList.stream().map(o -> new CompareResult(o.getTarIdSet(), o.getSrcIdSet(), true)).collect(Collectors.toList()));
    }

    private MultiResult recursion(List<CalcModel> currModelList, Map<String, Set<Object>> intersectCache, Deque<Object> path, MultiResult maxResult) {
        for (int i = 0; i < currModelList.size(); ++i) {
            int currMaxSize;
            String currCacheKey = this.getCacheKey(path);
            Set<Object> currRes = intersectCache.get(currCacheKey);
            CalcModel calcModel = currModelList.remove(i);
            path.push(calcModel.getSrcId());
            String cacheKey = this.getCacheKey(path);
            Set<Object> intersectRes = intersectCache.get(cacheKey);
            if (intersectRes == null) {
                intersectRes = new HashSet<Object>();
                intersectCache.put(cacheKey, intersectRes);
                if (path.size() == 1) {
                    intersectRes.addAll(calcModel.getTarIdSet());
                } else {
                    intersectRes.addAll((Collection<Object>)Sets.intersection(currRes, calcModel.getTarIdSet()));
                }
            }
            if ((currMaxSize = Math.min(intersectRes.size(), path.size())) > maxResult.getSize()) {
                maxResult = this.recursion(currModelList, intersectCache, path, new MultiResult(new HashSet<Object>(path), new HashSet<Object>(intersectRes)));
            }
            currModelList.add(i, calcModel);
            path.pop();
        }
        return maxResult;
    }

    private MultiResult computeMaxMultiResult(List<CalcModel> calcModelList) {
        HashMap<String, Set<Object>> intersectCache = new HashMap<String, Set<Object>>();
        LinkedList<Object> path = new LinkedList<Object>();
        intersectCache.put(this.getCacheKey(path), new HashSet());
        return this.recursion(calcModelList, intersectCache, path, new MultiResult());
    }

    private String getCacheKey(Deque<Object> path) {
        List sortedList = path.stream().map(Object::toString).sorted().collect(Collectors.toList());
        return String.join((CharSequence)",", sortedList);
    }

    private static class MultiResult {
        private Set<Object> srcIdSet;
        private Set<Object> tarIdSet;
        private String path;

        public MultiResult() {
        }

        public MultiResult(Set<Object> srcIdSet, Set<Object> tarIdSet) {
            this.srcIdSet = srcIdSet;
            this.tarIdSet = tarIdSet;
        }

        public Set<Object> getSrcIdSet() {
            return this.srcIdSet;
        }

        public void setSrcIdSet(Set<Object> srcIdSet) {
            this.srcIdSet = srcIdSet;
        }

        public Set<Object> getTarIdSet() {
            return this.tarIdSet;
        }

        public void setTarIdSet(Set<Object> tarIdSet) {
            this.tarIdSet = tarIdSet;
        }

        public int getSize() {
            int srcSize = this.srcIdSet == null ? 0 : this.srcIdSet.size();
            int tarSize = this.tarIdSet == null ? 0 : this.tarIdSet.size();
            return Math.min(srcSize, tarSize);
        }

        public void savePath() {
            if (this.srcIdSet != null) {
                List sortedList = this.srcIdSet.stream().map(Object::toString).sorted().collect(Collectors.toList());
                this.path = String.join((CharSequence)",", sortedList);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MultiResult that = (MultiResult)o;
            return Objects.equals(this.path, that.path);
        }

        public int hashCode() {
            return Objects.hash(this.path);
        }
    }

    private static class CalcModel {
        private Object srcId;
        private Set<Object> tarIdSet;

        public CalcModel(Object srcId, Set<Object> tarIdSet) {
            this.srcId = srcId;
            this.tarIdSet = tarIdSet;
        }

        public Object getSrcId() {
            return this.srcId;
        }

        public void setSrcId(Object srcId) {
            this.srcId = srcId;
        }

        public Set<Object> getTarIdSet() {
            return this.tarIdSet;
        }

        public void setTarIdSet(Set<Object> tarIdSet) {
            this.tarIdSet = tarIdSet;
        }
    }
}

