/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.compare.strategy;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.compare.data.CompareData;
import kd.tmc.fbp.common.compare.data.CompareRule;
import kd.tmc.fbp.common.compare.result.CompareResult;
import kd.tmc.fbp.common.compare.strategy.AbstractMultiRuleCompareStrategy;

public class MultiRuleOneToOneLevelUpCompareStrategy
extends AbstractMultiRuleCompareStrategy {
    public MultiRuleOneToOneLevelUpCompareStrategy(List<List<CompareRule>> ruleList) {
        super(ruleList);
    }

    @Override
    protected void handleResult(List<CompareResult> successList, List<CompareResult> resultList, List<CompareData> srcDataList, List<CompareData> tarDataList) {
        HashMap<Object, Integer> srcIdPresentCntMap = new HashMap<Object, Integer>();
        for (CompareResult result : resultList) {
            Set<Object> srcIdSet = result.getSrcIdSet();
            for (Object object : srcIdSet) {
                Integer pCnt = srcIdPresentCntMap.computeIfAbsent(object, t -> 0);
                int tarSize = result.getTarIdSet().size();
                srcIdPresentCntMap.put(object, pCnt + tarSize);
            }
        }
        HashSet<Object> waitRemoveSrcIdSet = new HashSet<Object>();
        HashSet<Object> waitRemoveTarIdSet = new HashSet<Object>();
        ArrayList<CompareResult> waitRemoveResultList = new ArrayList<CompareResult>();
        HashMap<Object, Integer> tarIdPresentCntMap = new HashMap<Object, Integer>();
        for (CompareResult result : resultList) {
            Set<Object> tarIdSet = result.getTarIdSet();
            for (Object object : tarIdSet) {
                Integer pCnt = srcIdPresentCntMap.computeIfAbsent(object, t -> 0);
                int srcSize = result.getSrcIdSet().size();
                tarIdPresentCntMap.put(object, pCnt + srcSize);
            }
        }
        Set<Object> set = srcIdPresentCntMap.entrySet().stream().filter(o -> (Integer)o.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toSet());
        HashSet<Object> successSrcId = new HashSet<Object>();
        HashSet<Object> successTarId = new HashSet<Object>();
        for (CompareResult compareResult : resultList) {
            HashSet<Object> matchedSrcIdSet = new HashSet<Object>();
            Set<Object> srcIdSet = compareResult.getSrcIdSet();
            if (compareResult.getTarIdSet().size() == 0) continue;
            for (Object srcId : srcIdSet) {
                Object tarId;
                if (!set.contains(srcId) || !matchedSrcIdSet.add(srcId) || successTarId.contains(tarId = compareResult.getTarIdSet().iterator().next()) || successSrcId.contains(srcId)) continue;
                successTarId.add(tarId);
                successSrcId.add(srcId);
                waitRemoveSrcIdSet.add(srcId);
                waitRemoveTarIdSet.add(tarId);
                waitRemoveResultList.add(compareResult);
                successList.add(new CompareResult(Collections.singleton(tarId), Collections.singleton(srcId)));
            }
        }
        resultList.removeAll(waitRemoveResultList);
        for (CompareResult compareResult : resultList) {
            compareResult.getSrcIdSet().removeAll(set);
        }
        this.removeFromDataList(srcDataList, set);
        Set singleMatchTarIdSet = tarIdPresentCntMap.entrySet().stream().filter(o -> (Integer)o.getValue() == 1).map(Map.Entry::getKey).collect(Collectors.toSet());
        for (CompareResult result : resultList) {
            Sets.SetView intersection;
            if (result.getSrcIdSet().size() == 0 || (intersection = Sets.intersection(singleMatchTarIdSet, result.getTarIdSet())).size() <= 0) continue;
            successList.add(result);
            waitRemoveSrcIdSet.addAll(result.getSrcIdSet());
            waitRemoveTarIdSet.addAll(result.getTarIdSet());
            waitRemoveResultList.add(result);
        }
        resultList.removeAll(waitRemoveResultList);
        Set set2 = tarIdPresentCntMap.entrySet().stream().filter(o -> (Integer)o.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toSet());
        HashSet<Object> matchedTarIdSet = new HashSet<Object>();
        for (CompareResult result : resultList) {
            Set<Object> tarIdSet = result.getTarIdSet();
            if (result.getSrcIdSet().size() == 0) continue;
            for (Object tarId : tarIdSet) {
                if (!set2.contains(tarId) || !matchedTarIdSet.add(tarId)) continue;
                Object srcId = result.getSrcIdSet().iterator().next();
                waitRemoveSrcIdSet.add(srcId);
                waitRemoveTarIdSet.add(tarId);
                successList.add(new CompareResult(Collections.singleton(tarId), Collections.singleton(srcId)));
            }
        }
        this.removeFromDataList(srcDataList, waitRemoveSrcIdSet);
        this.removeFromDataList(tarDataList, waitRemoveTarIdSet);
    }
}

