/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.compare.strategy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.compare.CompareUnit;
import kd.tmc.fbp.common.compare.data.CompareData;
import kd.tmc.fbp.common.compare.data.ComparePropValue;
import kd.tmc.fbp.common.compare.data.CompareRule;
import kd.tmc.fbp.common.compare.data.CompareRuleGroup;
import kd.tmc.fbp.common.compare.result.CompareResult;
import kd.tmc.fbp.common.compare.result.CompareUnitResult;
import kd.tmc.fbp.common.compare.result.CompareUnitResultCalcModel;
import kd.tmc.fbp.common.compare.strategy.ICompareStrategy;

public class StandardCompareStrategy
implements ICompareStrategy {
    private CompareRuleGroup ruleGroup;

    public StandardCompareStrategy(List<CompareRule> ruleList) {
        this.ruleGroup = new CompareRuleGroup(ruleList);
    }

    public StandardCompareStrategy(CompareRuleGroup ruleGroup) {
        this.ruleGroup = ruleGroup;
    }

    @Override
    public List<CompareResult> compare(List<CompareData> srcDataList, List<CompareData> tarDataList) {
        List<CompareUnit> compareUnitList = CompareUnit.fromPropValList(srcDataList, tarDataList, this.ruleGroup);
        CompareUnit prevUnit = null;
        for (int i = 0; i < compareUnitList.size(); ++i) {
            CompareUnit unit = compareUnitList.get(i);
            Set<ComparePropValue> srcNullDataList = unit.getSrcValList().stream().filter(o -> o.getData() == null || o.getData() instanceof String && ((String)o.getData()).trim().length() == 0).collect(Collectors.toSet());
            Set<ComparePropValue> tarNullDataList = unit.getTarValList().stream().filter(o -> o.getData() == null || o.getData() instanceof String && ((String)o.getData()).trim().length() == 0).collect(Collectors.toSet());
            ArrayList<CompareUnitResult> nullMatchResultList = new ArrayList<CompareUnitResult>();
            CompareRule rule = unit.getCompareRule();
            if (rule.isNullMatch()) {
                if (rule.isAllNullMatch()) {
                    this.addNullMatchData(unit.getSrcValList(), tarNullDataList, nullMatchResultList, srcNullDataList, unit.getTarValList());
                } else {
                    HashSet<ComparePropValue> srcValList = new HashSet<ComparePropValue>(unit.getSrcValList());
                    HashSet<ComparePropValue> tarValList = new HashSet<ComparePropValue>(unit.getTarValList());
                    srcNullDataList.forEach(srcValList::remove);
                    tarNullDataList.forEach(tarValList::remove);
                    this.addNullMatchData(srcValList, tarNullDataList, nullMatchResultList, srcNullDataList, tarValList);
                }
            } else if (rule.isAllNullMatch()) {
                CompareUnitResult nullMatchResult = new CompareUnitResult();
                nullMatchResult.setSrcIdSet(srcNullDataList.stream().map(ComparePropValue::getId).collect(Collectors.toSet()));
                nullMatchResult.setTarIdSet(tarNullDataList.stream().map(ComparePropValue::getId).collect(Collectors.toSet()));
                nullMatchResultList.add(nullMatchResult);
            }
            unit.getSrcValList().removeAll(srcNullDataList);
            unit.getTarValList().removeAll(tarNullDataList);
            if (prevUnit != null) {
                Set remainTarSet = prevUnit.getResult().stream().map(CompareUnitResult::getTarIdSet).flatMap(Collection::stream).collect(Collectors.toSet());
                Set<ComparePropValue> remainTarValList = unit.getTarValList();
                HashSet<ComparePropValue> removeList = new HashSet<ComparePropValue>(16);
                for (ComparePropValue tarVal : remainTarValList) {
                    if (remainTarSet.contains(tarVal.getId())) continue;
                    removeList.add(tarVal);
                }
                remainTarValList.removeAll(removeList);
            }
            if (unit.getTarValList().size() > 0 && unit.getSrcValList().size() > 0) {
                unit.compare();
            } else {
                unit.skip();
            }
            unit.getResult().addAll(nullMatchResultList);
            prevUnit = unit;
        }
        List<CompareResult> results = this.revertResult(compareUnitList);
        return results;
    }

    private void addNullMatchData(Set<ComparePropValue> srcValList, Set<ComparePropValue> tarNullDataList, List<CompareUnitResult> nullMatchResultList, Set<ComparePropValue> srcNullDataList, Set<ComparePropValue> tarValList) {
        CompareUnitResult nullMatchResult = new CompareUnitResult();
        nullMatchResult.setSrcIdSet(srcValList.stream().map(ComparePropValue::getId).collect(Collectors.toSet()));
        nullMatchResult.setTarIdSet(tarNullDataList.stream().map(ComparePropValue::getId).collect(Collectors.toSet()));
        nullMatchResultList.add(nullMatchResult);
        CompareUnitResult nullMatchResult2 = new CompareUnitResult();
        nullMatchResult2.setSrcIdSet(srcNullDataList.stream().map(ComparePropValue::getId).collect(Collectors.toSet()));
        nullMatchResult2.setTarIdSet(tarValList.stream().map(ComparePropValue::getId).collect(Collectors.toSet()));
        nullMatchResultList.add(nullMatchResult2);
    }

    private List<CompareResult> revertResult(List<CompareUnit> compareUnitList) {
        Map<Object, Object> remainResultMap;
        if (compareUnitList.size() == 1) {
            remainResultMap = new HashMap();
            List<CompareUnitResult> unitResultList = compareUnitList.get(0).getResult();
            for (CompareUnitResult compareUnitResult : unitResultList) {
                for (Object tarId : compareUnitResult.getTarIdSet()) {
                    Set srcIdSet = remainResultMap.computeIfAbsent(tarId, t -> new HashSet());
                    srcIdSet.addAll(compareUnitResult.getSrcIdSet());
                }
            }
        } else {
            remainResultMap = compareUnitList.size() > 1 ? CompareUnitResultCalcModel.calc(compareUnitList) : new HashMap();
        }
        ArrayList<CompareResult> finalResult = new ArrayList<CompareResult>(remainResultMap.size());
        for (Map.Entry entry : remainResultMap.entrySet()) {
            if (((Set)entry.getValue()).size() == 0) continue;
            CompareResult result = new CompareResult();
            HashSet<Object> tarIdSet = new HashSet<Object>();
            tarIdSet.add(entry.getKey());
            result.setRuleId(this.ruleGroup.getRuleId());
            result.setTarIdSet(tarIdSet);
            result.setSrcIdSet((Set)entry.getValue());
            finalResult.add(result);
        }
        return finalResult;
    }
}

