/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.enums;

import java.math.BigDecimal;
import kd.tmc.fbp.common.enums.MultiLangEnumBridge;
import kd.tmc.fbp.common.util.EmptyUtil;

public enum RepaySchemeEnum {
    YEAR("year", new MultiLangEnumBridge("\u5e74", "RepaySchemeEnum_0", "tmc-fbp-common")),
    HALFYEAR("halfyear", new MultiLangEnumBridge("\u534a\u5e74", "RepaySchemeEnum_1", "tmc-fbp-common")),
    QUARTER("quarter", new MultiLangEnumBridge("\u5b63\u5ea6", "RepaySchemeEnum_2", "tmc-fbp-common")),
    MONTH("month", new MultiLangEnumBridge("\u6708", "RepaySchemeEnum_3", "tmc-fbp-common")),
    DAY("day", new MultiLangEnumBridge("\u5929", "RepaySchemeEnum_9", "tmc-fbp-common")),
    TOYEAR("toyear", new MultiLangEnumBridge("\u5bf9\u5e74", "RepaySchemeEnum_4", "tmc-fbp-common")),
    TOQUARTER("toquarter", new MultiLangEnumBridge("\u5bf9\u5b63", "RepaySchemeEnum_7", "tmc-fbp-common")),
    TOMONTH("tomonth", new MultiLangEnumBridge("\u5bf9\u6708", "RepaySchemeEnum_5", "tmc-fbp-common")),
    TOHALFYEAR("tohalfyear", new MultiLangEnumBridge("\u5bf9\u534a\u5e74", "RepaySchemeEnum_8", "tmc-fbp-common")),
    ENDINTEREST("endinterest", new MultiLangEnumBridge("\u5230\u671f\u4e00\u6b21\u7ed3\u606f", "RepaySchemeEnum_6", "tmc-fbp-common")),
    CUSTOM("custom", new MultiLangEnumBridge("\u81ea\u5b9a\u4e49", "RepaySchemeEnum_10", "tmc-fbp-common"));

    private String value;
    private MultiLangEnumBridge name;

    private RepaySchemeEnum(String value, MultiLangEnumBridge name) {
        this.value = value;
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public String getName() {
        return this.name.loadKDString();
    }

    public static RepaySchemeEnum getByValue(String value) {
        for (RepaySchemeEnum inschemeEnum : RepaySchemeEnum.values()) {
            if (!inschemeEnum.getValue().equals(value)) continue;
            return inschemeEnum;
        }
        return CUSTOM;
    }

    public static RepaySchemeEnum trans2RepaySchemeEnum(String period) {
        switch (period) {
            case "1": {
                return YEAR;
            }
            case "2": {
                return HALFYEAR;
            }
            case "3": {
                return QUARTER;
            }
            case "4": {
                return MONTH;
            }
            case "5": {
                return TOYEAR;
            }
            case "6": {
                return TOMONTH;
            }
            case "7": {
                return TOQUARTER;
            }
            case "8": {
                return TOHALFYEAR;
            }
        }
        return CUSTOM;
    }

    public static BigDecimal getMonthByPeriod(String period) {
        if (EmptyUtil.isEmpty(period)) {
            return BigDecimal.ZERO;
        }
        RepaySchemeEnum repaySchemeEnum = RepaySchemeEnum.trans2RepaySchemeEnum(period);
        if (repaySchemeEnum == null) {
            return BigDecimal.ZERO;
        }
        switch (repaySchemeEnum) {
            case YEAR: 
            case TOYEAR: {
                return BigDecimal.ONE;
            }
            case MONTH: 
            case TOMONTH: {
                return BigDecimal.valueOf(12L);
            }
            case HALFYEAR: 
            case TOHALFYEAR: {
                return BigDecimal.valueOf(2L);
            }
            case QUARTER: 
            case TOQUARTER: {
                return BigDecimal.valueOf(4L);
            }
        }
        return BigDecimal.ZERO;
    }

    public static boolean isCycle(String value) {
        return RepaySchemeEnum.isYear(value) || RepaySchemeEnum.isHalfYear(value) || RepaySchemeEnum.isQuarter(value) || RepaySchemeEnum.isMonth(value);
    }

    public static boolean isToCycle(String value) {
        return RepaySchemeEnum.isToYear(value) || RepaySchemeEnum.isToQuarter(value) || RepaySchemeEnum.isToMonth(value) || RepaySchemeEnum.isToHalfYear(value);
    }

    public static boolean isYear(String value) {
        return YEAR.getValue().equals(value);
    }

    public static boolean isHalfYear(String value) {
        return HALFYEAR.getValue().equals(value);
    }

    public static boolean isQuarter(String value) {
        return QUARTER.getValue().equals(value);
    }

    public static boolean isMonth(String value) {
        return MONTH.getValue().equals(value);
    }

    public static boolean isDay(String value) {
        return DAY.getValue().equals(value);
    }

    public static boolean isToYear(String value) {
        return TOYEAR.getValue().equals(value);
    }

    public static boolean isToQuarter(String value) {
        return TOQUARTER.getValue().equals(value);
    }

    public static boolean isToMonth(String value) {
        return TOMONTH.getValue().equals(value);
    }

    public static boolean isToHalfYear(String value) {
        return TOHALFYEAR.getValue().equals(value);
    }

    public static boolean isEndinterest(String value) {
        return ENDINTEREST.getValue().equals(value);
    }

    public static boolean isCustom(String value) {
        return CUSTOM.getValue().equals(value);
    }
}

