/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.formula;

import java.math.BigDecimal;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.formula.MathFormulaUtils;
import org.apache.commons.math3.distribution.NormalDistribution;

public class FormulaUtils {
    public static BigDecimal transToOtherRA(BigDecimal yearRA, int freque) {
        if (freque == 1) {
            return yearRA;
        }
        double result = (Math.pow(1.0 + yearRA.doubleValue() / 100.0, 1.0 / (double)freque) - 1.0) * (double)freque * 100.0;
        return BigDecimal.valueOf(result);
    }

    public static BigDecimal getYearRA(BigDecimal RA, int freque) {
        if (freque == 1) {
            return RA;
        }
        BigDecimal freq = BigDecimal.valueOf(freque);
        return RA.divide(new BigDecimal(100)).divide(freq, 10, 4).add(BigDecimal.ONE).pow(freque).subtract(BigDecimal.ONE).multiply(new BigDecimal(100));
    }

    public static BigDecimal getBondIssue_A(BigDecimal PV, BigDecimal FV, BigDecimal r, int n) {
        return PV.subtract(FV).multiply(r).multiply(BigDecimal.ONE.add(r).pow(n)).divide(BigDecimal.ONE.add(r).pow(n).subtract(BigDecimal.ONE), 10, 4).add(FV.multiply(r));
    }

    public static BigDecimal getBondIssue_PV(BigDecimal A, BigDecimal FV, BigDecimal r, int n) {
        return A.multiply(BigDecimal.ONE.subtract(BigDecimal.ONE.divide(BigDecimal.ONE.add(r).pow(n), 10, 4))).divide(r, 10, 4).add(FV.multiply(BigDecimal.ONE.divide(BigDecimal.ONE.add(r).pow(n), 10, 4)));
    }

    public static BigDecimal getBondIssue_FV(BigDecimal A, BigDecimal PV, BigDecimal r, int n) {
        return PV.multiply(BigDecimal.ONE.add(r).pow(n)).subtract(A.multiply(BigDecimal.ONE.add(r).pow(n).subtract(BigDecimal.ONE)).divide(r, 6, 4));
    }

    public static BigDecimal getDFOnEnterzcrate(BigDecimal RA, BigDecimal baseBasis, BigDecimal intRate) {
        return Constants.ONE.divide(BigDecimal.valueOf(Math.pow(Constants.ONE.add(RA.divide(intRate.multiply(Constants.ONE_HUNDRED), 6, 4)).doubleValue(), baseBasis.multiply(intRate).doubleValue())), 10, 4);
    }

    public static BigDecimal getConDFOnEnterzcrate(BigDecimal RA, BigDecimal baseBasis) {
        return BigDecimal.valueOf(Math.exp(Constants._ONE.multiply(RA).multiply(baseBasis).divide(Constants.ONE_HUNDRED, 10, 4).doubleValue()));
    }

    public static BigDecimal getDFOnforwards(BigDecimal RA, BigDecimal baseBasis) {
        return Constants.ONE.divide(Constants.ONE.add(RA.multiply(baseBasis).divide(Constants.ONE_HUNDRED, 10, 4)), 10, 4);
    }

    public static BigDecimal getConRateOnforwards(BigDecimal DF, BigDecimal baseBasis) {
        return Constants._ONE.multiply(BigDecimal.valueOf(Math.log(DF.doubleValue()))).multiply(Constants.ONE_HUNDRED).divide(baseBasis, 10, 4);
    }

    public static BigDecimal getLineCompRate(BigDecimal days, BigDecimal x1Days, BigDecimal x2Days, BigDecimal x1Rate, BigDecimal x2Rate) {
        return x2Days.subtract(days).divide(x2Days.subtract(x1Days), 10, 4).multiply(x1Rate).add(days.subtract(x1Days).divide(x2Days.subtract(x1Days), 10, 4).multiply(x2Rate));
    }

    public static BigDecimal getD1(BigDecimal delta) {
        return BigDecimal.valueOf(MathFormulaUtils.inverseCumulativeProbability(delta.doubleValue()));
    }

    public static BigDecimal calculateDelta(String premiumName, BigDecimal volatility, BigDecimal strike, BigDecimal T, BigDecimal f0) {
        BigDecimal d1 = FormulaUtils.getD1(f0, strike, T, volatility);
        BigDecimal delta = BigDecimal.ZERO;
        switch (premiumName) {
            case "callpremium": {
                delta = BigDecimal.valueOf(MathFormulaUtils.cumulativeProbability(d1.doubleValue()));
                break;
            }
            case "putpremium": {
                delta = BigDecimal.valueOf(MathFormulaUtils.cumulativeProbability(Constants._ONE.multiply(d1).doubleValue()));
            }
        }
        return delta;
    }

    public static BigDecimal calculateStrike(String strikeName, BigDecimal volatility, BigDecimal delta, BigDecimal T, BigDecimal f0) {
        NormalDistribution normalDistribution = new NormalDistribution();
        BigDecimal d1 = BigDecimal.valueOf(normalDistribution.inverseCumulativeProbability(delta.doubleValue()));
        if ("putstrike".equals(strikeName)) {
            d1 = Constants._ONE.multiply(d1);
        }
        return f0.multiply(BigDecimal.valueOf(Math.exp(BigDecimal.valueOf(0.5).multiply(volatility).multiply(BigDecimal.valueOf(Math.sqrt(T.doubleValue()))).subtract(d1).multiply(volatility.multiply(BigDecimal.valueOf(Math.sqrt(T.doubleValue())))).doubleValue())));
    }

    public static BigDecimal calculatePremium(String premiumName, BigDecimal volatility, BigDecimal strike, BigDecimal T, BigDecimal f0, BigDecimal Zq) {
        BigDecimal premium = Constants.ZERO;
        BigDecimal d1 = FormulaUtils.getD1(f0, strike, T, volatility);
        BigDecimal d2 = FormulaUtils.getD2(d1, volatility, T);
        NormalDistribution normalDistribution = new NormalDistribution();
        switch (premiumName) {
            case "callpremium": {
                premium = Zq.multiply(f0.multiply(BigDecimal.valueOf(normalDistribution.cumulativeProbability(d1.doubleValue()))).subtract(strike.multiply(BigDecimal.valueOf(normalDistribution.cumulativeProbability(d2.doubleValue())))));
                break;
            }
            case "putpremium": {
                premium = Constants._ONE.multiply(Zq.multiply(f0.multiply(BigDecimal.valueOf(normalDistribution.cumulativeProbability(Constants._ONE.multiply(d1).doubleValue()))).subtract(strike.multiply(BigDecimal.valueOf(normalDistribution.cumulativeProbability(Constants._ONE.multiply(d2).doubleValue()))))));
            }
        }
        return premium;
    }

    public static BigDecimal calculatePremium(String premiumName, BigDecimal volatility, BigDecimal strike, BigDecimal delta, BigDecimal T, BigDecimal f0, BigDecimal Zq) {
        BigDecimal premium = Constants.ZERO;
        NormalDistribution normalDistribution = new NormalDistribution();
        switch (premiumName) {
            case "callpremium": {
                BigDecimal d1 = BigDecimal.valueOf(normalDistribution.inverseCumulativeProbability(delta.doubleValue()));
                BigDecimal d2 = FormulaUtils.getD2(d1, volatility, T);
                premium = Zq.multiply(f0.multiply(delta).subtract(strike.multiply(BigDecimal.valueOf(normalDistribution.cumulativeProbability(d2.doubleValue())))));
                break;
            }
            case "putpremium": {
                BigDecimal d1 = Constants._ONE.multiply(BigDecimal.valueOf(normalDistribution.inverseCumulativeProbability(delta.doubleValue())));
                BigDecimal d2 = FormulaUtils.getD2(d1, volatility, T);
                premium = Constants._ONE.multiply(Zq).multiply(f0.multiply(delta).subtract(strike.multiply(BigDecimal.valueOf(normalDistribution.cumulativeProbability(Constants._ONE.multiply(d2).doubleValue())))));
            }
        }
        return premium;
    }

    public static BigDecimal volatilityFunction(BigDecimal calculatePremium, BigDecimal currentPremium) {
        return calculatePremium.subtract(currentPremium);
    }

    public static BigDecimal volatilityFunctionDerivation(BigDecimal volatility, BigDecimal strike, BigDecimal T, BigDecimal f0, BigDecimal Zq) {
        BigDecimal d1 = FormulaUtils.getD1(f0, strike, T, volatility);
        return f0.multiply(Zq).multiply(BigDecimal.valueOf(Math.sqrt(T.doubleValue()))).divide(BigDecimal.valueOf(Math.sqrt(Math.PI * 2)), 10, 4).multiply(BigDecimal.valueOf(Math.exp(Constants._ONE.multiply(d1.pow(2).divide(BigDecimal.valueOf(2L), 10, 4)).doubleValue())));
    }

    public static BigDecimal volatilityFunctionDerivation(String premiumName, BigDecimal volatility, BigDecimal strike, BigDecimal delta, BigDecimal T, BigDecimal f0, BigDecimal Zq) {
        BigDecimal d2 = BigDecimal.ZERO;
        BigDecimal volFunctionDerivation = Constants.ZERO;
        switch (premiumName) {
            case "callpremium": {
                d2 = FormulaUtils.getD2(FormulaUtils.getD1(delta), volatility, T);
                volFunctionDerivation = Zq.multiply(BigDecimal.valueOf(Math.sqrt(T.doubleValue()))).multiply(strike).multiply(Constants.ONE.divide(BigDecimal.valueOf(Math.sqrt(Math.PI * 2)), 10, 4).multiply(BigDecimal.valueOf(Math.exp(Constants._ONE.multiply(d2.pow(2).divide(BigDecimal.valueOf(2L), 6, 4)).doubleValue()))).add(d2.multiply(BigDecimal.valueOf(MathFormulaUtils.cumulativeProbability(d2.doubleValue())))));
                break;
            }
            case "putpremium": {
                d2 = FormulaUtils.getD2(Constants._ONE.multiply(FormulaUtils.getD1(delta)), volatility, T);
                volFunctionDerivation = Zq.multiply(BigDecimal.valueOf(Math.sqrt(T.doubleValue()))).multiply(strike).multiply(Constants.ONE.divide(BigDecimal.valueOf(Math.sqrt(Math.PI * 2)), 10, 4).multiply(BigDecimal.valueOf(Math.exp(Constants._ONE.multiply(d2.pow(2).divide(BigDecimal.valueOf(2L), 6, 4)).doubleValue()))).subtract(d2.multiply(BigDecimal.valueOf(MathFormulaUtils.cumulativeProbability(Constants._ONE.multiply(d2).doubleValue())))));
            }
        }
        return volFunctionDerivation;
    }

    public static BigDecimal calculateVolatility(String premiumName, BigDecimal volatility, BigDecimal strike, BigDecimal currentPremium, BigDecimal T, BigDecimal f0, BigDecimal Zq) throws ArithmeticException {
        BigDecimal lastVolatility = volatility;
        BigDecimal lastFunction = Constants.ZERO;
        for (int i = 0; i < 50; ++i) {
            BigDecimal calculatePremium = FormulaUtils.calculatePremium(premiumName, lastVolatility, strike, T, f0, Zq);
            BigDecimal function = FormulaUtils.volatilityFunction(calculatePremium, currentPremium);
            BigDecimal functionDerivation = FormulaUtils.volatilityFunctionDerivation(lastVolatility, strike, T, f0, Zq);
            BigDecimal calculateVolatility = lastVolatility.subtract(function.divide(functionDerivation, 10, 4));
            if (i > 0 && function.subtract(lastFunction).abs().compareTo(currentPremium.multiply(BigDecimal.valueOf(1.0E-5))) < 0 && calculateVolatility.subtract(lastVolatility).abs().compareTo(BigDecimal.valueOf(1.0E-5)) < 0) {
                return calculateVolatility;
            }
            lastVolatility = calculateVolatility;
            lastFunction = function;
        }
        return lastVolatility;
    }

    public static BigDecimal calculateVolatility(String strikeName, String premiumName, BigDecimal volatility, BigDecimal delta, BigDecimal currentPremium, BigDecimal T, BigDecimal f0, BigDecimal Zq) throws ArithmeticException {
        BigDecimal lastVolatility = volatility;
        BigDecimal lastFunction = Constants.ZERO;
        for (int i = 0; i < 50; ++i) {
            BigDecimal strike = FormulaUtils.calculateStrike(strikeName, lastVolatility, delta, T, f0);
            BigDecimal calculatePremium = FormulaUtils.calculatePremium(premiumName, lastVolatility, strike, delta, T, f0, Zq);
            BigDecimal function = FormulaUtils.volatilityFunction(calculatePremium, currentPremium);
            BigDecimal functionDerivation = FormulaUtils.volatilityFunctionDerivation(premiumName, lastVolatility, strike, delta, T, f0, Zq);
            BigDecimal calculateVolatility = lastVolatility.subtract(function.divide(functionDerivation, 10, 4));
            if (i > 0 && function.subtract(lastFunction).abs().compareTo(BigDecimal.valueOf(1.0E-5).multiply(currentPremium)) < 0 && calculateVolatility.subtract(lastVolatility).abs().compareTo(BigDecimal.valueOf(1.0E-5)) < 0) {
                return calculateVolatility;
            }
            lastVolatility = calculateVolatility;
            lastFunction = function;
        }
        return lastVolatility;
    }

    public static BigDecimal getD1(BigDecimal f0, BigDecimal strike, BigDecimal T, BigDecimal volatility) {
        double ln_F_K = Math.log(f0.divide(strike, 10, 4).doubleValue());
        BigDecimal \u03c3_T = volatility.multiply(BigDecimal.valueOf(Math.sqrt(T.doubleValue())));
        BigDecimal addOne = BigDecimal.valueOf(Double.isNaN(ln_F_K) ? 0.0 : ln_F_K).divide(\u03c3_T, 10, 4);
        BigDecimal addTwo = \u03c3_T.divide(BigDecimal.valueOf(2L), 10, 4);
        return addOne.add(addTwo);
    }

    public static BigDecimal getD2(BigDecimal d1, BigDecimal volatility, BigDecimal T) {
        return d1.subtract(volatility.multiply(BigDecimal.valueOf(Math.sqrt(T.doubleValue()))));
    }

    public static BigDecimal getOP(BigDecimal d1, BigDecimal d2, BigDecimal T, BigDecimal df, BigDecimal zerorate, BigDecimal strike, boolean online) {
        if (online) {
            return T.multiply(df).multiply(zerorate.multiply(BigDecimal.valueOf(MathFormulaUtils.cumulativeProbability(d1.doubleValue()))).subtract(strike.multiply(BigDecimal.valueOf(MathFormulaUtils.cumulativeProbability(d2.doubleValue())))));
        }
        return T.multiply(df).multiply(strike.multiply(BigDecimal.valueOf(MathFormulaUtils.cumulativeProbability(d2.doubleValue()))).subtract(zerorate.multiply(BigDecimal.valueOf(MathFormulaUtils.cumulativeProbability(d1.doubleValue())))));
    }
}

