/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.tmc.fbp.common.graph.Edge;
import kd.tmc.fbp.common.graph.Path;

public class Vertex
implements Serializable {
    private static final long serialVersionUID = -7137397668009794800L;
    private final List<Edge> incomingEdges;
    private final List<Edge> outgoingEdges;
    private final String name;
    private boolean mark;
    private int markState;
    private List<Path> pathList = new ArrayList<Path>();

    public Vertex(String n) {
        this.incomingEdges = new ArrayList<Edge>();
        this.outgoingEdges = new ArrayList<Edge>();
        this.name = n;
        this.mark = false;
        this.markState = 1;
    }

    public String getName() {
        return this.name;
    }

    public boolean addEdge(Edge e) {
        if (e.getFrom() == this) {
            this.outgoingEdges.add(e);
        } else if (e.getTo() == this) {
            this.incomingEdges.add(e);
        } else {
            return false;
        }
        return true;
    }

    public boolean hasEdge(Edge e) {
        if (e.getFrom() == this) {
            return this.incomingEdges.contains(e);
        }
        if (e.getTo() == this) {
            return this.outgoingEdges.contains(e);
        }
        return false;
    }

    public boolean remove(Edge e) {
        if (e.getFrom() == this) {
            this.incomingEdges.remove(e);
        } else if (e.getTo() == this) {
            this.outgoingEdges.remove(e);
        } else {
            return false;
        }
        return true;
    }

    public int getIncomingEdgeCount() {
        return this.incomingEdges.size();
    }

    public Edge getIncomingEdge(int i) {
        return this.incomingEdges.get(i);
    }

    public List getIncomingEdges() {
        return this.incomingEdges;
    }

    public int getOutgoingEdgeCount() {
        return this.outgoingEdges.size();
    }

    public Edge getOutgoingEdge(int i) {
        return this.outgoingEdges.get(i);
    }

    public List getOutgoingEdges() {
        return this.outgoingEdges;
    }

    public Edge findEdge(Vertex dest) {
        for (Edge e : this.outgoingEdges) {
            if (e.getTo() != dest) continue;
            return e;
        }
        return null;
    }

    public Edge findEdge(Edge e) {
        if (this.outgoingEdges.contains(e)) {
            return e;
        }
        return null;
    }

    public boolean visited() {
        return this.mark;
    }

    public void mark() {
        this.mark = true;
    }

    public void setMarkState(int state) {
        this.markState = state;
    }

    public int getMarkState() {
        return this.markState;
    }

    public void visit() {
        this.mark();
    }

    public List<Path> getPathList() {
        return this.pathList;
    }

    public void setPathList(List<Path> pathList) {
        this.pathList = pathList;
    }

    public Set<Long> getBillIdByAccount(String account) {
        Path path = this.pathList.stream().filter(s -> s.getAccount().equals(account)).findFirst().orElse(null);
        if (path != null) {
            return path.getIds();
        }
        return null;
    }

    public void clearMark() {
        this.mark = false;
    }
}

