/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.cache.AppCache;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.AmountUnitEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.SystemStatusCtrolHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class AmountTransHelper {
    public static final String RATE = "rate";
    private static int cacheTime = 6000;

    public static Long getBaseCurrency(Long orgViewId) {
        String orgRootId;
        String key = String.valueOf(orgViewId);
        Long baseCurrencyId = (Long)AppCache.get((String)TmcAppEnum.TDA.getValue()).get(key, Long.class);
        if (EmptyUtil.isEmpty(baseCurrencyId) && EmptyUtil.isNoEmpty(orgRootId = TmcOrgDataHelper.getOrgRootId(orgViewId))) {
            long rootOrgId = Long.parseLong(orgRootId);
            DynamicObject standardCurrency = SystemStatusCtrolHelper.getStandardCurrency(rootOrgId);
            DynamicObject baseCurrency = standardCurrency == null ? TmcBusinessBaseHelper.getBaseCurrency(rootOrgId) : standardCurrency;
            if (baseCurrency == null) {
                return TmcDataServiceHelper.loadSingleFromCache((String)"bd_currency", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"CNY")}).getLong("id");
            }
            baseCurrencyId = baseCurrency.getLong("id");
            AppCache.get((String)TmcAppEnum.TDA.getValue()).put(key, (Object)baseCurrencyId, cacheTime);
        }
        return baseCurrencyId;
    }

    public static BigDecimal getExchangeRate(long sourceCurrencyId, long targetCurrencyId, long orgId, Date bizDate) {
        String key = "Rate-" + sourceCurrencyId + targetCurrencyId + orgId + bizDate;
        BigDecimal rate = (BigDecimal)AppCache.get((String)TmcAppEnum.TDA.getValue()).get(key, BigDecimal.class);
        if (EmptyUtil.isEmpty(rate)) {
            rate = TmcBusinessBaseHelper.getExchangeRate(sourceCurrencyId, targetCurrencyId, orgId, bizDate);
            AppCache.get((String)TmcAppEnum.TDA.getValue()).put(key, (Object)rate, cacheTime);
        }
        return rate;
    }

    public static DataSet dealRowOtherValue(DataSet ds, Map<String, Object> queryParam, Set<String> amountField) {
        ds = AmountTransHelper.dealAmountConvert(ds, queryParam, amountField);
        return AmountTransHelper.dealAmountUnit(ds, queryParam, amountField);
    }

    public static DataSet dealAmountConvert(DataSet ds, Map<String, Object> queryParam, Set<String> amountField) {
        boolean checkEmpty;
        DynamicObject reportCurrency = (DynamicObject)queryParam.get("currency");
        DynamicObject orgView = (DynamicObject)queryParam.get("orgview");
        Long rootOrgId = Long.valueOf(TmcOrgDataHelper.getOrgRootId(orgView.getLong("id")));
        Long baseCurrency = (Long)queryParam.get("basecurrency");
        Date queryDate = AmountTransHelper.getQueryDate(queryParam);
        if (EmptyUtil.isEmpty(baseCurrency)) {
            baseCurrency = AmountTransHelper.getBaseCurrency(orgView.getLong("id"));
        }
        boolean bl = checkEmpty = EmptyUtil.isEmpty(reportCurrency) || EmptyUtil.isEmpty(orgView) || EmptyUtil.isEmpty(rootOrgId) || EmptyUtil.isEmpty(baseCurrency) || Long.valueOf(reportCurrency.getLong("id")).equals(baseCurrency);
        if (checkEmpty) {
            return ds;
        }
        BigDecimal rate = AmountTransHelper.getExchangeRate(baseCurrency, reportCurrency.getLong("id"), rootOrgId, queryDate);
        if (rate == null) {
            rate = BigDecimal.ONE;
        }
        if (rate == null) {
            return ds;
        }
        String rateStr = rate.stripTrailingZeros().toPlainString();
        String[] fieldNames = ds.getRowMeta().getFieldNames();
        boolean isContainRate = false;
        for (String fieldName : fieldNames) {
            if (!RATE.equals(fieldName)) continue;
            isContainRate = true;
            break;
        }
        for (String field : amountField) {
            ds = ds.updateField(field, field + "*" + rateStr);
        }
        if (isContainRate) {
            ds = ds.updateField(RATE, "rate*" + rateStr);
        }
        return ds;
    }

    public static DataSet dealAmountUnit(DataSet ds, Map<String, Object> queryParam, Set<String> amountField) {
        String amountunit = (String)queryParam.get("amountunit");
        if (EmptyUtil.isEmpty(amountunit) || "1".equals(amountunit)) {
            return ds;
        }
        for (String field : amountField) {
            ds = ds.updateField(field, field + "/" + amountunit);
        }
        return ds;
    }

    public static DataSet getExchangeRateDataSet(DataSet dataSet, Long orgview, Long baseCurrency, String currencyFieldName, Date queryDate, boolean isCurrencyDataSet) {
        if (queryDate == null) {
            queryDate = DateUtils.getCurrentDate();
        }
        Long tarCurrencyId = baseCurrency;
        Long rootOrgId = Long.valueOf(TmcOrgDataHelper.getOrgRootId(orgview));
        if (EmptyUtil.isEmpty(tarCurrencyId)) {
            tarCurrencyId = AmountTransHelper.getBaseCurrency(orgview);
        }
        ArrayList<Object[]> collection = new ArrayList<Object[]>();
        HashSet<Long> exchgRateCache = new HashSet<Long>(16);
        Iterator iterator = isCurrencyDataSet ? dataSet.iterator() : dataSet.copy().select(currencyFieldName).groupBy(new String[]{currencyFieldName}).finish().iterator();
        while (iterator.hasNext()) {
            BigDecimal rate;
            Row row = (Row)iterator.next();
            Long fromCurrencyId = row.getLong(currencyFieldName);
            if (exchgRateCache.contains(fromCurrencyId)) continue;
            if (EmptyUtil.isEmpty(fromCurrencyId) || fromCurrencyId.equals(tarCurrencyId)) {
                rate = BigDecimal.ONE;
            } else {
                rate = TmcBusinessBaseHelper.getExchangeRate(fromCurrencyId, tarCurrencyId, rootOrgId, queryDate);
                if (rate == null) {
                    rate = BigDecimal.ONE;
                }
            }
            exchgRateCache.add(fromCurrencyId);
            collection.add(new Object[]{fromCurrencyId, DataType.convertValue((DataType)DataType.BigDecimalType, (Object)rate)});
        }
        DataSet exchangeRateDataSet = AmountTransHelper.createRow(AmountTransHelper.class.getName(), new String[]{currencyFieldName, RATE}, new DataType[]{DataType.LongType, DataType.BigDecimalType}, collection);
        return exchangeRateDataSet;
    }

    public static DataSet tranDataSetRate(DataSet dataSet, Long orgview, Long baseCurrency, String currencyFieldName, Set<String> tranFieldName, Date queryDate) {
        DataSet exchangeRate = AmountTransHelper.getExchangeRateDataSet(dataSet, orgview, baseCurrency, currencyFieldName, queryDate, false);
        dataSet = dataSet.leftJoin(exchangeRate).on(currencyFieldName, currencyFieldName).select(dataSet.getRowMeta().getFieldNames(), new String[]{RATE}).finish();
        for (String field : tranFieldName) {
            dataSet = dataSet.updateField(field, field + "*" + RATE);
        }
        return dataSet;
    }

    public static DataSet reverseTranDataSetRate(DataSet dataSet, Long orgview, Long baseCurrency, String currencyFieldName, Set<String> tranFieldName, Date queryDate) {
        DataSet exchangeRate = AmountTransHelper.getExchangeRateDataSet(dataSet, orgview, baseCurrency, currencyFieldName, queryDate, false);
        dataSet = dataSet.leftJoin(exchangeRate).on(currencyFieldName, currencyFieldName).select(dataSet.getRowMeta().getFieldNames(), new String[]{RATE}).finish();
        dataSet = dataSet.updateField(RATE, "case when rate is null or rate<0 then 1.0 else rate end");
        for (String field : tranFieldName) {
            dataSet = dataSet.updateField(field, field + "/" + RATE);
        }
        return dataSet;
    }

    public static DataSet tranDataSetRate(DataSet dataSet, DataSet currencyDataSet, Long orgview, Long baseCurrency, String currencyFieldName, Set<String> tranFieldName, Date queryDate) {
        DataSet exchangeRate = AmountTransHelper.getExchangeRateDataSet(currencyDataSet, orgview, baseCurrency, currencyFieldName, queryDate, true);
        dataSet = dataSet.leftJoin(exchangeRate).on(currencyFieldName, currencyFieldName).select(dataSet.getRowMeta().getFieldNames(), new String[]{RATE}).finish();
        for (String field : tranFieldName) {
            dataSet = dataSet.updateField(field, field + "*" + RATE);
        }
        return dataSet;
    }

    public static DataSet tranAmoutUnit(DataSet dataSet, Set<String> tranFieldName, AmountUnitEnum unit) {
        for (String field : tranFieldName) {
            dataSet = dataSet.updateField(field, field + "/" + unit.getValue());
        }
        return dataSet;
    }

    public static DataSet createRow(String className, String[] fieldNames, DataType[] dataTypes, Collection<Object[]> values) {
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])fieldNames, (DataType[])dataTypes);
        CollectionInput inputs = new CollectionInput(rowMeta, values);
        DataSet dataSet = Algo.create((String)className).createDataSet(new Input[]{inputs});
        return dataSet;
    }

    public static Date getQueryDate(Map<String, Object> paramMap) {
        Object date = paramMap.get("querydate");
        Date queryDate = date == null ? DateUtils.getCurrentDate() : (date instanceof String ? DateUtils.stringToDate((String)date, "yyyy-MM-dd HH:mm:ss") : (Date)date);
        return queryDate;
    }
}

