/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.bean.BalanceUpdateInfo;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BalanceUpdateHelper {
    public static final Date MIN_BIZ_DATE = DateUtils.getAppointDay(1900, 1, 1);
    public static final Date MAX_BIZ_DATE = DateUtils.getAppointDay(9999, 12, 31);
    private static final BigDecimal MAX_FREEAMOUNT = BigDecimal.valueOf(Integer.MAX_VALUE);
    private static final String SELECT_FIELDS = "id,company,accountbank,currency,bizdate,debitamount,creditamount,amount,lstbalance,valibalance,modifytime";
    private static final String QUERY_BALANCE_SQL = "SELECT a.fbizdate, \n   SUM(case when a.fbizdate >= b.fbizdate then b.fcreditamount-b.fdebitamount else 0 end) + %2$f as famount,\n   SUM(case when a.fbizdate > b.fbizdate then b.fcreditamount-b.fdebitamount else 0 end) + %2$f as flstbalance\nFROM %1$s a, %1$s b\n WHERE a.faccountbankid = b.faccountbankid\n   AND a.fcurrencyid = b.fcurrencyid\n   AND a.faccountbankid = %3$d\n   AND a.fcurrencyid = %4$d\n   AND a.fbizdate >= '%5$s' AND a.fbizdate <= '%6$s'\n   AND b.fbizdate >= '%5$s' AND b.fbizdate <= '%6$s'\n   GROUP BY a.fbizdate\n    ORDER BY a.fbizdate";
    private static final String FROM_BALANCE_SQL = "FROM %1$s a, %1$s b\n WHERE a.faccountbankid = b.faccountbankid\n   AND a.fcurrencyid = b.fcurrencyid\n   AND a.faccountbankid = %2$d  \n   AND a.fcurrencyid = %3$d \n   AND a.fbizdate >= '%4$s' \n   AND b.fbizdate >= '%4$s' \n   AND t.faccountbankid = a.faccountbankid AND t.fcurrencyid = a.fcurrencyid AND t.fbizdate = a.fbizdate";
    private static final String UPDATE_NEXT_BALANCE_SQL = "UPDATE %1$s t \n  SET famount = (SELECT SUM(case when a.fbizdate >= b.fbizdate then b.fcreditamount-b.fdebitamount else 0 end) + %2$f as famount \n       %3$s),\n  flstbalance = (SELECT SUM(case when a.fbizdate > b.fbizdate then b.fcreditamount-b.fdebitamount else 0 end) + %2$f as flstbalance \n       %3$s) \nWHERE t.faccountbankid = %4$d AND t.fcurrencyid = %5$d AND t.fbizdate > '%6$s'";
    private static final String UPDATE_VALIBALANCE_SQL = "UPDATE %1$s SET fvalibalance = famount WHERE t.faccountbankid = %2$d AND t.fcurrencyid = %3$d AND t.fbizdate > '%4$s'";
    private static final String SQL_UPDATE_BALANCE = "UPDATE %s SET famount = ?, flstbalance = ?, fvalibalance = ? WHERE fid = ?";
    private static final String SQL_DELETE_BALANCE = "DELETE FROM %s WHERE faccountbankid = ? AND fbizdate >= ?";

    public static void initBillBlance(String entityName, List<BalanceUpdateInfo> balanceList, Date beginDate) {
        BigDecimal lstBalance;
        if (EmptyUtil.isEmpty(balanceList)) {
            return;
        }
        balanceList.sort(Comparator.comparing(BalanceUpdateInfo::getBizDate));
        BalanceUpdateInfo initBalance = balanceList.get(0);
        Long bizBillId = initBalance.getBizBillId();
        Date initBizDate = initBalance.getBizDate();
        Date beginBizDate = beginDate != null ? beginDate : initBizDate;
        DynamicObject lstBlanceObj = BalanceUpdateHelper.queryLstBlanceObj(entityName, bizBillId, initBalance.getCurrencyId(), beginBizDate);
        if (lstBlanceObj != null) {
            Date lstBizDate = lstBlanceObj.getDate("bizdate");
            beginBizDate = DateUtils.getNextDay(lstBizDate, 1);
            lstBalance = lstBlanceObj.getBigDecimal("amount");
        } else {
            lstBalance = initBalance.getLstBalance() != null ? initBalance.getLstBalance() : BigDecimal.ZERO;
            beginBizDate = initBizDate;
        }
        DB.update((DBRoute)DBRouteConst.TMC, (String)String.format(SQL_DELETE_BALANCE, BalanceUpdateHelper.getEntityTableName(entityName)), (Object[])new Object[]{bizBillId, beginBizDate});
        Date startDate = beginBizDate;
        balanceList = balanceList.stream().filter(b -> b.getBizDate().compareTo(startDate) >= 0).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(balanceList)) {
            return;
        }
        BalanceUpdateHelper.saveBillBlanceByBalanceList(entityName, balanceList, lstBalance);
    }

    public static void saveBillBlanceByBalanceList(String entityName, List<BalanceUpdateInfo> balanceList, BigDecimal lstBalance) {
        BigDecimal totalFreezeAmount = BigDecimal.ZERO;
        ArrayList<DynamicObject> dynamicObjs = new ArrayList<DynamicObject>(balanceList.size());
        TreeMap<Date, List<BalanceUpdateInfo>> dateListMap = new TreeMap<Date, List<BalanceUpdateInfo>>(balanceList.stream().collect(Collectors.groupingBy(BalanceUpdateInfo::getBizDate)));
        for (Map.Entry<Date, List<BalanceUpdateInfo>> entry : dateListMap.entrySet()) {
            List<BalanceUpdateInfo> balances = entry.getValue();
            BalanceUpdateInfo updateInfo = balances.get(0);
            if (balances.size() > 1) {
                updateInfo = (BalanceUpdateInfo)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)updateInfo), BalanceUpdateInfo.class);
                int size = balances.size() - 1;
                for (int i = 1; i <= size; ++i) {
                    BalanceUpdateInfo balance = balances.get(i);
                    updateInfo.setCreditAmount(updateInfo.getCreditAmount().add(balance.getCreditAmount()));
                    updateInfo.setDebitAmount(updateInfo.getDebitAmount().add(balance.getDebitAmount()));
                    BigDecimal freezeAmount = balance.getFreezeAmount();
                    if (freezeAmount == null) continue;
                    totalFreezeAmount = totalFreezeAmount.add(freezeAmount);
                }
            }
            if (updateInfo.getFreezeAmount() != null) {
                totalFreezeAmount = totalFreezeAmount.add(updateInfo.getFreezeAmount());
            }
            updateInfo.setFreezeAmount(totalFreezeAmount);
            updateInfo.setLstBalance(lstBalance);
            DynamicObject balanceObj = BalanceUpdateHelper.createBalanceObj(entityName, updateInfo);
            dynamicObjs.add(balanceObj);
            lstBalance = balanceObj.getBigDecimal("amount");
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjs.toArray(dynamicObjs.toArray(new DynamicObject[0])));
    }

    public static void batchInitBillBlance(String entityName, List<BalanceUpdateInfo> balanceList, Date beginDate) {
        if (EmptyUtil.isEmpty(balanceList)) {
            return;
        }
        Map<Long, List<BalanceUpdateInfo>> bizBillMap = balanceList.stream().collect(Collectors.groupingBy(BalanceUpdateInfo::getBizBillId));
        for (Map.Entry<Long, List<BalanceUpdateInfo>> entry : bizBillMap.entrySet()) {
            BalanceUpdateHelper.initBillBlance(entityName, entry.getValue(), beginDate);
        }
    }

    public static void updateBalanceByDetail(String entityName, List<BalanceUpdateInfo> balanceList, Date beginDate, Date endDate, BigDecimal lstBalance) {
        BalanceUpdateInfo balance = balanceList.get(0);
        Long bizBillId = balance.getBizBillId();
        Long currencyId = balance.getCurrencyId();
        ArrayList<DynamicObject> addNewBalanceList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> updateBalanceList = new ArrayList<DynamicObject>(16);
        List<DynamicObject> balanceColls = BalanceUpdateHelper.queryBalanceColls(entityName, bizBillId, currencyId, beginDate, endDate);
        Map<Date, DynamicObject> balanceMap = balanceColls.stream().collect(Collectors.toMap(b -> b.getDate("bizdate"), b -> b));
        for (BalanceUpdateInfo balanceUpdateInfo : balanceList) {
            Date bizDate = balanceUpdateInfo.getBizDate();
            DynamicObject balanceObj = balanceMap.get(bizDate);
            if (balanceObj == null) {
                balanceObj = BalanceUpdateHelper.createBalanceObj(entityName, balanceUpdateInfo);
                addNewBalanceList.add(balanceObj);
                continue;
            }
            balanceObj.set("creditamount", (Object)BalanceUpdateHelper.defaultZero(balanceUpdateInfo.getCreditAmount()));
            balanceObj.set("debitamount", (Object)BalanceUpdateHelper.defaultZero(balanceUpdateInfo.getDebitAmount()));
            updateBalanceList.add(balanceObj);
        }
        if (!addNewBalanceList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])addNewBalanceList.toArray(new DynamicObject[addNewBalanceList.size()]));
        }
        if (!updateBalanceList.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])updateBalanceList.toArray(new DynamicObject[updateBalanceList.size()]));
        }
        ArrayList params = new ArrayList(16);
        String tableName = BalanceUpdateHelper.getEntityTableName(entityName);
        DB.query((DBRoute)DBRouteConst.TMC, (String)String.format(QUERY_BALANCE_SQL, tableName, lstBalance.doubleValue(), bizBillId, currencyId, DateUtils.formatString(beginDate, "yyyy-MM-dd"), DateUtils.formatString(endDate, "yyyy-MM-dd")), rs -> {
            while (rs.next()) {
                DynamicObject balanceObj = (DynamicObject)balanceMap.get(rs.getDate("fbizdate"));
                if (balanceObj == null) continue;
                BigDecimal amount = rs.getBigDecimal("famount");
                BigDecimal lstbalance = rs.getBigDecimal("flstbalance");
                params.add(new Object[]{amount, lstbalance, amount, balanceObj.getLong("id")});
            }
            return balanceMap;
        });
        DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)String.format(SQL_UPDATE_BALANCE, tableName), params);
    }

    public static DynamicObject createBalanceObj(String entityName, BalanceUpdateInfo balanceInfo) {
        DynamicObject balanceObj = TmcDataServiceHelper.newDynamicObject((String)entityName);
        balanceObj.set("company", (Object)balanceInfo.getCompanyId());
        balanceObj.set("accountbank", (Object)balanceInfo.getBizBillId());
        balanceObj.set("currency", (Object)balanceInfo.getCurrencyId());
        balanceObj.set("bizdate", (Object)balanceInfo.getBizDate());
        BigDecimal creditAmount = BalanceUpdateHelper.defaultZero(balanceInfo.getCreditAmount());
        BigDecimal debitAmount = BalanceUpdateHelper.defaultZero(balanceInfo.getDebitAmount());
        balanceObj.set("creditamount", (Object)creditAmount);
        balanceObj.set("debitamount", (Object)debitAmount);
        BigDecimal lstBalance = BalanceUpdateHelper.defaultZero(balanceInfo.getLstBalance());
        balanceObj.set("lstbalance", (Object)lstBalance);
        BigDecimal amount = lstBalance.add(creditAmount.subtract(debitAmount));
        balanceObj.set("amount", (Object)amount);
        BigDecimal validBalance = amount;
        BigDecimal freezeAmount = balanceInfo.getFreezeAmount();
        if (freezeAmount != null) {
            validBalance = amount.subtract(freezeAmount);
        }
        balanceObj.set("valibalance", (Object)validBalance);
        Timestamp currentTime = DateUtils.getCurrentTime();
        balanceObj.set("createtime", (Object)currentTime);
        balanceObj.set("keycol", (Object)balanceInfo.genKeyCol());
        return balanceObj;
    }

    public static void updateNetxBizDateBalance2(String entityName, BalanceUpdateInfo balanceInfo) {
        Long bizBillId = balanceInfo.getBizBillId();
        Long currencyId = balanceInfo.getCurrencyId();
        Date bizDate = balanceInfo.getBizDate() != null ? balanceInfo.getBizDate() : MIN_BIZ_DATE;
        String bizDateStr = DateUtils.formatString(bizDate, "yyyy-MM-dd");
        String tableName = BalanceUpdateHelper.getEntityTableName(entityName);
        BigDecimal lstBalance = balanceInfo.getLstBalance() != null ? balanceInfo.getLstBalance() : BalanceUpdateHelper.getLstBalance(entityName, bizBillId, currencyId, bizDate);
        String fromSql = String.format(FROM_BALANCE_SQL, tableName, bizBillId, currencyId, bizDateStr);
        String updateSql = String.format(UPDATE_NEXT_BALANCE_SQL, tableName, lstBalance.doubleValue(), fromSql, bizBillId, currencyId, bizDateStr);
        DB.execute((DBRoute)DBRouteConst.TMC, (String)updateSql);
        DB.execute((DBRoute)DBRouteConst.TMC, (String)String.format(UPDATE_VALIBALANCE_SQL, tableName, bizBillId, currencyId, bizDateStr));
    }

    public static void updateNetxBizDateBalance(String entityName, BalanceUpdateInfo balanceInfo) {
        Date bizDate;
        Long currencyId;
        Long bizBillId = balanceInfo.getBizBillId();
        List<DynamicObject> balances = BalanceUpdateHelper.queryNextBizDateBalances(entityName, bizBillId, currencyId = balanceInfo.getCurrencyId(), bizDate = balanceInfo.getBizDate());
        if (EmptyUtil.isEmpty(balances)) {
            return;
        }
        BigDecimal lstBalance = balanceInfo.getLstBalance();
        Date date = balances.get(0).getDate("bizdate");
        lstBalance = date.after(bizDate) ? balanceInfo.calcAmount() : (lstBalance != null ? lstBalance : BalanceUpdateHelper.getLstBalance(entityName, bizBillId, currencyId, bizDate));
        ArrayList<Object[]> params = new ArrayList<Object[]>(balances.size());
        for (DynamicObject balance : balances) {
            BigDecimal creditAmount = BalanceUpdateHelper.defaultZero(balance.getBigDecimal("creditamount"));
            BigDecimal debitAmount = BalanceUpdateHelper.defaultZero(balance.getBigDecimal("debitamount"));
            BigDecimal dcAmount = creditAmount.subtract(debitAmount);
            BigDecimal amount = lstBalance.add(dcAmount);
            params.add(new Object[]{amount, lstBalance, amount, balance.getLong("id")});
            lstBalance = amount;
        }
        DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)String.format(SQL_UPDATE_BALANCE, BalanceUpdateHelper.getEntityTableName(entityName)), params);
    }

    public static BalanceUpdateInfo queryLstBalance(String entityName, Long bizBillId, Long currencyId, Date bizDate) {
        DynamicObject balanceObj = BalanceUpdateHelper.queryLstBlanceObj(entityName, bizBillId, currencyId, bizDate);
        if (balanceObj == null) {
            return null;
        }
        return BalanceUpdateHelper.transBillBalance(balanceObj);
    }

    public static BigDecimal getLstBalance(String entityName, Long bizBillId, Long currencyId, Date bizDate) {
        DynamicObject lstBalance = BalanceUpdateHelper.queryLstBlanceObj(entityName, bizBillId, currencyId, bizDate);
        return lstBalance != null ? lstBalance.getBigDecimal("lstbalance") : BigDecimal.ZERO;
    }

    public static DynamicObject queryLstBlanceObj(String entityName, Long bizBillId, Long currencyId, Date bizDate) {
        QFilter filter = new QFilter("accountbank.id", "=", (Object)bizBillId);
        filter.and("currency.id", "=", (Object)currencyId);
        filter.and("bizdate", "<", (Object)bizDate);
        Object[] balances = TmcDataServiceHelper.load((String)entityName, (String)SELECT_FIELDS, (QFilter[])filter.toArray(), (String)"bizdate desc", (int)1);
        return EmptyUtil.isEmpty(balances) ? null : balances[0];
    }

    public static List<DynamicObject> queryNextBizDateBalances(String entityName, Long bizBillId, Long currencyId, Date bizDate) {
        QFilter filter = new QFilter("accountbank.id", "=", (Object)bizBillId);
        filter.and("currency.id", "=", (Object)currencyId);
        filter.and("bizdate", ">", (Object)bizDate);
        DynamicObject[] dynamicObjs = TmcDataServiceHelper.load((String)entityName, (String)SELECT_FIELDS, (QFilter[])filter.toArray(), (String)"bizdate");
        return Arrays.asList(dynamicObjs);
    }

    public static List<DynamicObject> queryBalanceColls(String entityName, Long bizBillId, Long currencyId, Date beginDate, Date endDate) {
        QFilter filter = new QFilter("accountbank.id", "=", (Object)bizBillId);
        if (currencyId != null) {
            filter.and("currency.id", "=", (Object)currencyId);
        }
        if (beginDate != null) {
            filter.and("bizdate", ">=", (Object)beginDate);
        }
        if (endDate != null) {
            filter.and("bizdate", "<=", (Object)endDate);
        }
        DynamicObject[] dynamicObjs = TmcDataServiceHelper.load((String)entityName, (String)SELECT_FIELDS, (QFilter[])filter.toArray(), (String)"bizdate");
        return Arrays.asList(dynamicObjs);
    }

    public static List<BalanceUpdateInfo> queryBalanceList(String entityName, Long bizBillId, Date beginDate, Date endDate) {
        List<DynamicObject> dynamicObjs = BalanceUpdateHelper.queryBalanceColls(entityName, bizBillId, null, beginDate, endDate);
        if (EmptyUtil.isEmpty(dynamicObjs)) {
            return Collections.EMPTY_LIST;
        }
        return BalanceUpdateHelper.transBillBalanceList(dynamicObjs);
    }

    public static List<BalanceUpdateInfo> queryBalanceGroupByCompanyId(String entityName, List<Long> companyIds, List<Long> currencyIds, Date beginDate, Date endDate) {
        QFilter filter = new QFilter("company.id", "in", companyIds);
        if (EmptyUtil.isNoEmpty(currencyIds)) {
            filter.and("currency.id", "in", currencyIds);
        }
        if (beginDate != null) {
            filter.and("bizdate", ">=", (Object)beginDate);
        }
        if (endDate != null) {
            filter.and("bizdate", "<=", (Object)endDate);
        }
        ArrayList<BalanceUpdateInfo> balanceList = new ArrayList<BalanceUpdateInfo>(16);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"tmc.fbp.queryBalanceGroupByCompanyId", (String)entityName, (String)"company.id,currency.id,debitamount,creditamount,amount,lstbalance,valibalance", (QFilter[])filter.toArray(), null);
        DataSet dataSet = ds.groupBy(new String[]{"company.id", "currency.id"}).sum("amount").sum("valibalance").sum("debitamount").sum("creditamount").finish();
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            BalanceUpdateInfo info = BalanceUpdateInfo.build(null, row.getLong("company.id"), row.getLong("currency.id")).setAmount(row.getBigDecimal("amount")).setValiBalance(row.getBigDecimal("valibalance")).setCreditAmount(row.getBigDecimal("creditamount")).setDebitAmount(row.getBigDecimal("debitamount"));
            balanceList.add(info);
        }
        return balanceList;
    }

    public static List<BalanceUpdateInfo> transBillBalanceList(List<DynamicObject> dynamicObjs) {
        if (EmptyUtil.isEmpty(dynamicObjs)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<BalanceUpdateInfo> balanceList = new ArrayList<BalanceUpdateInfo>(dynamicObjs.size());
        for (DynamicObject dynObj : dynamicObjs) {
            balanceList.add(BalanceUpdateHelper.transBillBalance(dynObj));
        }
        return balanceList;
    }

    private static BalanceUpdateInfo transBillBalance(DynamicObject dynObj) {
        BalanceUpdateInfo balance = new BalanceUpdateInfo();
        balance.setId(dynObj.getLong("id")).setBizBillId(dynObj.getLong("accountbank.id")).setCurrencyId(dynObj.getLong("currency.id")).setCompanyId(dynObj.getLong("company.id")).setBizDate(dynObj.getDate("bizdate")).setAmount(dynObj.getBigDecimal("amount")).setLstBalance(dynObj.getBigDecimal("lstbalance")).setValiBalance(dynObj.getBigDecimal("valibalance")).setDebitAmount(dynObj.getBigDecimal("debitamount")).setCreditAmount(dynObj.getBigDecimal("creditamount"));
        return balance;
    }

    public static Long saveBillBlance(String entityName, BalanceUpdateInfo balanceUpdateInfo, BigDecimal initBalance) {
        Date lastBizDate;
        DynamicObject balanceObj = null;
        DynamicObject lastBalanceObj = BalanceUpdateHelper.queryLstBlanceObj(entityName, balanceUpdateInfo.getBizBillId(), balanceUpdateInfo.getCurrencyId(), balanceUpdateInfo.getBizDate());
        BigDecimal lstBalance = lastBalanceObj == null ? initBalance : lastBalanceObj.getBigDecimal("lstbalance");
        BigDecimal bigDecimal = lstBalance = lstBalance != null ? initBalance : BigDecimal.ZERO;
        if (lastBalanceObj != null && (lastBizDate = lastBalanceObj.getDate("bizdate")).compareTo(balanceUpdateInfo.getBizDate()) == 0) {
            balanceObj = lastBalanceObj;
        }
        if (balanceObj == null) {
            balanceObj = BalanceUpdateHelper.createBalanceObj(entityName, balanceUpdateInfo);
        }
        balanceObj.set("lstbalance", (Object)lstBalance);
        BigDecimal amount = lstBalance.add(balanceObj.getBigDecimal("creditamount").subtract(balanceObj.getBigDecimal("debitamount")));
        balanceObj.set("amount", (Object)amount);
        balanceObj.set("valibalance", (Object)amount);
        if (balanceObj.getLong("id") == 0L) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{balanceObj});
        } else {
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{balanceObj});
        }
        BalanceUpdateHelper.updateNetxBizDateBalance(entityName, balanceUpdateInfo);
        return balanceObj.getLong("id");
    }

    public static String getEntityTableName(String entityName) {
        return EntityMetadataCache.getDataEntityType((String)entityName).getAlias();
    }

    public static BigDecimal defaultZero(BigDecimal value) {
        return value == null ? BigDecimal.ZERO : value;
    }

    public static boolean isZero(BigDecimal value) {
        return BigDecimal.ZERO.compareTo(value) == 0;
    }
}

