/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.CellStyle;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.metadata.util.GzipUtils;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.helper.DynamicObjectCompareHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class BillChangeHistoryHelper {
    public static final String CHANGE_HISTORY_ENTITY = "fcs_changehistory";
    private static final String CHANGE_HISTORY_PROPS = "id, bizid, bizentity, billinfo_tag,creator, createtime, seqnumber, lastversion, applyentity, applyid, applybillno, reason, version, applycreate";
    private static final String COLOR_THEMECOLOR = "rgba(85, 130, 243, .2)";

    public static void showChangePropForFormView(DynamicObject lastBill, DynamicObject nextBill, IFormView formView) {
        Map<String, Object> nextDataMap;
        Map<String, Object> lastDataMap = DynamicObjectCompareHelper.dynamicObj2Map(lastBill);
        Map<String, List<Object>> entriesDiffering = DynamicObjectCompareHelper.entriesDiffering(lastDataMap, nextDataMap = DynamicObjectCompareHelper.dynamicObj2Map(nextBill));
        if (CollectionUtils.isEmpty(entriesDiffering)) {
            return;
        }
        for (Map.Entry<String, List<Object>> entry : entriesDiffering.entrySet()) {
            TmcViewInputHelper.showModifyTip(formView, entry.getKey(), ResManager.loadKDString((String)"\u5b57\u6bb5\u6709\u4fee\u6539", (String)"BillChangeHistoryHelper_1", (String)"tmc-fbp-common", (Object[])new Object[0]));
        }
    }

    public static boolean showChangePropForEntryGrid(DynamicObject lastBill, DynamicObject nextBill, String entryName, String entryKey, IFormView formView) {
        boolean isModify = false;
        EntryGrid entryGrid = (EntryGrid)formView.getControl(entryName);
        DynamicObjectCollection lastEntitys = lastBill.getDynamicObjectCollection(entryName);
        DynamicObjectCollection nextEntitys = nextBill.getDynamicObjectCollection(entryName);
        HashMap<Object, Map<String, Object>> nextRecord = new HashMap<Object, Map<String, Object>>(nextEntitys.size());
        if (lastEntitys.size() > 0) {
            for (DynamicObject nextEntity : nextEntitys) {
                Map<String, Object> nextjMap = DynamicObjectCompareHelper.dynamicObj2Map(nextEntity, true);
                nextRecord.put(nextjMap.get(entryKey), nextjMap);
            }
        }
        int size = lastEntitys.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject entry = (DynamicObject)lastEntitys.get(i);
            Map<String, Object> lastObjMap = DynamicObjectCompareHelper.dynamicObj2Map(entry, true);
            if (nextRecord.isEmpty()) {
                return isModify;
            }
            Map nextObjMap = (Map)nextRecord.get(lastObjMap.get(entryKey));
            ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(16);
            if (nextObjMap == null) {
                for (Map.Entry<String, Object> oldEntry : lastObjMap.entrySet()) {
                    cellStyles.add(BillChangeHistoryHelper.buildCellStyle(oldEntry.getKey(), i));
                }
                isModify = true;
                entryGrid.setCellStyle(cellStyles);
                return isModify;
            }
            Map<String, List<Object>> entriesDiffering = DynamicObjectCompareHelper.entriesDiffering(lastObjMap, nextObjMap);
            if (CollectionUtils.isEmpty(entriesDiffering)) continue;
            for (Map.Entry<String, List<Object>> diffEntry : entriesDiffering.entrySet()) {
                cellStyles.add(BillChangeHistoryHelper.buildCellStyle(diffEntry.getKey(), i));
                isModify = true;
            }
            entryGrid.setCellStyle(cellStyles);
        }
        return isModify;
    }

    public static void addChangeHistory(Long applyId, String applyentity, String applybillno, String applyReason, String versionPrefix, DynamicObject bizBillInfo) {
        BillChangeHistoryHelper.addChangeHistory(applyId, applyentity, applybillno, applyReason, versionPrefix, bizBillInfo, "t_fcs_changehistory", CHANGE_HISTORY_ENTITY);
    }

    public static void addChangeHistory(Long applyId, String applyentity, String applybillno, String applyReason, String versionPrefix, DynamicObject bizBillInfo, String historyTableName, String historyEntity) {
        Long pkValue = (Long)bizBillInfo.getPkValue();
        String bizEntityName = bizBillInfo.getDataEntityType().getName();
        String updateSql = "update " + historyTableName + " set flastversion  = ? where fbizid = ? and fbizentity = ? and flastversion = ? ";
        DB.execute((DBRoute)DBRouteConst.TMC, (String)updateSql, (Object[])new Object[]{Character.valueOf('0'), pkValue, bizEntityName, "1"});
        DynamicObject changeHistory = TmcDataServiceHelper.newDynamicObject((String)historyEntity);
        changeHistory.set("applyid", (Object)applyId);
        changeHistory.set("applyentity", (Object)applyentity);
        changeHistory.set("applybillno", (Object)applybillno);
        changeHistory.set("bizid", (Object)pkValue);
        changeHistory.set("bizentity", (Object)bizEntityName);
        changeHistory.set("reason", (Object)applyReason);
        if (EmptyUtil.isNoEmpty(applyentity) && !bizEntityName.equals(applyentity)) {
            changeHistory.set("applycreate", (Object)true);
        }
        String serialize = SerializationUtils.serializeToBase64((Object)bizBillInfo);
        try {
            changeHistory.set("billinfo_tag", (Object)GzipUtils.compress((String)serialize, (String)"UTF-8"));
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        String version = versionPrefix + "-" + DateUtils.formatString(DateUtils.getCurrentDate(), "yyyyMMdd");
        Map<String, Object> map = BillChangeHistoryHelper.genSerialNumber(pkValue, historyEntity);
        changeHistory.set("version", (Object)(version + "-" + map.get("version")));
        changeHistory.set("seqnumber", map.get("seqnumber"));
        changeHistory.set("creator", (Object)RequestContext.get().getCurrUserId());
        changeHistory.set("lastversion", (Object)true);
        OperationResult result = TmcOperateServiceHelper.execOperate("save", historyEntity, new DynamicObject[]{changeHistory}, OperateOption.create());
        result.isSuccess();
    }

    public static DynamicObject genDelChangeHistory(Long bizId, String bizEntityName) {
        return BillChangeHistoryHelper.genDelChangeHistory(bizId, bizEntityName, "t_fcs_changehistory", CHANGE_HISTORY_ENTITY);
    }

    public static DynamicObject genDelChangeHistory(Long bizId, String bizEntityName, String historyTableName, String historyEntity) {
        DynamicObject history = BillChangeHistoryHelper.getLastChangeHistory(bizId, bizEntityName, historyEntity);
        int seqNumber = history.getInt("seqnumber");
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)historyEntity), (Object[])new Object[]{history.getPkValue()});
        if (seqNumber > 1) {
            String updateSql = "update " + historyTableName + " set flastversion  = ? where fbizid = ? and fbizentity = ? and fseqnumber = ? ";
            DB.execute((DBRoute)DBRouteConst.TMC, (String)updateSql, (Object[])new Object[]{Character.valueOf('1'), bizId, bizEntityName, seqNumber - 1});
        }
        return BillChangeHistoryHelper.deserializeBillInfo(history);
    }

    private static Map<String, Object> genSerialNumber(Long pkValue, String historyEntity) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>(16);
        QFilter filter = new QFilter("bizid", "=", (Object)pkValue);
        int count = TmcDataServiceHelper.count(historyEntity, filter.toArray());
        String seq = count == 0 ? "1" : String.valueOf(count + 1);
        StringBuilder number = new StringBuilder(seq);
        for (int index = number.length(); index < 4; ++index) {
            number.insert(0, "0");
        }
        returnMap.put("seqnumber", Integer.parseInt(seq));
        returnMap.put("version", number.toString());
        return returnMap;
    }

    public static DynamicObject getChangeHistoryById(Long historyId, String historyEntity) {
        return TmcDataServiceHelper.loadSingle((Object)historyId, (String)historyEntity, (String)CHANGE_HISTORY_PROPS);
    }

    public static DynamicObject getLastChangeHistory(Long bizId, String bizEntityName) {
        return BillChangeHistoryHelper.getLastChangeHistory(bizId, bizEntityName, CHANGE_HISTORY_ENTITY);
    }

    public static DynamicObject getLastChangeHistory(Long bizId, String bizEntityName, String historyEntity) {
        QFilter qFilter = new QFilter("bizid", "=", (Object)bizId);
        qFilter.and("bizentity", "=", (Object)bizEntityName);
        qFilter.and("lastversion", "=", (Object)true);
        return TmcDataServiceHelper.loadSingle((String)historyEntity, (String)CHANGE_HISTORY_PROPS, (QFilter[])qFilter.toArray());
    }

    public static DynamicObject getLastChangeHistoryByApplyId(Long applyId, String bizEntityName) {
        QFilter qFilter = new QFilter("applyid", "=", (Object)applyId);
        qFilter.and("bizentity", "=", (Object)bizEntityName);
        qFilter.and("lastversion", "=", (Object)true);
        return TmcDataServiceHelper.loadSingle((String)CHANGE_HISTORY_ENTITY, (String)CHANGE_HISTORY_PROPS, (QFilter[])qFilter.toArray());
    }

    public static Pair<Boolean, DynamicObject> getNextChangeHistory(DynamicObject historyBill, String historyEntity) {
        int seqNumber = historyBill.getInt("seqnumber");
        boolean isLastVersion = historyBill.getBoolean("lastversion");
        Long bizId = historyBill.getLong("bizid");
        String bizEntity = historyBill.getDynamicObject("bizentity").getString("number");
        if (isLastVersion) {
            return Pair.of((Object)isLastVersion, null);
        }
        QFilter qFilter = new QFilter("bizid", "=", (Object)bizId);
        qFilter.and("bizentity.number", "=", (Object)bizEntity);
        qFilter.and("seqnumber", "=", (Object)(seqNumber + 1));
        DynamicObject historyNextBill = TmcDataServiceHelper.loadSingle((String)historyEntity, (String)CHANGE_HISTORY_PROPS, (QFilter[])qFilter.toArray());
        return Pair.of((Object)isLastVersion, (Object)BillChangeHistoryHelper.deserializeBillInfo(historyNextBill));
    }

    public static DynamicObject deserializeBillInfo(DynamicObject historyBill) {
        try {
            String billinfoJson = historyBill.getString("billinfo_tag");
            String uncompress = GzipUtils.uncompress((String)billinfoJson, (String)"UTF-8");
            return (DynamicObject)SerializationUtils.deSerializeFromBase64((String)uncompress);
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static DynamicObject[] getChangeHistoryByBizId(Long bizId, String bizEntityName, String historyEntityName) {
        QFilter qFilter = new QFilter("bizid", "=", (Object)bizId);
        qFilter.and("bizentity", "=", (Object)bizEntityName);
        return TmcDataServiceHelper.load((String)historyEntityName, (String)CHANGE_HISTORY_PROPS, (QFilter[])qFilter.toArray(), (String)"seqnumber asc");
    }

    public static DynamicObject[] getChangeHistoryByBizId(Long bizId, String bizEntityName) {
        return BillChangeHistoryHelper.getChangeHistoryByBizId(bizId, bizEntityName, CHANGE_HISTORY_ENTITY);
    }

    private static CellStyle buildCellStyle(String propertyName, int index) {
        CellStyle style = new CellStyle();
        style.setFieldKey(propertyName);
        style.setRow(index);
        style.setBackColor(COLOR_THEMECOLOR);
        return style;
    }

    public static boolean loadEntrysInfo(IFormView view) {
        return view.getFormShowParameter().getCustomParams().containsKey("openHistoryId");
    }
}

