/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.bean.BalanceModelBean;
import kd.tmc.fbp.common.bean.BizBalanceModelBean;
import kd.tmc.fbp.common.bean.ModelRequestBean;
import kd.tmc.fbp.common.enums.CalFormulaEnum;
import kd.tmc.fbp.common.helper.BalanceModelHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class BizBalanceModelHelper {
    public static BizBalanceModelBean getRunningBalance(String balanceType, long accountId, long currencyId) {
        return BalanceModelHelper.genResponseBean(balanceType, accountId, currencyId);
    }

    public static ModelRequestBean getRunningBalanceBatch(ModelRequestBean bizBeans) throws Exception {
        return BalanceModelHelper.getAmountBatch(bizBeans);
    }

    public static BigDecimal getBalanceModelAmount(Long modelId, long accountId, long currencyId, Long billId) {
        DynamicObject balanceModel = TmcDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"fcs_balancemodel");
        return (BigDecimal)BizBalanceModelHelper.getBalanceModelAmountCommon(balanceModel, accountId, currencyId, billId).getRight();
    }

    public static BigDecimal getBalanceModelAmount(String modelType, String bizBill, String accountBankProp, String balanceType, long accountId, long currencyId) {
        DynamicObject balanceModel = BalanceModelHelper.queryBalanceModel(modelType, bizBill, accountBankProp, balanceType);
        return (BigDecimal)BizBalanceModelHelper.getBalanceModelAmountCommon(balanceModel, accountId, currencyId, null).getRight();
    }

    private static Pair<Set<Long>, BigDecimal> getBalanceModelAmountCommon(DynamicObject balanceModel, long accountId, long currencyId, Long billId) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        DynamicObjectCollection entrys = balanceModel.getDynamicObjectCollection("entry");
        boolean partCal = balanceModel.getBoolean("partcal");
        if (partCal) {
            BigDecimal amount;
            QFilter acctFlt;
            DynamicObject acc;
            DynamicObject account = TmcDataServiceHelper.loadSingleFromCache((Object)accountId, (String)"bd_accountbanks");
            if (EmptyUtil.isEmpty(account) && EmptyUtil.isNoEmpty(acc = TmcDataServiceHelper.loadSingleFromCache((String)"bd_accountbanks", (String)"id", (QFilter[])(acctFlt = new QFilter("inneracct.id", "=", (Object)accountId)).toArray()))) {
                accountId = acc.getLong("id");
            }
            if ((amount = BalanceModelHelper.getAmount(new BalanceModelBean(), balanceModel.getString("balancetype"), accountId, currencyId)) != null) {
                totalAmount = totalAmount.add(amount);
            }
        }
        HashSet idSet = new HashSet(16);
        for (DynamicObject entry : entrys) {
            String calFormula = entry.getString("calformula");
            Pair<Set<Long>, BigDecimal> pair = BalanceModelHelper.getCalIdsAndAmount(new BalanceModelBean(), balanceModel.getString("name"), entry, accountId, currencyId, billId);
            if (CalFormulaEnum.ADD.getValue().equals(calFormula)) {
                totalAmount = totalAmount.add((BigDecimal)pair.getRight());
                continue;
            }
            if (pair.getLeft() == null) continue;
            totalAmount = totalAmount.subtract((BigDecimal)pair.getRight());
            idSet.addAll((Collection)pair.getLeft());
        }
        return Pair.of(idSet, (Object)totalAmount);
    }

    public static void showBalanceModel(IFormView view, String modelType, String bizBill, String accountBankProp, String balanceType, long accountId, long currencyId) {
        DynamicObject balanceModel = BalanceModelHelper.queryBalanceModel(modelType, bizBill, accountBankProp, balanceType);
        BalanceModelHelper.drawModelFormula(view, balanceModel.getLong("id"), accountId, currencyId);
    }

    public static int getCountModelNum(Long countId, long accountId, long currencyId, Long billId) {
        int returnCount = 0;
        DynamicObject balanceModel = TmcDataServiceHelper.loadSingleFromCache((Object)countId, (String)"fcs_countmodel");
        DynamicObjectCollection entrys = balanceModel.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entrys) {
            String calFormula = entry.getString("calformula");
            int calCount = BalanceModelHelper.getCountModelNum(entry, balanceModel.getString("name"), accountId, currencyId, billId);
            if (CalFormulaEnum.ADD.getValue().equals(calFormula)) {
                returnCount += calCount;
                continue;
            }
            returnCount -= calCount;
        }
        return returnCount;
    }

    public static Pair<Set<Long>, BigDecimal> getBalanceModelIdsAndAmount(Long modelId, long accountId, long currencyId) {
        DynamicObject balanceModel = TmcDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"fcs_balancemodel");
        return BizBalanceModelHelper.getBalanceModelAmountCommon(balanceModel, accountId, currencyId, null);
    }
}

