/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CasBusinessHelper {
    private static final Log logger = LogFactory.getLog(CasBusinessHelper.class);
    public static final String CONFIG_BALANCE_MODEL = "fi.cas.model.balance";

    public static BigDecimal getBalanceFormCas(long orgId, long bankacctId, long currencyId) {
        logger.info("getBalanceFormCas \u7ec4\u7ec7ID:{}\uff0c\u8d26\u6237ID\uff1a{}\uff0c\u5e01\u522bID\uff1a{}", new Object[]{orgId, bankacctId, currencyId});
        Date bizDate = DateUtils.getCurrentDate();
        if (CasBusinessHelper.useBalanceModel()) {
            Object[] params = new Object[]{orgId, bankacctId, currencyId, bizDate};
            BigDecimal balanceAmout = (BigDecimal)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"BalanceCountService", (String)"getBizDateBalance", (Object[])params);
            logger.info("======= balanceAmout:{} ========", (Object)balanceAmout);
            return balanceAmout;
        }
        return (BigDecimal)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"accountAmountService", (String)"getAmountByAccount", (Object[])new Object[]{bankacctId, currencyId, bizDate});
    }

    public static Map<String, BigDecimal> getJournalBalanceBatch(Set<Long> orgIds, List<Long> accountIdList, List<Long> currencyIdList) {
        logger.info("getBalanceFormCas \u7ec4\u7ec7ID\u96c6\u5408:{}\uff0c\u8d26\u6237ID\u96c6\u5408\uff1a{}\uff0c\u5e01\u522bID\u96c6\u5408\uff1a{}", new Object[]{orgIds, accountIdList, currencyIdList});
        return (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"BalanceCountService", (String)"getJournalBalanceBatch", (Object[])new Object[]{orgIds, accountIdList, currencyIdList, DateUtils.getDataFormat(DateUtils.getCurrentDate(), false)});
    }

    public static BigDecimal getBalance(long orgId, long bankacctId, long currencyId) {
        logger.info("\u7ec4\u7ec7ID:{}\uff0c\u8d26\u6237ID\uff1a{}\uff0c\u5e01\u522bID\uff1a{}", new Object[]{orgId, bankacctId, currencyId});
        long periodId = CasBusinessHelper.getStartPeriod(orgId);
        Date bizDate = DateUtils.getCurrentDate();
        if (CasBusinessHelper.useBalanceModel()) {
            Object[] params = new Object[]{orgId, bankacctId, currencyId, bizDate};
            BigDecimal balanceAmout = (BigDecimal)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"BalanceCountService", (String)"getBizDateBalance", (Object[])params);
            logger.info("======= balanceAmout:{} ========", (Object)balanceAmout);
            return balanceAmout;
        }
        BigDecimal initBalance = CasBusinessHelper.getJounalInitBalance(orgId, periodId, bankacctId, currencyId);
        Date nextBizDate = DateUtils.getNextDay(bizDate, 1);
        BigDecimal journalBalance = CasBusinessHelper.getJournalBalance(orgId, bankacctId, currencyId, nextBizDate);
        return initBalance.add(journalBalance);
    }

    public static BigDecimal getBalance(long orgId, long bankacctId, Date bizDate, long currencyId) {
        long periodId = CasBusinessHelper.getStartPeriod(orgId);
        BigDecimal initBalance = CasBusinessHelper.getJounalInitBalance(orgId, periodId, bankacctId, currencyId);
        BigDecimal journalBalance = CasBusinessHelper.getJournalBalance(orgId, bankacctId, currencyId, bizDate);
        return initBalance.add(journalBalance);
    }

    public static BigDecimal getPayBillOnWayAmt(long bankacctId, long currencyId, boolean isPay) {
        QFilter status = new QFilter("billstatus", "=", (Object)BillStatusEnum.BEING.getValue());
        if (!isPay) {
            status.or(new QFilter("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getValue()));
            status.or(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        }
        QFilter currencyFilter = new QFilter("isdiffcur", "=", (Object)"1").and(new QFilter("dpcurrency", "=", (Object)currencyId)).or(new QFilter("isdiffcur", "=", (Object)"0").and(new QFilter("currency", "=", (Object)currencyId)));
        QFilter[] filters = new QFilter[]{new QFilter("payeracctbank", "=", (Object)bankacctId), currencyFilter, status, new QFilter("iswaitsche", "=", (Object)"0")};
        DynamicObject[] payBils = TmcDataServiceHelper.load((String)"cas_paybill", (String)"isdiffcur,dpamt,actpayamt", (QFilter[])filters);
        BigDecimal amount = BigDecimal.ZERO;
        for (DynamicObject payBill : payBils) {
            boolean isdiffcur = payBill.getBoolean("isdiffcur");
            amount = isdiffcur ? amount.add(payBill.getBigDecimal("dpamt")) : amount.add(payBill.getBigDecimal("actpayamt"));
        }
        return amount;
    }

    public static BigDecimal getPayBillOnWayAmt(long bankacctId, long currencyId) {
        QFilter currencyFilter = new QFilter("isdiffcur", "=", (Object)"1").and(new QFilter("dpcurrency", "=", (Object)currencyId)).or(new QFilter("isdiffcur", "=", (Object)"0").and(new QFilter("currency", "=", (Object)currencyId)));
        QFilter[] filters = new QFilter[]{new QFilter("payeracctbank", "=", (Object)bankacctId), currencyFilter, new QFilter("billstatus", "in", (Object)new String[]{BillStatusEnum.BEING.getValue(), BillStatusEnum.SAVE.getValue(), BillStatusEnum.SUBMIT.getValue(), BillStatusEnum.AUDIT.getValue()}), new QFilter("iswaitsche", "=", (Object)"0")};
        DynamicObject[] payBils = TmcDataServiceHelper.load((String)"cas_paybill", (String)"isdiffcur,dpamt,actpayamt", (QFilter[])filters);
        BigDecimal amount = BigDecimal.ZERO;
        for (DynamicObject payBill : payBils) {
            boolean isdiffcur = payBill.getBoolean("isdiffcur");
            amount = isdiffcur ? amount.add(payBill.getBigDecimal("dpamt")) : amount.add(payBill.getBigDecimal("actpayamt"));
        }
        return amount;
    }

    public static BigDecimal getAgentPayBillOnWayAmt(long bankacctId, long currencyId, boolean isPay) {
        QFilter[] filters;
        DataSet payBillSet;
        DataSet ds;
        QFilter status = new QFilter("billstatus", "=", (Object)BillStatusEnum.BEING.getValue());
        if (!isPay) {
            status.or(new QFilter("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getValue()));
            status.or(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        }
        if ((ds = (payBillSet = QueryServiceHelper.queryDataSet((String)"paymentbill", (String)"cas_agentpaybill", (String)"payamount,actpayamount", (QFilter[])(filters = new QFilter[]{new QFilter("payeracctbank", "=", (Object)bankacctId), new QFilter("currency", "=", (Object)currencyId), status}), null)).groupBy(new String[0]).sum("payamount").sum("actpayamount").finish()).hasNext()) {
            Row row = ds.next();
            BigDecimal payamount = row.getBigDecimal("payamount") == null ? BigDecimal.ZERO : row.getBigDecimal("payamount");
            BigDecimal actpayamount = row.getBigDecimal("actpayamount") == null ? BigDecimal.ZERO : row.getBigDecimal("actpayamount");
            return payamount.subtract(actpayamount);
        }
        return Constants.ZERO;
    }

    public static BigDecimal getPayBillPayAmt(long bankacctId, long currencyId, Date startTime, Date endTime) {
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.PAYED.getValue());
        QFilter startTimeFilter = new QFilter("paydate", ">=", (Object)startTime);
        QFilter endTimeFilter = new QFilter("paydate", "<=", (Object)endTime);
        QFilter[] filters = new QFilter[]{new QFilter("payeracctbank", "=", (Object)bankacctId), new QFilter("currency", "=", (Object)currencyId), statusFilter, startTimeFilter, endTimeFilter};
        DataSet payBillSet = QueryServiceHelper.queryDataSet((String)"paymentbill", (String)"cas_paybill", (String)"payeracctbank.id,currency.id,actpayamt", (QFilter[])filters, null);
        DataSet ds = payBillSet.groupBy(new String[0]).sum("actpayamt").finish();
        if (ds.hasNext()) {
            Row row = ds.next();
            return row.getBigDecimal("actpayamt");
        }
        return Constants.ZERO;
    }

    public static BigDecimal getAgentPayBillPayAmt(long bankacctId, long currencyId, Date startTime, Date endTime) {
        QFilter billstatusFilter = new QFilter("billstatus", "in", (Object)new String[]{BillStatusEnum.PAYED.getValue(), BillStatusEnum.BEING.getValue()});
        QFilter startTimeFilter = new QFilter("paytime", ">=", (Object)startTime);
        QFilter endTimeFilter = new QFilter("paytime", "<=", (Object)endTime);
        QFilter[] filters = new QFilter[]{new QFilter("payeracctbank", "=", (Object)bankacctId), new QFilter("currency", "=", (Object)currencyId), billstatusFilter, startTimeFilter, endTimeFilter};
        DataSet payBillSet = QueryServiceHelper.queryDataSet((String)"agentbill", (String)"cas_agentpaybill", (String)"actpayamount", (QFilter[])filters, null);
        DataSet ds = payBillSet.groupBy(new String[0]).sum("actpayamount").finish();
        if (ds.hasNext()) {
            Row row = ds.next();
            return row.getBigDecimal("actpayamount");
        }
        return Constants.ZERO;
    }

    private static BigDecimal getJournalBalance(long orgId, long acctId, long currencyId, Date bizDate) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("accountbank", "=", (Object)acctId), new QFilter("currency", "=", (Object)currencyId), new QFilter("bizdate", "<", (Object)bizDate), new QFilter("period", "!=", (Object)0)};
        DataSet journalSet = QueryServiceHelper.queryDataSet((String)"journal", (String)"cas_bankjournal", (String)"org.id,accountbank.id,currency.id,debitamount,creditamount", (QFilter[])filters, null);
        DataSet ds = journalSet.groupBy(new String[]{"accountbank.id", "org.id", "currency.id"}).sum("debitamount").sum("creditamount").finish();
        if (ds.hasNext()) {
            Row row = ds.next();
            return row.getBigDecimal("debitamount").subtract(row.getBigDecimal("creditamount"));
        }
        return Constants.ZERO;
    }

    private static BigDecimal getJounalInitBalance(long orgId, long period, long acctId, long currencyId) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("period", "=", (Object)period), new QFilter("accountbank", "=", (Object)acctId), new QFilter("currency", "=", (Object)currencyId)};
        DynamicObject initBalance = BusinessDataServiceHelper.loadSingleFromCache((String)"cas_journalbalance", (String)"id, currency, monthstart", (QFilter[])filters);
        if (!EmptyUtil.isEmpty(initBalance)) {
            return initBalance.getBigDecimal("monthstart");
        }
        return Constants.ZERO;
    }

    private static long getStartPeriod(long orgId) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId)};
        DynamicObject cashMgtInit = BusinessDataServiceHelper.loadSingleFromCache((String)"cas_cashmgtinit", (String)"id,startperiod,standardcurrency.id", (QFilter[])filters);
        if (cashMgtInit == null || cashMgtInit.getDynamicObject("standardcurrency") == null) {
            logger.info("===getStartPeriod.orgid:{}===,traceid:{}.", (Object)orgId, (Object)RequestContext.get().getTraceId());
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u8bf7\u5148\u8fdb\u884c\u51fa\u7eb3\u521d\u59cb\u5316\u8bbe\u7f6e,\u4e4b\u540e\u518d\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"CasBusinessHelper_0", (String)"tmc-fbp-common", (Object[])new Object[0]), CasBusinessHelper.getOrgById(orgId)));
        }
        return cashMgtInit.getDynamicObject("startperiod").getLong("id");
    }

    private static String getOrgById(long id) {
        Map orgMap = BusinessDataServiceHelper.loadFromCache((Object[])new Object[]{id}, (String)"bos_org");
        DynamicObject orgObj = (DynamicObject)orgMap.get(id);
        return orgObj == null ? id + "" : orgObj.getString("name");
    }

    private static boolean useBalanceModel() {
        QFilter payWriteNumber = new QFilter("number", "=", (Object)CONFIG_BALANCE_MODEL);
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        DynamicObject conFig = BusinessDataServiceHelper.loadSingleFromCache((String)"cas_extend_config", (String)"configvalue", (QFilter[])new QFilter[]{payWriteNumber, enable});
        return conFig != null && "true".equals(conFig.getString("configvalue"));
    }

    public static boolean journalIsCheck(DynamicObject bankAcct) {
        DynamicObject[] bankStatement;
        DynamicObject[] bankJournal;
        if (EmptyUtil.isEmpty(bankAcct)) {
            return false;
        }
        Object bankAcctId = bankAcct.getPkValue();
        for (DynamicObject obj : bankJournal = TmcDataServiceHelper.load((String)"cas_bankjournal", (String)"ischeck", (QFilter[])new QFilter[]{new QFilter("accountbank", "in", bankAcctId).and(new QFilter("isvalid", "=", (Object)"1"))})) {
            if (obj.getBoolean("ischeck")) continue;
            return false;
        }
        for (DynamicObject obj : bankStatement = TmcDataServiceHelper.load((String)"cas_bankstatement", (String)"ischeck", (QFilter[])new QFilter[]{new QFilter("accountbank", "in", bankAcctId).and(new QFilter("isvalid", "=", (Object)"1"))})) {
            if (obj.getBoolean("ischeck")) continue;
            return false;
        }
        return true;
    }

    public static boolean bankJournalIsCheck(Set<Long> orgIds, Object bankAcctId) {
        return TmcDataServiceHelper.exists("cas_bankjournal", new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("accountbank", "=", bankAcctId), new QFilter("isvalid", "=", (Object)"1"), new QFilter("ischeck", "=", (Object)"0")});
    }

    public static boolean bankStatementIsCheck(Set<Long> orgIds, Object bankAcctId) {
        return TmcDataServiceHelper.exists("cas_bankstatement", new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("accountbank", "=", bankAcctId), new QFilter("isvalid", "=", (Object)"1"), new QFilter("ischeck", "=", (Object)"0")});
    }

    public static void book(DynamicObject[] journal) {
        OperateOption operate = OperateOption.create();
        TmcOperateServiceHelper.execOperate("book", "cas_bankjournal", journal, operate);
    }

    public static void antiBook(DynamicObject[] journal) {
        OperateOption operate = OperateOption.create();
        TmcOperateServiceHelper.execOperate("antibook", "cas_bankjournal", journal, operate);
    }
}

