/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.bean.CostShareInfo;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.IntHTRuleEnum;
import kd.tmc.fbp.common.enums.ShareFrequencyEnum;
import kd.tmc.fbp.common.enums.ShareTypeEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class CostShareServiceHelper {
    private static final BigDecimal maxYtm = new BigDecimal("0.5");
    private static final BigDecimal minYtm = new BigDecimal("-0.5");
    private static final int maxCount = 200;

    public static List<CostShareInfo> getCostShareList(List<Pair<Date, Date>> dateList, BigDecimal amount, BigDecimal initCcbAmt, BigDecimal loanRate, BasisEnum basisEnum, int amtPrecision, String shareType) {
        if (dateList.size() == 0 || EmptyUtil.isEmpty(amount)) {
            return new ArrayList<CostShareInfo>();
        }
        if (ShareTypeEnum.INTEREST.getValue().equals(shareType)) {
            return CostShareServiceHelper.getCostShareInfoList(dateList, amount, initCcbAmt, loanRate, basisEnum, amtPrecision);
        }
        return CostShareServiceHelper.getContShareListByStraight(dateList, amount, basisEnum, amtPrecision);
    }

    public static List<CostShareInfo> dealCurrencyTailDiff(List<CostShareInfo> infos, BigDecimal freeAmount, int amtPrecision) {
        if (EmptyUtil.isEmpty(infos) && infos.size() == 0) {
            return infos;
        }
        BigDecimal freeAmountSum = BigDecimal.ZERO;
        for (CostShareInfo info : infos) {
            info.setEiInterestAmt(info.getEiInterestAmt() != null ? info.getEiInterestAmt().setScale(amtPrecision, RoundingMode.HALF_UP) : BigDecimal.ZERO);
            info.setAiInterestAmt(info.getAiInterestAmt() != null ? info.getAiInterestAmt().setScale(amtPrecision, RoundingMode.HALF_UP) : BigDecimal.ZERO);
            info.setAmAmt(info.getAmAmt() != null ? info.getAmAmt().setScale(amtPrecision, RoundingMode.HALF_UP) : BigDecimal.ZERO);
            freeAmountSum = freeAmountSum.add(info.getAmAmt());
        }
        BigDecimal diffAmt = freeAmount.subtract(freeAmountSum);
        CostShareInfo costShareInfo = infos.get(infos.size() - 1);
        costShareInfo.setAmAmt(costShareInfo.getAmAmt().add(diffAmt));
        return infos;
    }

    public static List<CostShareInfo> getCostShareInfoList(List<Pair<Date, Date>> dateList, BigDecimal amount, BigDecimal initCcbAmt, BigDecimal loanRate, BasisEnum basisEnum, int amtPrecision) {
        List<CostShareInfo> costShareInfos = CostShareServiceHelper.getCostShareInfo(dateList, amount, loanRate, basisEnum);
        List<CostShareInfo> costShareInfosList = CostShareServiceHelper.calculateYtm(costShareInfos, initCcbAmt, amount, amtPrecision);
        return costShareInfosList;
    }

    public static List<CostShareInfo> getContShareListByStraight(List<Pair<Date, Date>> dateList, BigDecimal amount, BasisEnum basisEnum, int amtPrecision) {
        Date startDate = (Date)dateList.get(0).getLeft();
        Date endDate = (Date)dateList.get(dateList.size() - 1).getRight();
        int sumDates = TermHelper.getBasis_BetweenDay(startDate, DateUtils.getNextDay(endDate, 1), basisEnum, null);
        ArrayList<CostShareInfo> costShareInfos = new ArrayList<CostShareInfo>(dateList.size());
        CostShareInfo info = null;
        for (Pair<Date, Date> datePair : dateList) {
            info = new CostShareInfo();
            info.setStartDate((Date)datePair.getLeft());
            info.setEndDate((Date)datePair.getRight());
            int diffDays = TermHelper.getBasis_BetweenDay((Date)datePair.getLeft(), DateUtils.getNextDay((Date)datePair.getRight(), 1), basisEnum, null);
            info.setDays(diffDays);
            BigDecimal amt = amount.multiply(BigDecimal.valueOf(diffDays)).divide(BigDecimal.valueOf(sumDates), 11, 4);
            info.setAmAmt(amt);
            info.setCcbEndAmt(amt);
            info.setYtm(BigDecimal.ZERO);
            costShareInfos.add(info);
        }
        return costShareInfos;
    }

    public static List<CostShareInfo> calculateYtm(List<CostShareInfo> infos, BigDecimal initCcbAmt, BigDecimal amount, int amtPrecision) {
        BigDecimal ytm = maxYtm.divide(new BigDecimal("2"));
        BigDecimal minYtmTemp = minYtm;
        BigDecimal maxYtmTemp = maxYtm;
        BigDecimal minAmt = CostShareServiceHelper.getMinAmt(amtPrecision);
        boolean isSuccess = false;
        for (int i = 0; i < 200; ++i) {
            BigDecimal ccbEndAmt = CostShareServiceHelper.getCcbEndAmt(infos, initCcbAmt, ytm);
            if (ccbEndAmt.subtract(amount).abs().compareTo(minAmt) <= 0) {
                isSuccess = true;
                break;
            }
            boolean isLarger = ccbEndAmt.compareTo(amount) > 0;
            minYtmTemp = isLarger ? minYtmTemp : ytm;
            maxYtmTemp = isLarger ? ytm : maxYtmTemp;
            ytm = minYtmTemp.add(maxYtmTemp).divide(new BigDecimal("2"));
        }
        if (!isSuccess) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d85\u8fc7\u6700\u5927\u8fed\u4ee3\u6b21\u6570\uff0c\u8ba1\u7b97\u5931\u8d25\u3002", (String)"CostShareServiceHelper_0", (String)"tmc-fbp-common", (Object[])new Object[0]));
        }
        return infos;
    }

    private static BigDecimal getCcbEndAmt(List<CostShareInfo> infos, BigDecimal initCcbAmt, BigDecimal ytm) {
        BigDecimal ccbEndAmt = initCcbAmt;
        for (CostShareInfo info : infos) {
            info.setCcbAmt(ccbEndAmt);
            info.setYtm(ytm);
            info.setEiRate(new BigDecimal(info.getDayRate()).setScale(11, RoundingMode.HALF_UP).multiply(ytm));
            info.setEiInterestAmt(info.getCcbAmt().multiply(info.getEiRate()));
            info.setAmAmt(info.getEiInterestAmt().subtract(info.getAiInterestAmt()));
            ccbEndAmt = info.getCcbAmt().add(info.getAmAmt().setScale(11, RoundingMode.HALF_UP));
            info.setCcbEndAmt(ccbEndAmt);
        }
        return ccbEndAmt;
    }

    private static BigDecimal getMinAmt(int amtPrecision) {
        BigDecimal mixAmt = new BigDecimal(1);
        return mixAmt.movePointLeft(amtPrecision + 1);
    }

    public static List<CostShareInfo> getCostShareInfo(List<Pair<Date, Date>> dateList, BigDecimal amount, BigDecimal loanrate, BasisEnum basisEnum) {
        if (basisEnum == null) {
            basisEnum = BasisEnum.Actual_actual;
        }
        ArrayList<CostShareInfo> infos = new ArrayList<CostShareInfo>(dateList.size());
        HashMap<Integer, Integer> yearMap = new HashMap<Integer, Integer>();
        CostShareInfo info = null;
        for (Pair<Date, Date> date : dateList) {
            info = new CostShareInfo();
            info.setStartDate((Date)date.getLeft());
            info.setEndDate((Date)date.getRight());
            int diffDays = TermHelper.getBasis_BetweenDay((Date)date.getLeft(), DateUtils.getNextDay((Date)date.getRight(), 1), basisEnum, null);
            info.setDays(diffDays);
            int year = DateUtils.getYear((Date)date.getLeft());
            Integer yearDays = (Integer)yearMap.get(year);
            if (EmptyUtil.isEmpty(yearDays)) {
                yearDays = TermHelper.getBasis_YearDay((Date)date.getLeft(), (Date)date.getLeft(), basisEnum);
                yearMap.put(year, yearDays);
            }
            BigDecimal dayRate = BigDecimal.valueOf((double)diffDays / (double)yearDays.intValue());
            info.setDayRate(dayRate.doubleValue());
            info.setAiInterestAmt(amount.multiply(loanrate).multiply(dayRate).setScale(11, RoundingMode.HALF_UP));
            infos.add(info);
        }
        return infos;
    }

    public static List<Pair<Date, Date>> getDateList(DynamicObject factory, Date startDate, Date endDate, String shareFrequency) {
        IntHTRuleEnum intHTRule = CostShareServiceHelper.getIntHTRule(factory);
        Pair<Date, Date> beginAndEndDate = CostShareServiceHelper.getBeginAndEndDate(intHTRule, startDate, endDate);
        List<Pair<Date, Date>> datePeriod = CostShareServiceHelper.getDatePeriod(beginAndEndDate, shareFrequency);
        ArrayList<Pair<Date, Date>> datePairs = new ArrayList<Pair<Date, Date>>();
        if (datePeriod == null) {
            return datePairs;
        }
        datePeriod.forEach(date -> datePairs.add(Pair.of((Object)DateUtils.getDataFormat((Date)date.getLeft(), true), (Object)DateUtils.getDataFormat((Date)date.getRight(), true))));
        return datePairs;
    }

    public static List<Pair<Date, Date>> getDateList(String factory, Date startDate, Date endDate, String shareFrequency) {
        IntHTRuleEnum intHTRule = CostShareServiceHelper.getIntHTRule(factory);
        Pair<Date, Date> beginAndEndDate = CostShareServiceHelper.getBeginAndEndDate(intHTRule, startDate, endDate);
        List<Pair<Date, Date>> datePeriod = CostShareServiceHelper.getDatePeriod(beginAndEndDate, shareFrequency);
        ArrayList<Pair<Date, Date>> datePairs = new ArrayList<Pair<Date, Date>>();
        if (datePeriod == null) {
            return datePairs;
        }
        datePeriod.forEach(date -> datePairs.add(Pair.of((Object)DateUtils.getDataFormat((Date)date.getLeft(), true), (Object)DateUtils.getDataFormat((Date)date.getRight(), true))));
        return datePairs;
    }

    private static IntHTRuleEnum getIntHTRule(DynamicObject factory) {
        IntHTRuleEnum intHTRule = IntHTRuleEnum.headnotail;
        if (EmptyUtil.isNoEmpty(factory)) {
            intHTRule = IntHTRuleEnum.valueOf(factory.getString("intheadtailrule"));
        }
        return intHTRule;
    }

    private static IntHTRuleEnum getIntHTRule(String factory) {
        IntHTRuleEnum intHTRule = IntHTRuleEnum.headnotail;
        if (EmptyUtil.isNoEmpty(factory)) {
            intHTRule = IntHTRuleEnum.valueOf(factory);
        }
        return intHTRule;
    }

    private static Pair<Date, Date> getBeginAndEndDate(IntHTRuleEnum ruleEnum, Date startDate, Date endDate) {
        switch (ruleEnum) {
            case headnotail: {
                endDate = DateUtils.getLastDay(endDate, 1);
                break;
            }
            case noheadnotail: {
                startDate = DateUtils.getNextDay(startDate, 1);
                endDate = DateUtils.getLastDay(endDate, 1);
                break;
            }
            case noheadtail: {
                startDate = DateUtils.getNextDay(startDate, 1);
            }
        }
        return Pair.of((Object)startDate, (Object)endDate);
    }

    public static List<Pair<Date, Date>> getDatePeriod(Pair<Date, Date> beginAndEndDate, String shareFrequency) {
        ShareFrequencyEnum shareEnum = ShareFrequencyEnum.getEnum(shareFrequency);
        switch (shareEnum) {
            case DAY: {
                return CostShareServiceHelper.getPeriodListByDay((Date)beginAndEndDate.getLeft(), (Date)beginAndEndDate.getRight());
            }
            case MONTH: {
                return CostShareServiceHelper.getPeriodListByMonth((Date)beginAndEndDate.getLeft(), (Date)beginAndEndDate.getRight());
            }
            case QUARTER: {
                return CostShareServiceHelper.getPeriodListByQuarter((Date)beginAndEndDate.getLeft(), (Date)beginAndEndDate.getRight());
            }
            case HALFYEAR: {
                return CostShareServiceHelper.getPeriodListByHalfYear((Date)beginAndEndDate.getLeft(), (Date)beginAndEndDate.getRight());
            }
            case YEAR: {
                return CostShareServiceHelper.getPeriodListByYear((Date)beginAndEndDate.getLeft(), (Date)beginAndEndDate.getRight());
            }
        }
        return null;
    }

    private static List<Pair<Date, Date>> getPeriodListByYear(Date startDate, Date endDate) {
        int endYear = DateUtils.getYear(endDate);
        ArrayList<Pair<Date, Date>> dateList = new ArrayList<Pair<Date, Date>>();
        for (int startYear = DateUtils.getYear(startDate); startYear <= endYear; ++startYear) {
            Date endYearDateTemp = DateUtils.getLastYearDate(startDate);
            if (startYear == endYear) {
                dateList.add((Pair<Date, Date>)Pair.of((Object)startDate, (Object)endDate));
                continue;
            }
            dateList.add((Pair<Date, Date>)Pair.of((Object)startDate, (Object)endYearDateTemp));
            startDate = DateUtils.getNextDay(endYearDateTemp, 1);
        }
        return dateList;
    }

    private static List<Pair<Date, Date>> getPeriodListByHalfYear(Date startDate, Date endDate) {
        int endYear = DateUtils.getYear(endDate);
        ArrayList<Pair<Date, Date>> dateList = new ArrayList<Pair<Date, Date>>();
        for (int startYear = DateUtils.getYear(startDate); startYear <= endYear; ++startYear) {
            if (startYear < endYear) {
                Date endYearDateTemp = DateUtils.getLastYearDate(startDate);
                CostShareServiceHelper.getPeriodHalfYear(dateList, startDate, endYearDateTemp, startYear);
                startDate = DateUtils.getNextDay(endYearDateTemp, 1);
                continue;
            }
            CostShareServiceHelper.getPeriodHalfYear(dateList, startDate, endDate, startYear);
        }
        return dateList;
    }

    private static void getPeriodHalfYear(List<Pair<Date, Date>> dateList, Date startDate, Date endDate, int startYear) {
        Date halfYearLastDay = DateUtils.getLastDay(DateUtils.getAppointDay(startYear, 7, 1), 1);
        if (halfYearLastDay.compareTo(startDate) <= 0 || halfYearLastDay.compareTo(endDate) > 0) {
            dateList.add((Pair<Date, Date>)Pair.of((Object)startDate, (Object)endDate));
        } else if (halfYearLastDay.compareTo(startDate) > 0 && halfYearLastDay.compareTo(endDate) <= 0) {
            dateList.add((Pair<Date, Date>)Pair.of((Object)startDate, (Object)halfYearLastDay));
            if (halfYearLastDay.compareTo(endDate) < 0) {
                dateList.add((Pair<Date, Date>)Pair.of((Object)DateUtils.getNextDay(halfYearLastDay, 1), (Object)endDate));
            }
        }
    }

    private static List<Pair<Date, Date>> getPeriodListByQuarter(Date startDate, Date endDate) {
        int startMonth = DateUtils.getMonth(startDate);
        int endMonth = DateUtils.getMonth(endDate);
        int startYear = DateUtils.getYear(startDate);
        int endYear = DateUtils.getYear(endDate);
        int startSeason = DateUtils.getSeason(startMonth - 1);
        int endSeason = DateUtils.getSeason(endMonth - 1);
        ArrayList<Pair<Date, Date>> dateList = new ArrayList<Pair<Date, Date>>();
        while (startYear <= endYear) {
            if (startYear < endYear) {
                CostShareServiceHelper.getPeriodQuarter(dateList, startDate, endDate, startSeason, 4, endYear);
            } else {
                CostShareServiceHelper.getPeriodQuarter(dateList, startDate, endDate, startSeason, endSeason, endYear);
            }
            startSeason = 1;
            startDate = DateUtils.getAppointDay(++startYear, 1, 1);
        }
        return dateList;
    }

    private static void getPeriodQuarter(List<Pair<Date, Date>> dateList, Date startDate, Date endDate, int startSeason, int endSeason, int endYear) {
        while (startSeason <= endSeason) {
            Date lastSeasonDate = DateUtils.getLastSeasonDate(startDate);
            int year = DateUtils.getYear(lastSeasonDate);
            if (startSeason == endSeason && endYear == year) {
                dateList.add((Pair<Date, Date>)Pair.of((Object)startDate, (Object)(lastSeasonDate.compareTo(endDate) > 0 ? endDate : lastSeasonDate)));
            } else {
                dateList.add((Pair<Date, Date>)Pair.of((Object)startDate, (Object)lastSeasonDate));
            }
            startDate = DateUtils.getFirstSeasonDate(DateUtils.getNextMonth(lastSeasonDate, 1));
            ++startSeason;
        }
    }

    private static List<Pair<Date, Date>> getPeriodListByMonth(Date startDate, Date endDate) {
        ArrayList<Pair<Date, Date>> dateList = new ArrayList<Pair<Date, Date>>();
        int startYear = DateUtils.getYear(startDate);
        int endYear = DateUtils.getYear(endDate);
        int startMonth = DateUtils.getMonth(startDate);
        int endMonth = DateUtils.getMonth(endDate);
        while (startYear <= endYear) {
            if (startYear < endYear) {
                CostShareServiceHelper.monthPeriod(dateList, startMonth, 12, startDate, endDate, endYear);
                startMonth = 1;
            } else {
                CostShareServiceHelper.monthPeriod(dateList, startMonth, endMonth, startDate, endDate, endYear);
            }
            startDate = DateUtils.getAppointDay(++startYear, startMonth, 1);
        }
        return dateList;
    }

    private static void monthPeriod(List<Pair<Date, Date>> dateList, int startMonth, int endMonth, Date startDate, Date endDate, int endYear) {
        while (startMonth <= endMonth) {
            Date endDateTemp = DateUtils.getMaxMonthDate(startDate);
            int endTempYear = DateUtils.getYear(endDateTemp);
            if (startMonth == endMonth && endYear == endTempYear && endDateTemp.compareTo(endDate) >= 0) {
                dateList.add((Pair<Date, Date>)Pair.of((Object)startDate, (Object)endDate));
                break;
            }
            dateList.add((Pair<Date, Date>)Pair.of((Object)startDate, (Object)endDateTemp));
            ++startMonth;
            startDate = DateUtils.getNextDay(endDateTemp, 1);
        }
    }

    private static List<Pair<Date, Date>> getPeriodListByDay(Date startDate, Date endDate) {
        ArrayList<Pair<Date, Date>> dateLIst = new ArrayList<Pair<Date, Date>>();
        while (startDate.compareTo(endDate) < 0) {
            dateLIst.add(Pair.of((Object)startDate, (Object)startDate));
            startDate = DateUtils.getNextDay(startDate, 1);
        }
        dateLIst.add(Pair.of((Object)startDate, (Object)endDate));
        return dateLIst;
    }

    public static DynamicObjectCollection getFeeBills(Set<Long> billIds) {
        QFilter filter = new QFilter("entry.srcbillid", "in", billIds).and(new QFilter("sharetype", "in", (Object)new Object[]{ShareTypeEnum.INTEREST.getValue(), ShareTypeEnum.STRAIGHT.getValue()})).and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        DynamicObjectCollection feeBills = QueryServiceHelper.query((String)"cfm_feebill", (String)"id,currency,sharetype,entry.feedetailamt", (QFilter[])new QFilter[]{filter});
        return feeBills;
    }

    public static BigDecimal getFeeAmount(Long billId, Long orgId, Long bizCurrency, String dataSource) {
        DynamicObjectCollection feeBills = CostShareServiceHelper.getFeeBills(Collections.singleton(billId));
        BigDecimal totalAmt = BigDecimal.ZERO;
        if (EmptyUtil.isEmpty(feeBills)) {
            return totalAmt;
        }
        String tipName = ResManager.loadKDString((String)"\u53d1\u884c", (String)"CostShareServiceHelper_1", (String)"tmc-fbp-common", (Object[])new Object[0]);
        if ("cfm".equals(dataSource)) {
            tipName = ResManager.loadKDString((String)"\u63d0\u6b3e", (String)"CostShareServiceHelper_2", (String)"tmc-fbp-common", (Object[])new Object[0]);
        }
        HashMap<Long, BigDecimal> rateMap = new HashMap<Long, BigDecimal>();
        DynamicObject bizCurrencyObj = TmcDataServiceHelper.loadSingleFromCache((Object)bizCurrency, (String)"bd_currency", (String)"id,amtprecision,name");
        for (DynamicObject freeBill : feeBills) {
            BigDecimal rate = BigDecimal.ONE;
            BigDecimal payAmt = freeBill.getBigDecimal("entry.feedetailamt");
            Long currencyId = freeBill.getLong("currency");
            if (!currencyId.equals(bizCurrency) && EmptyUtil.isEmpty(rate = (BigDecimal)rateMap.get(currencyId))) {
                rate = CostShareServiceHelper.getRate(orgId, currencyId, bizCurrency);
                if (rate == null) {
                    DynamicObject feeCurrencyObj = TmcDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency", (String)"id,name");
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d39\u7528\u5e01\u79cd\u8f6c\u6362%1$s\u5e01\u79cd\u65f6\uff0c\u6c47\u7387\u8868\u4e2d\u4e0d\u5b58\u5728%2$s\u5151%3$s\u7684\u6c47\u7387\uff0c\u8bf7\u5148\u5f55\u5165\u6c47\u7387\u3002", (String)"CostShareServiceHelper_3", (String)"tmc-fbp-common", (Object[])new Object[0]), tipName, feeCurrencyObj.getString("name"), bizCurrencyObj.getString("name")));
                }
                rateMap.put(currencyId, rate);
            }
            totalAmt = totalAmt.add(payAmt.multiply(rate));
        }
        return totalAmt.setScale(bizCurrencyObj.getInt("amtprecision"), RoundingMode.HALF_UP);
    }

    public static BigDecimal getActFeeTotalAmt(BigDecimal feeAmount, BigDecimal pubAmt, BigDecimal tickAmt, BigDecimal amount) {
        BigDecimal rate = pubAmt.divide(tickAmt, 11, RoundingMode.HALF_UP);
        return feeAmount.add(amount.multiply(BigDecimal.ONE.subtract(rate)));
    }

    private static BigDecimal getRate(Long orgId, Long sCurrencyId, Long tCurrencyId) {
        Long standardExRateTableId = TmcBusinessBaseHelper.getExchageTableId(orgId);
        if (EmptyUtil.isNoEmpty(standardExRateTableId)) {
            return BaseDataServiceHelper.getExchangeRate((Long)standardExRateTableId, (Long)sCurrencyId, (Long)tCurrencyId, (Date)new Date());
        }
        return null;
    }
}

