/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.CreditLimitF7ResBean;
import kd.tmc.fbp.common.model.CreditLimitInfo;
import kd.tmc.fbp.common.model.CreditLimitUseBean;
import kd.tmc.fbp.common.model.interest.ReturnCreditLimitInfo;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditLimitServiceHelper {
    private static final String SERVICE = "creditService";

    public static BigDecimal getCreditLimitAvaAmt(Long creditLimitId, Long orgId, Long creditTypeId, Date startDate, Date endDate) {
        CreditLimitUseBean bean = new CreditLimitUseBean();
        bean.setCreditLimitId(creditLimitId);
        bean.setOrgId(orgId);
        bean.setCreditTypeId(creditTypeId);
        bean.setStartDate(startDate);
        bean.setEndDate(endDate);
        return CreditLimitServiceHelper.getCreditLimitAvaAmt(bean);
    }

    @Deprecated
    public static CreditLimitInfo confirmCreditLimit(DynamicObject bill, DynamicObject srcBill, boolean isPreOccupy) {
        return CreditLimitServiceHelper.confirmCreditLimit(bill, srcBill, isPreOccupy, new Date());
    }

    public static CreditLimitInfo confirmCreditLimit(DynamicObject bill, DynamicObject srcBill, boolean isPreOccupy, Date createTime) {
        boolean isPreOccupyApply;
        CreditLimitInfo confirm = new CreditLimitInfo();
        confirm.setId((Long)bill.getPkValue());
        confirm.setEntityName(bill.getDataEntityType().getName());
        confirm.setBillno(bill.getString("billno"));
        confirm.setPreOccupy(isPreOccupy);
        confirm.setCreatetime(createTime);
        if (EmptyUtil.isNoEmpty(srcBill) && (isPreOccupyApply = CreditLimitServiceHelper.getPreOccupyBill(srcBill.getDataEntityType().getName(), (Long)srcBill.getPkValue()))) {
            confirm.setPreId((Long)srcBill.getPkValue());
            confirm.setPreEntityName(srcBill.getDataEntityType().getName());
        }
        if ("fl_leasecontractbill_init".equals(bill.getDataEntityType().getName())) {
            confirm.setEntityName("fl_leasecontractbill");
        }
        return CreditLimitServiceHelper.confirmCreditLimit(confirm);
    }

    public static CreditLimitInfo cancelCreditLimit(DynamicObject bill, DynamicObject srcBill, boolean isPreOccupy) {
        boolean returnArr;
        CreditLimitInfo confirm = new CreditLimitInfo();
        confirm.setId((Long)bill.getPkValue());
        confirm.setEntityName(bill.getDataEntityType().getName());
        confirm.setBillno(bill.getString("billno"));
        confirm.setPreOccupy(isPreOccupy);
        if ("fl_leasecontractbill_init".equals(bill.getDataEntityType().getName())) {
            confirm.setEntityName("fl_leasecontractbill");
        }
        if (EmptyUtil.isNoEmpty(srcBill) && (returnArr = CreditLimitServiceHelper.getReturnBill(confirm, srcBill.getDataEntityType().getName(), srcBill.getLong("id")))) {
            confirm.setPreId(srcBill.getLong("id"));
            confirm.setPreEntityName(srcBill.getDataEntityType().getName());
        }
        return CreditLimitServiceHelper.cancelCreditLimit(confirm);
    }

    @Deprecated
    public static ReturnCreditLimitInfo returnCreditLimit(DynamicObject bill, DynamicObject srcBill, boolean isPreOccupy, BigDecimal srcAmount, Long returnBillId) {
        return CreditLimitServiceHelper.returnCreditLimit(bill, srcBill, isPreOccupy, srcAmount, returnBillId, false);
    }

    @Deprecated
    public static ReturnCreditLimitInfo returnCreditLimit(DynamicObject bill, DynamicObject srcBill, boolean isPreOccupy, BigDecimal srcAmount, Long returnBillId, boolean isLast) {
        return CreditLimitServiceHelper.returnCreditLimit(bill, srcBill, isPreOccupy, srcAmount, returnBillId, isLast, new Date());
    }

    public static ReturnCreditLimitInfo returnCreditLimit(DynamicObject bill, DynamicObject srcBill, boolean isPreOccupy, BigDecimal srcAmount, Long returnBillId, boolean isLast, Date returnTime) {
        ReturnCreditLimitInfo param = CreditLimitServiceHelper.getReturnInfo(bill, srcBill, isPreOccupy, returnBillId, returnTime);
        param.setReturnAmt(srcAmount);
        param.setLast(isLast);
        return CreditLimitServiceHelper.returnCreditLimit(param);
    }

    @Deprecated
    public static ReturnCreditLimitInfo returnCreditLimit(DynamicObject bill, DynamicObject srcBill, boolean isPreOccupy, BigDecimal srcAmount, Long returnBillId, boolean isLast, boolean isPart) {
        ReturnCreditLimitInfo param = CreditLimitServiceHelper.getReturnInfo(bill, srcBill, isPreOccupy, returnBillId, new Date());
        param.setReturnAmt(srcAmount);
        param.setLast(isLast);
        param.setPart(isPart);
        return CreditLimitServiceHelper.returnCreditLimit(param);
    }

    @Deprecated
    public static ReturnCreditLimitInfo returnCreditLimitByEntry(DynamicObject bill, DynamicObject srcBill, boolean isPreOccupy, Map<Long, BigDecimal> entryReturnAmtMap, Long returnBillId, boolean isLast) {
        ReturnCreditLimitInfo param = CreditLimitServiceHelper.getReturnInfo(bill, srcBill, isPreOccupy, returnBillId, new Date());
        param.setEntryReturnAmtMap(entryReturnAmtMap);
        param.setLast(isLast);
        return CreditLimitServiceHelper.returnCreditLimit(param);
    }

    public static ReturnCreditLimitInfo cancelReturnCreditLimit(DynamicObject bill, DynamicObject srcBill, boolean isPreOccupy, BigDecimal srcAmount, Long returnBillId) {
        ReturnCreditLimitInfo param = CreditLimitServiceHelper.getCancelReturnInfo(bill, srcBill, isPreOccupy, returnBillId);
        return CreditLimitServiceHelper.cancelReturnCreditLimit(param);
    }

    public static ReturnCreditLimitInfo cancelReturnCreditLimit(DynamicObject bill, DynamicObject srcBill, boolean isPreOccupy, Long returnBillId, boolean isPart) {
        ReturnCreditLimitInfo param = CreditLimitServiceHelper.getCancelReturnInfo(bill, srcBill, isPreOccupy, returnBillId);
        param.setPart(isPart);
        return CreditLimitServiceHelper.cancelReturnCreditLimit(param);
    }

    public static CreditLimitUseBean updateCreditLimitUse(String entityName, Long pkId, BigDecimal bizAmt, boolean isPreOccupy) {
        CreditLimitUseBean confirm = new CreditLimitUseBean();
        confirm.setEntityName(entityName);
        confirm.setPkId(pkId);
        confirm.setBizAmt(bizAmt);
        confirm.setPreOccupy(isPreOccupy);
        return CreditLimitServiceHelper.updateCreditLimitUse(confirm);
    }

    public static CreditLimitUseBean autoUseCreditLimit(CreditLimitUseBean param) {
        String info = (String)CreditLimitServiceHelper.invokeBizService("autoUseCreditLimit", SerializationUtils.toJsonString((Object)param));
        return (CreditLimitUseBean)SerializationUtils.fromJsonString((String)info, CreditLimitUseBean.class);
    }

    public static CreditLimitF7ResBean validataCreditLimitAmt(CreditLimitUseBean param) {
        String info = (String)CreditLimitServiceHelper.invokeBizService("checkCreditLimitAmt", SerializationUtils.toJsonString((Object)param));
        return (CreditLimitF7ResBean)SerializationUtils.fromJsonString((String)info, CreditLimitF7ResBean.class);
    }

    private static BigDecimal getCreditLimitAvaAmt(CreditLimitUseBean param) {
        String info = (String)CreditLimitServiceHelper.invokeBizService("getCreditLimitAvaAmt", SerializationUtils.toJsonString((Object)param));
        return (BigDecimal)SerializationUtils.fromJsonString((String)info, BigDecimal.class);
    }

    private static CreditLimitInfo confirmCreditLimit(CreditLimitInfo param) {
        String info = (String)CreditLimitServiceHelper.invokeBizService("confirmCreditLimit", SerializationUtils.toJsonString((Object)param));
        return (CreditLimitInfo)SerializationUtils.fromJsonString((String)info, CreditLimitInfo.class);
    }

    private static CreditLimitInfo cancelCreditLimit(CreditLimitInfo param) {
        String info = (String)CreditLimitServiceHelper.invokeBizService("cancelCreditLimit", SerializationUtils.toJsonString((Object)param));
        return (CreditLimitInfo)SerializationUtils.fromJsonString((String)info, CreditLimitInfo.class);
    }

    public static ReturnCreditLimitInfo batchRreturnCreditLimit(List<ReturnCreditLimitInfo> paramList) {
        String info = (String)CreditLimitServiceHelper.invokeBizService("batchReturnCreditLimit", SerializationUtils.toJsonString(paramList));
        return (ReturnCreditLimitInfo)SerializationUtils.fromJsonString((String)info, ReturnCreditLimitInfo.class);
    }

    public static ReturnCreditLimitInfo returnCreditLimit(ReturnCreditLimitInfo param) {
        String info = (String)CreditLimitServiceHelper.invokeBizService("returnCreditLimit", SerializationUtils.toJsonString((Object)param));
        return (ReturnCreditLimitInfo)SerializationUtils.fromJsonString((String)info, ReturnCreditLimitInfo.class);
    }

    public static ReturnCreditLimitInfo cancelReturnCreditLimit(ReturnCreditLimitInfo param) {
        String info = (String)CreditLimitServiceHelper.invokeBizService("cancelReturnCreditLimit", SerializationUtils.toJsonString((Object)param));
        return (ReturnCreditLimitInfo)SerializationUtils.fromJsonString((String)info, ReturnCreditLimitInfo.class);
    }

    public static ReturnCreditLimitInfo batchCancelReturnCreditLimit(List<ReturnCreditLimitInfo> paramList) {
        String info = (String)CreditLimitServiceHelper.invokeBizService("batchCancelReturnCreditLimit", SerializationUtils.toJsonString(paramList));
        return (ReturnCreditLimitInfo)SerializationUtils.fromJsonString((String)info, ReturnCreditLimitInfo.class);
    }

    public static CreditLimitUseBean updateCreditLimitUse(CreditLimitUseBean param) {
        String info = (String)CreditLimitServiceHelper.invokeBizService("updateCreditLimitUse", SerializationUtils.toJsonString((Object)param));
        return (CreditLimitUseBean)SerializationUtils.fromJsonString((String)info, CreditLimitUseBean.class);
    }

    public static Map deleteCreditLimitUse(Long billId, Set<Long> entryIds) {
        HashMap<Long, Set<Long>> paramMap = new HashMap<Long, Set<Long>>(1);
        paramMap.put(billId, entryIds);
        String info = (String)CreditLimitServiceHelper.invokeBizService("deleteCreditLimitUse", SerializationUtils.toJsonString(paramMap));
        return (Map)SerializationUtils.fromJsonString((String)info, Map.class);
    }

    public static Map addCreditVariety(Long creditTypeId, Long bizBillId, String formId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(3);
        paramMap.put("creditTypeId", creditTypeId);
        paramMap.put("bizBaseId", bizBillId);
        paramMap.put("formId", formId);
        String info = (String)CreditLimitServiceHelper.invokeBizService("addCreditVariety", SerializationUtils.toJsonString(paramMap));
        return (Map)SerializationUtils.fromJsonString((String)info, Map.class);
    }

    public static Map deleteCreditVariety(Long creditTypeId, Long bizBillId, String formId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(3);
        paramMap.put("creditTypeId", creditTypeId);
        paramMap.put("bizBaseId", bizBillId);
        paramMap.put("formId", formId);
        String info = (String)CreditLimitServiceHelper.invokeBizService("deleteCreditVariety", SerializationUtils.toJsonString(paramMap));
        return (Map)SerializationUtils.fromJsonString((String)info, Map.class);
    }

    private static Object invokeBizService(String method, Object ... param) {
        Object result = DispatchServiceHelper.invokeBizService((String)TmcAppEnum.TMC.getValue(), (String)"creditm", (String)SERVICE, (String)method, (Object[])param);
        return result;
    }

    public static DynamicObject getCreditUseBill(Long billId, String billType) {
        Object[] creditUses = TmcDataServiceHelper.load((String)"cfm_credituse", (String)"id,amount,currency,preamount,returnamt,creditlimit,realamt,bizcreditamount,creditrate,creditratio", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)billId).and("sourcetype", "=", (Object)billType).and("isrelease", "=", (Object)"0")}, (String)"createtime desc", (int)1);
        return EmptyUtil.isNoEmpty(creditUses) ? creditUses[0] : null;
    }

    private static boolean getPreOccupyBill(String entityName, Long billId) {
        QFilter filter = new QFilter("sourcetype", "=", (Object)entityName);
        filter.and(new QFilter("sourcebillid", "=", (Object)billId));
        filter.and(new QFilter("preamount", ">", (Object)Constants.ZERO));
        filter.and(QFilter.sqlExpress((String)"returnamt", (String)"!=", (String)"fpreamount"));
        return TmcDataServiceHelper.exists("cfm_credituse", filter.toArray());
    }

    private static ReturnCreditLimitInfo getReturnInfo(DynamicObject bill, DynamicObject srcBill, boolean isPreOccupy, Long returnBillId, Date returnTime) {
        ReturnCreditLimitInfo param = new ReturnCreditLimitInfo();
        param.setId((Long)srcBill.getPkValue());
        param.setEntityName(srcBill.getDataEntityType().getName());
        param.setPreOccupy(isPreOccupy);
        param.setPreEntityName(bill.getDynamicObjectType().getName());
        param.setReturnBillId(returnBillId);
        param.setBizBillId((Long)bill.getPkValue());
        param.setReturnTime(returnTime);
        return param;
    }

    private static ReturnCreditLimitInfo getCancelReturnInfo(DynamicObject bill, DynamicObject srcBill, boolean isPreOccupy, Long returnBillId) {
        ReturnCreditLimitInfo param = new ReturnCreditLimitInfo();
        param.setId((Long)srcBill.getPkValue());
        param.setEntityName(srcBill.getDataEntityType().getName());
        param.setBillno(srcBill.getString("billno"));
        param.setPreOccupy(isPreOccupy);
        param.setReturnBillId(returnBillId);
        param.setBizBillId((Long)bill.getPkValue());
        return param;
    }

    private static boolean getReturnBill(CreditLimitInfo confirm, String entityName, Long billId) {
        QFilter filter = new QFilter("sourcebillid", "=", (Object)billId).and(new QFilter("sourcetype", "=", (Object)entityName)).and(new QFilter("returnentry.e_returnid", "=", (Object)confirm.getId()));
        return TmcDataServiceHelper.exists("cfm_credituse", new QFilter[]{filter});
    }
}

