/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.tmc.fbp.common.dataset.SplitByFilterExtDataSetBuilder;

public class DataSetHelper {
    private static final int DEFAULT_COPIES = 2;

    public static DataSet[] splitByFilter(DataSet dataSet, String[] filterExprs, Map<String, Object> params, boolean includeOthers) {
        if (dataSet instanceof AbstractDataSet) {
            ((AbstractDataSet)dataSet).checkClosed();
        }
        return new SplitByFilterExtDataSetBuilder(dataSet, filterExprs, params, includeOthers).split();
    }

    public static DataSet[] copy(DataSet srcDs) {
        return DataSetHelper.copy(srcDs, 2);
    }

    public static DataSet[] copy(DataSet srcDs, int copies) {
        if (copies < 2) {
            throw new IllegalArgumentException("copies must be greater than 2");
        }
        String[] express = new String[copies];
        for (int i = 0; i < copies; ++i) {
            express[i] = "true";
        }
        return srcDs.splitByFilter(express, false);
    }

    public static DataSet createEmptyDataSet(RowMeta rowMeta) {
        return DataSetHelper.createEmptyDataSet(rowMeta.getFieldNames(), rowMeta.getDataTypes());
    }

    public static DataSet createEmptyDataSet(String[] fieldNames, DataType[] dataTypes) {
        RowMeta rowMeta = new RowMeta(fieldNames, dataTypes);
        return Algo.create((String)"EmptyDataSet").createDataSetBuilder(rowMeta).build();
    }
}

