/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class MarketDataServiceHelper {
    private static final Log logger = LogFactory.getLog(MarketDataServiceHelper.class);
    private static final String SERVICE = "marketDataService";

    public static ForexQuoteInfo getForexQuoteInfo(Long forexQuoteId, String currencyPair, Date issueTime, Date Dm) {
        String result = (String)MarketDataServiceHelper.invokeBizService("getForexQuoteInfo", forexQuoteId, currencyPair, issueTime, Dm);
        ForexQuoteInfo info = (ForexQuoteInfo)SerializationUtils.fromJsonString((String)result, ForexQuoteInfo.class);
        if (EmptyUtil.isNoEmpty(info.getErrMsg())) {
            throw new KDBizException(TmcErrorCode.COMMON, new Object[]{info.getErrMsg()});
        }
        return info;
    }

    public static ForexQuoteInfo queryForexQuote(IFormView view, Long forexQuoteId, ForexQuoteInfo forexQuoteParam) {
        try {
            String param = SerializationUtils.toJsonString((Object)forexQuoteParam);
            String result = (String)MarketDataServiceHelper.invokeBizService("queryForexQuote", forexQuoteId, param);
            return (ForexQuoteInfo)SerializationUtils.fromJsonString((String)result, ForexQuoteInfo.class);
        }
        catch (Exception e) {
            if (view != null) {
                view.showErrorNotification(e.getMessage());
                return forexQuoteParam;
            }
            throw e;
        }
    }

    public static BigDecimal referRate(String rateNum, Date date) {
        return MarketDataServiceHelper.referRate(rateNum, date, false);
    }

    public static BigDecimal referRate(String rateNum, Date date, boolean isReturnEmpty) {
        date = DateUtils.truncateDate(date);
        HashSet<Date> dateSet = new HashSet<Date>(16);
        dateSet.add(date);
        Map<Date, BigDecimal> rate = MarketDataServiceHelper.referRate(rateNum, dateSet, isReturnEmpty);
        if (rate != null && rate.containsKey(date)) {
            return rate.get(date);
        }
        return null;
    }

    public static Map<Date, BigDecimal> referRate(String rateNum, Date startDate, Date endDate) {
        return (Map)MarketDataServiceHelper.invokeBizService("getReferRatesByDate", rateNum, startDate, endDate);
    }

    public static Map<Date, BigDecimal> referRate(String rateNum, Set<Date> dateSet, boolean isReturnEmpty) {
        return (Map)MarketDataServiceHelper.invokeBizService("referRate", rateNum, dateSet, isReturnEmpty);
    }

    private static Object invokeBizService(String method, Object ... param) {
        logger.info(JSON.toJSONString((Object)param));
        Object result = DispatchServiceHelper.invokeBizService((String)TmcAppEnum.TMC.getValue(), (String)"md", (String)SERVICE, (String)method, (Object[])param);
        logger.info(JSON.toJSONString((Object)result));
        return result;
    }
}

