/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.bos.workflow.engine.msg.info.MessageInfo;

public class NoticeMsgHelper {
    private static final Log logger = LogFactory.getLog(NoticeMsgHelper.class);
    private static final ThreadPoolExecutor threadPools = new ThreadPoolExecutor(10, 50, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(50), new MsgThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());

    public static void batchAsyncSendNoticeMsg(Collection<DynamicObject> bills, String msgTemplateNumber, String msgTag) {
        if (CollectionUtils.isEmpty(bills) || StringUtils.isBlank((String)msgTemplateNumber)) {
            return;
        }
        String domainContextUrl = UrlService.getDomainContextUrl();
        logger.info("batchAsyncSendNoticeMsg msgTemplateNumber=" + msgTemplateNumber);
        Runnable runnable = () -> {
            logger.info("batchAsyncSendNoticeMsg start size=" + bills.size() + ", msgTemplateNumber=" + msgTemplateNumber);
            ArrayList<MessageInfo> msgList = new ArrayList<MessageInfo>(bills.size());
            for (DynamicObject bill : bills) {
                String entityName = bill.getDataEntityType().getName();
                Long pkValue = (Long)bill.getPkValue();
                MessageInfo messageInfo = new MessageInfo();
                messageInfo.setBizDataId(pkValue);
                messageInfo.setMessageTag((ILocaleString)new LocaleString(msgTag));
                messageInfo.setEntityNumber(entityName);
                messageInfo.setTemplateNumber(msgTemplateNumber);
                messageInfo.setUserIds(Collections.singletonList(bill.getDynamicObject("creator").getLong("id")));
                messageInfo.setContentUrl(domainContextUrl + "/index.html?formId=" + entityName + "&pkId=" + pkValue);
                msgList.add(messageInfo);
            }
            MessageCenterServiceHelper.batchSendMessages(msgList);
            logger.info("batchAsyncSendNoticeMsg end msgTemplateNumber=" + msgTemplateNumber);
        };
        threadPools.execute(runnable);
    }

    private static class MsgThreadFactory
    implements ThreadFactory {
        private final AtomicLong count = new AtomicLong(0L);

        private MsgThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "notice-msg-" + this.count.incrementAndGet());
        }
    }
}

