/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.enums.UseStatusEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SettleCenterHelper {
    public static boolean isSettleCenter(Long orgId) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("finorgtype.type", "=", (Object)FinOrgTypeEnum.CLEARINGHOUSE.getValue())};
        Object[] settleCenter = TmcDataServiceHelper.load((String)"bd_finorginfo", (String)"id", (QFilter[])filters);
        return !EmptyUtil.isEmpty(settleCenter);
    }

    public static Set<Long> getAuthorizedBankCenter(String appId, String entityID, String permissionItem) {
        Long userID = Long.valueOf(RequestContext.get().getUserId());
        List permOrgList = TmcOrgDataHelper.getAuthorizedBankOrgId(userID, appId, entityID, permissionItem);
        return SettleCenterHelper.getAuthorizedSettleCenterIds(permOrgList);
    }

    public static Set<DynamicObject> getAuthorizedSubAcctOrg(String appId, String entityID, String permissionItem, String entityName) {
        Long userID = Long.valueOf(RequestContext.get().getUserId());
        List permOrgList = TmcOrgDataHelper.getAuthorizedBankOrgId(userID, appId, entityID, permissionItem);
        Set<Long> bankIds = SettleCenterHelper.getAuthorizedSettleCenterIds(permOrgList);
        Set<DynamicObject> subOrgs = SettleCenterHelper.getAllInnerAcctSubOrgs(bankIds, entityName);
        Set<DynamicObject> bankOrgs = SettleCenterHelper.getAuthorizedSettleCenterOrgs(permOrgList);
        List<Long> orgIdList = TmcBusinessBaseHelper.objectsToIdList(subOrgs.toArray(new DynamicObject[subOrgs.size()]));
        for (DynamicObject org : bankOrgs) {
            if (orgIdList.contains(org.getLong("id"))) continue;
            subOrgs.add(org);
        }
        return subOrgs;
    }

    private static Set<DynamicObject> getAllInnerAcctSubOrgs(Set<Long> bankIds, String entityName) {
        QFilter[] filters;
        Object[] innerAccts;
        HashSet<DynamicObject> orgs = new HashSet<DynamicObject>();
        if (bankIds.size() > 0 && !EmptyUtil.isEmpty(innerAccts = TmcDataServiceHelper.load((String)entityName, (String)"id, company", (QFilter[])(filters = new QFilter[]{new QFilter("finorg.id", "in", bankIds)})))) {
            for (Object innerAcct : innerAccts) {
                if (!EmptyUtil.isNoEmpty((DynamicObject)innerAcct) || !EmptyUtil.isNoEmpty(innerAcct.getDynamicObject("company"))) continue;
                orgs.add(innerAcct.getDynamicObject("company"));
            }
        }
        return orgs;
    }

    private static Set<DynamicObject> getAuthorizedSettleCenterOrgs(List<Long> allOrgs) {
        HashSet<DynamicObject> orgs = new HashSet<DynamicObject>();
        DynamicObjectCollection settleOrgs = SettleCenterHelper.getSettleCenterOrgs();
        for (DynamicObject org : settleOrgs) {
            if (!allOrgs.contains(org.getLong("id"))) continue;
            orgs.add(org);
        }
        return orgs;
    }

    private static DynamicObjectCollection getSettleCenterOrgs() {
        DynamicObjectCollection orgs = new DynamicObjectCollection();
        List<DynamicObject> settleCenters = SettleCenterHelper.getSettleCenterBank();
        if (!EmptyUtil.isEmpty(settleCenters)) {
            for (DynamicObject settleCenter : settleCenters) {
                orgs.add((Object)settleCenter.getDynamicObject("org"));
            }
        }
        return orgs;
    }

    public static Set<DynamicObject> getAuthorizedSettleCenters(String appId, String entityID, String permissionItem) {
        HashSet<DynamicObject> bankList = new HashSet<DynamicObject>();
        long userID = RequestContext.get().getCurrUserId();
        List<Long> orgIds = TmcOrgDataHelper.getCacheUserPermission(userID, appId, entityID, permissionItem);
        for (DynamicObject bank : SettleCenterHelper.getSettleCenterBank()) {
            if (EmptyUtil.isEmpty(bank.getDynamicObject("org")) || orgIds != null && !orgIds.contains(bank.getDynamicObject("org").getLong("id"))) continue;
            bankList.add(bank);
        }
        return bankList;
    }

    public static Set<Long> getAuthorizedSettleCenterIds(List<Long> orgs) {
        HashSet<Long> bankIds = new HashSet<Long>();
        for (DynamicObject bank : SettleCenterHelper.getSettleCenterBank()) {
            DynamicObject org = bank.getDynamicObject("org");
            if (!EmptyUtil.isNoEmpty(org) || !orgs.contains(org.getLong("id"))) continue;
            bankIds.add(bank.getLong("id"));
        }
        return bankIds;
    }

    private static List<DynamicObject> getSettleCenterBank() {
        QFilter[] filters = new QFilter[]{new QFilter("usestatus", "=", (Object)UseStatusEnum.STARTED.getValue())};
        Map settings = TmcDataServiceHelper.loadFromCache((String)"ifm_settcentersetting", (String)"id,settlecenter.id,settlecenter.org", (QFilter[])filters);
        return settings.values().stream().map(set -> set.getDynamicObject("settlecenter")).collect(Collectors.toList());
    }

    public static DynamicObject getCurrentSettleCenterBank() {
        Long orgId = RequestContext.get().getOrgId();
        QFilter[] filters = new QFilter[]{new QFilter("org.id", "=", (Object)orgId), new QFilter("finorgtype.type", "=", (Object)FinOrgTypeEnum.CLEARINGHOUSE.getValue()), new QFilter("is_leaf", "=", (Object)1)};
        return TmcDataServiceHelper.loadSingleFromCache((String)"bd_finorginfo", (String)"id,number,name,org", (QFilter[])filters);
    }

    public static Set<Long> hasPermissionSettleCenter(String appId, String entityId, String permissionItem) {
        HashSet<Long> permSet = new HashSet<Long>();
        for (DynamicObject settleCenter : SettleCenterHelper.getSettleCenterBank()) {
            Long orgId;
            int hasPerm;
            Long userId = Long.valueOf(RequestContext.get().getUserId());
            if (settleCenter == null || !EmptyUtil.isNoEmpty(settleCenter.getDynamicObject("org")) || 1 != (hasPerm = PermissionServiceHelper.checkPermission((Long)userId, (Long)(orgId = Long.valueOf(settleCenter.getDynamicObject("org").getLong("id"))), (String)appId, (String)entityId, (String)permissionItem))) continue;
            permSet.add(settleCenter.getLong("id"));
        }
        return permSet;
    }
}

