/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.BillSourceEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.SuretyReleaseTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretyHelper {
    private static final Map<String, Map<String, String>> entityBizPropMap = new HashMap<String, Map<String, String>>(16);
    private static final String LOAD_SURETY_BY_DEBIT_PROPS = String.join((CharSequence)",", "id", "entry", "finorginfo", "finorgother", "amount", "surplusamount", "settleaccount", "intdate", "term", "investorgtype", "currency", "expiredate", String.join((CharSequence)".", "entry", "debtbillid"));
    private static final String LOAD_SURETY_BY_CREDIT_PROPS = String.join((CharSequence)",", "id", "entry_credit", String.join((CharSequence)".", "entry_credit", "creditbillid"));
    private static final String[] STPROPS;

    public static String getBizPropName(String entity, String prop) {
        if (!entityBizPropMap.containsKey(entity)) {
            return null;
        }
        Map<String, String> bizPropMap = entityBizPropMap.get(entity);
        return bizPropMap.get(prop);
    }

    public static boolean alreadySuretyRepay(Long billId, String bizType) {
        QFilter filter = new QFilter("repaybillid", "=", (Object)billId).and("repaybilltype", "=", (Object)bizType);
        return TmcDataServiceHelper.exists("fbd_suretyreleasebill", filter.toArray());
    }

    private static void setEntrysDebtAmt(DynamicObject targetBill) {
        DynamicObjectCollection entrys = targetBill.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entrys) {
            String bizType = entry.getString("debttype");
            if (!"cdm_payablebill".equals(bizType)) continue;
            entry.set("repaydebt", (Object)true);
            entry.set("repaydebtamt", (Object)entry.getBigDecimal("debtamt"));
        }
    }

    private static String getReleaseType(DynamicObject suretyEntry, DynamicObject suretyBill) {
        Date expireDate = suretyBill.getDate("expiredate");
        if (EmptyUtil.isEmpty(expireDate)) {
            return SuretyReleaseTypeEnum.CURRENT.getValue();
        }
        Date repayDate = suretyEntry.getDate("repaydate");
        if (repayDate.before(expireDate)) {
            return SuretyReleaseTypeEnum.INADVANCE.getValue();
        }
        return SuretyReleaseTypeEnum.EXPIRE.getValue();
    }

    public static void setSuretyInfo(DynamicObject bill) {
        QFilter idFilter = new QFilter("entry.debtbillid", "=", bill.getPkValue());
        Object[] suretyBills = BusinessDataServiceHelper.load((String)"fbd_suretybill", (String)String.join((CharSequence)",", STPROPS), (QFilter[])idFilter.toArray());
        if (EmptyUtil.isEmpty(suretyBills)) {
            return;
        }
        SuretyHelper.setSuretyEntryInfo(bill, (DynamicObject[])suretyBills);
    }

    public static void setSuretyEntryInfo(DynamicObject bill, DynamicObject[] suretyBills) {
        DynamicObjectCollection entrySurety = bill.getDynamicObjectCollection("entry_surety");
        for (DynamicObject suretyBill : suretyBills) {
            DynamicObject addNew = entrySurety.addNew();
            addNew.set("suretybill", (Object)suretyBill);
            addNew.set("suretyfinorg", (Object)suretyBill.getDynamicObject("finorginfo"));
            addNew.set("suretycurrency", (Object)suretyBill.getDynamicObject("currency"));
            addNew.set("suretyamount", (Object)suretyBill.getBigDecimal("amount"));
            addNew.set("suretyaccount", (Object)suretyBill.getDynamicObject("settleaccount"));
            addNew.set("suretyintdate", (Object)suretyBill.getDate("intdate"));
            addNew.set("suretyterm", (Object)suretyBill.getString("term"));
            addNew.set("suretyexpiredate", (Object)suretyBill.getDate("expiredate"));
            addNew.set("suretysource", (Object)SuretyHelper.getSuretySource((Long)bill.getPkValue(), suretyBill));
        }
    }

    private static String getSuretySource(Long id, DynamicObject suretyBill) {
        DynamicObjectCollection entrys = suretyBill.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entrys) {
            Long debtBillId = entry.getLong("debtbillid");
            if (!id.equals(debtBillId)) continue;
            return entry.getString("suretysource");
        }
        return BillSourceEnum.HAND.getValue();
    }

    public static DynamicObject loadSuretyBillByDebit(Long debitId) {
        QFilter qFilter = new QFilter("entry.debtbillid", "=", (Object)debitId);
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        return TmcDataServiceHelper.loadSingle((String)"fbd_suretybill", (String)LOAD_SURETY_BY_DEBIT_PROPS, (QFilter[])new QFilter[]{qFilter});
    }

    public static DynamicObject loadSuretyBillByCredit(Long creditId) {
        QFilter qFilter = new QFilter("entry_credit.creditbillid", "=", (Object)creditId);
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        return TmcDataServiceHelper.loadSingle((String)"fbd_suretybill", (String)LOAD_SURETY_BY_CREDIT_PROPS, (QFilter[])new QFilter[]{qFilter});
    }

    public static DynamicObject loadSuretyBillByDebitAllStatus(Long debitId) {
        QFilter qFilter = new QFilter("entry.debtbillid", "=", (Object)debitId);
        return TmcDataServiceHelper.loadSingle((String)"fbd_suretybill", (String)LOAD_SURETY_BY_DEBIT_PROPS, (QFilter[])new QFilter[]{qFilter});
    }

    public static DynamicObject loadSuretyBillByCreditAllStatus(Long creditId) {
        QFilter qFilter = new QFilter("entry_credit.creditbillid", "=", (Object)creditId);
        return TmcDataServiceHelper.loadSingle((String)"fbd_suretybill", (String)LOAD_SURETY_BY_CREDIT_PROPS, (QFilter[])new QFilter[]{qFilter});
    }

    public static QFilter getSuretyEntryFilter(Long selectedId, String entityName) {
        QFilter qFilter = StringUtils.equals((CharSequence)"cfm_creditlimit", (CharSequence)entityName) ? new QFilter("entry_credit.creditbillid", "=", (Object)selectedId) : new QFilter("entry.debtbillid", "=", (Object)selectedId);
        return qFilter;
    }

    public static QFilter getBatchSuretyEntryFilter(List<Long> selectedIds, String entityName) {
        QFilter qFilter = StringUtils.equals((CharSequence)"cfm_creditlimit", (CharSequence)entityName) ? new QFilter("entry_credit.creditbillid", "in", selectedIds) : new QFilter("entry.debtbillid", "in", selectedIds);
        return qFilter;
    }

    public static QFilter getSuretyEntryFilterWithSave(Long bizId, String entityName) {
        QFilter qFilter = SuretyHelper.getSuretyEntryFilter(bizId, entityName);
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue());
        return qFilter;
    }

    public static DynamicObject loadSuretyByBizId(Long bizId, String entityName) {
        DynamicObject suretyBill = StringUtils.equals((CharSequence)"cfm_creditlimit", (CharSequence)entityName) ? SuretyHelper.loadSuretyBillByCredit(bizId) : SuretyHelper.loadSuretyBillByDebit(bizId);
        return suretyBill;
    }

    public static DynamicObject loadSuretyByBizIdAllStatus(Long bizId, String entityName) {
        DynamicObject suretyBill = StringUtils.equals((CharSequence)"cfm_creditlimit", (CharSequence)entityName) ? SuretyHelper.loadSuretyBillByCreditAllStatus(bizId) : SuretyHelper.loadSuretyBillByDebitAllStatus(bizId);
        return suretyBill;
    }

    public static void cancelSuretiesLink(DynamicObject[] bizBill) {
        if (EmptyUtil.isEmpty(bizBill)) {
            return;
        }
        ArrayList<DynamicObject> saveSuretyList = new ArrayList<DynamicObject>(bizBill.length);
        for (DynamicObject bill : bizBill) {
            DynamicObject removeSuretyLink = SuretyHelper.removeSuretyLink(bill);
            if (!EmptyUtil.isNoEmpty(removeSuretyLink)) continue;
            saveSuretyList.add(removeSuretyLink);
        }
        if (EmptyUtil.isNoEmpty(saveSuretyList)) {
            SaveServiceHelper.save((DynamicObject[])saveSuretyList.toArray(new DynamicObject[0]));
        }
    }

    public static DynamicObject removeSuretyLink(DynamicObject bizBill) {
        if (EmptyUtil.isEmpty(bizBill)) {
            return null;
        }
        DynamicObject surety = SuretyHelper.loadSuretyByBizIdAllStatus(bizBill.getLong("id"), bizBill.getDataEntityType().getName());
        if (EmptyUtil.isEmpty(surety)) {
            return null;
        }
        if (StringUtils.equals((CharSequence)"cfm_creditlimit", (CharSequence)bizBill.getDataEntityType().getName())) {
            surety.getDynamicObjectCollection("entry_credit").removeIf(d -> d.getDynamicObject("creditbillid").getLong("id") == bizBill.getLong("id"));
        } else {
            surety.getDynamicObjectCollection("entry").removeIf(d -> d.getLong("debtbillid") == bizBill.getLong("id"));
        }
        return surety;
    }

    static {
        HashMap<String, String> lcBizPropMap = new HashMap<String, String>(16);
        lcBizPropMap.put("org", "org");
        lcBizPropMap.put("status", "billstatus");
        lcBizPropMap.put("bizno", "creditno");
        lcBizPropMap.put("finorginfo", "bank");
        lcBizPropMap.put("currency", "currency");
        lcBizPropMap.put("amount", "amount");
        lcBizPropMap.put("suretystatus", "creditstatus");
        lcBizPropMap.put("credit", "creditlimit");
        lcBizPropMap.put("debtstartdate", "bizdate");
        lcBizPropMap.put("debtenddate", "validdate");
        entityBizPropMap.put("lc_lettercredit", lcBizPropMap);
        entityBizPropMap.put("lc_lettercredit_init", lcBizPropMap);
        HashMap<String, String> gmBizPropMap = new HashMap<String, String>(16);
        gmBizPropMap.put("org", "applyorg");
        gmBizPropMap.put("status", "billstatus");
        gmBizPropMap.put("bizno", "billno");
        gmBizPropMap.put("finorginfo", "finorginfo");
        gmBizPropMap.put("currency", "currency");
        gmBizPropMap.put("amount", "amount");
        gmBizPropMap.put("suretystatus", "bizstatus");
        gmBizPropMap.put("credit", "creditlimit");
        gmBizPropMap.put("debtstartdate", "startdate");
        gmBizPropMap.put("debtenddate", "expiredate");
        entityBizPropMap.put("gm_letterofguarantee", gmBizPropMap);
        HashMap<String, String> cdmBizPropMap = new HashMap<String, String>(16);
        cdmBizPropMap.put("org", "company");
        cdmBizPropMap.put("status", "billstatus");
        cdmBizPropMap.put("bizno", "draftbillno");
        cdmBizPropMap.put("finorginfo", "drawerorg");
        cdmBizPropMap.put("currency", "currency");
        cdmBizPropMap.put("amount", "amount");
        cdmBizPropMap.put("suretystatus", "draftbillstatus");
        cdmBizPropMap.put("credit", "creditlimit");
        cdmBizPropMap.put("debtstartdate", "issuedate");
        cdmBizPropMap.put("debtenddate", "draftbillexpiredate");
        entityBizPropMap.put("cdm_payablebill", cdmBizPropMap);
        HashMap<String, String> cdmApplyPropMap = new HashMap<String, String>(16);
        cdmApplyPropMap.put("org", "company");
        cdmBizPropMap.put("status", "billstatus");
        cdmApplyPropMap.put("bizno", "billno");
        cdmApplyPropMap.put("finorginfo", "drawerorg");
        cdmApplyPropMap.put("currency", "currency");
        cdmApplyPropMap.put("amount", "amounttotal");
        cdmApplyPropMap.put("suretystatus", "draftbillstatus");
        cdmApplyPropMap.put("credit", "creditlimit");
        cdmApplyPropMap.put("debtstartdate", "issuedate");
        cdmApplyPropMap.put("debtenddate", "draftbillexpiredate");
        entityBizPropMap.put("cdm_payablebill_ap_manual", cdmApplyPropMap);
        HashMap<String, String> creditLimitPropMap = new HashMap<String, String>(16);
        creditLimitPropMap.put("billno", "number");
        creditLimitPropMap.put("status", "status");
        creditLimitPropMap.put("org", "org");
        creditLimitPropMap.put("bizno", "contractno");
        creditLimitPropMap.put("finorginfo", "bank");
        creditLimitPropMap.put("investorgtype", "banktype");
        creditLimitPropMap.put("currency", "currency");
        creditLimitPropMap.put("amount", "totalamt");
        entityBizPropMap.put("cfm_creditlimit", creditLimitPropMap);
        entityBizPropMap.put("creditm_limit_framework", creditLimitPropMap);
        HashMap<String, String> loanContractPropMap = new HashMap<String, String>(16);
        loanContractPropMap.put("org", "org");
        loanContractPropMap.put("status", "billstatus");
        loanContractPropMap.put("bizno", "contractno");
        loanContractPropMap.put("finorginfo", "creditor");
        loanContractPropMap.put("currency", "currency");
        loanContractPropMap.put("amount", "amount");
        loanContractPropMap.put("suretystatus", "contractstatus");
        loanContractPropMap.put("credit", "creditlimit");
        loanContractPropMap.put("debtstartdate", "startdate");
        loanContractPropMap.put("debtenddate", "enddate");
        entityBizPropMap.put("cfm_loancontractbill", loanContractPropMap);
        entityBizPropMap.put("fl_leasecontractbill", loanContractPropMap);
        HashMap<String, String> loanBillPropMap = new HashMap<String, String>(16);
        loanBillPropMap.put("org", "org");
        loanBillPropMap.put("status", "billstatus");
        loanBillPropMap.put("bizno", "billno");
        loanBillPropMap.put("finorginfo", "creditor");
        loanBillPropMap.put("currency", "currency");
        loanBillPropMap.put("amount", "amount");
        loanBillPropMap.put("suretystatus", "drawtype");
        loanBillPropMap.put("credit", "creditlimit");
        loanBillPropMap.put("debtstartdate", "startintdate");
        loanBillPropMap.put("debtenddate", "expiredate");
        entityBizPropMap.put("cfm_loanbill", loanBillPropMap);
        entityBizPropMap.put("fl_receiptbill", loanBillPropMap);
        STPROPS = new String[]{"finorginfo", "currency", "amount", "settleaccount", "intdate", "term", "expiredate", "entry.debtbillid", "entry.suretysource"};
    }
}

