/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.AttachmentDto;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.url.UrlService;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TmcAttachmentHelper {
    private static Log logger = LogFactory.getLog(TmcAttachmentHelper.class);
    private static final String SEPARATOR = "/";
    public static final String PRE_INSDATA_SYMBOL = "icons/pc/other";

    public static Map<String, List<Map<String, Object>>> getAttachments(String entityName, Long[] bizBillIds) {
        Map attachmentpanel = AttachmentServiceHelper.getAttachments((String)entityName, (Object[])bizBillIds, (String)"attachmentpanel", (boolean)false);
        return attachmentpanel;
    }

    public static List<Map<String, Object>> copyAttachment(List<Map<String, Object>> attachments, String entityName) {
        ArrayList<Map<String, Object>> attaList = new ArrayList<Map<String, Object>>(attachments.size());
        for (int i = 0; i < attachments.size(); ++i) {
            Map<String, Object> attachmentInfo = attachments.get(i);
            String fileName = (String)attachmentInfo.get("name");
            String originalUid = (String)attachmentInfo.get("uid");
            String fileType = (String)attachmentInfo.get("type");
            AttachmentDto attachmentDto = AttachmentServiceHelper.getAttachmentInfoByAttPk((Object)attachmentInfo.get("attPkId"));
            String url = attachmentDto.getResourcePath();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            FileServiceFactory.getAttachmentFileService().download(url, (OutputStream)out, null);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            attaList.add(TmcAttachmentHelper.newModelTempFile(fileName, fileType, in, originalUid, entityName));
            try {
                ((InputStream)in).close();
                continue;
            }
            catch (IOException ioException) {
                logger.error(ioException.getMessage());
            }
        }
        return attaList;
    }

    public static Map<String, Object> newModelTempFile(String fileName, String fileType, InputStream in, String originalUid, String entityName) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("entityNum", entityName);
        long time = System.currentTimeMillis();
        map.put("createdate", time);
        map.put("lastModified", time);
        map.put("name", fileName);
        try {
            map.put("size", in.available());
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        map.put("status", "success");
        map.put("type", fileType);
        StringBuilder uid = new StringBuilder();
        uid.append("rc-upload-");
        uid.append(time);
        uid.append("-");
        String numberIndex = null;
        int index = originalUid.lastIndexOf("-");
        if (index != -1) {
            numberIndex = originalUid.substring(index + 1);
        }
        uid.append(numberIndex);
        map.put("uid", uid.toString());
        StringBuilder newUrl = new StringBuilder();
        newUrl.append(RequestContext.get().getClientFullContextPath());
        if (!newUrl.toString().endsWith(SEPARATOR)) {
            newUrl.append(SEPARATOR);
        }
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        String tempUrl = tempFileCache.saveAsUrl(fileName, in, 7200);
        newUrl.append(tempUrl);
        map.put("url", newUrl.toString());
        return map;
    }

    public static OutputStream downloadFile(String desPlace, String realUploadUrl) {
        FileOutputStream out = null;
        try {
            FileService fs = FileServiceFactory.getAttachmentFileService();
            String userAgent = "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36";
            try {
                out = new FileOutputStream(desPlace);
            }
            catch (FileNotFoundException e) {
                logger.error("\u6839\u636e\u76ee\u6807\u8def\u5f84\u521b\u5efa\u6587\u4ef6\u8f93\u51fa\u6d41\u51fa\u9519 {}", (Object)e.getMessage());
            }
            fs.download(realUploadUrl, (OutputStream)out, userAgent);
        }
        catch (Exception e) {
            logger.error("\u6267\u884cdownload\u4e0b\u8f7d\u64cd\u4f5c\u51fa\u9519 {}", (Object)e.getMessage());
        }
        return out;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File getFile(OutputStream outStream, String relativeUrl, String targetPdfRoute) {
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        try (InputStream inputStream = fileService.getInputStream(relativeUrl);){
            byte[] buffer = new byte[inputStream.available()];
            inputStream.read(buffer);
            File targetFile = new File(targetPdfRoute);
            outStream.write(buffer);
            File file = targetFile;
            return file;
        }
        catch (Exception e) {
            logger.error("\u4ece\u5bb9\u5668\u83b7\u53d6\u7535\u5b50\u56de\u5355pdf\u5931\u8d25 {}", (Object)e.getMessage());
            return null;
        }
    }

    public static String getRealPath(String relativePath) {
        if (EmptyUtil.isBlank((CharSequence)relativePath)) {
            return "";
        }
        String rootUrl = UrlService.getDomainContextUrl();
        if (rootUrl.endsWith(SEPARATOR)) {
            rootUrl = rootUrl.substring(0, rootUrl.length() - 1);
        }
        if (relativePath.contains(PRE_INSDATA_SYMBOL) && !relativePath.contains(rootUrl)) {
            return rootUrl + relativePath;
        }
        return relativePath;
    }

    public static void setAttachments(DynamicObject srcData, String targetEntity, Long targetPkId, String srcAttachPanel, String tagAttachPanel) {
        List attachments = AttachmentServiceHelper.getAttachments((String)srcData.getDynamicObjectType().getName(), (Object)srcData.get("id"), (String)srcAttachPanel);
        if (EmptyUtil.isEmpty(attachments)) {
            return;
        }
        for (Map attachment : attachments) {
            if (attachment.containsKey("lastModified") && attachment.get("lastModified") instanceof Date) {
                Date date = (Date)attachment.get("lastModified");
                attachment.put("lastModified", date.getTime());
            }
            if (!attachment.containsKey("attPkId")) continue;
            DynamicObject atts = TmcDataServiceHelper.loadSingle(attachment.get("attPkId"), (String)"bos_attachment", (String)"ffileid");
            String property = System.getProperty("clusterName");
            StringBuilder path = new StringBuilder();
            if (EmptyUtil.isNoEmpty(property)) {
                path.append(property);
                path.append(SEPARATOR);
            }
            path.append(DateUtils.formatString(new Date(), "yyyyMM"));
            path.append(SEPARATOR);
            path.append(targetEntity);
            path.append(SEPARATOR);
            path.append(targetPkId);
            path.append(SEPARATOR);
            path.append("attachments");
            path.append(SEPARATOR);
            path.append(attachment.get("name"));
            TXHandle h = TX.requiresNew();
            Throwable throwable = null;
            try {
                try {
                    FileService fs = FileServiceFactory.getAttachmentFileService();
                    FileItem fi = new FileItem((String)attachment.get("name"), path.toString(), fs.getInputStream(atts.getString("ffileid")));
                    String upload = fs.upload(fi);
                    attachment.put("url", upload);
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (h == null) continue;
                if (throwable != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                h.close();
            }
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                AttachmentServiceHelper.upload((String)targetEntity, (Object)targetPkId, (String)tagAttachPanel, (List)attachments);
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    public static void deleteAttachment(String srcEntity, Object srcPkId, String tarEntity, Object tarPkId) {
        List attachments = AttachmentServiceHelper.getAttachments((String)srcEntity, (Object)srcPkId, (String)"attachmentpanel");
        if (EmptyUtil.isEmpty(attachments)) {
            return;
        }
        for (int i = 0; i < attachments.size(); ++i) {
            Map attMap = (Map)attachments.get(i);
            Object uid = attMap.get("uid");
            if (null == uid) continue;
            AttachmentServiceHelper.remove((String)tarEntity, (Object)tarPkId, uid);
        }
    }

    public static String getOppositeEntity(DynamicObject srcBill, String srcEntity) {
        String oppositeEntity;
        if (EmptyUtil.isAnyoneEmpty(srcBill, srcEntity)) {
            return "";
        }
        if ("ifm_initbill".equals(srcEntity)) {
            return "cfm_loancontractbill";
        }
        if (!srcBill.getDynamicObjectType().getProperties().containsKey((Object)"creditortype")) {
            return "";
        }
        if (!CreditorTypeEnum.isInnerUnit(srcBill.getString("creditortype"))) {
            return "";
        }
        switch (srcEntity) {
            case "cfm_initbill": 
            case "cfm_contract_apply": {
                oppositeEntity = "cim_invest_contract";
                break;
            }
            case "cim_contract_apply": {
                oppositeEntity = "cfm_loancontractbill";
                break;
            }
            case "cim_apply_loanbill": {
                oppositeEntity = "cfm_loanbill";
                break;
            }
            case "cfm_apply_loanbill": {
                oppositeEntity = "cim_invest_loanbill";
                break;
            }
            default: {
                oppositeEntity = "";
            }
        }
        return oppositeEntity;
    }
}

