/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import com.alibaba.fastjson.JSON;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.runtime.AbstractConvertServiceArgs;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.BeforeDrawArgs;
import kd.bos.entity.botp.runtime.BeforeDrawOpResult;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.ConvertReport;
import kd.bos.entity.botp.runtime.DrawArgs;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.operate.botp.Push;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class TmcBotpHelper {
    private static Log logger = LogFactory.getLog(TmcBotpHelper.class);

    public static DynamicObject getTargetBill(String currEntity, Object currEntityId, String targetEntity) {
        return TmcBotpHelper.getTargetBill(currEntity, currEntityId, targetEntity, null);
    }

    public static DynamicObject getTargetBill(String currEntity, Object currEntityId, String targetEntity, String targetProps) {
        Map botpMap = BFTrackerServiceHelper.findTargetBills((String)currEntity, (Long[])new Long[]{(Long)currEntityId});
        return TmcBotpHelper.getBillFromBotpMap(targetEntity, targetProps, botpMap);
    }

    public static Long[] getTargetBillIds(String currEntity, Object currEntityId, String targetEntity) {
        Map botpMap = BFTrackerServiceHelper.findTargetBills((String)currEntity, (Long[])new Long[]{(Long)currEntityId});
        Set destIds = (Set)botpMap.get(targetEntity);
        return destIds != null ? destIds.toArray(new Long[0]) : null;
    }

    public static Long[] getSourceBillIds(String currEntity, Object currEntityId, String sourceEntity) {
        Map botpMap = BFTrackerServiceHelper.findSourceBills((String)currEntity, (Long[])new Long[]{(Long)currEntityId});
        Set sourceIds = (Set)botpMap.get(sourceEntity);
        return sourceIds == null ? null : sourceIds.toArray(new Long[0]);
    }

    public static DynamicObject getSourceBill(String currEntity, Object currEntityId, String sourceEntity) {
        return TmcBotpHelper.getSourceBill(currEntity, currEntityId, sourceEntity, null);
    }

    public static DynamicObject getSourceBill(String currEntity, Object currEntityId, String sourceEntity, String sourceProps) {
        Map botpMap = BFTrackerServiceHelper.findSourceBills((String)currEntity, (Long[])new Long[]{(Long)currEntityId});
        return TmcBotpHelper.getBillFromBotpMap(sourceEntity, sourceProps, botpMap);
    }

    private static DynamicObject getBillFromBotpMap(String entityName, String selectProps, Map<String, HashSet<Long>> map) {
        DynamicObject sourceBill = null;
        HashSet<Long> sourceIds = map.get(entityName);
        if (EmptyUtil.isNoEmpty(sourceIds)) {
            Long id = sourceIds.iterator().next();
            sourceBill = EmptyUtil.isNoEmpty(selectProps) ? TmcDataServiceHelper.loadSingle((Object)id, (String)entityName, (String)selectProps) : TmcDataServiceHelper.loadSingle((Object)id, (String)entityName);
        }
        return sourceBill;
    }

    private static DynamicObject getBillFromBotpMap(String entityName, Map<String, HashSet<Long>> map) {
        return TmcBotpHelper.getBillFromBotpMap(entityName, null, map);
    }

    public static void showParamter(String entitynumber, Long primaryKeyValue, String opeat, IFormView iFormView) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_lookuptracker");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HashSet<Long> subEntryIds = new HashSet<Long>();
        subEntryIds.add(primaryKeyValue);
        String linkNodesJson = null;
        List nodes = null;
        nodes = opeat.equals("lookdown") ? BFTrackerServiceHelper.loadLinkDownNodes((String)entitynumber, (String)"", (Long[])subEntryIds.toArray(new Long[subEntryIds.size()])) : BFTrackerServiceHelper.loadLinkUpNodes((String)entitynumber, (String)"", (Long[])subEntryIds.toArray(new Long[subEntryIds.size()]));
        if (nodes.isEmpty()) {
            iFormView.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"TmcBotpHelper_0", (String)"tmc-fbp-common", (Object[])new Object[0]));
            return;
        }
        linkNodesJson = SerializationUtils.serializeToBase64((Object)nodes);
        showParameter.getCustomParams().put("linknodes", linkNodesJson);
        showParameter.getCustomParams().put("lookuptype", opeat);
        iFormView.showForm(showParameter);
    }

    public static void showTrackParameter(List<Tuple<String, List<Long>>> billTuple, IFormView iFormView) {
        if (CollectionUtils.isEmpty(billTuple)) {
            iFormView.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"TmcBotpHelper_0", (String)"tmc-fbp-common", (Object[])new Object[0]));
            return;
        }
        for (Tuple<String, List<Long>> tuple : billTuple) {
            BillShowParameter showParameter;
            String entityNumber = (String)tuple.item1;
            List billIds = (List)tuple.item2;
            if (billIds.size() == 1) {
                showParameter = TmcBotpHelper.createBillShowParameter(entityNumber, (Long)billIds.get(0));
                if (showParameter == null) continue;
                iFormView.showForm((FormShowParameter)showParameter);
                continue;
            }
            showParameter = TmcBotpHelper.createShowParameter(entityNumber, new HashSet<Long>(billIds));
            if (showParameter == null) continue;
            iFormView.showForm((FormShowParameter)showParameter);
        }
    }

    private static BillShowParameter createBillShowParameter(String entityNumber, Long billId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(entityNumber);
        showParameter.setPkId((Object)billId);
        showParameter.getCustomParams().put("isIgnoreLicense", true);
        showParameter.getCustomParams().put("isFromTrack", "true");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getOpenStyle().setTargetKey("tabbills");
        showParameter.setShowTitle(false);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        showParameter.setCaption(mainType.getDisplayName().toString());
        showParameter.setStatusValue(OperationStatus.VIEW.getValue());
        showParameter.setHasRight(true);
        return showParameter;
    }

    private static ListShowParameter createShowParameter(String entityNumber, HashSet<Long> billIds) {
        QFilter qFilter = null;
        qFilter = billIds.size() == 1 ? new QFilter("id", "=", (Object)billIds.iterator().next()) : new QFilter("id", "in", (Object)billIds.toArray(new Long[billIds.size()]));
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("botp_trackerlist");
        showParameter.setBillFormId(entityNumber);
        showParameter.setIsolationOrg(false);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getOpenStyle().setTargetKey("tabbills");
        showParameter.setShowTitle(false);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        showParameter.setCaption(mainType.getDisplayName().toString());
        showParameter.getCustomParams().put("isFromTrack", "true");
        showParameter.getListFilterParameter().setFilter(qFilter);
        showParameter.addCustPlugin("kd.bos.form.plugin.botp.LookUpTrackerList");
        showParameter.setHasRight(true);
        return showParameter;
    }

    public static void showBillParamter(String entitynumber, Long primaryKeyValue, IFormView iFormView, String targetBill) {
        Map botpMap = BFTrackerServiceHelper.findTargetBills((String)entitynumber, (Long[])new Long[]{primaryKeyValue});
        Long targetBillId = 0L;
        if (botpMap != null && !CollectionUtils.isEmpty((Map)botpMap)) {
            for (Map.Entry entry : botpMap.entrySet()) {
                if (!StringUtils.equals((CharSequence)((CharSequence)entry.getKey()), (CharSequence)targetBill)) continue;
                targetBillId = (Long)((HashSet)entry.getValue()).iterator().next();
                break;
            }
        }
        if (targetBillId == 0L) {
            iFormView.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e", (String)"CfmBotpHelper_0", (String)"tmc-cfm-common", (Object[])new Object[0]));
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(targetBill);
        showParameter.setPkId((Object)targetBillId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.EDIT);
        iFormView.showForm((FormShowParameter)showParameter);
    }

    public static void doBeforeDraw(IFormView view, String soureEntity, String targetEntity, Boolean isMultiSelect, QFilter filter, CloseCallBack closeCallBack) {
        TmcBotpHelper.doBeforeDraw(view, soureEntity, soureEntity, targetEntity, isMultiSelect, filter, closeCallBack);
    }

    public static void doBeforeDraw(IFormView view, String soureEntity, String srcLayoutFormId, String targetEntity, Boolean isMultiSelect, QFilter filter, CloseCallBack closeCallBack, boolean isMainOrgPermFilter) {
        List rules = ConvertMetaServiceHelper.loadRules((String)soureEntity, (String)targetEntity);
        if (EmptyUtil.isEmpty(rules)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6709\u6548\u7684\u8f6c\u6362\u89c4\u5219,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u3002", (String)"TmcBotpHelper_1", (String)"tmc-fbp-common", (Object[])new Object[0]));
            return;
        }
        String ruleId = TmcBotpHelper.getRule(soureEntity, targetEntity);
        BeforeDrawArgs args = new BeforeDrawArgs();
        args.setSourceEntityNumber(soureEntity);
        args.setTargetEntityNumber(targetEntity);
        args.setTargetPageId(view.getPageId());
        args.setRuleId(ruleId);
        ConvertOperationResult opResult = ConvertServiceHelper.beforeDraw((BeforeDrawArgs)args);
        BeforeDrawOpResult result = (BeforeDrawOpResult)opResult;
        if (!result.isSuccess()) {
            StringBuilder sBuilder = new StringBuilder();
            if (result.getReports().size() == 0) {
                sBuilder.append(result.getMessage());
            } else {
                for (ConvertReport report : result.getReports()) {
                    sBuilder.append(report).append("; ");
                }
            }
            view.showErrorNotification(sBuilder.toString());
        } else {
            String drawFilter = result.getDrawFilter();
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)srcLayoutFormId, (boolean)isMultiSelect);
            QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
            if (isMainOrgPermFilter) {
                String mianOrgFieldName = "org";
                MainEntityType soureEntityType = MetadataServiceHelper.getDataEntityType((String)soureEntity);
                String mainOrg = soureEntityType.getMainOrg();
                if (!EmptyUtil.isEmpty(mainOrg)) {
                    mianOrgFieldName = mainOrg;
                }
                Long userPK = Long.valueOf(RequestContext.get().getUserId());
                String appId = view.getFormShowParameter().getAppId();
                List orgIdSet = TmcOrgDataHelper.getAuthorizedBankOrgId(userPK, appId, soureEntity, "47150e89000000ac");
                qFilter.and(new QFilter(mianOrgFieldName, "in", (Object)orgIdSet));
            }
            if (EmptyUtil.isNoEmpty(drawFilter)) {
                QFilter fi = QFilter.fromSerializedString((String)drawFilter);
                if (filter != null) {
                    qFilter.and(fi);
                }
            }
            if (filter != null) {
                qFilter.and(filter);
            }
            showParameter.getListFilterParameter().setFilter(qFilter);
            logger.info("\u9009\u5355\u7684\u8fc7\u6ee4\u6761\u4ef6:" + qFilter.toString());
            if (result.getDrawSelectedEntity().size() > 0) {
                String selectEntity = (String)result.getDrawSelectedEntity().get(result.getDrawSelectedEntity().size() - 1);
                showParameter.getListFilterParameter().setSelectEntity(selectEntity);
                showParameter.getCustomParams().put("ismergerows", false);
            }
            if (result.getSrcMainOrgId() != null) {
                showParameter.setIsolationOrg(true);
                showParameter.setUseOrgId(result.getSrcMainOrgId().longValue());
            } else {
                showParameter.setIsolationOrg(false);
            }
            showParameter.setCloseCallBack(closeCallBack);
            view.showForm((FormShowParameter)showParameter);
        }
    }

    public static void doBeforeDraw(IFormView view, String soureEntity, String srcLayoutFormId, String targetEntity, Boolean isMultiSelect, QFilter filter, CloseCallBack closeCallBack) {
        TmcBotpHelper.doBeforeDraw(view, soureEntity, srcLayoutFormId, targetEntity, isMultiSelect, filter, closeCallBack, true);
    }

    public static void doDraw(IFormView view, String soureEntity, String targetEntity, ListSelectedRowCollection rows) {
        String mianOrgFieldName = "org";
        MainEntityType tagEntityType = MetadataServiceHelper.getDataEntityType((String)targetEntity);
        String mainOrg = tagEntityType.getMainOrg();
        if (!EmptyUtil.isEmpty(mainOrg)) {
            mianOrgFieldName = mainOrg;
        }
        String ruleId = TmcBotpHelper.getRule(soureEntity, targetEntity);
        DrawArgs args = new DrawArgs();
        args.setSourceEntityNumber(soureEntity);
        args.setTargetEntityNumber(targetEntity);
        args.getSelectedRows().addAll(rows);
        args.setTargetPageId(view.getPageId());
        args.setRuleId(ruleId);
        args.setBuildConvReport(true);
        ConvertOperationResult result = ConvertServiceHelper.draw((DrawArgs)args);
        if (!result.isSuccess() || result.getCachePageIds().size() == 0) {
            Push.showReport((IFormView)view, (AbstractConvertServiceArgs)args, (ConvertOperationResult)result);
        } else {
            IRefrencedataProvider refProvider = BusinessDataReader::loadRefence;
            IBillView billView = (IBillView)view.getView(view.getPageId());
            List dataEntitys = result.loadTargetDataObjects(refProvider, billView.getModel().getDataEntityType());
            DynamicObject dataEntity = (DynamicObject)dataEntitys.get(0);
            String tagBillno = dataEntity.getString("billno");
            if (EmptyUtil.isEmpty(tagBillno) && EmptyUtil.isNoEmpty(dataEntity.getDynamicObject(mianOrgFieldName))) {
                String codeNumber = CodeRuleHelper.generateNumber(dataEntity.getDataEntityType().getName(), dataEntity, dataEntity.getDynamicObject(mianOrgFieldName).getPkValue().toString(), "");
                dataEntity.set("billno", (Object)codeNumber);
            }
            ((IBillModel)billView.getModel()).push((Object)dataEntity);
            billView.updateView();
            view.sendFormAction((IFormView)billView);
            result.release(refProvider, billView.getModel().getDataEntityType());
        }
    }

    private static String getRule(String soureEntity, String targetEntity) {
        List rules = ConvertMetaServiceHelper.loadRules((String)soureEntity, (String)targetEntity);
        String ruleId = "";
        for (ConvertRuleElement rule : rules) {
            if (!rule.isDefRule()) continue;
            ruleId = rule.getId();
            break;
        }
        if (EmptyUtil.isEmpty(ruleId)) {
            ruleId = ((ConvertRuleElement)rules.get(0)).getId();
        }
        return ruleId;
    }

    public static void doPush(IFormView view, Long srcBillId, String srcEntityNumber, String targetEntityNumber, String srcLayoutFormId, String targetLayoutFormId) {
        TmcBotpHelper.doPush(view, Collections.singletonList(srcBillId), srcEntityNumber, targetEntityNumber, srcLayoutFormId, targetLayoutFormId);
    }

    public static void doPush(IFormView view, List<Long> srcBillIds, String srcEntityNumber, String targetEntityNumber, String srcLayoutFormId, String targetLayoutFormId) {
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(srcBillIds.size());
        for (Long id : srcBillIds) {
            ListSelectedRow row = new ListSelectedRow();
            row.setPrimaryKeyValue((Object)id);
            selectedRows.add(row);
        }
        PushArgs pushArgs = new PushArgs();
        List rules = ConvertMetaServiceHelper.loadRules((String)srcEntityNumber, (String)targetEntityNumber);
        if (EmptyUtil.isEmpty(rules)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6709\u6548\u7684\u8f6c\u6362\u89c4\u5219,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u3002", (String)"TmcBotpHelper_1", (String)"tmc-fbp-common", (Object[])new Object[0]));
            return;
        }
        for (ConvertRuleElement rule : rules) {
            String sourceLayout = rule.getLinkEntityPolicy().getSourceLayout();
            if (!srcLayoutFormId.equals(sourceLayout)) continue;
            pushArgs.setRuleId(rule.getId());
        }
        pushArgs.setSourceEntityNumber(srcEntityNumber);
        pushArgs.setTargetEntityNumber(targetEntityNumber);
        pushArgs.setSelectedRows(selectedRows);
        ConvertOperationResult convertResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (convertResult.isSuccess() && convertResult.getCachePageIds().size() != 0) {
            if (convertResult.getCachePageIds().size() == 1) {
                convertResult.setTargetBillFormId(targetLayoutFormId);
                TmcBotpHelper.showTargetBill(view, pushArgs, convertResult, false);
            } else {
                view.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u4e00\u6b21\u4e0b\u63a8\u751f\u6210\u591a\u5f20\u76ee\u6807\u5355\u3002", (String)"TmcBotpHelper_2", (String)"tmc-fbp-common", (Object[])new Object[0]));
            }
        } else {
            TmcBotpHelper.showReport(view, (AbstractConvertServiceArgs)pushArgs, convertResult);
        }
    }

    public static void showTargetBill(IFormView view, PushArgs pushArgs, ConvertOperationResult convertResult, boolean showReport) {
        Object showParameter = null;
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)pushArgs.getTargetEntityNumber());
        boolean isBasedata = mainType instanceof BasedataEntityType;
        showParameter = isBasedata ? new BaseShowParameter() : new BillShowParameter();
        showParameter.setFormId(convertResult.loadTargetLayoutFormId());
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if (convertResult.getTargetBillIds().isEmpty()) {
            showParameter.setStatus(OperationStatus.ADDNEW);
            showParameter.setCachePageId((String)convertResult.getCachePageIds().get(0));
        } else {
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setPkId(convertResult.getTargetBillIds().iterator().next());
        }
        showParameter.setHasRight(true);
        showParameter.getCustomParams().put("isIgnoreLicense", true);
        showParameter.addCustPlugin("kd.bos.form.plugin.botp.ConvertTrackerEdit");
        showParameter.getCustomParams().put("showreport", String.valueOf(showReport));
        showParameter.getCustomParams().put("botptag_of_datasource", "true");
        if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)pushArgs.getAppId())) {
            showParameter.getCustomParams().put("checkRightAppId", pushArgs.getAppId());
        }
        String resultJson = SerializationUtils.toJsonString((Object)convertResult);
        IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
        pageCache.put("ConvertOperationResult", resultJson);
        view.showForm((FormShowParameter)showParameter);
    }

    public static void showReport(IFormView view, AbstractConvertServiceArgs convertArgs, ConvertOperationResult convertResult) {
        if (convertResult.getBillReports().isEmpty()) {
            view.showErrorNotification(convertResult.getMessage());
        } else {
            String resultJson = SerializationUtils.toJsonString((Object)convertResult);
            IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
            pageCache.put("ConvertOperationResult", resultJson);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("botp_convertreport");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.getOpenStyle().setInlineStyleCss(new StyleCss());
            showParameter.getOpenStyle().getInlineStyleCss().setHeight("410");
            showParameter.getOpenStyle().getInlineStyleCss().setWidth("850");
            showParameter.setShowTitle(true);
            showParameter.getCustomParams().put("convertresultpageid", view.getPageId());
            showParameter.getCustomParams().put("targetentitynumber", convertArgs.getTargetEntityNumber());
            showParameter.getCustomParams().put("releaseresult", String.valueOf(true));
            view.showForm(showParameter);
        }
    }

    public static DynamicObject[] push(DynamicObject info, String TargetEntity) {
        String sourceEntity = info.getDataEntityType().getName();
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>();
        ListSelectedRow row = new ListSelectedRow();
        row.setPrimaryKeyValue(info.getPkValue());
        selectedRows.add(row);
        PushArgs args = new PushArgs();
        args.setSourceEntityNumber(sourceEntity);
        args.setTargetEntityNumber(TargetEntity);
        args.setSelectedRows(selectedRows);
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)args);
        IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dynamicObjects, IDataEntityType dType) {
                BusinessDataServiceHelper.loadRefence((Object[])dynamicObjects, (IDataEntityType)dType);
            }
        };
        if (result.isSuccess()) {
            MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)TargetEntity);
            List dataResults = result.loadTargetDataObjects(refDataProvider, mainType);
            return dataResults.toArray(new DynamicObject[dataResults.size()]);
        }
        throw new TmcBizException(TmcErrorCode.COMMON, new String[]{result.getMessage()});
    }

    public static DynamicObject[] push(DynamicObject info, String TargetEntity, String srcLayoutFormId) {
        String sourceEntity = info.getDataEntityType().getName();
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>();
        ListSelectedRow row = new ListSelectedRow();
        row.setPrimaryKeyValue(info.getPkValue());
        selectedRows.add(row);
        PushArgs args = new PushArgs();
        args.setSourceEntityNumber(sourceEntity);
        args.setTargetEntityNumber(TargetEntity);
        List rules = ConvertMetaServiceHelper.loadRules((String)sourceEntity, (String)TargetEntity);
        for (ConvertRuleElement rule : rules) {
            String sourceLayout = rule.getLinkEntityPolicy().getSourceLayout();
            if (!srcLayoutFormId.equals(sourceLayout)) continue;
            args.setRuleId(rule.getId());
            break;
        }
        args.setSelectedRows(selectedRows);
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)args);
        IRefrencedataProvider refDataProvider = BusinessDataServiceHelper::loadRefence;
        if (result.isSuccess()) {
            MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)TargetEntity);
            List dataResults = result.loadTargetDataObjects(refDataProvider, mainType);
            return dataResults.toArray(new DynamicObject[dataResults.size()]);
        }
        throw new TmcBizException(TmcErrorCode.COMMON, new String[]{result.getMessage()});
    }

    public static DynamicObject[] batchPush(Object[] srcPkIds, String sourceEntity, String targetEntity) {
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(srcPkIds.length);
        for (Object info : srcPkIds) {
            ListSelectedRow row = new ListSelectedRow();
            row.setPrimaryKeyValue(info);
            selectedRows.add(row);
        }
        PushArgs args = new PushArgs();
        args.setSourceEntityNumber(sourceEntity);
        args.setTargetEntityNumber(targetEntity);
        args.setSelectedRows(selectedRows);
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)args);
        IRefrencedataProvider refDataProvider = BusinessDataServiceHelper::loadRefence;
        if (result.isSuccess()) {
            MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)targetEntity);
            List dataResults = result.loadTargetDataObjects(refDataProvider, mainType);
            return dataResults.toArray(new DynamicObject[dataResults.size()]);
        }
        throw new TmcBizException(TmcErrorCode.COMMON, new String[]{result.getMessage()});
    }

    public static void saveRelation(DynamicObject sourceBill, DynamicObject targetBill) {
        String sourceKey = sourceBill.getDataEntityType().getName();
        Long sourcePk = (Long)sourceBill.getPkValue();
        String targetKey = targetBill.getDataEntityType().getName();
        Long targetPk = (Long)targetBill.getPkValue();
        TmcBotpHelper.saveRelation(sourceKey, sourcePk, targetKey, targetPk);
    }

    public static void saveRelation(String sourceEntityKey, Long sourcePk, String targetEntityKey, Long targetPk) {
        Long sourceTableId = TmcBotpHelper.getTableIdByEntityKey(sourceEntityKey);
        Long targetTableId = TmcBotpHelper.getTableIdByEntityKey(targetEntityKey);
        ArrayList<kd.tmc.fbp.common.model.BFRow> rows = new ArrayList<kd.tmc.fbp.common.model.BFRow>();
        long pk = DBServiceHelper.genGlobalLongId();
        kd.tmc.fbp.common.model.BFRow row = new kd.tmc.fbp.common.model.BFRow(pk, sourcePk, sourceTableId, targetTableId, targetPk);
        rows.add(row);
        TmcBotpHelper.saveRelation(rows, targetEntityKey);
    }

    public static void batchSaveRelation(String sourceEntityKey, String targetEntityKey, List<Pair<Long, Long>> srcTarIds) {
        Long sourceTableId = TmcBotpHelper.getTableIdByEntityKey(sourceEntityKey);
        Long targetTableId = TmcBotpHelper.getTableIdByEntityKey(targetEntityKey);
        ArrayList<kd.tmc.fbp.common.model.BFRow> rows = new ArrayList<kd.tmc.fbp.common.model.BFRow>(srcTarIds.size());
        for (Pair<Long, Long> srcTarId : srcTarIds) {
            if (TmcBotpHelper.isExistsBotp(sourceEntityKey, (Long)srcTarId.getLeft(), targetEntityKey, (Long)srcTarId.getRight())) continue;
            long pk = DBServiceHelper.genGlobalLongId();
            kd.tmc.fbp.common.model.BFRow row = new kd.tmc.fbp.common.model.BFRow(pk, (Long)srcTarId.getKey(), sourceTableId, targetTableId, (Long)srcTarId.getValue());
            rows.add(row);
        }
        if (EmptyUtil.isNoEmpty(rows)) {
            TmcBotpHelper.saveRelation(rows, targetEntityKey);
        }
    }

    public static void batchSaveRelation(String sourceEntityKey, String targetEntityKey, List<Pair<Long, Long>> srcTarIds, String relateType) {
        Long sourceTableId = TmcBotpHelper.getTableIdByEntityKey(sourceEntityKey);
        Long targetTableId = TmcBotpHelper.getTableIdByEntityKey(targetEntityKey);
        ArrayList<kd.tmc.fbp.common.model.BFRow> rows = new ArrayList<kd.tmc.fbp.common.model.BFRow>(srcTarIds.size());
        for (Pair<Long, Long> srcTarId : srcTarIds) {
            if (TmcBotpHelper.isExistsBotp(sourceEntityKey, (Long)srcTarId.getLeft(), targetEntityKey, (Long)srcTarId.getRight()) && "down".equals(relateType)) continue;
            long pk = DBServiceHelper.genGlobalLongId();
            kd.tmc.fbp.common.model.BFRow row = new kd.tmc.fbp.common.model.BFRow(pk, (Long)srcTarId.getKey(), sourceTableId, targetTableId, (Long)srcTarId.getValue());
            rows.add(row);
        }
        if (EmptyUtil.isNoEmpty(rows)) {
            TmcBotpHelper.saveRelation(rows, targetEntityKey);
        }
    }

    public static void saveRelation(String sourceEntityKey, Collection<Long> sourcePks, String targetEntityKey, Long targetPk) {
        Long sourceTableId = TmcBotpHelper.getTableIdByEntityKey(sourceEntityKey);
        Long targetTableId = TmcBotpHelper.getTableIdByEntityKey(targetEntityKey);
        ArrayList<kd.tmc.fbp.common.model.BFRow> rows = new ArrayList<kd.tmc.fbp.common.model.BFRow>(sourcePks.size());
        for (Long sourcePk : sourcePks) {
            long pk = DBServiceHelper.genGlobalLongId();
            kd.tmc.fbp.common.model.BFRow row = new kd.tmc.fbp.common.model.BFRow(pk, sourcePk, sourceTableId, targetTableId, targetPk);
            rows.add(row);
        }
        TmcBotpHelper.saveRelation(rows, targetEntityKey);
    }

    private static void saveRelation(List<kd.tmc.fbp.common.model.BFRow> rows, String targetEntityKey) {
        LinkSetElement linkSet = EntityMetadataCache.getLinkSet((String)targetEntityKey);
        String tc = linkSet.getTrackerTable();
        String lk = null;
        List items = linkSet.getItems();
        if (items != null && items.size() > 0) {
            lk = ((LinkSetItemElement)items.get(0)).getTableName();
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)targetEntityKey);
            DBRoute dbRoute = DBRouteConst.TMC;
            if (EmptyUtil.isNoEmpty(entityType.getDBRouteKey())) {
                dbRoute = DBRoute.of((String)entityType.getDBRouteKey());
            }
            TmcBotpHelper.saveBizRelation(rows, tc, lk, dbRoute);
            try (TXHandle h = TX.requiresNew();){
                TmcBotpHelper.saveSysRelation(rows);
            }
        }
    }

    public static void deleteRation(String destEntityKey, Long FSBillId, Long[] FTBILLIDs) {
        for (Long FTBILLID : FTBILLIDs) {
            TmcBotpHelper.deleteRation(destEntityKey, FSBillId, FTBILLID);
        }
    }

    public static void deleteRation(String destEntityKey, Long FSBillId, Long FTBILLID) {
        String sSQL = "select ftableid from t_meta_entityinfo where fentitykey = ?";
        DataSet ds = DB.queryDataSet((String)"loanEntity", (DBRoute)DBRoute.meta, (String)sSQL, (Object[])new Object[]{destEntityKey});
        Long FTTableId = 0L;
        if (ds.hasNext()) {
            Row row = ds.next();
            FTTableId = row.getLong("ftableid");
        }
        TmcBotpHelper.deleteLkRation(destEntityKey, FTTableId, FSBillId, FTBILLID);
        try (TXHandle tx = TX.requiresNew();){
            String sBuilder = "delete from T_BOTP_BillTracker where FSBillId= ? and FTBillId= ? and FTTableId = ?";
            DB.execute((DBRoute)DBRoute.basedata, (String)sBuilder, (Object[])new Object[]{FSBillId, FTBILLID, FTTableId});
        }
    }

    private static void deleteLkRation(String dEntityKey, Long FTTableId, Long FSBillId, Long FTBILLID) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)dEntityKey);
        DBRoute dbRoute = DBRouteConst.TMC;
        if (EmptyUtil.isNoEmpty(entityType.getDBRouteKey())) {
            dbRoute = new DBRoute(entityType.getDBRouteKey());
        }
        LinkSetElement linkSet = EntityMetadataCache.getLinkSet((String)dEntityKey);
        String tc = linkSet.getTrackerTable();
        String lk = null;
        List items = linkSet.getItems();
        if (items != null && items.size() > 0) {
            lk = ((LinkSetItemElement)items.get(0)).getTableName();
        }
        ArrayList<SqlParameter> params_tc = new ArrayList<SqlParameter>();
        String sBuilder_tc = "delete from  " + tc + " where FSBillId= ? and FTId= ? and FTTableId =?";
        params_tc.add(new SqlParameter(":FSBillId", -5, (Object)FSBillId));
        params_tc.add(new SqlParameter(":FTId", -5, (Object)FTBILLID));
        params_tc.add(new SqlParameter(":FTTableId", -5, (Object)FTTableId));
        DB.execute((DBRoute)dbRoute, (String)sBuilder_tc, (Object[])params_tc.toArray(new SqlParameter[params_tc.size()]));
        ArrayList<SqlParameter> params_lk = new ArrayList<SqlParameter>();
        String sBuilder_lk = "delete from  " + lk + " where FSBillId= ? and FId= ?";
        params_lk.add(new SqlParameter(":FSBillId", -5, (Object)FSBillId));
        params_lk.add(new SqlParameter(":FId", -5, (Object)FTBILLID));
        DB.execute((DBRoute)dbRoute, (String)sBuilder_lk, (Object[])params_lk.toArray(new SqlParameter[params_lk.size()]));
    }

    private static void saveSysRelation(List<kd.tmc.fbp.common.model.BFRow> rows) {
        ArrayList<SqlParameter[]> batchParameters = new ArrayList<SqlParameter[]>(rows.size());
        ArrayList<SqlParameter[]> batchDelParams = new ArrayList<SqlParameter[]>(rows.size());
        ArrayList<SqlParameter> delParams = new ArrayList<SqlParameter>(4);
        for (kd.tmc.fbp.common.model.BFRow row : rows) {
            ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
            params.add(new SqlParameter(":FID", -5, (Object)row.getId()));
            params.add(new SqlParameter(":FSTABLEID", -5, (Object)row.getsTableId()));
            params.add(new SqlParameter(":FSBILLID", -5, (Object)row.getsBillid()));
            params.add(new SqlParameter(":FTTABLEID", -5, (Object)row.gettTableId()));
            params.add(new SqlParameter(":FTBILLID", -5, (Object)row.getTbillId()));
            params.add(new SqlParameter(":FCREATETIME", 91, (Object)new Date()));
            batchParameters.add(params.toArray(new SqlParameter[params.size()]));
            delParams.clear();
            delParams.add(new SqlParameter(":FTBILLID", -5, (Object)row.getTbillId()));
            delParams.add(new SqlParameter(":FTTABLEID", -5, (Object)row.gettTableId()));
            delParams.add(new SqlParameter(":FSBILLID", -5, (Object)row.getsBillid()));
            delParams.add(new SqlParameter(":FSTABLEID", -5, (Object)row.getsTableId()));
            batchDelParams.add(delParams.toArray(new SqlParameter[delParams.size()]));
        }
        String deleteSql = "DELETE FROM T_BOTP_BillTracker  WHERE   FTBILLID=? and FTTABLEID= ? and FSBillId= ? and FSTableId= ?";
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)deleteSql, batchDelParams);
        String sBuilder = "INSERT INTO T_BOTP_BillTracker (FID, FSTABLEID, FSBILLID, FTTABLEID, FTBILLID, FCREATETIME) VALUES (?, ?, ?, ?, ?, ?)";
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)sBuilder, batchParameters);
    }

    private static void saveBizRelation(List<kd.tmc.fbp.common.model.BFRow> rows, String tc, String lk, DBRoute dbRoute) {
        ArrayList<SqlParameter[]> tcBatchParameters = new ArrayList<SqlParameter[]>(1024);
        ArrayList<SqlParameter[]> lkBatchParameters = new ArrayList<SqlParameter[]>(1024);
        ArrayList<SqlParameter[]> deleteBatchParameters = new ArrayList<SqlParameter[]>(1024);
        ArrayList<SqlParameter> delParams_lk = new ArrayList<SqlParameter>(10);
        ArrayList<SqlParameter[]> tcDeleteBatchParam = new ArrayList<SqlParameter[]>(1024);
        ArrayList<SqlParameter> delParams_tc = new ArrayList<SqlParameter>(10);
        for (kd.tmc.fbp.common.model.BFRow row : rows) {
            delParams_lk.clear();
            delParams_tc.clear();
            Long id_tc = DBServiceHelper.genGlobalLongId();
            Long FTBillId = row.getTbillId();
            Long FTTableId = row.gettTableId();
            Long FTId = row.getTbillId();
            Long FSBillId = row.getsBillid();
            Long FSTableId = row.getsTableId();
            Long FSId = row.getsBillid();
            ArrayList<SqlParameter> params_tc = new ArrayList<SqlParameter>();
            params_tc.add(new SqlParameter(":FID", -5, (Object)id_tc));
            params_tc.add(new SqlParameter(":FTBillId", -5, (Object)FTBillId));
            params_tc.add(new SqlParameter(":FTTableId", -5, (Object)FTTableId));
            params_tc.add(new SqlParameter(":FTId", -5, (Object)FTId));
            params_tc.add(new SqlParameter(":FSBillId", -5, (Object)FSBillId));
            params_tc.add(new SqlParameter(":FSTableId", -5, (Object)FSTableId));
            params_tc.add(new SqlParameter(":FSId", -5, (Object)FSId));
            tcBatchParameters.add(params_tc.toArray(new SqlParameter[params_tc.size()]));
            delParams_tc.add(new SqlParameter(":FTBillId", -5, (Object)FTBillId));
            delParams_tc.add(new SqlParameter(":FTTableId", -5, (Object)FTTableId));
            delParams_tc.add(new SqlParameter(":FTId", -5, (Object)FTId));
            delParams_tc.add(new SqlParameter(":FSBillId", -5, (Object)FSBillId));
            delParams_tc.add(new SqlParameter(":FSTableId", -5, (Object)FSTableId));
            delParams_tc.add(new SqlParameter(":FSId", -5, (Object)FSId));
            tcDeleteBatchParam.add(delParams_tc.toArray(new SqlParameter[delParams_tc.size()]));
            Long id_lk = DBServiceHelper.genGlobalLongId();
            ArrayList<SqlParameter> params_lk = new ArrayList<SqlParameter>();
            params_lk.add(new SqlParameter(":FId", -5, (Object)FTId));
            params_lk.add(new SqlParameter(":FPKId", -5, (Object)id_lk));
            params_lk.add(new SqlParameter(":FSeq", 4, (Object)1));
            params_lk.add(new SqlParameter(":FSTableId", -5, (Object)FSTableId));
            params_lk.add(new SqlParameter(":FSBillId", -5, (Object)FSBillId));
            params_lk.add(new SqlParameter(":FSId", -5, (Object)FSBillId));
            lkBatchParameters.add(params_lk.toArray(new SqlParameter[params_lk.size()]));
            delParams_lk.add(new SqlParameter(":FId", -5, (Object)FTId));
            delParams_lk.add(new SqlParameter(":FSTableId", -5, (Object)FSTableId));
            delParams_lk.add(new SqlParameter(":FSBillId", -5, (Object)FSBillId));
            delParams_lk.add(new SqlParameter(":FSId", -5, (Object)FSBillId));
            deleteBatchParameters.add(delParams_lk.toArray(new SqlParameter[0]));
        }
        String delete_tc = "delete from  " + tc + " where  FTBillId= ? and FTTableId= ? and FTId=? and FSBillId= ? and FSTableId=? and FSId= ?";
        DB.executeBatch((DBRoute)dbRoute, (String)delete_tc, tcDeleteBatchParam);
        String sBuilder_tc = "INSERT INTO " + tc + " (FID, FTBillId, FTTableId,FTId,FSBillId,FSTableId,FSId) VALUES (?, ?,?,?, ?,?,?)";
        DB.executeBatch((DBRoute)dbRoute, (String)sBuilder_tc, tcBatchParameters);
        String delete_lk = "delete from  " + lk + " where  FId= ? and FSTableId= ? and FSBillId= ? and FSId= ?";
        DB.executeBatch((DBRoute)dbRoute, (String)delete_lk, deleteBatchParameters);
        String sBuilder_lk = "INSERT INTO " + lk + " (FId, FPKId, FSeq,FSTableId,FSBillId,FSId) VALUES (?, ?,?,?, ?,?)";
        DB.executeBatch((DBRoute)dbRoute, (String)sBuilder_lk, lkBatchParameters);
    }

    public static Long getTableIdByEntityKey(final String entityName) {
        Object[] parameters = new SqlParameter[1];
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("SELECT FId, FEntityKey, FTableId ");
        sBuilder.append("FROM T_META_EntityInfo ");
        sBuilder.append("WHERE FEntityKey = ? ");
        parameters[0] = new SqlParameter(":FEntityKey", 12, (Object)entityName);
        ResultSetHandler<TableDefine> action = new ResultSetHandler<TableDefine>(){

            public TableDefine handle(ResultSet rs) throws Exception {
                TableDefine tableDefine = null;
                if (rs.next()) {
                    tableDefine = new TableDefine();
                    tableDefine.setEntityNumber(rs.getString("FId"));
                    tableDefine.setEntityKey(entityName);
                    tableDefine.setTableId(Long.valueOf(rs.getLong("FTableId")));
                }
                return tableDefine;
            }
        };
        TableDefine tableDefine = (TableDefine)DB.query((DBRoute)DBRouteConst.META, (String)sBuilder.toString(), (Object[])parameters, (ResultSetHandler)action);
        return tableDefine.getTableId();
    }

    public static void showDirtBillParamter(String entitynumber, Long primaryKeyValue, IFormView iFormView, String targetBill) {
        Long targetTableId = TmcBotpHelper.getTableIdByEntityKey(targetBill);
        Map botpMap = BFTrackerServiceHelper.findDirtTargetBills((String)entitynumber, (Long[])new Long[]{primaryKeyValue});
        Long targetBillId = 0L;
        if (botpMap != null && !CollectionUtils.isEmpty((Map)botpMap)) {
            List bfRows = (List)botpMap.get(primaryKeyValue);
            for (BFRow bfRow : bfRows) {
                BFRowId tRow = bfRow.getId();
                if (!tRow.getMainTableId().equals(targetTableId)) continue;
                targetBillId = tRow.getBillId();
                break;
            }
        }
        if (targetBillId == 0L) {
            iFormView.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e", (String)"CfmBotpHelper_0", (String)"tmc-cfm-common", (Object[])new Object[0]));
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(targetBill);
        showParameter.setPkId((Object)targetBillId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.EDIT);
        iFormView.showForm((FormShowParameter)showParameter);
    }

    public static Set<String> getTargetBillEntityType(String entityName, Long srcId) {
        HashSet<String> entitys = new HashSet<String>(512);
        Map botpMap = BFTrackerServiceHelper.findTargetBills((String)entityName, (Long[])new Long[]{srcId});
        logger.info(JSON.toJSONString((Object)botpMap));
        Iterator it = botpMap.keySet().iterator();
        while (it.hasNext()) {
            entitys.add((String)it.next());
        }
        return entitys;
    }

    public static boolean isExistTargetBills(String currEntity, Long currEntityId, String[] sourceEntities) {
        Map botpMap = BFTrackerServiceHelper.findTargetBills((String)currEntity, (Long[])new Long[]{currEntityId});
        for (String sourceEntity : sourceEntities) {
            if (!EmptyUtil.isNoEmpty(botpMap.get(sourceEntity))) continue;
            return true;
        }
        return false;
    }

    public static DynamicObjectCollection queryTargetBills(String currEntity, Object currEntityId, String targetEntity, String properties) {
        Map botpMap = BFTrackerServiceHelper.findTargetBills((String)currEntity, (Long[])new Long[]{(Long)currEntityId});
        logger.info(JSON.toJSONString((Object)botpMap));
        Set sourceIds = (Set)botpMap.get(targetEntity);
        if (sourceIds == null) {
            return null;
        }
        return QueryServiceHelper.query((String)targetEntity, (String)properties, (QFilter[])new QFilter("id", "in", (Object)sourceIds).toArray());
    }

    public static DynamicObject[] getTargetBills(String currEntity, Object currEntityId, String targetEntity, QFilter filter) {
        Map botpMap = BFTrackerServiceHelper.findTargetBills((String)currEntity, (Long[])new Long[]{(Long)currEntityId});
        logger.info(JSON.toJSONString((Object)botpMap));
        return TmcBotpHelper.getBillFromBotpMap(targetEntity, botpMap, filter);
    }

    public static DynamicObject[] getSourceBills(String currEntity, Object currEntityId, String sourceEntity, QFilter filter) {
        Map botpMap = BFTrackerServiceHelper.findSourceBills((String)currEntity, (Long[])new Long[]{(Long)currEntityId});
        logger.info(JSON.toJSONString((Object)botpMap));
        return TmcBotpHelper.getBillFromBotpMap(sourceEntity, botpMap, filter);
    }

    private static DynamicObject[] getBillFromBotpMap(String entityName, Map<String, HashSet<Long>> map, QFilter filter) {
        HashSet<Long> sourceIds = map.get(entityName);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        if (sourceIds == null) {
            return null;
        }
        if (filter != null) {
            filter.and(new QFilter("id", "in", sourceIds));
            Map bills = TmcDataServiceHelper.loadFromCache((DynamicObjectType)type, (QFilter[])filter.toArray());
            DynamicObject[] valueArray = new DynamicObject[bills.size()];
            return bills.values().toArray(valueArray);
        }
        return TmcDataServiceHelper.load((Object[])sourceIds.toArray(), (DynamicObjectType)type);
    }

    public static String getSourceBillEntityType(String entityName, Long destId) {
        Map botpMap = BFTrackerServiceHelper.findSourceBills((String)entityName, (Long[])new Long[]{destId});
        logger.info(JSON.toJSONString((Object)botpMap));
        Iterator it = botpMap.keySet().iterator();
        if (it.hasNext()) {
            return (String)it.next();
        }
        return null;
    }

    public static boolean isExistsBotp(String sourceEntityKey, Long sourceBillId, String targetEntityKey, Long targetBillId) {
        Object[] targetBillIds = TmcBotpHelper.getTargetBillIds(sourceEntityKey, sourceBillId, targetEntityKey);
        return EmptyUtil.isNoEmpty(targetBillIds) && Arrays.asList(targetBillIds).contains(targetBillId);
    }

    public static Map<Long, Map<String, Set<Long>>> getDirtTargetBillIdMap(String sourceEntity, List<Long> billIds, Set<String> excludeTargetEntitys, Set<String> includeTargetEntitys) {
        return TmcBotpHelper.getTargetBillIdMap(sourceEntity, billIds, excludeTargetEntitys, includeTargetEntitys, Boolean.TRUE);
    }

    public static Map<Long, Map<String, Set<Long>>> getTargetBillIdMap(String sourceEntity, List<Long> billIds, Set<String> excludeTargetEntitys, Set<String> includeTargetEntitys) {
        return TmcBotpHelper.getTargetBillIdMap(sourceEntity, billIds, excludeTargetEntitys, includeTargetEntitys, Boolean.FALSE);
    }

    private static Map<Long, Map<String, Set<Long>>> getTargetBillIdMap(String sourceEntity, List<Long> billIds, Set<String> excludeTargetEntitys, Set<String> includeTargetEntitys, boolean onlyDirtTarget) {
        HashMap<Long, Map<String, Set<Long>>> map = new HashMap<Long, Map<String, Set<Long>>>(billIds.size());
        Map targetBillMap = BFTrackerServiceHelper.loadBillLinkDownNodes((String)sourceEntity, (Long[])billIds.toArray(new Long[0]), (boolean)onlyDirtTarget);
        for (Map.Entry entry : targetBillMap.entrySet()) {
            Long billId = (Long)entry.getKey();
            HashMap<String, Set> targetIdMap = new HashMap<String, Set>(10);
            BFRowLinkDownNode linkDownNode = (BFRowLinkDownNode)entry.getValue();
            List childNodes = linkDownNode.findAllChildNodes();
            for (BFRowLinkDownNode childNode : childNodes) {
                BFRowId rowId = childNode.getRowId();
                String entityNumber = EntityMetadataCache.loadTableDefine((Long)rowId.getMainTableId()).getEntityNumber();
                if (EmptyUtil.isNoEmpty(excludeTargetEntitys) && excludeTargetEntitys.contains(entityNumber) || EmptyUtil.isNoEmpty(includeTargetEntitys) && !includeTargetEntitys.contains(entityNumber)) continue;
                Set idSet = targetIdMap.computeIfAbsent(entityNumber, o -> new HashSet(2));
                idSet.add(rowId.getBillId());
            }
            map.put(billId, targetIdMap);
        }
        billIds.forEach(d -> map.putIfAbsent((Long)d, Collections.emptyMap()));
        return map;
    }

    public static Map<Long, Map<String, List<String>>> getTargetBillNoMap(String sourceEntity, List<Long> billIds, Set<String> excludeTargetEntitys, Set<String> includeTargetEntitys, Map<String, QFilter> filterMap) {
        Map<Long, Map<String, Set<Long>>> targetBillIdMap = TmcBotpHelper.getTargetBillIdMap(sourceEntity, billIds, excludeTargetEntitys, includeTargetEntitys);
        return TmcBotpHelper.getBillNoMap(targetBillIdMap, filterMap);
    }

    public static Map<Long, String> getTargetBillMsgMap(String sourceEntity, List<Long> billIds, Set<String> excludeTargetEntitys, Set<String> includeTargetEntitys, Map<String, QFilter> filterMap) {
        return TmcBotpHelper.getTargetBillMsgMap(TmcBotpHelper.getTargetBillNoMap(sourceEntity, billIds, excludeTargetEntitys, includeTargetEntitys, filterMap));
    }

    public static Map<Long, String> getTargetBillMsgMap(Map<Long, Map<String, List<String>>> targetBillNoMap) {
        if (targetBillNoMap == null || targetBillNoMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, String> targetBillMsgMap = new HashMap<Long, String>(10);
        Map<Long, String> linkBillNos = TmcBotpHelper.getLinkEntityBillNos(targetBillNoMap);
        for (Map.Entry<Long, String> entry : linkBillNos.entrySet()) {
            String msg = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u4e0b\u6e38\u5355\u636e\uff1a%s\u3002", (String)"TmcBotpHelper_3", (String)"tmc-fbp-common", (Object[])new Object[0]), entry.getValue());
            targetBillMsgMap.put(entry.getKey(), msg);
        }
        return targetBillMsgMap;
    }

    public static Map<Long, Map<String, List<String>>> getDirtTargetBillNoMap(String sourceEntity, List<Long> billIds, Set<String> excludeTargetEntitys, Set<String> includeTargetEntitys, Map<String, QFilter> filterMap) {
        Map<Long, Map<String, Set<Long>>> targetBillIdMap = TmcBotpHelper.getDirtTargetBillIdMap(sourceEntity, billIds, excludeTargetEntitys, includeTargetEntitys);
        return TmcBotpHelper.getBillNoMap(targetBillIdMap, filterMap);
    }

    private static Map<Long, Map<String, List<String>>> getBillNoMap(Map<Long, Map<String, Set<Long>>> targetBillIdMap, Map<String, QFilter> filterMap) {
        HashMap<Long, Map<String, List<String>>> result = new HashMap<Long, Map<String, List<String>>>();
        HashMap<String, Map> targetEntityIdMap = new HashMap<String, Map>();
        for (Map.Entry<Long, Map<String, Set<Long>>> targetEntry : targetBillIdMap.entrySet()) {
            Long l = targetEntry.getKey();
            for (Map.Entry<String, Set<Long>> targetIdEntry : targetEntry.getValue().entrySet()) {
                String entityNumber = targetIdEntry.getKey();
                Map setMap = targetEntityIdMap.computeIfAbsent(entityNumber, d -> new HashMap(10));
                for (Long id : targetIdEntry.getValue()) {
                    Set billIdSet = setMap.computeIfAbsent(id, d -> new HashSet(10));
                    billIdSet.add(l);
                }
            }
        }
        HashMap<String, Set> targetEntityMap = new HashMap<String, Set>(10);
        for (Map<String, Set<Long>> map : targetBillIdMap.values()) {
            for (Map.Entry<String, Set<Long>> entry : map.entrySet()) {
                Set idSets = targetEntityMap.computeIfAbsent(entry.getKey(), d -> new HashSet(10));
                idSets.addAll((Collection)entry.getValue());
            }
        }
        for (Map.Entry entry : targetEntityMap.entrySet()) {
            Map sourceBillIdMap;
            DynamicObjectCollection targetBills;
            String entityNumber = (String)entry.getKey();
            Set targetBillIdSet = (Set)entry.getValue();
            QFilter filter = null == filterMap ? null : filterMap.get(entityNumber);
            QFilter qFilters = new QFilter("id", "in", (Object)targetBillIdSet);
            if (EmptyUtil.isNoEmpty(filter)) {
                qFilters.and(filter);
            }
            if ((targetBills = QueryServiceHelper.query((String)entityNumber, (String)"id,billno", (QFilter[])qFilters.toArray())).isEmpty() || EmptyUtil.isEmpty(sourceBillIdMap = (Map)targetEntityIdMap.get(entityNumber))) continue;
            for (DynamicObject targetBill : targetBills) {
                long targetBillId = targetBill.getLong("id");
                String billno = targetBill.getString("billno");
                Set sourceBillIdSet = (Set)sourceBillIdMap.get(targetBillId);
                for (Long sourceBillId : sourceBillIdSet) {
                    Map listMap = result.computeIfAbsent(sourceBillId, d -> new HashMap(10));
                    List billNos = listMap.computeIfAbsent(entityNumber, d -> new ArrayList(4));
                    billNos.add(billno);
                }
            }
        }
        return result;
    }

    public static Map<Long, Map<String, Set<Long>>> getSourceBillIdMap(String targetEntity, List<Long> billIds, Set<String> excludeSourceEntitys, Set<String> includeSourceEntitys, boolean onlyDirtSource) {
        HashMap<Long, Map<String, Set<Long>>> map = new HashMap<Long, Map<String, Set<Long>>>(billIds.size());
        Map sourceBillMap = BFTrackerServiceHelper.loadBillLinkUpNodes((String)targetEntity, (Long[])billIds.toArray(new Long[0]), (boolean)onlyDirtSource);
        for (Map.Entry entry : sourceBillMap.entrySet()) {
            Long billId = (Long)entry.getKey();
            HashMap<String, Set> sourceIdMap = new HashMap<String, Set>(10);
            BFRowLinkUpNode linkDownNode = (BFRowLinkUpNode)entry.getValue();
            List childNodes = linkDownNode.findAllSourceNodes();
            for (BFRowLinkUpNode childNode : childNodes) {
                BFRowId rowId = childNode.getRowId();
                String entityNumber = EntityMetadataCache.loadTableDefine((Long)rowId.getMainTableId()).getEntityNumber();
                if (EmptyUtil.isNoEmpty(excludeSourceEntitys) && excludeSourceEntitys.contains(entityNumber) || EmptyUtil.isNoEmpty(includeSourceEntitys) && !includeSourceEntitys.contains(entityNumber)) continue;
                Set idSet = sourceIdMap.computeIfAbsent(entityNumber, o -> new HashSet(2));
                idSet.add(rowId.getBillId());
            }
            map.put(billId, sourceIdMap);
        }
        billIds.forEach(d -> map.putIfAbsent((Long)d, Collections.emptyMap()));
        return map;
    }

    public static Map<Long, Map<String, Set<Long>>> getDirtSourceBillIdMap(String targetEntity, List<Long> billIds, Set<String> excludeSourceEntitys, Set<String> includeSourceEntitys) {
        return TmcBotpHelper.getSourceBillIdMap(targetEntity, billIds, excludeSourceEntitys, includeSourceEntitys, Boolean.TRUE);
    }

    public static Map<Long, Map<String, Set<Long>>> getSourceBillIdMap(String targetEntity, List<Long> billIds, Set<String> excludeSourceEntitys, Set<String> includeSourceEntitys) {
        return TmcBotpHelper.getSourceBillIdMap(targetEntity, billIds, excludeSourceEntitys, includeSourceEntitys, Boolean.FALSE);
    }

    public static Map<Long, Map<String, List<String>>> getSourceBillNoMap(String targetEntity, List<Long> billIds, Set<String> excludeSourceEntitys, Set<String> includeSourceEntitys, Map<String, QFilter> filterMap) {
        Map<Long, Map<String, Set<Long>>> sourceBillIdMap = TmcBotpHelper.getSourceBillIdMap(targetEntity, billIds, excludeSourceEntitys, includeSourceEntitys);
        return TmcBotpHelper.getBillNoMap(sourceBillIdMap, filterMap);
    }

    public static Map<Long, String> getLinkEntityBillNos(Map<Long, Map<String, List<String>>> billNoMap) {
        if (billNoMap == null || billNoMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, String> msgMap = new HashMap<Long, String>(billNoMap.size());
        for (Map.Entry<Long, Map<String, List<String>>> entry : billNoMap.entrySet()) {
            StringJoiner msgBuilder = new StringJoiner("; ");
            for (Map.Entry<String, List<String>> entityEntry : entry.getValue().entrySet()) {
                String entityName = EntityMetadataCache.getDataEntityType((String)entityEntry.getKey()).getDisplayName().getLocaleValue();
                msgBuilder.add(String.format("%1$s[%2$s]", entityName, String.join((CharSequence)",", (Iterable<? extends CharSequence>)entityEntry.getValue())));
            }
            msgMap.put(entry.getKey(), msgBuilder.toString());
        }
        return msgMap;
    }

    public static void addLinkEntity(DynamicObject targetBillObj, String targetEntryKey, String srcBillTypeFld, DynamicObject sourceBillObj, String srcEntryIdFld) {
        TableDefine targetTableDefine = EntityMetadataCache.loadTableDefine((String)targetBillObj.getDataEntityType().getName(), (String)targetEntryKey);
        String srcBillType = targetBillObj.getString(srcBillTypeFld);
        TableDefine srcTableDefine = EntityMetadataCache.loadMainTableDefine((String)srcBillType);
        TmcBotpHelper.createLinkEntity(targetTableDefine, targetBillObj, srcTableDefine, sourceBillObj, srcEntryIdFld);
    }

    private static void createLinkEntity(TableDefine targetTableDefine, DynamicObject targetBillObj, TableDefine srcTableDefine, DynamicObject sourceBillObj, String srcEntryIdFld) {
        HashSet<String> srcRowIds = new HashSet<String>();
        srcRowIds.add(sourceBillObj.getString("id"));
        Long srcTableId = srcTableDefine.getTableId();
        Long srcId = sourceBillObj.getLong("id");
        String lkEntryKey = targetTableDefine.getEntityKey() + "_lk";
        DynamicObjectCollection targetRows = targetBillObj.getDynamicObjectCollection(targetTableDefine.getEntityKey());
        for (DynamicObject targetRow : targetRows) {
            String srcRowId;
            DynamicObjectCollection linkRows = targetRow.getDynamicObjectCollection(lkEntryKey);
            if (!linkRows.isEmpty() || EmptyUtil.isEmpty(linkRows.getDynamicObjectType()) || !srcRowIds.contains(srcRowId = targetRow.getString(srcEntryIdFld))) continue;
            DynamicObject linkRow = new DynamicObject(linkRows.getDynamicObjectType());
            linkRows.add((Object)linkRow);
            linkRow.set(lkEntryKey + "_stableid", (Object)srcTableId);
            linkRow.set(lkEntryKey + "_sbillid", (Object)srcId);
            linkRow.set(lkEntryKey + "_sid", (Object)srcRowId);
        }
    }
}

