/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

@KSObject
public class TmcDataServiceHelper
extends BusinessDataServiceHelper {
    private static final Log logger = LogFactory.getLog(TmcDataServiceHelper.class);

    public static boolean exists(Object pk, String entityName) {
        return QueryServiceHelper.exists((String)entityName, (QFilter[])new QFilter("id", "=", pk).toArray());
    }

    public static int count(String entityName, QFilter[] filters) {
        return ORM.create().count(entityName, entityName, filters);
    }

    public static boolean exists(String entityName, QFilter[] filters) {
        return QueryServiceHelper.exists((String)entityName, (QFilter[])filters);
    }

    @KSMethod
    public static int[] executeBatch(DBRoute dbRoute, String sSQL, List<Object[]> param) {
        logger.info("sSQL = [" + sSQL + "], param = [" + JSON.toJSONString(param) + "]");
        return DB.executeBatch((DBRoute)dbRoute, (String)sSQL, param);
    }

    public static boolean isFromDatabase(DynamicObject dataEntity) {
        return dataEntity.getDataEntityState().getFromDatabase();
    }

    public static boolean isFromDatabase(ExtendedDataEntity dataEntity) {
        return dataEntity.getDataEntity().getDataEntityState().getFromDatabase();
    }

    @KSMethod
    public static boolean execute(DBRoute dbRoute, String sSQL, Object[] param) {
        logger.info("sSQL = [" + sSQL + "], param = [" + JSON.toJSONString((Object)param) + "]");
        return DB.execute((DBRoute)dbRoute, (String)sSQL, (Object[])param);
    }

    @KSMethod
    public static DynamicObject clone(DynamicObject info) {
        return (DynamicObject)OrmUtils.clone((Object)info, (IDataEntityType)info.getDataEntityType(), (boolean)true, (boolean)true);
    }

    @KSMethod
    public static Object[] save(DynamicObject[] data) {
        return SaveServiceHelper.save((DynamicObject[])data);
    }

    public static DynamicObjectCollection generateMultiPropValue(DynamicObject entity, String propName, DynamicObject ... objs) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity.getDataEntityType().getName());
        return TmcDataServiceHelper.generateMultiPropValue(entity, (DynamicObjectType)entityType, propName, objs);
    }

    public static DynamicObjectCollection generateMultiPropValue(DynamicObject entity, DynamicObjectType entityType, String propName, DynamicObject ... objs) {
        DynamicCollectionProperty currencyProp = (DynamicCollectionProperty)entityType.getProperty(propName);
        if (currencyProp == null) {
            logger.error(entity.getDataEntityType().getExtendName() + " entity property [" + propName + "] does not exist.");
            return null;
        }
        DynamicObjectCollection collection = new DynamicObjectCollection(currencyProp.getDynamicCollectionItemPropertyType(), (Object)entity);
        for (DynamicObject obj : objs) {
            DynamicObject newObj = new DynamicObject(currencyProp.getDynamicCollectionItemPropertyType());
            newObj.set("fbasedataid", (Object)obj);
            newObj.set("fbasedataid_id", obj.getPkValue());
            collection.add((Object)newObj);
        }
        return collection;
    }

    public static Map<Long, DynamicObject> loadDataAndMapById(String entityName, Collection<Long> idList) {
        if (EmptyUtil.isEmpty(idList)) {
            return new HashMap<Long, DynamicObject>(10);
        }
        DynamicObject[] dataArr = BusinessDataServiceHelper.load((Object[])idList.stream().filter(Objects::nonNull).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
        HashMap<Long, DynamicObject> dataMap = new HashMap<Long, DynamicObject>(dataArr.length);
        for (DynamicObject data : dataArr) {
            dataMap.put((Long)data.getPkValue(), data);
        }
        return dataMap;
    }

    public static Map<Long, DynamicObject> loadDataAndMapById(String entityName, String selectProps, Collection<Long> idList) {
        if (EmptyUtil.isEmpty(idList)) {
            return new HashMap<Long, DynamicObject>(10);
        }
        DynamicObject[] dataArr = BusinessDataServiceHelper.load((String)entityName, (String)selectProps, (QFilter[])new QFilter("id", "in", idList).toArray());
        HashMap<Long, DynamicObject> dataMap = new HashMap<Long, DynamicObject>(dataArr.length);
        for (DynamicObject data : dataArr) {
            dataMap.put((Long)data.getPkValue(), data);
        }
        return dataMap;
    }

    public static DynamicObject[] loadByFilter(String entityName, QFilter[] filters) {
        if (EmptyUtil.isEmpty(filters)) {
            return new DynamicObject[0];
        }
        List idList = QueryServiceHelper.queryPrimaryKeys((String)entityName, (QFilter[])filters, null, (int)-1);
        return EmptyUtil.isNoEmpty(idList) ? TmcDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName)) : new DynamicObject[]{};
    }

    public static DynamicObject[] loadByFilter(String entityName, String selectProps, QFilter[] filters) {
        if (EmptyUtil.isEmpty(filters)) {
            return new DynamicObject[0];
        }
        return TmcDataServiceHelper.load((String)entityName, (String)selectProps, (QFilter[])filters);
    }

    public static DynamicObject newDynamicObject(String entityName, Object id) {
        DynamicObject entity = TmcDataServiceHelper.newDynamicObject((String)entityName);
        entity.set("id", id);
        return entity;
    }
}

