/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.plugin.print.ComplexSettingItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.PrintServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class TmcPrintServiceHelper {
    public static String printPreview(String pageId, String formId, String templateFormId, Long[] pks) {
        return PrintServiceHelper.createPdfUrl((String)pageId, (String)formId, (String)templateFormId, (Object[])pks);
    }

    public static Map<String, List<Long>> getTemplateForm(String pageId, String formId, String printerId, Long[] pks) {
        Map<String, QFilter> printConfig = TmcPrintServiceHelper.loadPrintSetting(formId, formId + "_printsetting");
        return TmcPrintServiceHelper.getTemplateForm(formId, pks, printConfig);
    }

    private static Map<String, List<Long>> getTemplateForm(String formId, Long[] pks, Map<String, QFilter> printConfig) {
        HashMap<String, List<Long>> templateMap = new HashMap<String, List<Long>>();
        String entityTypeId = FormMetadataCache.getFormConfig((String)formId).getEntityTypeId();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityTypeId);
        for (Map.Entry<String, QFilter> entry : printConfig.entrySet()) {
            QFilter[] filters = new QFilter[]{entry.getValue(), new QFilter("id", "in", (Object)pks)};
            DynamicObject[] bills = TmcDataServiceHelper.load((String)dt.getName(), (String)"id", (QFilter[])filters);
            if (bills.length <= 0) continue;
            templateMap.put(TmcPrintServiceHelper.getTemplateFromNumber(entry.getKey()), TmcBusinessBaseHelper.objectsToIdList(bills));
        }
        return templateMap;
    }

    private static String getTemplateFromNumber(String id) {
        DynamicObject templateFrom = TmcDataServiceHelper.loadSingleFromCache((Object)id, (String)"bos_printtemplate");
        return templateFrom.getString("number");
    }

    private static Map<String, QFilter> loadPrintSetting(String formId, String configKey) {
        Map printSetting = new HashMap();
        String userId = RequestContext.get().getUserId();
        String settingData = UserConfigServiceHelper.getSetting((long)Long.parseLong(userId), (String)configKey);
        if (StringUtils.isNotBlank((CharSequence)settingData)) {
            printSetting = (Map)SerializationUtils.fromJsonString((String)settingData, Map.class);
        }
        String entityTypeId = FormMetadataCache.getFormConfig((String)formId).getEntityTypeId();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityTypeId);
        String complexsetting = SerializationUtils.toJsonString(printSetting.get("complexsetting"));
        if (complexsetting.equals("null")) {
            HashMap<String, QFilter> printConfig = new HashMap<String, QFilter>(1);
            printConfig.put((String)printSetting.get("templateid"), null);
            return printConfig;
        }
        List complexList = (List)JSON.parseObject((String)complexsetting, (TypeReference)new TypeReference<List<ComplexSettingItem>>(){}, (Feature[])new Feature[0]);
        HashMap<String, QFilter> printConfig = new HashMap<String, QFilter>(complexList.size());
        for (ComplexSettingItem item : complexList) {
            FilterCondition filterCondition = null;
            filterCondition = item.getFiltercondition() instanceof String ? (FilterCondition)SerializationUtils.fromJsonString((String)item.getFiltercondition().toString(), FilterCondition.class) : (FilterCondition)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)item.getFiltercondition()), FilterCondition.class);
            FilterBuilder filterBuilder = new FilterBuilder(dt, filterCondition, true);
            filterBuilder.buildFilter(true);
            printConfig.put(item.getFiltertemplateid(), filterBuilder.getQFilter());
        }
        return printConfig;
    }
}

