/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.FieldTip;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.param.ParamMap;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TmcViewInputHelper {
    public static void addF7Filter(IFormView view, String prop, F7FilterBuilder builder) {
        BasedataEdit f7 = (BasedataEdit)view.getControl(prop);
        f7.addBeforeF7SelectListener(e -> {
            ListShowParameter sp = (ListShowParameter)e.getFormShowParameter();
            QFilter qFilter = builder.build(e);
            sp.getListFilterParameter().setFilter(qFilter);
        });
    }

    public static void registerMustInput(IFormView view, IDataModel model, String[] propNameArr, String billStatusName, String ... statusArr) {
        for (String propName : propNameArr) {
            TmcViewInputHelper.registerMustInput(view, model, propName, billStatusName, statusArr);
        }
    }

    public static void registerMustInput(IFormView view, IDataModel model, String propName, String billStatusName, String ... statusArr) {
        FieldEdit fieldEdit = (FieldEdit)view.getControl(propName);
        boolean statusMatch = TmcViewInputHelper.isStatusMatch(model, billStatusName, statusArr);
        fieldEdit.setMustInput(statusMatch);
    }

    public static void registerMustInput(IFormView view, String[] propNameArr) {
        TmcViewInputHelper.registerMustInput(view, true, propNameArr);
    }

    public static void registerMustInput(IFormView view, boolean isMustInput, String ... propNameArr) {
        for (String propName : propNameArr) {
            FieldEdit fieldEdit = (FieldEdit)view.getControl(propName);
            fieldEdit.setMustInput(isMustInput);
        }
    }

    public static void registerShowingStatus(IFormView view, IDataModel model, String[] propNameArr, String billStatusName, String ... statusArr) {
        for (String propName : propNameArr) {
            TmcViewInputHelper.registerShowingStatus(view, model, propName, billStatusName, statusArr);
        }
    }

    public static void registerShowingStatus(IFormView view, IDataModel model, String propName, String billStatusName, String ... statusArr) {
        boolean statusMatch = TmcViewInputHelper.isStatusMatch(model, billStatusName, statusArr);
        view.setVisible(Boolean.valueOf(statusMatch), new String[]{propName});
    }

    public static boolean checkMustInput(IFormView view, IDataModel model, boolean isShowTip, String ... props) {
        boolean ischedked = true;
        StringBuilder error = new StringBuilder();
        for (String prop : props) {
            if (!isShowTip) {
                if (!EmptyUtil.isEmpty(model.getValue(prop))) continue;
                LocaleString field = model.getProperty(prop).getDisplayName();
                if (EmptyUtil.isNoEmpty(error.toString())) {
                    error.append(", ").append(field);
                } else {
                    error.append(field);
                }
                if (!ischedked) continue;
                ischedked = false;
                continue;
            }
            if (TmcViewInputHelper.checkMustInput(view, model, isShowTip, prop) || !ischedked) continue;
            ischedked = false;
        }
        if (!isShowTip && EmptyUtil.isNoEmpty(error.toString())) {
            view.showTipNotification(String.format(new TmcErrorCode().VALUE_CANNOT_NULL_NEW().getMessage(), error.toString()));
        }
        return ischedked;
    }

    public static boolean checkMustInput(IFormView view, IDataModel model, boolean isShowTip, String prop) {
        boolean result = true;
        if (EmptyUtil.isEmpty(model.getValue(prop))) {
            if (isShowTip) {
                TmcViewInputHelper.showErrTip(view, prop, new TmcErrorCode().VALUE_CANNOT_NULL().getMessage());
            } else {
                LocaleString field = model.getProperty(prop).getDisplayName();
                view.showTipNotification(String.format(new TmcErrorCode().VALUE_CANNOT_NULL_NEW().getMessage(), field));
            }
            result = false;
        }
        return result;
    }

    public static void showErrTip(IFormView view, String field, String message) {
        FieldTip tip = new FieldTip();
        tip.setFieldKey(field);
        tip.setLevel(FieldTip.FieldTipsLevel.Error);
        tip.setTip(message);
        view.showFieldTip(tip);
    }

    public static void showModifyTip(IFormView view, String field, String message) {
        FieldTip tip = new FieldTip();
        tip.setFieldKey(field);
        tip.setLevel(FieldTip.FieldTipsLevel.Info);
        tip.setTipsType(FieldTip.FieldTipsTypes.email);
        tip.setTip(message);
        tip.setSuccess(false);
        view.showFieldTip(tip);
    }

    public static void hideErrTip(IFormView view, String field) {
        FieldTip tip = new FieldTip();
        tip.setFieldKey(field);
        tip.setSuccess(true);
        view.showFieldTip(tip);
    }

    public static void registerShowingStatus(IFormView view, String[] propNameArr) {
        for (String propName : propNameArr) {
            view.setVisible(Boolean.TRUE, new String[]{propName});
        }
    }

    public static void registerVisibleStatus(IFormView view, String[] propNameArr, boolean visibleFlag) {
        for (String propName : propNameArr) {
            view.setVisible(Boolean.valueOf(visibleFlag), new String[]{propName});
        }
    }

    public static void registerDisableStatus(IFormView view, IDataModel model, String[] propNameArr, String billStatusName, String ... statusArr) {
        for (String propName : propNameArr) {
            TmcViewInputHelper.registerDisableStatus(view, model, propName, billStatusName, statusArr);
        }
    }

    public static void registerDisableStatus(IFormView view, IDataModel model, String propName, String billStatusName, String ... statusArr) {
        boolean statusMatch = TmcViewInputHelper.isStatusMatch(model, billStatusName, statusArr);
        view.setEnable(Boolean.valueOf(!statusMatch), new String[]{propName});
    }

    public static void registerDisableStatus(IFormView view, String[] propNameArr) {
        for (String propName : propNameArr) {
            view.setEnable(Boolean.FALSE, new String[]{propName});
        }
    }

    public static void batchFillEntity(String entryName, AbstractFormDataModel model, List<Map<String, Object>> dataMap, boolean isDeleteEntry) {
        if (isDeleteEntry) {
            model.deleteEntryData(entryName);
        }
        TmcViewInputHelper.fillEntity(entryName, model, dataMap);
    }

    public static void batchFillEntity(String entryName, AbstractFormDataModel model, List<Map<String, Object>> dataMap) {
        model.deleteEntryData(entryName);
        TmcViewInputHelper.fillEntity(entryName, model, dataMap);
    }

    private static void fillEntity(String entryName, AbstractFormDataModel model, List<Map<String, Object>> dataMap) {
        if (null != dataMap && dataMap.size() > 0) {
            TableValueSetter vs = new TableValueSetter(new String[0]);
            for (Map<String, Object> map : dataMap) {
                map.forEach((key, value) -> {
                    if (value instanceof DynamicObject) {
                        value = ((DynamicObject)value).getPkValue();
                    }
                    vs.addField(key, new Object[]{value});
                });
            }
            model.batchCreateNewEntryRow(entryName, vs);
        }
    }

    public static void clearValWithoutPropChgEvt(IFormView view, IDataModel model, String ... propNames) {
        for (String propName : propNames) {
            if (model.getValue(propName) == null) continue;
            TmcViewInputHelper.setValWithoutPropChgEvt(view, model, propName, null);
        }
    }

    public static void clearValWithoutPropChgEvt(IFormView view, IDataModel model, int rowIndex, String ... propNames) {
        for (String propName : propNames) {
            if (model.getValue(propName, rowIndex) == null) continue;
            TmcViewInputHelper.setValWithoutPropChgEvt(view, model, propName, null, rowIndex);
        }
    }

    public static void setValWithoutPropChgEvt(IFormView view, IDataModel model, String propName, Object value) {
        TmcViewInputHelper.setValWithoutPropChgEvt(view, model, new ParamMap().put(propName, value).getParams());
    }

    public static void setValWithoutPropChgEvt(IFormView view, IDataModel model, String propName, Object value, int rowIndex) {
        model.beginInit();
        model.setValue(propName, value, rowIndex);
        model.endInit();
        view.updateView(propName, rowIndex);
    }

    public static void setValWithoutPropChgEvt(IFormView view, IDataModel model, String propName, Object value, int rowIndex, int parentRowIndex) {
        model.beginInit();
        model.setValue(propName, value, rowIndex, parentRowIndex);
        model.endInit();
        view.updateView(propName, rowIndex);
    }

    public static void setValWithoutPropChgEvt(IFormView view, IDataModel model, Map<String, Object> valueMap) {
        model.beginInit();
        for (Map.Entry<String, Object> entry : valueMap.entrySet()) {
            model.setValue(entry.getKey(), entry.getValue());
        }
        model.endInit();
        for (String prop : valueMap.keySet()) {
            view.updateView(prop);
        }
    }

    public static void setValWithoutDataChanged(IDataModel model, String propName, Object value) {
        TmcViewInputHelper.setValWithoutDataChanged(model, new ParamMap().put(propName, value).getParams());
    }

    public static void setValWithoutDataChanged(IDataModel model, String propName, Object value, int i) {
        boolean isChanged = model.getDataChanged();
        model.setValue(propName, value, i);
        if (!isChanged) {
            model.setDataChanged(false);
        }
    }

    public static void setValWithoutDataChanged(IDataModel model, Map<String, Object> valueMap) {
        boolean isChanged = model.getDataChanged();
        for (Map.Entry<String, Object> entry : valueMap.entrySet()) {
            model.setValue(entry.getKey(), entry.getValue());
        }
        if (!isChanged) {
            model.setDataChanged(false);
        }
    }

    public static boolean isStatusMatch(IDataModel model, String billStatusName, String ... statusArr) {
        Object currStatus = model.getValue(billStatusName);
        boolean statusMatch = Arrays.asList(statusArr).contains(currStatus);
        return statusMatch;
    }

    public static void resetComboItems(List<String> comboItemValues, String propName, IFormView view) {
        DataEntityPropertyCollection properties = view.getModel().getDataEntity().getDynamicObjectType().getProperties();
        Optional<IDataEntityProperty> optional = properties.stream().filter(v -> v.getName().equals(propName)).findFirst();
        if (!optional.isPresent()) {
            return;
        }
        ComboProp comboProp = (ComboProp)optional.get();
        List valueMapItems = comboProp.getComboItems();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(8);
        for (ValueMapItem valueMapItem : valueMapItems) {
            String value = valueMapItem.getValue();
            if (!comboItemValues.contains(value)) continue;
            comboItems.add(new ComboItem(valueMapItem.getName(), value));
        }
        ((ComboEdit)view.getControl(propName)).setComboItems(comboItems);
    }

    public static void batchFillWithoutPropChg(IDataModel model, IFormView view, String entrysName, List<Map<String, Object>> dataMap, boolean clearOldData) {
        model.beginInit();
        if (clearOldData) {
            model.deleteEntryData(entrysName);
        }
        if (null != dataMap && dataMap.size() > 0) {
            TableValueSetter vs = new TableValueSetter(new String[0]);
            for (Map<String, Object> map : dataMap) {
                map.forEach((key, vaule) -> vs.addField(key, new Object[]{vaule}));
            }
            ((AbstractFormDataModel)model).batchCreateNewEntryRow(entrysName, vs);
        }
        model.endInit();
        view.updateView(entrysName);
    }

    public static interface F7FilterBuilder {
        public QFilter build(BeforeF7SelectEvent var1);
    }
}

