/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.script.annotations.KSObject;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.helper.WorkCalendarHelper;
import kd.tmc.fbp.common.util.DateUtils;

@KSObject
public class WorkCalendarAdjustHelper {
    public static int callSettleDelayDay(DynamicObjectCollection workCalendars, Date bizDate, Date settleDate) {
        int workDay = 0;
        while (bizDate.before(settleDate)) {
            if (!WorkCalendarHelper.isWorkDay(workCalendars, bizDate = DateUtils.getNextDay(DateUtils.truncateDate(bizDate), 1))) continue;
            ++workDay;
        }
        return workDay;
    }

    public static Date callSettleDelayDate(DynamicObjectCollection workCalendars, Date date, int settleDelay) {
        Date settleDate = date;
        int internal = 1;
        if (settleDelay < 0) {
            internal = -1;
            settleDelay = -settleDelay;
        }
        for (int index = 0; index < settleDelay; ++index) {
            settleDate = DateUtils.getNextDay(DateUtils.truncateDate(settleDate), internal);
            while (!WorkCalendarHelper.isWorkDay(workCalendars, settleDate)) {
                settleDate = DateUtils.getNextDay(DateUtils.truncateDate(settleDate), internal);
            }
        }
        return settleDate;
    }

    public static Date callBasicSettleDelayDate(DynamicObjectCollection workCalendars, Date date, int settleDelay) {
        Date settleDate = date;
        int internal = 1;
        if (settleDelay < 0) {
            internal = -1;
            settleDelay = -settleDelay;
        }
        Set<Long> wcIds = workCalendars.stream().distinct().map(o -> o.getLong("id")).collect(Collectors.toSet());
        for (int index = 0; index < settleDelay; ++index) {
            while (!WorkCalendarHelper.isWorkDay(wcIds.toArray(new Long[0]), settleDate)) {
                settleDate = DateUtils.getNextDay(DateUtils.truncateDate(settleDate), internal);
            }
        }
        return settleDate;
    }

    public static Date callAdjustSettleDate(DynamicObjectCollection workCalendars, Date date, AdjustMethodEnum adjustMethod) {
        Date settleDate = date = DateUtils.truncateDate(date);
        switch (adjustMethod) {
            case forward: {
                while (!WorkCalendarHelper.isWorkDay(workCalendars, settleDate)) {
                    settleDate = DateUtils.getNextDay(settleDate, 1);
                }
                break;
            }
            case ad_forward: {
                while (!WorkCalendarHelper.isWorkDay(workCalendars, settleDate)) {
                    if (!DateUtils.isSameMonth(date, settleDate)) {
                        settleDate = WorkCalendarAdjustHelper.callAdjustSettleDate(workCalendars, date, AdjustMethodEnum.backward);
                        continue;
                    }
                    settleDate = DateUtils.getNextDay(settleDate, 1);
                }
                if (DateUtils.isSameMonth(date, settleDate)) break;
                settleDate = WorkCalendarAdjustHelper.callAdjustSettleDate(workCalendars, date, AdjustMethodEnum.backward);
                break;
            }
            case backward: {
                while (!WorkCalendarHelper.isWorkDay(workCalendars, settleDate)) {
                    settleDate = DateUtils.getLastDay(settleDate, 1);
                }
                break;
            }
            case ad_backward: {
                while (!WorkCalendarHelper.isWorkDay(workCalendars, settleDate)) {
                    if (!DateUtils.isSameMonth(date, settleDate)) {
                        settleDate = WorkCalendarAdjustHelper.callAdjustSettleDate(workCalendars, date, AdjustMethodEnum.forward);
                        continue;
                    }
                    settleDate = DateUtils.getLastDay(settleDate, 1);
                }
                if (DateUtils.isSameMonth(date, settleDate)) break;
                settleDate = WorkCalendarAdjustHelper.callAdjustSettleDate(workCalendars, date, AdjustMethodEnum.forward);
                break;
            }
        }
        return settleDate;
    }

    public static Date callAdjustSettleDate(Map<Date, Boolean> workCalendarMap, Date date, AdjustMethodEnum adjustMethod) {
        Date settleDate = date = DateUtils.truncateDate(date);
        switch (adjustMethod) {
            case forward: {
                while (!WorkCalendarAdjustHelper.isWorkDay(workCalendarMap, settleDate)) {
                    settleDate = DateUtils.getNextDay(settleDate, 1);
                }
                break;
            }
            case ad_forward: {
                while (!WorkCalendarAdjustHelper.isWorkDay(workCalendarMap, settleDate)) {
                    if (!DateUtils.isSameMonth(date, settleDate)) {
                        settleDate = WorkCalendarAdjustHelper.callAdjustSettleDate(workCalendarMap, date, AdjustMethodEnum.backward);
                        continue;
                    }
                    settleDate = DateUtils.getNextDay(settleDate, 1);
                }
                if (DateUtils.isSameMonth(date, settleDate)) break;
                settleDate = WorkCalendarAdjustHelper.callAdjustSettleDate(workCalendarMap, date, AdjustMethodEnum.backward);
                break;
            }
            case backward: {
                while (!WorkCalendarAdjustHelper.isWorkDay(workCalendarMap, settleDate)) {
                    settleDate = DateUtils.getLastDay(settleDate, 1);
                }
                break;
            }
            case ad_backward: {
                while (!WorkCalendarAdjustHelper.isWorkDay(workCalendarMap, settleDate)) {
                    if (!DateUtils.isSameMonth(date, settleDate)) {
                        settleDate = WorkCalendarAdjustHelper.callAdjustSettleDate(workCalendarMap, date, AdjustMethodEnum.forward);
                        continue;
                    }
                    settleDate = DateUtils.getLastDay(settleDate, 1);
                }
                if (DateUtils.isSameMonth(date, settleDate)) break;
                settleDate = WorkCalendarAdjustHelper.callAdjustSettleDate(workCalendarMap, date, AdjustMethodEnum.forward);
                break;
            }
        }
        return settleDate;
    }

    public static Map<Date, Date> callAdjustSettleDate(Map<Date, Boolean> workCalendarMap, Date beginDate, Date endDate, AdjustMethodEnum adjustMethod) {
        HashMap<Date, Date> adjustDateMap = new HashMap<Date, Date>(32);
        beginDate = DateUtils.truncateDate(beginDate);
        endDate = DateUtils.truncateDate(endDate);
        while (beginDate.compareTo(endDate) <= 0) {
            Date settleDate = WorkCalendarAdjustHelper.callAdjustSettleDate(workCalendarMap, beginDate, adjustMethod);
            adjustDateMap.put(beginDate, settleDate);
            beginDate = DateUtils.getNextDay(beginDate, 1);
        }
        return adjustDateMap;
    }

    public static boolean isWorkDay(Map<Date, Boolean> workCalendarMap, Date date) {
        Boolean isWorkDay = workCalendarMap.get(date);
        if (isWorkDay == null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            isWorkDay = 7 != calendar.get(7) && 1 != calendar.get(7);
            workCalendarMap.put(date, isWorkDay);
        }
        return isWorkDay;
    }

    public static Date callDelayAdjustSettleDate(DynamicObjectCollection workCalendars, Date date, int settleDelay, AdjustMethodEnum adjustMethod) {
        Date settleDelayDate = WorkCalendarAdjustHelper.callSettleDelayDate(workCalendars, date, settleDelay);
        return WorkCalendarAdjustHelper.callAdjustSettleDate(workCalendars, settleDelayDate, adjustMethod);
    }
}

