/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.BondDealTypeEnum;
import kd.tmc.fbp.common.enums.PayFrequeEnum;
import kd.tmc.fbp.common.enums.ReturnValTypeEnum;
import kd.tmc.fbp.common.enums.TradeToolEnum;
import kd.tmc.fbp.common.formula.MathFormulaUtils;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.fbp.common.util.TermUtils;

public class YieldCurveHelper {
    private static final Log logger = LogFactory.getLog(YieldCurveHelper.class);
    protected static final String[] contract = new String[]{"Mar", "Jun", "Sep", "Dec"};
    private static final int PRECISION_15 = 15;

    public static BigDecimal bond_CalBondPrice(String bondDealType, BigDecimal couponRate, BigDecimal midRate, PayFrequeEnum payFrequeEnum, BasisEnum basis, String term, Date fromDate, Date endDate) {
        BigDecimal bd;
        int N = 0;
        double d = 0.0;
        boolean isZeroCoupon = false;
        if (couponRate.compareTo(BigDecimal.ZERO) == 0) {
            payFrequeEnum = PayFrequeEnum.year;
            isZeroCoupon = true;
        }
        if (EmptyUtil.isAnyoneEmpty(new Object[]{payFrequeEnum, fromDate, bondDealType, basis}) || BondDealTypeEnum.isSwap(bondDealType) && EmptyUtil.isAnyoneEmpty(new Object[]{payFrequeEnum, fromDate, term}) || BondDealTypeEnum.isBond(bondDealType) && EmptyUtil.isAnyoneEmpty(endDate)) {
            return BigDecimal.ZERO;
        }
        int h = payFrequeEnum.getFreque();
        int days = 0;
        Date toDate = endDate;
        if (BondDealTypeEnum.isSwap(bondDealType)) {
            toDate = TermUtils.getDateByTerm(term, fromDate);
            Map<String, Integer> ymd = TermUtils.getYMD(term);
            days = ymd.get("y") * 360 + ymd.get("m") * 30 + ymd.get("d");
        } else {
            days = TradeBusinessHelper.getBasis_BetweenDay(fromDate, toDate, BasisEnum.SIA_30_360, null);
            if (days <= 0) {
                return BigDecimal.ZERO;
            }
        }
        if (isZeroCoupon) {
            bd = TradeBusinessHelper.getBaseBasis(fromDate, toDate, basis, null, null, null);
            d = bd.doubleValue();
        } else {
            N = days * h / 360;
            if (days * h % 360 > 0) {
                bd = TradeBusinessHelper.getBaseBasis(fromDate, TcDateUtils.getLastMonth(toDate, N * payFrequeEnum.getMonth()), basis, null, null, null);
                d = bd.doubleValue();
            }
        }
        BigDecimal sum = BigDecimal.ZERO;
        couponRate = couponRate.multiply(Constants.ONE_HUNDRED).divide(BigDecimal.valueOf(h), 15, 4);
        BigDecimal temp = BigDecimal.ONE.add(midRate.divide(BigDecimal.valueOf(h), 15, 4));
        for (int i = 1; i <= N; ++i) {
            sum = sum.add(couponRate.divide(temp.pow(i), 15, 4));
        }
        sum = sum.add(Constants.ONE_HUNDRED.divide(temp.pow(N), 15, 4));
        if (d >= 0.001) {
            sum = sum.add(couponRate);
        }
        sum = sum.divide(BigDecimal.valueOf(Math.pow(temp.doubleValue(), d)), 15, 4);
        return sum;
    }

    public static BigDecimal bond_CalMidRate(String bondDealType, BigDecimal bondPrice, BigDecimal couponRate, PayFrequeEnum payFrequeEnum, BasisEnum basis, String term, Date fromDate, Date endDate) {
        if (couponRate.compareTo(BigDecimal.ZERO) == 0) {
            payFrequeEnum = PayFrequeEnum.year;
        }
        if (EmptyUtil.isAnyoneEmpty(new Object[]{payFrequeEnum, term})) {
            return BigDecimal.ZERO;
        }
        BigDecimal r1 = BigDecimal.valueOf(-0.2);
        BigDecimal r2 = BigDecimal.valueOf(1L);
        BigDecimal two = BigDecimal.valueOf(2L);
        BigDecimal price1 = bondPrice.subtract(YieldCurveHelper.bond_CalBondPrice(bondDealType, couponRate, r1, payFrequeEnum, basis, term, fromDate, endDate));
        BigDecimal price2 = bondPrice.subtract(YieldCurveHelper.bond_CalBondPrice(bondDealType, couponRate, r2, payFrequeEnum, basis, term, fromDate, endDate));
        BigDecimal midRate = r1.add(r2).divide(two, 15, 4);
        BigDecimal calPrice = BigDecimal.ZERO;
        BigDecimal limit = BigDecimal.valueOf(1.0E-10);
        int count = 100;
        while (count > 0 && price1.multiply(price2).compareTo(BigDecimal.ZERO) < 0 && price1.subtract(price2).abs().compareTo(limit) > 0) {
            --count;
            midRate = r1.add(r2).divide(two, 15, 4);
            calPrice = bondPrice.subtract(YieldCurveHelper.bond_CalBondPrice(bondDealType, couponRate, midRate, payFrequeEnum, basis, term, fromDate, endDate));
            if (calPrice.compareTo(BigDecimal.ZERO) == 0) break;
            if (price1.multiply(calPrice).compareTo(BigDecimal.ZERO) < 0) {
                r2 = midRate;
                price2 = calPrice;
            }
            if (price2.multiply(calPrice).compareTo(BigDecimal.ZERO) >= 0) continue;
            r1 = midRate;
            price1 = calPrice;
        }
        return midRate.multiply(Constants.ONE_HUNDRED);
    }

    public static void fillAllDFByFintool(boolean zerorate, String bootstrap, Date referdate, BasisEnum basisEnum, PayFrequeEnum payFrequeEnum, String interpType, String bondDealType, DynamicObjectCollection workcalendar, DynamicObjectCollection fintoolEntry, List<Date> dateList, Map<Date, BigDecimal> result) {
        YieldCurveHelper.rebuildFutureContract(referdate, fintoolEntry);
        for (int i = 0; i < fintoolEntry.size(); ++i) {
            Date enddate;
            int offset;
            Date referdateWithOffset;
            if (!TradeToolEnum.isBond(((DynamicObject)fintoolEntry.get(i)).getString("fintool_fin")) || !BondDealTypeEnum.isBond(bondDealType) || (referdateWithOffset = TradeBusinessHelper.callSettleDelayDate(workcalendar, referdate, offset = ((DynamicObject)fintoolEntry.get(i)).getInt("rateoffset_fin"))).compareTo(enddate = ((DynamicObject)fintoolEntry.get(i)).getDate("enddate_fin")) < 0) continue;
            ((DynamicObject)fintoolEntry.get(i)).set("isforcurve_fin", (Object)Boolean.FALSE);
        }
        if (zerorate) {
            YieldCurveHelper.fillAllDFByFintool_OnZeroRate(referdate, workcalendar, basisEnum, payFrequeEnum, fintoolEntry, dateList, result);
        } else {
            YieldCurveHelper.fillAllDFByFintool_OnForwardOrOnYield(referdate, workcalendar, interpType, bootstrap, bondDealType, fintoolEntry, dateList, result);
        }
    }

    public static void fillAllDFByFintool(DynamicObject yieldline, Date referdate, List<Date> dateList, Map<Date, BigDecimal> result) {
        boolean zerorate = yieldline.getBoolean("zerorate");
        String boostrap = yieldline.getString("bootstrap");
        String basis = yieldline.getString("basis");
        String freq = yieldline.getString("frequency");
        String interpType = yieldline.getString("interptype");
        String bondDealType = yieldline.getString("bonddealtype");
        DynamicObjectCollection workcalendar = yieldline.getDynamicObjectCollection("workcalendar");
        BasisEnum basisEnum = null;
        if (EmptyUtil.isNoEmpty(basis)) {
            basisEnum = BasisEnum.valueOf(basis);
        }
        if (EmptyUtil.isNoEmpty(freq)) {
            PayFrequeEnum payFrequeEnum = PayFrequeEnum.valueOf(freq);
            DynamicObjectCollection fintoolEntry = yieldline.getDynamicObjectCollection("fintoolentry");
            YieldCurveHelper.fillAllDFByFintool(zerorate, boostrap, referdate, basisEnum, payFrequeEnum, interpType, bondDealType, workcalendar, fintoolEntry, dateList, result);
        }
    }

    private static void fillAllDFByFintool_OnZeroRate(Date referdate, DynamicObjectCollection workcalendar, BasisEnum basisEnum, PayFrequeEnum payFrequeEnum, DynamicObjectCollection fintoolEntry, List<Date> dateList, Map<Date, BigDecimal> result) {
        Object[] wc;
        if (EmptyUtil.isAnyoneEmpty(new Object[]{referdate, basisEnum, payFrequeEnum, fintoolEntry})) {
            return;
        }
        if (EmptyUtil.isEmpty(workcalendar)) {
            wc = null;
        } else {
            wc = new DynamicObject[workcalendar.size()];
            wc = (DynamicObject[])workcalendar.toArray(wc);
        }
        for (int i = 0; i < fintoolEntry.size(); ++i) {
            DynamicObject row = (DynamicObject)fintoolEntry.get(i);
            String fintool_fin = row.getString("fintool_fin");
            boolean isforcurve_fin = row.getBoolean("isforcurve_fin");
            if (TradeToolEnum.isFra(fintool_fin) || TradeToolEnum.isFuture(fintool_fin) || !isforcurve_fin) continue;
            int rateOffset = row.getInt("rateoffset_fin");
            String term = row.getString("term_fin");
            BigDecimal midRate = row.getBigDecimal("midrate_fin");
            midRate = midRate.divide(Constants.ONE_HUNDRED);
            AdjustMethodEnum adjustMethodEnum = AdjustMethodEnum.valueOf(row.getString("adjmethod_fin"));
            Date referedateoffset = TradeBusinessHelper.callSettleDelayDate(workcalendar, referdate, rateOffset);
            Date paydate = TermUtils.getDateByTerm(term, referedateoffset);
            paydate = TradeBusinessHelper.callAdjustSettleDate(workcalendar, paydate, adjustMethodEnum);
            BigDecimal basis = TradeBusinessHelper.getBaseBasis(referdate, paydate, basisEnum, (DynamicObject[])wc, null, null);
            double z = payFrequeEnum == PayFrequeEnum.day ? Math.exp(-midRate.multiply(basis).doubleValue()) : 1.0 / Math.pow(1.0 + midRate.doubleValue() / (double)payFrequeEnum.getFreque(), basis.doubleValue() * (double)payFrequeEnum.getFreque());
            BigDecimal df = BigDecimal.valueOf(z);
            YieldCurveHelper.addToDfResultList(result, dateList, paydate, df);
            dateList.sort((o1, o2) -> o1.compareTo((Date)o2));
        }
    }

    private static List<DynamicObject> preDeal_SwapAndBond(String swapOrBond, String bootstrap, String bondDealType, Date referdate, DynamicObjectCollection workcalendar, DynamicObject[] wc, List<DynamicObject> list_used, List<Date> dateList) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(list_used.size() * 2);
        for (int i = 0; i < list_used.size(); ++i) {
            DynamicObject curRow = list_used.get(i);
            String fintool = curRow.getString("fintool_fin");
            BigDecimal finCouponrate = curRow.getBigDecimal("couponrate_fin");
            String basis = curRow.getString("basis_fin");
            String term = curRow.getString("term_fin");
            int rateOffset = curRow.getInt("rateoffset_fin");
            Date enddate = curRow.getDate("enddate_fin");
            BasisEnum basisEnum = BasisEnum.valueOf(basis);
            ArrayList<BigDecimal> bondPis = new ArrayList<BigDecimal>();
            if ("OnYield".equals(bootstrap) && (finCouponrate.compareTo(BigDecimal.ZERO) > 0 || TradeToolEnum.isSwap(fintool))) {
                int n;
                Date referdateOffset = TradeBusinessHelper.callSettleDelayDate(workcalendar, referdate, rateOffset);
                String freq = curRow.getString("freq_fin");
                PayFrequeEnum frequeEnum = PayFrequeEnum.valueOf(freq);
                if (TradeToolEnum.isBond(fintool) && BondDealTypeEnum.isBond(bondDealType)) {
                    if (!enddate.after(referdateOffset)) continue;
                    int days = TradeBusinessHelper.getBasis_BetweenDay(referdateOffset, enddate, BasisEnum.SIA_30_360, wc);
                    term = TermUtils.getFormatStr(days / 360, days % 360 / 30, days % 360 % 30);
                }
                if ((n = YieldCurveHelper.getN(term, frequeEnum) - 1) == 0) {
                    list.add(curRow);
                } else {
                    String term_min = list_used.get(0).getString("term_fin");
                    Map<String, Integer> ymd_min = TermUtils.getYMD(term_min);
                    int day_min = ymd_min.get("y") * 360 + ymd_min.get("m") * 30 + ymd_min.get("d");
                    if (TradeToolEnum.isBond(fintool) && BondDealTypeEnum.isBond(bondDealType)) {
                        int uoffset = list_used.get(0).getInt("rateoffset_fin");
                        Date ureferedate = TradeBusinessHelper.callSettleDelayDate(workcalendar, referdate, uoffset);
                        Date uendate = list_used.get(0).getDate("enddate_fin");
                        day_min = TradeBusinessHelper.getBasis_BetweenDay(ureferedate, uendate, BasisEnum.SIA_30_360, wc);
                    }
                    Map<String, Integer> ymd = TermUtils.getYMD(term);
                    int days = ymd.get("y") * 360 + ymd.get("m") * 30 + ymd.get("d");
                    for (int index = 1; index < n + 1; ++index) {
                        String term_i;
                        int day_i;
                        Date enddate_i = null;
                        if (TradeToolEnum.isSwap(fintool) || TradeToolEnum.isBond(fintool) && BondDealTypeEnum.isSwap(bondDealType)) {
                            int month = days / 30 - (n + 1 - index) * frequeEnum.getMonth();
                            day_i = days - (n + 1 - index) * frequeEnum.getMonth() * 30;
                            term_i = TermUtils.getFormatStr(month / 12, month % 12, days % 30);
                        } else {
                            Date date_i = TcDateUtils.getLastMonth(enddate, (n + 1 - index) * 12 / frequeEnum.getFreque());
                            day_i = TradeBusinessHelper.getBasis_BetweenDay(referdateOffset, date_i, BasisEnum.SIA_30_360, wc);
                            term_i = TermUtils.getFormatStr(day_i / 360, day_i % 360 / 30, day_i % 360 % 30);
                            enddate_i = date_i;
                        }
                        DynamicObject insertRow = TmcDataServiceHelper.clone(curRow);
                        insertRow.set("term_fin", (Object)term_i);
                        insertRow.set("couponrate_fin", (Object)BigDecimal.ZERO);
                        insertRow.set("enddate_fin", (Object)enddate_i);
                        insertRow.set("isnewadd_fin", (Object)Boolean.TRUE);
                        boolean match = false;
                        for (int j = 0; j < list_used.size(); ++j) {
                            int day_j;
                            if (TradeToolEnum.isBond(fintool) && BondDealTypeEnum.isBond(bondDealType)) {
                                int joffset = list_used.get(j).getInt("rateoffset_fin");
                                Date jreferedate = TradeBusinessHelper.callSettleDelayDate(workcalendar, referdate, joffset);
                                Date jendate = list_used.get(j).getDate("enddate_fin");
                                day_j = TradeBusinessHelper.getBasis_BetweenDay(jreferedate, jendate, BasisEnum.SIA_30_360, wc);
                            } else {
                                String term_j = list_used.get(j).getString("term_fin");
                                Map<String, Integer> ymd_j = TermUtils.getYMD(term_j);
                                day_j = ymd_j.get("y") * 360 + ymd_j.get("m") * 30 + ymd_j.get("d");
                            }
                            if (day_i - day_j != 0) continue;
                            insertRow.set("midrate_fin", (Object)list_used.get(j).getBigDecimal("midrate_fin"));
                            match = true;
                            break;
                        }
                        if (!match) {
                            if (day_i <= day_min) {
                                insertRow.set("midrate_fin", (Object)list_used.get(0).getBigDecimal("midrate_fin"));
                            } else {
                                int day2;
                                int day1;
                                int index_T1 = YieldCurveHelper.preDeal_getNearLastTermRowIndex(referdate, fintool, bondDealType, term_i, workcalendar, wc, list_used);
                                BigDecimal r1 = list_used.get(index_T1).getBigDecimal("midrate_fin");
                                r1 = r1.divide(Constants.ONE_HUNDRED);
                                BigDecimal r2 = list_used.get(index_T1 + 1).getBigDecimal("midrate_fin");
                                r2 = r2.divide(Constants.ONE_HUNDRED);
                                if (TradeToolEnum.isBond(fintool) && BondDealTypeEnum.isBond(bondDealType)) {
                                    int t1Offset = list_used.get(index_T1).getInt("rateoffset_fin");
                                    Date t1Referedate = TradeBusinessHelper.callSettleDelayDate(workcalendar, referdate, t1Offset);
                                    Date t1Endate = list_used.get(index_T1).getDate("enddate_fin");
                                    int t2Offset = list_used.get(index_T1 + 1).getInt("rateoffset_fin");
                                    Date t2Referedate = TradeBusinessHelper.callSettleDelayDate(workcalendar, referdate, t2Offset);
                                    Date t2Endate = list_used.get(index_T1 + 1).getDate("enddate_fin");
                                    day1 = TradeBusinessHelper.getBasis_BetweenDay(t1Referedate, t1Endate, BasisEnum.SIA_30_360, wc);
                                    day2 = TradeBusinessHelper.getBasis_BetweenDay(t2Referedate, t2Endate, BasisEnum.SIA_30_360, wc);
                                } else {
                                    String T1 = list_used.get(index_T1).getString("term_fin");
                                    String T2 = list_used.get(index_T1 + 1).getString("term_fin");
                                    Map<String, Integer> ymd1 = TermUtils.getYMD(T1);
                                    day1 = ymd1.get("y") * 360 + ymd1.get("m") * 30 + ymd1.get("d");
                                    Map<String, Integer> ymd2 = TermUtils.getYMD(T2);
                                    day2 = ymd2.get("y") * 360 + ymd2.get("m") * 30 + ymd2.get("d");
                                }
                                BigDecimal r_i = r1.add(r2.subtract(r1).multiply(BigDecimal.valueOf(day_i - day1)).divide(BigDecimal.valueOf(day2 - day1), 10, 4));
                                insertRow.set("midrate_fin", (Object)r_i.multiply(Constants.ONE_HUNDRED));
                            }
                        }
                        if (swapOrBond.equals("Bond")) {
                            int yearDay = TradeBusinessHelper.getBasis_YearDay(0, BasisEnum.SIA_30_360);
                            BigDecimal couponrate = BigDecimal.ZERO;
                            if (day_i > yearDay) {
                                couponrate = finCouponrate.divide(BigDecimal.valueOf(100L));
                                insertRow.set("couponrate_fin", (Object)finCouponrate);
                            }
                            BigDecimal bondPrice = YieldCurveHelper.bond_CalBondPrice(bondDealType, couponrate, ((BigDecimal)insertRow.get("midrate_fin")).divide(Constants.ONE_HUNDRED), frequeEnum, basisEnum, term_i, referdateOffset, enddate_i);
                            bondPrice = bondPrice.setScale(insertRow.getBigDecimal("price_fin").scale(), 4);
                            insertRow.set("price_fin", (Object)bondPrice);
                            bondPis.add(bondPrice);
                        }
                        list.add(insertRow);
                    }
                    list.add(curRow);
                }
            } else {
                list.add(curRow);
            }
            YieldCurveHelper.logPi(bondPis, term);
        }
        return list;
    }

    private static void logPi(List<BigDecimal> bondPis, String term) {
        if (bondPis != null && bondPis.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (int j = 1; j < bondPis.size() + 1; ++j) {
                sb.append(String.format("[i=%s, pi=%s]\n", j, bondPis.get(j - 1)));
            }
            logger.info("\u671f\u9650{}\u503a\u5238\u9884\u5904\u7406\u503a\u5238\u4ef7\u683cpi:{}", (Object)term, (Object)sb.toString());
        }
    }

    private static int preDeal_getNearLastTermRowIndex(Date referdate, String fintool, String bondDealType, String term, DynamicObjectCollection workcalendar, DynamicObject[] wc, List<DynamicObject> rowList) {
        Map<String, Integer> ymd = TermUtils.getYMD(term);
        int day = ymd.get("y") * 360 + ymd.get("m") * 30 + ymd.get("d");
        for (int i = 0; i < rowList.size() - 1; ++i) {
            int day_next;
            int day_i;
            if (TradeToolEnum.isBond(fintool) && BondDealTypeEnum.isBond(bondDealType)) {
                int ioffset = rowList.get(i).getInt("rateoffset_fin");
                Date ireferedate = TradeBusinessHelper.callSettleDelayDate(workcalendar, referdate, ioffset);
                Date iendate = rowList.get(i).getDate("enddate_fin");
                day_i = TradeBusinessHelper.getBasis_BetweenDay(ireferedate, iendate, BasisEnum.SIA_30_360, wc);
                int i2offset = rowList.get(i + 1).getInt("rateoffset_fin");
                Date i2referedate = TradeBusinessHelper.callSettleDelayDate(workcalendar, referdate, i2offset);
                Date i2endate = rowList.get(i + 1).getDate("enddate_fin");
                day_next = TradeBusinessHelper.getBasis_BetweenDay(i2referedate, i2endate, BasisEnum.SIA_30_360, wc);
            } else {
                String term_i = rowList.get(i).getString("term_fin");
                Map<String, Integer> ymd_i = TermUtils.getYMD(term_i);
                day_i = ymd_i.get("y") * 360 + ymd_i.get("m") * 30 + ymd_i.get("d");
                String term_next = rowList.get(i + 1).getString("term_fin");
                Map<String, Integer> ymd_next = TermUtils.getYMD(term_next);
                day_next = ymd_next.get("y") * 360 + ymd_next.get("m") * 30 + ymd_next.get("d");
            }
            if ((day - day_i) * (day_next - day) <= 0) continue;
            return i;
        }
        return -1;
    }

    private static int getN(String term, PayFrequeEnum frequeEnum) {
        Map<String, Integer> ymd = TermUtils.getYMD(term);
        int days = ymd.get("y") * 360 + ymd.get("m") * 30 + ymd.get("d");
        int N = days * frequeEnum.getFreque() / 360;
        if (days * frequeEnum.getFreque() % 360 != 0) {
            ++N;
        }
        return N;
    }

    private static String getMod(String term, PayFrequeEnum frequeEnum) {
        Map<String, Integer> ymd = TermUtils.getYMD(term);
        int days = ymd.get("y") * 360 + ymd.get("m") * 30 + ymd.get("d");
        Map<String, Integer> ymd_freq = TermUtils.getYMD(frequeEnum.getName());
        int days_freq = ymd_freq.get("y") * 360 + ymd_freq.get("m") * 30 + ymd_freq.get("d");
        String mod = days % days_freq / 30 + "m" + days % days_freq % 30 + "d";
        return mod;
    }

    private static void fillAllDFByFintool_OnForwardOrOnYield(Date referdate, DynamicObjectCollection workcalendar, String interpType, String bootstrap, String bondDealType, DynamicObjectCollection fintoolEntry, List<Date> dateList, Map<Date, BigDecimal> result) {
        Object[] wc;
        if (EmptyUtil.isAnyoneEmpty(referdate, interpType, bootstrap, bondDealType, fintoolEntry)) {
            return;
        }
        if (EmptyUtil.isEmpty(workcalendar)) {
            wc = null;
        } else {
            wc = new DynamicObject[workcalendar.size()];
            wc = (DynamicObject[])workcalendar.toArray(wc);
        }
        ArrayList<Date> dateList_Cash = new ArrayList<Date>(10);
        ArrayList<Map<String, Object>> dateList_Future = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> dateList_FRA = new ArrayList<Map<String, Object>>(10);
        ArrayList<DynamicObject> swapList_input = new ArrayList<DynamicObject>(fintoolEntry.size());
        ArrayList<DynamicObject> bondList_input = new ArrayList<DynamicObject>(fintoolEntry.size());
        DynamicObject firstRow = YieldCurveHelper.getFirstValidFintoolEntryRow(fintoolEntry);
        for (int i = 0; i < fintoolEntry.size(); ++i) {
            DynamicObject row = (DynamicObject)fintoolEntry.get(i);
            String fintool = row.getString("fintool_fin");
            boolean isforcurve_fin = row.getBoolean("isforcurve_fin");
            if (!isforcurve_fin) continue;
            switch (fintool) {
                case "Cash": {
                    YieldCurveHelper.dealFintool_Cash(referdate, firstRow, bondDealType, row, workcalendar, (DynamicObject[])wc, result, dateList_Cash, dateList);
                    dateList_Cash.sort(new Comparator<Date>(){

                        @Override
                        public int compare(Date o1, Date o2) {
                            return o1.compareTo(o2);
                        }
                    });
                    break;
                }
                case "Future": {
                    YieldCurveHelper.dealFintool_Future(interpType, referdate, row, workcalendar, (DynamicObject[])wc, result, dateList_Future, dateList_Cash, dateList);
                    break;
                }
                case "FRA": {
                    YieldCurveHelper.dealFintool_FRA(interpType, referdate, row, workcalendar, (DynamicObject[])wc, result, dateList_FRA, dateList_Cash, dateList);
                    break;
                }
                case "Swap": {
                    swapList_input.add(row);
                    break;
                }
                case "Bond": {
                    bondList_input.add(row);
                }
            }
            dateList.sort(new Comparator<Date>(){

                @Override
                public int compare(Date o1, Date o2) {
                    return o1.compareTo(o2);
                }
            });
        }
        List<DynamicObject> swapList_final = YieldCurveHelper.preDeal_SwapAndBond("Swap", bootstrap, bondDealType, referdate, workcalendar, (DynamicObject[])wc, swapList_input, dateList);
        for (int i = 0; i < swapList_final.size(); ++i) {
            YieldCurveHelper.dealFintool_Swap(bootstrap, bondDealType, interpType, referdate, swapList_final.get(i), firstRow, workcalendar, (DynamicObject[])wc, result, dateList);
            dateList.sort(new Comparator<Date>(){

                @Override
                public int compare(Date o1, Date o2) {
                    return o1.compareTo(o2);
                }
            });
        }
        List<DynamicObject> bondList_final = YieldCurveHelper.preDeal_SwapAndBond("Bond", bootstrap, bondDealType, referdate, workcalendar, (DynamicObject[])wc, bondList_input, dateList);
        for (int i = 0; i < bondList_final.size(); ++i) {
            DynamicObject bond = bondList_final.get(i);
            YieldCurveHelper.dealFintool_Bond(bootstrap, bondDealType, interpType, referdate, bond, firstRow, workcalendar, (DynamicObject[])wc, result, dateList);
            dateList.sort(new Comparator<Date>(){

                @Override
                public int compare(Date o1, Date o2) {
                    return o1.compareTo(o2);
                }
            });
        }
    }

    private static void getDate_i_List(String bondDealType, Date referdate, DynamicObject row, DynamicObjectCollection workcalendar, int N, String mod, List<Date> dateList_i) {
        BigDecimal couponRate = row.getBigDecimal("couponrate_fin");
        couponRate = couponRate.divide(Constants.ONE_HUNDRED);
        String freq = row.getString("freq_fin");
        String adjMethod = row.getString("adjmethod_fin");
        Date enddate = row.getDate("enddate_fin");
        int rateOffset = row.getInt("rateoffset_fin");
        boolean hasCouponRate = couponRate.compareTo(BigDecimal.ZERO) > 0;
        AdjustMethodEnum adjustMethodEnum = AdjustMethodEnum.valueOf(adjMethod);
        String fintool = row.getString("fintool_fin");
        String term = row.getString("term_fin");
        PayFrequeEnum frequeEnum = PayFrequeEnum.year;
        if (EmptyUtil.isNoEmpty(freq)) {
            frequeEnum = PayFrequeEnum.valueOf(freq);
        }
        Date referDateWithOffset = TradeBusinessHelper.callSettleDelayDate(workcalendar, referdate, rateOffset);
        for (int i = 1; i < N + 1; ++i) {
            Date date_i;
            if (TradeToolEnum.isBond(fintool) && !hasCouponRate) {
                date_i = BondDealTypeEnum.isSwap(bondDealType) ? TermUtils.getDateByTerm(term, referDateWithOffset) : enddate;
            } else if (BondDealTypeEnum.isSwap(bondDealType) || TradeToolEnum.isSwap(fintool)) {
                date_i = referDateWithOffset;
                date_i = "0d".equals(mod) || "0m0d".equals(mod) ? TcDateUtils.getNextMonth(date_i, i * 12 / frequeEnum.getFreque()) : TcDateUtils.getNextMonth(TermUtils.getDateByTerm(mod, date_i), (i - 1) * 12 / frequeEnum.getFreque());
            } else {
                date_i = TcDateUtils.getLastMonth(enddate, (N - i) * 12 / frequeEnum.getFreque());
            }
            date_i = TradeBusinessHelper.callAdjustSettleDate(workcalendar, date_i, adjustMethodEnum);
            dateList_i.add(date_i);
        }
    }

    protected static void dealFintool_Bond(String bootstrap, String bondDealType, String interpType, Date referdate, DynamicObject row, DynamicObject firstRow, DynamicObjectCollection workcalendar, DynamicObject[] wc, Map<Date, BigDecimal> result, List<Date> dateList) {
        int n;
        BigDecimal df_i;
        BigDecimal midRate = row.getBigDecimal("midrate_fin");
        midRate = midRate.divide(Constants.ONE_HUNDRED);
        BigDecimal couponRate = row.getBigDecimal("couponrate_fin");
        couponRate = couponRate.divide(Constants.ONE_HUNDRED);
        BigDecimal bondPrice = row.getBigDecimal("price_fin");
        String term = row.getString("term_fin");
        String freq = row.getString("freq_fin");
        String basis = row.getString("basis_fin");
        String adjMethod = row.getString("adjmethod_fin");
        Date enddate = row.getDate("enddate_fin");
        int rateOffset = row.getInt("rateoffset_fin");
        Boolean isnewAdd = row.getBoolean("isnewadd_fin");
        boolean hasCouponRate = couponRate.compareTo(BigDecimal.ZERO) > 0;
        BasisEnum basisEnum = BasisEnum.valueOf(basis);
        PayFrequeEnum frequeEnum = PayFrequeEnum.year;
        Date referdateOffset = TradeBusinessHelper.callSettleDelayDate(workcalendar, referdate, rateOffset);
        if (hasCouponRate) {
            frequeEnum = PayFrequeEnum.valueOf(freq);
        }
        int N = 1;
        String mod = "0d";
        if (BondDealTypeEnum.isBond(bondDealType)) {
            int days = TradeBusinessHelper.getBasis_BetweenDay(referdateOffset, enddate, BasisEnum.SIA_30_360, wc);
            term = TermUtils.getFormatStr(days / 360, days % 360 / 30, days % 360 % 30);
            if (!isnewAdd.booleanValue()) {
                BigDecimal oldPrice = bondPrice;
                bondPrice = YieldCurveHelper.bond_CalBondPrice(bondDealType, couponRate, midRate, frequeEnum, basisEnum, term, referdateOffset, enddate);
                bondPrice = bondPrice.setScale(row.getBigDecimal("price_fin").scale(), RoundingMode.HALF_UP);
                logger.info("\u503a\u5238\u5269\u4f59\u671f\u9650\u6cd5\u91cd\u65b0\u8ba1\u7b97\u503a\u5238\u4ef7\u683c,\u503a\u5238\u671f\u9650{}, \u8ba1\u7b97\u524d\u4ef7\u683c:{}, \u8ba1\u7b97\u540e\u4ef7\u683c:{}, \u662f\u5426\u4e3a\u9884\u5904\u7406\u63d2\u5165:{}", new Object[]{term, oldPrice, bondPrice, isnewAdd});
            }
        }
        if (hasCouponRate) {
            N = YieldCurveHelper.getN(term, frequeEnum);
            mod = YieldCurveHelper.getMod(term, frequeEnum);
        }
        HashMap<Date, BigDecimal> date_i_df_i = new HashMap<Date, BigDecimal>(N);
        HashMap<Date, BigDecimal> date_i_y_i = new HashMap<Date, BigDecimal>(N);
        Date d0 = referdateOffset;
        BigDecimal df0 = BigDecimal.ONE;
        if (rateOffset != 0) {
            df0 = YieldCurveHelper.getDF_delay(d0, bondDealType, firstRow, referdate, workcalendar, wc, dateList, result);
        }
        date_i_df_i.put(d0, df0);
        date_i_y_i.put(d0, BigDecimal.ONE);
        ArrayList<Date> dateList_i = new ArrayList<Date>(N);
        dateList_i.add(d0);
        YieldCurveHelper.getDate_i_List(bondDealType, referdate, row, workcalendar, N, mod, dateList_i);
        Date compareStartDate = referdateOffset;
        Date compareEndDate = referdateOffset;
        boolean isBetween = false;
        if (EmptyUtil.isNoEmpty(dateList)) {
            if (dateList.size() > 1) {
                isBetween = true;
            }
            compareStartDate = dateList.get(0);
            compareEndDate = dateList.get(dateList.size() - 1);
        }
        ArrayList<String> logList = new ArrayList<String>(N + 1);
        for (int i = 1; i < N + 1; ++i) {
            Date date_i = (Date)dateList_i.get(i);
            if (date_i.before(compareStartDate)) {
                Date da = compareStartDate;
                df_i = YieldCurveHelper.calDF_DailyForward(date_i, referdate, BigDecimal.ONE, da, result.get(da), wc, basisEnum);
                Date date_last = (Date)dateList_i.get(i - 1);
                BigDecimal df_last = (BigDecimal)date_i_df_i.get(date_last);
                BigDecimal y_i = YieldCurveHelper.getFWDRate_between(date_last, date_i, df_last, df_i, basisEnum, wc);
                date_i_y_i.put(date_i, y_i);
                date_i_df_i.put(date_i, df_i);
                boolean added = YieldCurveHelper.addToDfResultList(result, dateList, date_i, df_i);
                logList.add(String.format("Di<Da:[di=%tF, yi=%s, dfi=%s, price=%s,cprate=%s, indefarray=%s] ", date_i, y_i, df_i, bondPrice, couponRate, !added));
                continue;
            }
            if (!isBetween || date_i.after(compareEndDate)) continue;
            BigDecimal df_i2 = YieldCurveHelper.getDF_between(interpType, referdate, date_i, wc, dateList, result, basisEnum);
            Date date_last = (Date)dateList_i.get(i - 1);
            BigDecimal df_last = (BigDecimal)date_i_df_i.get(date_last);
            BigDecimal y_i = YieldCurveHelper.getFWDRate_between(date_last, date_i, df_last, df_i2, basisEnum, wc);
            date_i_y_i.put(date_i, y_i);
            date_i_df_i.put(date_i, df_i2);
            boolean added = YieldCurveHelper.addToDfResultList(result, dateList, date_i, df_i2);
            logList.add(String.format("Da<Di<Db:[di=%tF, yi=%s, dfi=%s, price=%s,cprate=%s, indefarray=%s] ", date_i, y_i, df_i2, bondPrice, couponRate, !added));
        }
        N = dateList_i.size() - 1;
        int other_N = N - (n = date_i_y_i.size() - 1);
        if (other_N != 0 && hasCouponRate) {
            Date date_last;
            Date date_i;
            BigDecimal df_i3;
            Date date_i2;
            BigDecimal h;
            BigDecimal sum;
            if (bootstrap.equals("OnForward")) {
                sum = BigDecimal.ZERO;
                h = BigDecimal.ZERO;
                if (hasCouponRate) {
                    h = BigDecimal.valueOf(frequeEnum.getFreque());
                    for (int i = 1; i < date_i_df_i.size(); ++i) {
                        date_i2 = (Date)dateList_i.get(i);
                        df_i3 = (BigDecimal)date_i_df_i.get(date_i2);
                        sum = sum.add(df_i3.multiply(couponRate).multiply(Constants.ONE_HUNDRED).divide(h, 15, 4));
                    }
                }
                BigDecimal rLeft = midRate.subtract(BigDecimal.valueOf(0.5));
                BigDecimal rRight = midRate.add(BigDecimal.valueOf(0.5));
                BigDecimal d_yn_Left = YieldCurveHelper.calD_yN_OnForward_Bond(N, date_i_df_i, date_i_y_i, dateList_i, basisEnum, wc, rLeft, couponRate, sum, bondPrice, h);
                BigDecimal d_yn_Right = YieldCurveHelper.calD_yN_OnForward_Bond(N, date_i_df_i, date_i_y_i, dateList_i, basisEnum, wc, rRight, couponRate, sum, bondPrice, h);
                BigDecimal scale = BigDecimal.valueOf(1.0E-9);
                BigDecimal two = BigDecimal.valueOf(2L);
                BigDecimal yN_temp = BigDecimal.ZERO;
                int count = 100;
                while (count > 0 && d_yn_Left.multiply(d_yn_Right).compareTo(BigDecimal.ZERO) < 0 && rLeft.subtract(rRight).abs().compareTo(scale) > 0) {
                    --count;
                    yN_temp = rLeft.add(rRight).divide(two, 15, 4);
                    BigDecimal d_yN_temp = YieldCurveHelper.calD_yN_OnForward_Bond(N, date_i_df_i, date_i_y_i, dateList_i, basisEnum, wc, yN_temp, couponRate, sum, bondPrice, h);
                    if (d_yN_temp.compareTo(BigDecimal.ZERO) == 0) break;
                    if (d_yn_Left.multiply(d_yN_temp).compareTo(BigDecimal.ZERO) < 0) {
                        rRight = yN_temp;
                        d_yn_Right = d_yN_temp;
                    }
                    if (d_yn_Right.multiply(d_yN_temp).compareTo(BigDecimal.ZERO) >= 0) continue;
                    rLeft = yN_temp;
                    d_yn_Left = d_yN_temp;
                }
                if (count != 100) {
                    for (int i = date_i_y_i.size(); i < N + 1; ++i) {
                        BigDecimal y_i;
                        date_i = (Date)dateList_i.get(i);
                        date_last = (Date)dateList_i.get(i - 1);
                        BigDecimal y_last = (BigDecimal)date_i_y_i.get(date_last);
                        if (n == 0) {
                            y_i = yN_temp;
                        } else {
                            int d_i_i_1 = TradeBusinessHelper.getBasis_BetweenDay((Date)dateList_i.get(i - 2), date_last, basisEnum, wc);
                            int d_N_i_1 = TradeBusinessHelper.getBasis_BetweenDay((Date)dateList_i.get(i - 2), (Date)dateList_i.get(dateList_i.size() - 2), basisEnum, wc);
                            y_i = y_last.add(yN_temp.subtract(y_last).multiply(BigDecimal.valueOf(d_i_i_1)).divide(BigDecimal.valueOf(d_N_i_1), 15, 4));
                        }
                        date_i_y_i.put(date_i, y_i);
                        BigDecimal df_last = (BigDecimal)date_i_df_i.get(date_last);
                        BigDecimal dfbasis = TradeBusinessHelper.getBaseBasis(date_last, date_i, basisEnum, wc, null, null);
                        BigDecimal df_i4 = df_last.divide(BigDecimal.ONE.add(y_i.multiply(dfbasis)), 15, 4);
                        date_i_df_i.put(date_i, df_i4);
                        boolean added = YieldCurveHelper.addToDfResultList(result, dateList, date_i, df_i4);
                        logList.add(String.format("Bisection:[di=%tF, yi=%s, dfi=%s, price=%s,cprate=%s,indfarray=%s]", date_i, y_i, df_i4, bondPrice, couponRate, !added));
                    }
                }
            }
            if (bootstrap.equals("OnYield")) {
                sum = BigDecimal.ZERO;
                h = BigDecimal.ZERO;
                if (hasCouponRate) {
                    h = BigDecimal.valueOf(frequeEnum.getFreque());
                    sum = BigDecimal.ZERO;
                    for (int i = 1; i < date_i_df_i.size(); ++i) {
                        date_i2 = (Date)dateList_i.get(i);
                        df_i3 = (BigDecimal)date_i_df_i.get(date_i2);
                        sum = sum.add(df_i3.multiply(couponRate).multiply(Constants.ONE_HUNDRED).divide(h, 15, 4));
                    }
                }
                for (int i = date_i_df_i.size(); i < N + 1; ++i) {
                    BigDecimal rLeft = midRate.subtract(BigDecimal.valueOf(0.5));
                    BigDecimal rRight = midRate.add(BigDecimal.valueOf(0.5));
                    BigDecimal d_yn_Left = YieldCurveHelper.calD_yN_OnYield_Bond(date_i_df_i, dateList_i, basisEnum, wc, rLeft, sum, couponRate, bondPrice, h);
                    BigDecimal d_yn_Right = YieldCurveHelper.calD_yN_OnYield_Bond(date_i_df_i, dateList_i, basisEnum, wc, rRight, sum, couponRate, bondPrice, h);
                    BigDecimal scale = BigDecimal.valueOf(1.0E-9);
                    BigDecimal two = BigDecimal.valueOf(2L);
                    BigDecimal yN_temp = BigDecimal.ZERO;
                    int count = 100;
                    while (count > 0 && d_yn_Left.multiply(d_yn_Right).compareTo(BigDecimal.ZERO) < 0 && rLeft.subtract(rRight).abs().compareTo(scale) > 0) {
                        --count;
                        yN_temp = rLeft.add(rRight).divide(two, 15, 4);
                        BigDecimal d_yN_temp = YieldCurveHelper.calD_yN_OnYield_Bond(date_i_df_i, dateList_i, basisEnum, wc, yN_temp, sum, couponRate, bondPrice, h);
                        if (d_yN_temp.compareTo(BigDecimal.ZERO) == 0) break;
                        if (d_yn_Left.multiply(d_yN_temp).compareTo(BigDecimal.ZERO) < 0) {
                            rRight = yN_temp;
                            d_yn_Right = d_yN_temp;
                        }
                        if (d_yn_Right.multiply(d_yN_temp).compareTo(BigDecimal.ZERO) >= 0) continue;
                        rLeft = yN_temp;
                        d_yn_Left = d_yN_temp;
                    }
                    if (count == 100) continue;
                    date_i = (Date)dateList_i.get(date_i_df_i.size());
                    date_last = (Date)dateList_i.get(date_i_df_i.size() - 1);
                    BigDecimal df_last = (BigDecimal)date_i_df_i.get(date_last);
                    BigDecimal dfbasis = TradeBusinessHelper.getBaseBasis(date_last, date_i, basisEnum, wc, null, null);
                    BigDecimal df_i5 = df_last.divide(BigDecimal.ONE.add(yN_temp.multiply(dfbasis)), 15, 4);
                    date_i_df_i.put(date_i, df_i5);
                    boolean added = YieldCurveHelper.addToDfResultList(result, dateList, date_i, df_i5);
                    if (hasCouponRate) {
                        sum = sum.add(df_i5.multiply(couponRate).multiply(Constants.ONE_HUNDRED).divide(h, 15, 4));
                    }
                    logList.add(String.format("Bisection:[di=%tF, yi=%s, dfi=%s, price=%s,cprate=%s,indfarray=%s]", date_i, yN_temp, df_i5, bondPrice, couponRate, !added));
                }
            }
        }
        if (other_N != 0 && !hasCouponRate) {
            Date date_i = (Date)dateList_i.get(dateList_i.size() - 1);
            df_i = bondPrice.divide(Constants.ONE_HUNDRED);
            YieldCurveHelper.addToDfResultList(result, dateList, date_i, df_i);
        }
        YieldCurveHelper.logDFYP("Bond", term, logList);
    }

    private static void logDFYP(String type, String term, List<String> logs) {
        StringBuilder sb = new StringBuilder();
        for (String line : logs) {
            sb.append(line).append("\n");
        }
        logger.info("{},{},di-yi-dfi:{}", new Object[]{type, term, sb.toString()});
    }

    private static boolean addToDfResultList(Map<Date, BigDecimal> result, List<Date> dateList, Date date_i, BigDecimal df_i) {
        boolean b = true;
        if (!result.containsKey(date_i)) {
            result.put(date_i, df_i);
        } else {
            b = false;
        }
        if (!dateList.contains(date_i)) {
            dateList.add(date_i);
            dateList.sort((o1, o2) -> o1.compareTo((Date)o2));
        }
        return b;
    }

    private static BigDecimal calD_yN_OnForward_Bond(int N, Map<Date, BigDecimal> date_i_df_i, Map<Date, BigDecimal> date_i_y_i, List<Date> dateList_i, BasisEnum basisEnum, DynamicObject[] wc, BigDecimal y_N, BigDecimal couponRate, BigDecimal sum, BigDecimal bondPrice, BigDecimal h) {
        int i;
        HashMap<Date, BigDecimal> tempDF = new HashMap<Date, BigDecimal>(N);
        tempDF.putAll(date_i_df_i);
        HashMap<Date, BigDecimal> tempYi = new HashMap<Date, BigDecimal>(N);
        tempYi.putAll(date_i_y_i);
        int n = date_i_y_i.size() - 1;
        for (i = date_i_y_i.size(); i < N + 1; ++i) {
            BigDecimal y_i;
            Date date_i = dateList_i.get(i);
            Date date_last = dateList_i.get(i - 1);
            BigDecimal y_last = (BigDecimal)tempYi.get(date_last);
            if (n == 0 || i == N) {
                y_i = y_N;
            } else {
                int d_before = TradeBusinessHelper.getBasis_BetweenDay(dateList_i.get(i - 2), date_last, basisEnum, wc);
                int d_after = TradeBusinessHelper.getBasis_BetweenDay(dateList_i.get(i - 2), dateList_i.get(dateList_i.size() - 2), basisEnum, wc);
                y_i = y_last.add(y_N.subtract(y_last).multiply(BigDecimal.valueOf(d_before)).divide(BigDecimal.valueOf(d_after), 15, 4));
            }
            tempYi.put(date_i, y_i);
            BigDecimal df_last = (BigDecimal)tempDF.get(date_last);
            BigDecimal basis = TradeBusinessHelper.getBaseBasis(date_last, date_i, basisEnum, wc, null, null);
            BigDecimal df_i = df_last.divide(BigDecimal.ONE.add(y_i.multiply(basis)), 15, 4);
            tempDF.put(date_i, df_i);
        }
        if (couponRate.compareTo(BigDecimal.ZERO) > 0) {
            for (i = date_i_df_i.size(); i < tempDF.size(); ++i) {
                sum = sum.add(((BigDecimal)tempDF.get(dateList_i.get(i))).multiply(couponRate).multiply(Constants.ONE_HUNDRED).divide(h, 15, 4));
            }
        }
        BigDecimal zn = ((BigDecimal)tempDF.get(dateList_i.get(dateList_i.size() - 1))).multiply(Constants.ONE_HUNDRED);
        BigDecimal d_yn = bondPrice.subtract(sum).subtract(zn);
        return d_yn;
    }

    private static BigDecimal calD_yN_OnYield_Bond(Map<Date, BigDecimal> date_i_df_i, List<Date> dateList_i, BasisEnum basisEnum, DynamicObject[] wc, BigDecimal y_N, BigDecimal sum, BigDecimal couponRate, BigDecimal bondPrice, BigDecimal h) {
        int dealIndex = date_i_df_i.size();
        Date date_i = dateList_i.get(dealIndex);
        Date date_last = dateList_i.get(dealIndex - 1);
        BigDecimal df_last = date_i_df_i.get(date_last);
        BigDecimal basis = TradeBusinessHelper.getBaseBasis(date_last, date_i, basisEnum, wc, null, null);
        BigDecimal df_i = df_last.divide(BigDecimal.ONE.add(y_N.multiply(basis)), 15, 4);
        if (couponRate.compareTo(BigDecimal.ZERO) > 0) {
            sum = sum.add(df_i.multiply(couponRate).multiply(Constants.ONE_HUNDRED).divide(h, 15, 4));
        }
        return bondPrice.subtract(sum).subtract(df_i.multiply(Constants.ONE_HUNDRED));
    }

    protected static void dealFintool_Swap(String bootstrap, String bondDealType, String interpType, Date referdate, DynamicObject row, DynamicObject firstRow, DynamicObjectCollection workcalendar, DynamicObject[] wc, Map<Date, BigDecimal> result, List<Date> dateList) {
        int n;
        BigDecimal df0;
        Date d0;
        BigDecimal midRate = row.getBigDecimal("midrate_fin");
        midRate = midRate.divide(Constants.ONE_HUNDRED);
        String term = row.getString("term_fin");
        String freq = row.getString("freq_fin");
        String basisS = row.getString("basis_fin");
        String adjMethod = row.getString("adjmethod_fin");
        int rateOffset = row.getInt("rateoffset_fin");
        BasisEnum basisEnum = BasisEnum.valueOf(basisS);
        PayFrequeEnum frequeEnum = PayFrequeEnum.valueOf(freq);
        int N = YieldCurveHelper.getN(term, frequeEnum);
        String mod = YieldCurveHelper.getMod(term, frequeEnum);
        HashMap<Date, BigDecimal> date_i_df_i = new HashMap<Date, BigDecimal>(N);
        HashMap<Date, BigDecimal> date_i_y_i = new HashMap<Date, BigDecimal>(N);
        ArrayList<Date> dateList_i = new ArrayList<Date>(N);
        if (rateOffset == 0) {
            d0 = referdate;
            df0 = BigDecimal.ONE;
        } else {
            d0 = TradeBusinessHelper.callSettleDelayDate(workcalendar, referdate, rateOffset);
            df0 = YieldCurveHelper.getDF_delay(d0, bondDealType, firstRow, referdate, workcalendar, wc, dateList, result);
        }
        date_i_df_i.put(d0, df0);
        date_i_y_i.put(d0, BigDecimal.ZERO);
        dateList_i.add(d0);
        YieldCurveHelper.getDate_i_List(bondDealType, referdate, row, workcalendar, N, mod, dateList_i);
        Date compareStartDate = d0;
        Date compareEndDate = d0;
        boolean isBetween = false;
        if (EmptyUtil.isNoEmpty(dateList)) {
            if (dateList.size() > 1) {
                isBetween = true;
            }
            compareStartDate = dateList.get(0);
            compareEndDate = dateList.get(dateList.size() - 1);
        }
        ArrayList<String> logList = new ArrayList<String>(N + 1);
        for (int i = 1; i < N + 1; ++i) {
            boolean added;
            BigDecimal y_i;
            BigDecimal df_last;
            Date date_last;
            BigDecimal df_i;
            Date date_i = (Date)dateList_i.get(i);
            if (date_i.before(compareStartDate)) {
                df_i = YieldCurveHelper.calDF_DailyForward(date_i, referdate, BigDecimal.ONE, compareStartDate, result.get(compareStartDate), wc, basisEnum);
                date_last = (Date)dateList_i.get(i - 1);
                df_last = (BigDecimal)date_i_df_i.get(date_last);
                y_i = YieldCurveHelper.getFWDRate_between(date_last, date_i, df_last, df_i, basisEnum, wc);
                date_i_y_i.put(date_i, y_i);
                date_i_df_i.put(date_i, df_i);
                added = YieldCurveHelper.addToDfResultList(result, dateList, date_i, df_i);
                logList.add(String.format("Di<Da:[di=%tF, yi=%s, dfi=%s, indefarray=%s] ", date_i, y_i, df_i, !added));
                continue;
            }
            if (!isBetween || date_i.after(compareEndDate)) continue;
            df_i = YieldCurveHelper.getDF_between(interpType, referdate, date_i, wc, dateList, result, basisEnum);
            date_last = (Date)dateList_i.get(i - 1);
            df_last = (BigDecimal)date_i_df_i.get(date_last);
            y_i = YieldCurveHelper.getFWDRate_between(date_last, date_i, df_last, df_i, basisEnum, wc);
            date_i_y_i.put(date_i, y_i);
            date_i_df_i.put(date_i, df_i);
            added = YieldCurveHelper.addToDfResultList(result, dateList, date_i, df_i);
            logList.add(String.format("Da<Di<Db:[di=%tF, yi=%s, dfi=%s,indefarray=%s] ", date_i, y_i, df_i, !added));
        }
        N = dateList_i.size() - 1;
        int other_N = N - (n = date_i_y_i.size() - 1);
        if (other_N != 0) {
            Date date_last;
            Date date_i;
            BigDecimal tempBasis;
            BigDecimal sum;
            if (bootstrap.equals("OnForward")) {
                sum = BigDecimal.ZERO;
                for (int i = 1; i < date_i_df_i.size(); ++i) {
                    tempBasis = TradeBusinessHelper.getBaseBasis((Date)dateList_i.get(i - 1), (Date)dateList_i.get(i), basisEnum, wc, null, null);
                    sum = sum.add(((BigDecimal)date_i_df_i.get(dateList_i.get(i))).multiply(tempBasis));
                }
                BigDecimal rLeft = midRate.subtract(BigDecimal.valueOf(0.5));
                BigDecimal rRight = midRate.add(BigDecimal.valueOf(0.5));
                BigDecimal d_yn_Left = YieldCurveHelper.calD_yN_OnForward_Swap(N, date_i_df_i, date_i_y_i, dateList_i, basisEnum, wc, midRate, rLeft, sum);
                BigDecimal d_yn_Right = YieldCurveHelper.calD_yN_OnForward_Swap(N, date_i_df_i, date_i_y_i, dateList_i, basisEnum, wc, midRate, rRight, sum);
                BigDecimal scale = BigDecimal.valueOf(1.0E-11);
                BigDecimal two = BigDecimal.valueOf(2L);
                BigDecimal yN_temp = BigDecimal.ZERO;
                BigDecimal d_yN_temp = BigDecimal.ZERO;
                int count = 100;
                while (count > 0 && d_yn_Left.multiply(d_yn_Right).compareTo(BigDecimal.ZERO) < 0 && rLeft.subtract(rRight).abs().compareTo(scale) > 0) {
                    --count;
                    yN_temp = rLeft.add(rRight).divide(two, 15, 4);
                    d_yN_temp = YieldCurveHelper.calD_yN_OnForward_Swap(N, date_i_df_i, date_i_y_i, dateList_i, basisEnum, wc, midRate, yN_temp, sum);
                    if (d_yN_temp.compareTo(BigDecimal.ZERO) == 0) break;
                    if (d_yn_Left.multiply(d_yN_temp).compareTo(BigDecimal.ZERO) < 0) {
                        rRight = yN_temp;
                        d_yn_Right = d_yN_temp;
                    }
                    if (d_yn_Right.multiply(d_yN_temp).compareTo(BigDecimal.ZERO) >= 0) continue;
                    rLeft = yN_temp;
                    d_yn_Left = d_yN_temp;
                }
                if (count != 100) {
                    for (int i = date_i_y_i.size(); i < N + 1; ++i) {
                        BigDecimal y_i;
                        date_i = (Date)dateList_i.get(i);
                        date_last = (Date)dateList_i.get(i - 1);
                        BigDecimal y_last = (BigDecimal)date_i_y_i.get(date_last);
                        if (n == 0) {
                            y_i = yN_temp;
                        } else {
                            int d_i_i_1 = TradeBusinessHelper.getBasis_BetweenDay((Date)dateList_i.get(i - 2), date_last, basisEnum, wc);
                            int d_N_i_1 = TradeBusinessHelper.getBasis_BetweenDay((Date)dateList_i.get(i - 2), (Date)dateList_i.get(dateList_i.size() - 2), basisEnum, wc);
                            y_i = y_last.add(yN_temp.subtract(y_last).multiply(BigDecimal.valueOf(d_i_i_1)).divide(BigDecimal.valueOf(d_N_i_1), 15, 4));
                        }
                        date_i_y_i.put(date_i, y_i);
                        BigDecimal df_last = (BigDecimal)date_i_df_i.get(date_last);
                        BigDecimal basis = TradeBusinessHelper.getBaseBasis(date_last, date_i, basisEnum, wc, null, null);
                        BigDecimal df_i = df_last.divide(BigDecimal.ONE.add(y_i.multiply(basis)), 15, 4);
                        date_i_df_i.put(date_i, df_i);
                        boolean added = YieldCurveHelper.addToDfResultList(result, dateList, date_i, df_i);
                        logList.add(String.format("Bisection:[di=%tF, yi=%s, dfi=%s,indfarray=%s]", date_i, y_i, df_i, !added));
                    }
                }
            }
            if (bootstrap.equals("OnYield")) {
                int i;
                tempBasis = BigDecimal.ZERO;
                sum = BigDecimal.ZERO;
                for (i = 1; i < date_i_df_i.size(); ++i) {
                    tempBasis = TradeBusinessHelper.getBaseBasis((Date)dateList_i.get(i - 1), (Date)dateList_i.get(i), basisEnum, wc, null, null);
                    sum = sum.add(((BigDecimal)date_i_df_i.get(dateList_i.get(i))).multiply(tempBasis));
                }
                for (i = date_i_df_i.size(); i < N + 1; ++i) {
                    BigDecimal rLeft = midRate.subtract(BigDecimal.valueOf(0.5));
                    BigDecimal rRight = midRate.add(BigDecimal.valueOf(0.5));
                    BigDecimal d_yn_Left = YieldCurveHelper.calD_yN_OnYield_Swap(date_i_df_i, dateList_i, basisEnum, wc, midRate, rLeft, sum);
                    BigDecimal d_yn_Right = YieldCurveHelper.calD_yN_OnYield_Swap(date_i_df_i, dateList_i, basisEnum, wc, midRate, rRight, sum);
                    BigDecimal scale = BigDecimal.valueOf(1.0E-9);
                    BigDecimal two = BigDecimal.valueOf(2L);
                    BigDecimal yN_temp = BigDecimal.ZERO;
                    BigDecimal d_yN_temp = BigDecimal.ZERO;
                    int count = 100;
                    while (count > 0 && d_yn_Left.multiply(d_yn_Right).compareTo(BigDecimal.ZERO) < 0 && rLeft.subtract(rRight).abs().compareTo(scale) > 0) {
                        --count;
                        yN_temp = rLeft.add(rRight).divide(two, 15, 4);
                        d_yN_temp = YieldCurveHelper.calD_yN_OnYield_Swap(date_i_df_i, dateList_i, basisEnum, wc, midRate, yN_temp, sum);
                        if (d_yN_temp.compareTo(BigDecimal.ZERO) == 0) break;
                        if (d_yn_Left.multiply(d_yN_temp).compareTo(BigDecimal.ZERO) < 0) {
                            rRight = yN_temp;
                            d_yn_Right = d_yN_temp;
                        }
                        if (d_yn_Right.multiply(d_yN_temp).compareTo(BigDecimal.ZERO) >= 0) continue;
                        rLeft = yN_temp;
                        d_yn_Left = d_yN_temp;
                    }
                    if (count == 100) continue;
                    date_i = (Date)dateList_i.get(date_i_df_i.size());
                    date_last = (Date)dateList_i.get(date_i_df_i.size() - 1);
                    BigDecimal df_last = (BigDecimal)date_i_df_i.get(date_last);
                    BigDecimal basis = TradeBusinessHelper.getBaseBasis(date_last, date_i, basisEnum, wc, null, null);
                    BigDecimal df_i = df_last.divide(BigDecimal.ONE.add(yN_temp.multiply(basis)), 15, 4);
                    date_i_df_i.put(date_i, df_i);
                    boolean added = YieldCurveHelper.addToDfResultList(result, dateList, date_i, df_i);
                    logList.add(String.format("Bisection:[di=%tF, yi=%s, dfi=%s,indfarray=%s]", date_i, yN_temp, df_i, !added));
                    sum = sum.add(df_i.multiply(TradeBusinessHelper.getBaseBasis(date_last, date_i, basisEnum, wc, null, null)));
                }
            }
        }
        YieldCurveHelper.logDFYP("Swap", term, logList);
    }

    private static BigDecimal calD_yN_OnYield_Swap(Map<Date, BigDecimal> date_i_df_i, List<Date> dateList_i, BasisEnum basisEnum, DynamicObject[] wc, BigDecimal midRate, BigDecimal y_N, BigDecimal sum) {
        int dealIndex = date_i_df_i.size();
        Date date_i = dateList_i.get(dealIndex);
        Date date_last = dateList_i.get(dealIndex - 1);
        BigDecimal df_last = date_i_df_i.get(date_last);
        BigDecimal basis = TradeBusinessHelper.getBaseBasis(date_last, date_i, basisEnum, wc, null, null);
        BigDecimal df_i = df_last.divide(BigDecimal.ONE.add(y_N.multiply(basis)), 15, 4);
        BigDecimal df0 = date_i_df_i.get(dateList_i.get(0));
        return df0.subtract(df_i).divide(sum.add(df_i.multiply(basis)), 15, 4).subtract(midRate);
    }

    private static BigDecimal calD_yN_OnForward_Swap(int N, Map<Date, BigDecimal> date_i_df_i, Map<Date, BigDecimal> date_i_y_i, List<Date> dateList_i, BasisEnum basisEnum, DynamicObject[] wc, BigDecimal midRate, BigDecimal y_N, BigDecimal sum) {
        int i;
        HashMap<Date, BigDecimal> tempDF = new HashMap<Date, BigDecimal>(N);
        tempDF.putAll(date_i_df_i);
        HashMap<Date, BigDecimal> tempYi = new HashMap<Date, BigDecimal>(N);
        tempYi.putAll(date_i_y_i);
        int n = date_i_y_i.size() - 1;
        for (i = date_i_y_i.size(); i < N + 1; ++i) {
            BigDecimal y_i;
            Date date_i = dateList_i.get(i);
            Date date_last = dateList_i.get(i - 1);
            BigDecimal y_last = (BigDecimal)tempYi.get(date_last);
            if (n == 0 || i == N) {
                y_i = y_N;
            } else {
                int d_before = TradeBusinessHelper.getBasis_BetweenDay(dateList_i.get(i - 2), date_last, basisEnum, wc);
                int d_after = TradeBusinessHelper.getBasis_BetweenDay(dateList_i.get(i - 2), dateList_i.get(dateList_i.size() - 2), basisEnum, wc);
                y_i = y_last.add(y_N.subtract(y_last).multiply(BigDecimal.valueOf(d_before)).divide(BigDecimal.valueOf(d_after), 15, 4));
            }
            tempYi.put(date_i, y_i);
            BigDecimal df_last = (BigDecimal)tempDF.get(date_last);
            BigDecimal basis = TradeBusinessHelper.getBaseBasis(date_last, date_i, basisEnum, wc, null, null);
            BigDecimal df_i = df_last.divide(BigDecimal.ONE.add(y_i.multiply(basis)), 15, 4);
            tempDF.put(date_i, df_i);
        }
        for (i = date_i_df_i.size(); i < tempDF.size(); ++i) {
            sum = sum.add(((BigDecimal)tempDF.get(dateList_i.get(i))).multiply(TradeBusinessHelper.getBaseBasis(dateList_i.get(i - 1), dateList_i.get(i), basisEnum, wc, null, null)));
        }
        Date date_N = dateList_i.get(dateList_i.size() - 1);
        BigDecimal df_N = (BigDecimal)tempDF.get(date_N);
        BigDecimal df0 = (BigDecimal)tempDF.get(dateList_i.get(0));
        BigDecimal d_yn = df0.subtract(df_N).divide(sum, 15, 4).subtract(midRate);
        return d_yn;
    }

    protected static void dealFintool_FRA(String interpType, Date referdate, DynamicObject row, DynamicObjectCollection workcalendar, DynamicObject[] wc, Map<Date, BigDecimal> result, List<Map<String, Object>> dateList_FRA, List<Date> dateList_cash, List<Date> dateList) {
        BigDecimal midRate = row.getBigDecimal("midrate_fin");
        midRate = midRate.divide(Constants.ONE_HUNDRED);
        String term = row.getString("term_fin");
        String basis = row.getString("basis_fin");
        String FRA = row.getString("fra_fin");
        String adjMethod = row.getString("adjmethod_fin");
        int rateOffset = row.getInt("rateoffset_fin");
        BasisEnum basisEnum = BasisEnum.valueOf(basis);
        AdjustMethodEnum adjustMethodEnum = AdjustMethodEnum.valueOf(adjMethod);
        int N = Integer.parseInt(FRA.split("-")[0]);
        Date date1 = TradeBusinessHelper.callSettleDelayDate(workcalendar, referdate, rateOffset);
        date1 = TcDateUtils.getNextMonth(date1, N);
        date1 = TradeBusinessHelper.callAdjustSettleDate(workcalendar, date1, adjustMethodEnum);
        Date date2 = TermUtils.getDateByTerm(term, date1);
        date2 = TradeBusinessHelper.callAdjustSettleDate(workcalendar, date2, adjustMethodEnum);
        YieldCurveHelper.deal_oneFintoolBuildTwoDate(interpType, referdate, date1, date2, midRate, basisEnum, wc, result, dateList_FRA, dateList_cash, dateList);
    }

    private static void deal_oneFintoolBuildTwoDate(String interpType, Date referdate, Date date1, Date date2, BigDecimal midRate, BasisEnum basisEnum, DynamicObject[] wc, Map<Date, BigDecimal> result, List<Map<String, Object>> dateList_Fintool, List<Date> dateList_cash, List<Date> dateList) {
        BigDecimal basis = TradeBusinessHelper.getBaseBasis(date1, date2, basisEnum, wc, null, null);
        BigDecimal df1 = BigDecimal.ZERO;
        if (EmptyUtil.isEmpty(dateList_Fintool)) {
            Date date_lastCash = YieldCurveHelper.getNearDate(dateList_cash, date1);
            if (EmptyUtil.isNoEmpty(date_lastCash)) {
                BigDecimal df_lastCash = result.get(date_lastCash);
                if ("perFwdRateCon".equals(interpType)) {
                    double d1_dc = TradeBusinessHelper.getBasis_BetweenDay(date_lastCash, date1, basisEnum, wc);
                    double d2_d1 = TradeBusinessHelper.getBasis_BetweenDay(date1, date2, basisEnum, wc);
                    df1 = df_lastCash.divide(BigDecimal.valueOf(Math.pow(1.0 + midRate.multiply(basis).doubleValue(), d1_dc / d2_d1)), 10, 4);
                } else if ("lineZeroRate".equals(interpType)) {
                    int index = dateList_cash.indexOf(date_lastCash);
                    if (index != dateList_cash.size() - 1) {
                        df1 = YieldCurveHelper.calDF_ZeroRate(referdate, date1, date_lastCash, df_lastCash, dateList_cash.get(index + 1), result.get(dateList_cash.get(index + 1)), wc, basisEnum);
                    } else {
                        double d1_dc = TradeBusinessHelper.getBasis_BetweenDay(date_lastCash, date1, basisEnum, wc);
                        double d2_d1 = TradeBusinessHelper.getBasis_BetweenDay(date1, date2, basisEnum, wc);
                        df1 = df_lastCash.divide(BigDecimal.valueOf(Math.pow(1.0 + midRate.multiply(basis).doubleValue(), d1_dc / d2_d1)), 10, 4);
                    }
                } else {
                    int index = dateList_cash.indexOf(date_lastCash);
                    if (index != dateList_cash.size() - 1) {
                        df1 = YieldCurveHelper.calDF_TripleSamp(referdate, date1, date_lastCash, df_lastCash, dateList_cash.get(index + 1), result.get(dateList_cash.get(index + 1)));
                    } else {
                        double d1_dc = TradeBusinessHelper.getBasis_BetweenDay(date_lastCash, date1, basisEnum, wc);
                        double d2_d1 = TradeBusinessHelper.getBasis_BetweenDay(date1, date2, basisEnum, wc);
                        df1 = df_lastCash.divide(BigDecimal.valueOf(Math.pow(1.0 + midRate.multiply(basis).doubleValue(), d1_dc / d2_d1)), 10, 4);
                    }
                }
            } else {
                double d1_d0 = TradeBusinessHelper.getBasis_BetweenDay(referdate, date1, basisEnum, wc);
                double d2_d1 = TradeBusinessHelper.getBasis_BetweenDay(date1, date2, basisEnum, wc);
                df1 = BigDecimal.ONE.divide(BigDecimal.valueOf(Math.pow(1.0 + midRate.multiply(basis).doubleValue(), d1_d0 / d2_d1)), 10, 4);
            }
        } else {
            Date date1_last = (Date)dateList_Fintool.get(dateList_Fintool.size() - 1).get("date1");
            BigDecimal df1_last = (BigDecimal)dateList_Fintool.get(dateList_Fintool.size() - 1).get("df1");
            Date date2_last = (Date)dateList_Fintool.get(dateList_Fintool.size() - 1).get("date2");
            BigDecimal df2_last = (BigDecimal)dateList_Fintool.get(dateList_Fintool.size() - 1).get("df2");
            df1 = "perFwdRateCon".equals(interpType) ? YieldCurveHelper.calDF_DailyForward(date1, date1_last, df1_last, date2_last, df2_last, wc, basisEnum) : ("lineZeroRate".equals(interpType) ? (!date1.after(date2_last) ? YieldCurveHelper.calDF_ZeroRate(referdate, date1, date1_last, df1_last, date2_last, df2_last, wc, basisEnum) : YieldCurveHelper.calDF_DailyForward(date1, date1_last, df1_last, date2_last, df2_last, wc, basisEnum)) : YieldCurveHelper.calDF_TripleSamp(referdate, date1, date1_last, df1_last, date2_last, df2_last));
        }
        BigDecimal df2 = df1.divide(BigDecimal.ONE.add(midRate.multiply(basis)), 10, 4);
        HashMap<String, Comparable<Date>> one = new HashMap<String, Comparable<Date>>(4);
        one.put("date1", date1);
        one.put("df1", df1);
        one.put("date2", date2);
        one.put("df2", df2);
        dateList_Fintool.add(one);
        YieldCurveHelper.addToDfResultList(result, dateList, date1, df1);
        YieldCurveHelper.addToDfResultList(result, dateList, date2, df2);
    }

    protected static void dealFintool_Future(String interpType, Date referdate, DynamicObject row, DynamicObjectCollection workcalendar, DynamicObject[] wc, Map<Date, BigDecimal> result, List<Map<String, Object>> dateList_Future, List<Date> dateList_cash, List<Date> dateList) {
        String futureEnddate = row.getString("futureenddate_fin");
        String futureContract = row.getString("futurecontract_fin");
        String term = row.getString("term_fin");
        String basisS = row.getString("basis_fin");
        String adjMethod = row.getString("adjmethod_fin");
        BigDecimal midRate = row.getBigDecimal("midrate_fin");
        midRate = midRate.divide(Constants.ONE_HUNDRED);
        BasisEnum basisEnum = BasisEnum.valueOf(basisS);
        AdjustMethodEnum adjustMethodEnum = AdjustMethodEnum.valueOf(adjMethod);
        int year = Integer.parseInt(futureContract.substring(3));
        int month = YieldCurveHelper.future_GetMonth(futureContract);
        Date date1 = "thirdWednesday".equals(futureEnddate) ? YieldCurveHelper.getTheDate(year, month, 3, 3) : YieldCurveHelper.getTheDate(year, month, 2, 5);
        Date date2 = TermUtils.getDateByTerm(term, date1);
        date2 = TradeBusinessHelper.callAdjustSettleDate(workcalendar, date2, adjustMethodEnum);
        YieldCurveHelper.deal_oneFintoolBuildTwoDate(interpType, referdate, date1, date2, midRate, basisEnum, wc, result, dateList_Future, dateList_cash, dateList);
    }

    protected static void dealFintool_Cash(Date referdate, DynamicObject firstRow, String bondDealType, DynamicObject row, DynamicObjectCollection workcalendar, DynamicObject[] wc, Map<Date, BigDecimal> result, List<Date> dateList_Cash, List<Date> dateList) {
        int rateOffset = row.getInt("rateoffset_fin");
        String term = row.getString("term_fin");
        String basisS = row.getString("basis_fin");
        String adjMethod = row.getString("adjmethod_fin");
        BigDecimal midRate = row.getBigDecimal("midrate_fin");
        midRate = midRate.divide(Constants.ONE_HUNDRED);
        AdjustMethodEnum adjustMethodEnum = AdjustMethodEnum.valueOf(adjMethod);
        BasisEnum basisEnum = BasisEnum.valueOf(basisS);
        Date paydate = TradeBusinessHelper.callSettleDelayDate(workcalendar, referdate, rateOffset);
        paydate = TermUtils.getDateByTerm(term, paydate);
        paydate = TradeBusinessHelper.callAdjustSettleDate(workcalendar, paydate, adjustMethodEnum);
        if (rateOffset == 0) {
            BigDecimal basis = TradeBusinessHelper.getBaseBasis(referdate, paydate, basisEnum, wc, null, null);
            BigDecimal df = BigDecimal.ONE.divide(BigDecimal.ONE.add(midRate.multiply(basis)), 10, 4);
            if (!dateList_Cash.contains(paydate)) {
                dateList_Cash.add(paydate);
            }
            YieldCurveHelper.addToDfResultList(result, dateList, paydate, df);
        } else {
            Date delayDate = TradeBusinessHelper.callSettleDelayDate(workcalendar, referdate, rateOffset);
            BigDecimal basis = TradeBusinessHelper.getBaseBasis(delayDate, paydate, basisEnum, wc, null, null);
            BigDecimal df_delay = YieldCurveHelper.getDF_delay(delayDate, bondDealType, firstRow, referdate, workcalendar, wc, dateList, result);
            if (!dateList_Cash.contains(delayDate)) {
                dateList_Cash.add(delayDate);
            }
            YieldCurveHelper.addToDfResultList(result, dateList, delayDate, df_delay);
            BigDecimal df = df_delay.divide(BigDecimal.ONE.add(midRate.multiply(basis)), 10, 4);
            if (!dateList_Cash.contains(paydate)) {
                dateList_Cash.add(paydate);
            }
            YieldCurveHelper.addToDfResultList(result, dateList, paydate, df);
        }
    }

    private static BigDecimal getDF_delay(Date date_delay, String bondDealType, DynamicObject firstRow, Date referdate, DynamicObjectCollection workcalendar, DynamicObject[] wc, List<Date> dateList, Map<Date, BigDecimal> result) {
        Date nearDate = YieldCurveHelper.getNearDate(dateList, date_delay);
        String basis = firstRow.getString("basis_fin");
        BasisEnum basisEnum = BasisEnum.valueOf(basis);
        BigDecimal df_delay = EmptyUtil.isNoEmpty(nearDate) ? YieldCurveHelper.calDF_DailyForward(date_delay, referdate, BigDecimal.ONE, nearDate, result.get(nearDate), wc, basisEnum) : YieldCurveHelper.calDF_delay(date_delay, bondDealType, firstRow, referdate, workcalendar, wc);
        if (!result.containsKey(date_delay)) {
            result.put(date_delay, df_delay);
            dateList.add(date_delay);
            dateList.sort((o1, o2) -> o1.compareTo((Date)o2));
        }
        return df_delay;
    }

    private static Date getNearDate(List<Date> dateList, Date baseDate) {
        if (EmptyUtil.isEmpty(dateList)) {
            return null;
        }
        if (dateList.contains(baseDate)) {
            return baseDate;
        }
        Date before = null;
        for (int i = 0; i < dateList.size() && dateList.get(i).before(baseDate); ++i) {
            before = dateList.get(i);
        }
        return before;
    }

    private static BigDecimal calDF_delay(Date date_delay, String bondDealType, DynamicObject firstRow, Date referdate, DynamicObjectCollection workcalendar, DynamicObject[] wc) {
        String fintool = firstRow.getString("fintool_fin");
        String term = firstRow.getString("term_fin");
        String futureEnddate = firstRow.getString("futureenddate_fin");
        String futureContract = firstRow.getString("futurecontract_fin");
        String FRA = firstRow.getString("fra_fin");
        String adjMethod = firstRow.getString("adjmethod_fin");
        String basis = firstRow.getString("basis_fin");
        Date enddate = firstRow.getDate("enddate_fin");
        int rateOffset = firstRow.getInt("rateoffset_fin");
        BigDecimal midrate = firstRow.getBigDecimal("midrate_fin");
        midrate = midrate.divide(Constants.ONE_HUNDRED);
        TradeToolEnum fintoolEnum = TradeToolEnum.valueOf(fintool);
        BasisEnum basisEnum = BasisEnum.valueOf(basis);
        AdjustMethodEnum adjustMethodEnum = AdjustMethodEnum.valueOf(adjMethod);
        BigDecimal d = BigDecimal.ZERO;
        double d_before = 1.0;
        double d_after = 1.0;
        switch (fintoolEnum) {
            case Cash: {
                Date paydate = TradeBusinessHelper.callSettleDelayDate(workcalendar, referdate, rateOffset);
                paydate = TermUtils.getDateByTerm(term, paydate);
                paydate = TradeBusinessHelper.callAdjustSettleDate(workcalendar, paydate, adjustMethodEnum);
                d = TradeBusinessHelper.getBaseBasis(date_delay, paydate, basisEnum, wc, null, null);
                d_before = TradeBusinessHelper.getBasis_BetweenDay(referdate, date_delay, basisEnum, wc);
                d_after = TradeBusinessHelper.getBasis_BetweenDay(date_delay, paydate, basisEnum, wc);
                break;
            }
            case Future: {
                int year = Integer.parseInt(futureContract.substring(3));
                int month = YieldCurveHelper.future_GetMonth(futureContract);
                Date date1 = "thirdWednesday".equals(futureEnddate) ? YieldCurveHelper.getTheDate(year, month, 3, 3) : YieldCurveHelper.getTheDate(year, month, 2, 5);
                Date date2 = TermUtils.getDateByTerm(term, date1);
                date2 = TradeBusinessHelper.callAdjustSettleDate(workcalendar, date2, adjustMethodEnum);
                d = TradeBusinessHelper.getBaseBasis(date1, date2, basisEnum, wc, null, null);
                d_before = TradeBusinessHelper.getBasis_BetweenDay(referdate, date_delay, basisEnum, wc);
                d_after = TradeBusinessHelper.getBasis_BetweenDay(date1, date2, basisEnum, wc);
                break;
            }
            case FRA: {
                int N = Integer.parseInt(FRA.split("-")[0]);
                Date date1_FRA = TcDateUtils.getNextMonth(referdate, N);
                date1_FRA = TradeBusinessHelper.callAdjustSettleDate(workcalendar, date1_FRA, adjustMethodEnum);
                Date date2_FRA = TermUtils.getDateByTerm(term, date1_FRA);
                date2_FRA = TradeBusinessHelper.callAdjustSettleDate(workcalendar, date2_FRA, adjustMethodEnum);
                d = TradeBusinessHelper.getBaseBasis(date1_FRA, date2_FRA, basisEnum, wc, null, null);
                d_before = TradeBusinessHelper.getBasis_BetweenDay(referdate, date_delay, basisEnum, wc);
                d_after = TradeBusinessHelper.getBasis_BetweenDay(date1_FRA, date2_FRA, basisEnum, wc);
                break;
            }
            case Swap: {
                Date referdateOffset = TradeBusinessHelper.callSettleDelayDate(workcalendar, referdate, rateOffset);
                Date termEndDate = TermUtils.getDateByTerm(term, referdateOffset);
                Date date_N = TradeBusinessHelper.callAdjustSettleDate(workcalendar, termEndDate, adjustMethodEnum);
                d = TradeBusinessHelper.getBaseBasis(date_delay, date_N, basisEnum, wc, null, null);
                d_before = TradeBusinessHelper.getBasis_BetweenDay(referdate, date_delay, basisEnum, wc);
                d_after = TradeBusinessHelper.getBasis_BetweenDay(date_delay, date_N, basisEnum, wc);
                break;
            }
            case Bond: {
                Date dN;
                if (BondDealTypeEnum.isSwap(bondDealType)) {
                    Date termDate = TermUtils.getDateByTerm(term, TradeBusinessHelper.callSettleDelayDate(workcalendar, referdate, rateOffset));
                    dN = TradeBusinessHelper.callAdjustSettleDate(workcalendar, termDate, adjustMethodEnum);
                } else {
                    dN = enddate;
                    dN = TradeBusinessHelper.callAdjustSettleDate(workcalendar, dN, adjustMethodEnum);
                }
                d = TradeBusinessHelper.getBaseBasis(date_delay, dN, basisEnum, wc, null, null);
                d_before = TradeBusinessHelper.getBasis_BetweenDay(referdate, date_delay, basisEnum, wc);
                d_after = TradeBusinessHelper.getBasis_BetweenDay(date_delay, dN, basisEnum, wc);
            }
        }
        double delayDF = 1.0 / Math.pow(1.0 + midrate.multiply(d).doubleValue(), d_before / d_after);
        return BigDecimal.valueOf(delayDF);
    }

    private static BigDecimal getFWDRate_between(Date date_last, Date date_i, BigDecimal df_last, BigDecimal df_i, BasisEnum basisEnum, DynamicObject[] wc) {
        BigDecimal basis = TradeBusinessHelper.getBaseBasis(date_last, date_i, basisEnum, wc, null, null);
        BigDecimal y_i = df_last.subtract(df_i).divide(df_i.multiply(basis), 10, 4);
        return y_i;
    }

    private static BigDecimal getDF_between(String interpType, Date referdate, Date date_i, DynamicObject[] wc, List<Date> dateList, Map<Date, BigDecimal> result, BasisEnum basisEnum) {
        BigDecimal df_i = BigDecimal.ONE;
        if (dateList.contains(date_i)) {
            df_i = result.get(date_i);
        } else {
            Date nearDate = YieldCurveHelper.getNearDate(dateList, date_i);
            BigDecimal df_near = result.get(nearDate);
            Date nextDate = dateList.get(dateList.indexOf(nearDate) + 1);
            BigDecimal df_next = result.get(nextDate);
            df_i = "lineZeroRate".equals(interpType) ? YieldCurveHelper.calDF_ZeroRate(referdate, date_i, nearDate, df_near, nextDate, df_next, wc, basisEnum) : ("perFwdRateCon".equals(interpType) ? YieldCurveHelper.calDF_DailyForward(date_i, nearDate, df_near, nextDate, df_next, wc, basisEnum) : YieldCurveHelper.calDF_TripleSamp(referdate, date_i, nearDate, df_near, nextDate, df_next));
        }
        return df_i;
    }

    private static BigDecimal calDF_DailyForward(Date basedate, Date beforedate, BigDecimal beforeDF, Date afterdate, BigDecimal afterDF, DynamicObject[] wc, BasisEnum basisEnum) {
        double day_ts = TradeBusinessHelper.getBasis_BetweenDay(beforedate, basedate, basisEnum, wc);
        double day_ls = TradeBusinessHelper.getBasis_BetweenDay(beforedate, afterdate, basisEnum, wc);
        double right = Math.pow(afterDF.doubleValue() / beforeDF.doubleValue(), day_ts / day_ls);
        return BigDecimal.valueOf(beforeDF.doubleValue() * right);
    }

    private static BigDecimal calDF_ZeroRate(Date referdate, Date basedate, Date beforedate, BigDecimal beforeDF, Date afterdate, BigDecimal afterDF, DynamicObject[] wc, BasisEnum basisEnum) {
        if (referdate.before(beforedate)) {
            double day_t0 = TradeBusinessHelper.getBasis_BetweenDay(referdate, basedate, basisEnum, wc);
            double day_lt = TradeBusinessHelper.getBasis_BetweenDay(basedate, afterdate, basisEnum, wc);
            double day_s0 = TradeBusinessHelper.getBasis_BetweenDay(referdate, beforedate, basisEnum, wc);
            double day_ls = TradeBusinessHelper.getBasis_BetweenDay(beforedate, afterdate, basisEnum, wc);
            double day_ts = TradeBusinessHelper.getBasis_BetweenDay(beforedate, basedate, basisEnum, wc);
            double day_l0 = TradeBusinessHelper.getBasis_BetweenDay(referdate, afterdate, basisEnum, wc);
            double left = day_t0 * day_lt / (day_s0 * day_ls);
            double right = day_t0 * day_ts / (day_l0 * day_ls);
            double result = Math.pow(beforeDF.doubleValue(), left) * Math.pow(afterDF.doubleValue(), right);
            return BigDecimal.valueOf(result);
        }
        return YieldCurveHelper.calDF_DailyForward(basedate, referdate, BigDecimal.ONE, afterdate, afterDF, wc, basisEnum);
    }

    private static BigDecimal calDF_TripleSamp(Date referdate, Date basedate, Date beforedate, BigDecimal beforeDF, Date afterdate, BigDecimal afterDF) {
        HashMap<Integer, BigDecimal> finDataMap = new HashMap<Integer, BigDecimal>(3);
        finDataMap.put(TcDateUtils.getDiffDays(referdate, beforedate), beforeDF);
        finDataMap.put(TcDateUtils.getDiffDays(referdate, afterdate), afterDF);
        int between = TcDateUtils.getDiffDays(referdate, basedate);
        Map<Integer, BigDecimal> result = MathFormulaUtils.getDataMapByMethod("tripleSamp", new Integer[]{between}, finDataMap);
        return result.get(between);
    }

    public static BigDecimal struct_calZeroRate(Date referdate, PayFrequeEnum payFrequeEnum, BasisEnum basisEnum, DynamicObject[] wc, Date date, BigDecimal DF) {
        if (EmptyUtil.isAnyoneEmpty(new Object[]{referdate, payFrequeEnum, basisEnum, date})) {
            return BigDecimal.ZERO;
        }
        BigDecimal basis = TradeBusinessHelper.getBaseBasis(referdate, date, basisEnum, wc, null, null);
        if (payFrequeEnum == PayFrequeEnum.day) {
            double zeroRate = -Math.log(DF.doubleValue()) / basis.doubleValue();
            return BigDecimal.valueOf(zeroRate).multiply(Constants.ONE_HUNDRED);
        }
        int h = payFrequeEnum.getFreque();
        double zeroRate = (Math.pow(DF.doubleValue(), -1.0 / (basis.doubleValue() * (double)h)) - 1.0) * (double)h;
        return BigDecimal.valueOf(zeroRate).multiply(Constants.ONE_HUNDRED);
    }

    public static BigDecimal struct_calZeroRate(DynamicObject yieldline, Date referdate, Date date, BigDecimal DF) {
        Object[] wc;
        String basis = yieldline.getString("basis");
        String freq = yieldline.getString("frequency");
        DynamicObjectCollection workcalendar = yieldline.getDynamicObjectCollection("workcalendar");
        BasisEnum basisEnum = null;
        if (EmptyUtil.isNoEmpty(basis)) {
            basisEnum = BasisEnum.valueOf(basis);
        }
        if (EmptyUtil.isEmpty(workcalendar)) {
            wc = null;
        } else {
            wc = new DynamicObject[workcalendar.size()];
            wc = (DynamicObject[])workcalendar.toArray(wc);
        }
        if (EmptyUtil.isAnyoneEmpty(new Object[]{referdate, freq, basisEnum, date})) {
            return BigDecimal.ZERO;
        }
        return YieldCurveHelper.struct_calZeroRate(referdate, PayFrequeEnum.valueOf(freq), basisEnum, (DynamicObject[])wc, date, DF);
    }

    public static BigDecimal zero_getDfByDate(Date startDate, Date endDate, Date referdate, Date date_i, String interpType, String bondDealType, DynamicObjectCollection workCalendar, DynamicObject[] wc, DynamicObject firstRow, List<Date> dateList, Map<Date, BigDecimal> result, BasisEnum basisEnum) {
        date_i = new Date(date_i.getTime());
        BigDecimal df_i = BigDecimal.ONE;
        if (!date_i.before(startDate) && !date_i.after(endDate)) {
            df_i = YieldCurveHelper.getDF_between(interpType, referdate, date_i, wc, dateList, result, basisEnum);
        }
        if (date_i.before(startDate)) {
            df_i = YieldCurveHelper.calDF_delay(date_i, bondDealType, firstRow, referdate, workCalendar, wc);
        }
        if (date_i.after(endDate)) {
            Date nearDate = dateList.get(dateList.size() - 2);
            BigDecimal df_near = result.get(nearDate);
            Date nextDate = dateList.get(dateList.size() - 1);
            BigDecimal df_next = result.get(nextDate);
            df_i = YieldCurveHelper.calDF_DailyForward(date_i, nearDate, df_near, nextDate, df_next, wc, basisEnum);
        }
        return df_i;
    }

    public static BigDecimal zero_getDfByDate(DynamicObject yield, Date startDate, Date endDate, Date referdate, Date date_i, List<Date> dateList, Map<Date, BigDecimal> result) {
        Object[] wc;
        String basis = yield.getString("basis");
        String interpType = yield.getString("interptype");
        String bondDealType = yield.getString("bonddealtype");
        DynamicObjectCollection workcalendar = yield.getDynamicObjectCollection("workcalendar");
        if (EmptyUtil.isEmpty(workcalendar)) {
            wc = null;
        } else {
            wc = new DynamicObject[workcalendar.size()];
            wc = (DynamicObject[])workcalendar.toArray(wc);
        }
        BasisEnum basisEnum = null;
        if (EmptyUtil.isNoEmpty(basis)) {
            basisEnum = BasisEnum.valueOf(basis);
        }
        DynamicObject firstRow = YieldCurveHelper.getFirstValidFintoolEntryRow(yield.getDynamicObjectCollection("fintoolentry"));
        return YieldCurveHelper.zero_getDfByDate(startDate, endDate, referdate, date_i, interpType, bondDealType, workcalendar, (DynamicObject[])wc, firstRow, dateList, result, basisEnum);
    }

    public static List<Map<String, Object>> zero_getZeroEntry(Long dateAixsId, String interpType, String bondDealType, Date referdate, PayFrequeEnum payFrequeEnum, BasisEnum basisEnum, DynamicObjectCollection workCalendars, AdjustMethodEnum adjustMethodEnum, DynamicObject[] wc, DynamicObject firstRow, List<Date> dateList, Map<Date, BigDecimal> result) {
        if (EmptyUtil.isEmpty(dateList) || dateList.size() <= 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6536\u76ca\u7387\u66f2\u7ebf\u6784\u9020\u53ca\u8ba1\u7b97\u81f3\u5c11\u9700\u8981\u4e24\u4e2a\u6298\u73b0\u56e0\u5b50\uff0c\u8bf7\u6dfb\u52a0\u91d1\u878d\u5de5\u5177\u3002", (String)"YieldCurveHelper_0", (String)"tmc-md-common", (Object[])new Object[0]));
        }
        ArrayList<Map<String, Object>> zeroEntrys = new ArrayList<Map<String, Object>>(dateList.size());
        if (EmptyUtil.isAnyoneEmpty(new Object[]{dateAixsId, interpType, referdate, payFrequeEnum, basisEnum, adjustMethodEnum, dateList, result})) {
            return zeroEntrys;
        }
        DynamicObject dateAxis = TmcDataServiceHelper.loadSingle((Object)dateAixsId, (String)"tbd_dateaxis");
        DynamicObjectCollection entrys = dateAxis.getDynamicObjectCollection("entrys");
        Date startDate = dateList.get(0);
        Date endDate = dateList.get(dateList.size() - 1);
        for (int i = 0; i < entrys.size(); ++i) {
            HashMap<String, Comparable<Date>> entryRow = new HashMap<String, Comparable<Date>>(3);
            String curTerm = ((DynamicObject)entrys.get(i)).getString("point");
            Date date_i = TermUtils.getDateByTerm(curTerm, referdate);
            date_i = TradeBusinessHelper.callAdjustSettleDate(workCalendars, date_i, adjustMethodEnum);
            BigDecimal df_i = YieldCurveHelper.zero_getDfByDate(startDate, endDate, referdate, date_i, interpType, bondDealType, workCalendars, wc, firstRow, dateList, result, basisEnum);
            BigDecimal zeroRate = YieldCurveHelper.struct_calZeroRate(referdate, payFrequeEnum, basisEnum, wc, date_i, df_i);
            entryRow.put("date_zero", date_i);
            entryRow.put("disfactor_zero", df_i);
            entryRow.put("zerorate_zero", zeroRate);
            zeroEntrys.add(entryRow);
        }
        return zeroEntrys;
    }

    public static Map<Date, BigDecimal> getDFOrZeroRate(ReturnValTypeEnum queryType, String interpType, String bondDealType, Date referdate, PayFrequeEnum payFrequeEnum, BasisEnum basisEnum, DynamicObjectCollection workCalendar, DynamicObject[] wc, DynamicObject firstRow, Date furdate, List<Date> querydateList, List<Date> dateList, Map<Date, BigDecimal> result) {
        HashMap<Date, BigDecimal> querydateResult = new HashMap<Date, BigDecimal>(querydateList.size());
        if (EmptyUtil.isAnyoneEmpty(new Object[]{interpType, referdate, payFrequeEnum, basisEnum, dateList, result})) {
            return querydateResult;
        }
        Date startDate = dateList.get(0);
        Date endDate = dateList.get(dateList.size() - 1);
        BigDecimal df_fur = BigDecimal.ONE;
        if (queryType == ReturnValTypeEnum.furrate) {
            df_fur = furdate.compareTo(referdate) == 0 ? BigDecimal.ONE : YieldCurveHelper.zero_getDfByDate(startDate, endDate, referdate, furdate, interpType, bondDealType, workCalendar, wc, firstRow, dateList, result, basisEnum);
        }
        for (int i = 0; i < querydateList.size(); ++i) {
            Date date_i = querydateList.get(i);
            BigDecimal df_i = YieldCurveHelper.zero_getDfByDate(startDate, endDate, referdate, date_i, interpType, bondDealType, workCalendar, wc, firstRow, dateList, result, basisEnum);
            if (queryType == ReturnValTypeEnum.df) {
                querydateResult.put(date_i, df_i);
                continue;
            }
            if (queryType == ReturnValTypeEnum.rate) {
                BigDecimal zeroRate = YieldCurveHelper.struct_calZeroRate(referdate, payFrequeEnum, basisEnum, wc, date_i, df_i);
                querydateResult.put(date_i, zeroRate);
                continue;
            }
            if (date_i.compareTo(furdate) == 0) {
                BigDecimal furRate = YieldCurveHelper.struct_calZeroRate(referdate, payFrequeEnum, basisEnum, wc, date_i, df_i);
                querydateResult.put(date_i, furRate);
                continue;
            }
            BigDecimal d = TradeBusinessHelper.getBaseBasis(furdate, date_i, basisEnum, wc, null, null);
            df_fur = df_fur.setScale(10, 4);
            df_i = df_i.setScale(10, 4);
            BigDecimal furRate = df_fur.divide(df_i, 10, 4).subtract(BigDecimal.ONE).divide(d, 10, 4).multiply(Constants.ONE_HUNDRED);
            querydateResult.put(date_i, furRate);
        }
        return querydateResult;
    }

    public static Map<Date, BigDecimal> getDFOrZeroRate(DynamicObject yield, ReturnValTypeEnum queryType, Date referdate, Date furdate, List<Date> querydateList, List<Date> dateList, Map<Date, BigDecimal> result) {
        Object[] wc;
        String basis = yield.getString("basis");
        String freq = yield.getString("frequency");
        String interpType = yield.getString("interptype");
        String bondDealType = yield.getString("bonddealtype");
        DynamicObjectCollection workcalendar = yield.getDynamicObjectCollection("workcalendar");
        if (EmptyUtil.isEmpty(workcalendar)) {
            wc = null;
        } else {
            wc = new DynamicObject[workcalendar.size()];
            wc = (DynamicObject[])workcalendar.toArray(wc);
        }
        BasisEnum basisEnum = null;
        if (EmptyUtil.isNoEmpty(basis)) {
            basisEnum = BasisEnum.valueOf(basis);
        }
        PayFrequeEnum payFrequeEnum = null;
        if (EmptyUtil.isNoEmpty(freq)) {
            payFrequeEnum = PayFrequeEnum.valueOf(freq);
        }
        DynamicObject firstRow = YieldCurveHelper.getFirstValidFintoolEntryRow(yield.getDynamicObjectCollection("fintoolentry"));
        return YieldCurveHelper.getDFOrZeroRate(queryType, interpType, bondDealType, referdate, payFrequeEnum, basisEnum, workcalendar, (DynamicObject[])wc, firstRow, furdate, querydateList, dateList, result);
    }

    private static DynamicObject getFirstValidFintoolEntryRow(DynamicObjectCollection fintoolEntry) {
        DynamicObject firstRow = null;
        for (int i = 0; i < fintoolEntry.size(); ++i) {
            if (!((DynamicObject)fintoolEntry.get(i)).getBoolean("isforcurve_fin")) continue;
            firstRow = (DynamicObject)fintoolEntry.get(i);
            break;
        }
        return firstRow;
    }

    public static List chart_getY(List<Date> xDateList, String interpType, String bondDealType, Date referdate, PayFrequeEnum payFrequeEnum, BasisEnum basisEnum, DynamicObjectCollection workCalendars, AdjustMethodEnum adjustMethodEnum, DynamicObject[] wc, DynamicObject firstFin, List<Date> dateList, Map<Date, BigDecimal> result) {
        ArrayList<BigDecimal> yNumber = new ArrayList<BigDecimal>(xDateList.size());
        if (EmptyUtil.isAnyoneEmpty(new Object[]{interpType, referdate, payFrequeEnum, basisEnum, adjustMethodEnum, dateList, result})) {
            return yNumber;
        }
        Date startDate = dateList.get(0);
        Date endDate = dateList.get(dateList.size() - 1);
        for (Date date_i : xDateList) {
            BigDecimal df_i = YieldCurveHelper.zero_getDfByDate(startDate, endDate, referdate, date_i, interpType, bondDealType, workCalendars, wc, firstFin, dateList, result, basisEnum);
            BigDecimal zeroRate = YieldCurveHelper.struct_calZeroRate(referdate, payFrequeEnum, basisEnum, wc, date_i, df_i);
            yNumber.add(zeroRate);
        }
        return yNumber;
    }

    public static List chart_getY(List<Date> xDateList, DynamicObject yield, Date referdate, List<Date> dateList, Map<Date, BigDecimal> result) {
        Object[] wc;
        String basis = yield.getString("basis");
        String freq = yield.getString("frequency");
        String interpType = yield.getString("interptype");
        String bondDealType = yield.getString("bonddealtype");
        String adjustmethod = yield.getString("adjustmethod");
        DynamicObjectCollection workcalendar = yield.getDynamicObjectCollection("workcalendar");
        if (EmptyUtil.isEmpty(workcalendar)) {
            wc = null;
        } else {
            wc = new DynamicObject[workcalendar.size()];
            wc = (DynamicObject[])workcalendar.toArray(wc);
        }
        BasisEnum basisEnum = null;
        if (EmptyUtil.isNoEmpty(basis)) {
            basisEnum = BasisEnum.valueOf(basis);
        }
        PayFrequeEnum payFrequeEnum = null;
        if (EmptyUtil.isNoEmpty(freq)) {
            payFrequeEnum = PayFrequeEnum.valueOf(freq);
        }
        AdjustMethodEnum adjustMethodEnum = null;
        if (EmptyUtil.isNoEmpty(adjustmethod)) {
            adjustMethodEnum = AdjustMethodEnum.valueOf(adjustmethod);
        }
        DynamicObjectCollection entry_struct = yield.getDynamicObjectCollection("structentry");
        for (int i = 0; i < entry_struct.size(); ++i) {
            if (!((DynamicObject)entry_struct.get(i)).getBoolean("isforcurve_struct")) continue;
            Date date_i = ((DynamicObject)entry_struct.get(i)).getDate("date_struct");
            BigDecimal df_i = ((DynamicObject)entry_struct.get(i)).getBigDecimal("implieddf_struct");
            dateList.add(date_i);
            df_i = df_i.setScale(10, RoundingMode.HALF_UP);
            result.put(date_i, df_i);
        }
        DynamicObject firstRow = YieldCurveHelper.getFirstValidFintoolEntryRow(yield.getDynamicObjectCollection("fintoolentry"));
        return YieldCurveHelper.chart_getY(xDateList, interpType, bondDealType, referdate, payFrequeEnum, basisEnum, workcalendar, adjustMethodEnum, (DynamicObject[])wc, firstRow, dateList, result);
    }

    private static int future_GetMonth(String futureContract) {
        int month;
        String monthS;
        switch (monthS = futureContract.substring(0, 3)) {
            case "Mar": {
                month = 2;
                break;
            }
            case "Jun": {
                month = 5;
                break;
            }
            case "Sep": {
                month = 8;
                break;
            }
            case "Dec": {
                month = 11;
                break;
            }
            default: {
                month = 0;
            }
        }
        return month;
    }

    protected static Date getTheDate(int year, int month, int wek, int num) {
        Calendar time = Calendar.getInstance();
        time.set(1, year);
        time.set(2, month);
        time.set(11, 0);
        time.set(12, 0);
        time.set(13, 0);
        time.set(14, 0);
        int day = time.getActualMaximum(5);
        int countWeek = 0;
        for (int i = 1; i <= day; ++i) {
            time.set(5, i);
            int weekd = time.get(7) - 1;
            if (num == weekd) {
                ++countWeek;
            }
            if (wek != countWeek) continue;
            return time.getTime();
        }
        return null;
    }

    public static void generateStructEntry(DynamicObject yieldline) {
        Date referdate = TcDateUtils.getCurrentDate();
        String freq = yieldline.getString("frequency");
        DynamicObjectCollection fintoolEntry = yieldline.getDynamicObjectCollection("fintoolentry");
        if (EmptyUtil.isNoEmpty(freq)) {
            ArrayList<Date> dateList = new ArrayList<Date>(fintoolEntry.size());
            HashMap<Date, BigDecimal> result = new HashMap<Date, BigDecimal>(fintoolEntry.size());
            YieldCurveHelper.fillAllDFByFintool(yieldline, referdate, dateList, result);
            if (EmptyUtil.isNoEmpty(dateList)) {
                DynamicObjectCollection structentry = yieldline.getDynamicObjectCollection("structentry");
                structentry.clear();
                for (Date date : dateList) {
                    if (referdate != null && referdate.compareTo(date) >= 0) continue;
                    DynamicObject dynamicObject = structentry.addNew();
                    dynamicObject.set("date_struct", (Object)date);
                    dynamicObject.set("implieddf_struct", result.get(date));
                }
            }
        }
    }

    private static void rebuildFutureContract(Date referdate, DynamicObjectCollection fintoolEntry) {
        if (referdate == null) {
            return;
        }
        Calendar temp = Calendar.getInstance();
        temp.setTime(referdate);
        int year = temp.get(1);
        int month = temp.get(2);
        int index = 0;
        index = month < 2 ? 0 : (month < 5 ? 1 : (month < 8 ? 2 : (month < 12 ? 3 : 0)));
        for (int i = 0; i < fintoolEntry.size(); ++i) {
            DynamicObject fintool = (DynamicObject)fintoolEntry.get(i);
            if (!TradeToolEnum.isFuture(fintool.getString("fintool_fin"))) continue;
            String futureContract = contract[index] + Integer.toString(year);
            fintool.set("futurecontract_fin", (Object)futureContract);
            if (++index != 4) continue;
            index = 0;
            ++year;
        }
    }
}

