/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper.business;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.bean.tc.PriceRuleInfo;
import kd.tmc.fbp.common.bean.tc.TreePriceInfo;
import kd.tmc.fbp.common.bean.tc.YieldCurveInfo;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.OptionsTradeTypeEnum;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.enums.YieldTypeEnum;
import kd.tmc.fbp.common.formula.MathFormulaUtils;
import kd.tmc.fbp.common.helper.MarketDataHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.model.ModelAgent;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;

public class OptionsBizHelper {
    private static final Log logger = LogFactory.getLog(OptionsBizHelper.class);

    public static BigDecimal getD1(BigDecimal f0, BigDecimal K, BigDecimal T, BigDecimal volatility) {
        try {
            double ln_F_K = Math.log(f0.divide(K, 6, RoundingMode.HALF_UP).doubleValue());
            BigDecimal \u03c3_T = volatility.multiply(BigDecimal.valueOf(Math.sqrt(T.doubleValue())));
            BigDecimal addOne = BigDecimal.valueOf(Double.isNaN(ln_F_K) ? 0.0 : ln_F_K).divide(\u03c3_T, 6, RoundingMode.HALF_UP);
            BigDecimal addTwo = \u03c3_T.divide(BigDecimal.valueOf(2L), 6, RoundingMode.HALF_UP);
            return addOne.add(addTwo);
        }
        catch (NumberFormatException e) {
            logger.error((Throwable)e);
            return Constants.ZERO;
        }
    }

    public static BigDecimal getD2(BigDecimal d1, BigDecimal volatility, BigDecimal T) {
        BigDecimal \u03c3_T = volatility.multiply(BigDecimal.valueOf(Math.sqrt(T.doubleValue())));
        return d1.subtract(\u03c3_T);
    }

    public static BigDecimal calculateOptionPV(BigDecimal F, BigDecimal K, BigDecimal T, BigDecimal \u03c3, BigDecimal Ao, BigDecimal Zq, BigDecimal D_k) {
        try {
            BigDecimal d1 = OptionsBizHelper.getD1(F, K, T, \u03c3);
            BigDecimal d2 = OptionsBizHelper.getD2(d1, \u03c3, T);
            double Nd1 = MathFormulaUtils.cumulativeProbability(D_k.multiply(d1).doubleValue());
            double Nd2 = MathFormulaUtils.cumulativeProbability(D_k.multiply(d2).doubleValue());
            BigDecimal formula1 = F.multiply(BigDecimal.valueOf(Nd1)).subtract(K.multiply(BigDecimal.valueOf(Nd2)));
            return Ao.multiply(Zq).multiply(formula1);
        }
        catch (NumberFormatException e) {
            logger.error((Throwable)e);
            return Constants.ZERO;
        }
    }

    public static BigDecimal calculateBsmDelta(BigDecimal Ao, BigDecimal Zq, BigDecimal D_k, BigDecimal F, BigDecimal T, BigDecimal K, BigDecimal V) {
        BigDecimal d = OptionsBizHelper.getD1(F, K, T, V);
        double Nd = MathFormulaUtils.cumulativeProbability(d.doubleValue());
        if (Constants._ONE.compareTo(D_k) == 0) {
            Nd -= 1.0;
        }
        return Ao.multiply(Zq).multiply(BigDecimal.valueOf(Nd));
    }

    public static BigDecimal calculateHedgeRatio(BigDecimal F, BigDecimal K, BigDecimal T, BigDecimal \u03c3, BigDecimal D_k) {
        BigDecimal d1 = OptionsBizHelper.getD1(F, K, T, \u03c3);
        BigDecimal hedgeRatio = BigDecimal.valueOf(MathFormulaUtils.cumulativeProbability(d1.doubleValue()));
        if (Constants._ONE.compareTo(D_k) == 0) {
            hedgeRatio = hedgeRatio.subtract(Constants.ONE);
        }
        return hedgeRatio;
    }

    public static BigDecimal calculateEuroBsmGamma(BigDecimal Ao, BigDecimal Zq, BigDecimal F, BigDecimal T, BigDecimal K, BigDecimal \u03c3) {
        BigDecimal d1 = OptionsBizHelper.getD1(F, K, T, \u03c3);
        BigDecimal Nd1 = OptionsBizHelper.getN_d(d1);
        BigDecimal formula = F.multiply(BigDecimal.valueOf(Math.sqrt(T.doubleValue()))).multiply(\u03c3);
        return Ao.multiply(Zq).multiply(Nd1).divide(formula, 6, RoundingMode.HALF_UP);
    }

    public static BigDecimal getN_d(BigDecimal d) {
        return BigDecimal.valueOf(Math.pow(Math.E, Math.pow(d.doubleValue(), 2.0) / -2.0) / Math.sqrt(Math.PI * 2));
    }

    public static BigDecimal calculateEuroBsmVega(BigDecimal Ao, BigDecimal Zq, BigDecimal F, BigDecimal T, BigDecimal K, BigDecimal \u03c3) {
        try {
            BigDecimal Nd = OptionsBizHelper.getN_d(OptionsBizHelper.getD1(F, K, T, \u03c3));
            BigDecimal formula = BigDecimal.valueOf(Math.sqrt(T.doubleValue()));
            return Ao.multiply(Zq).multiply(F).multiply(Nd).multiply(formula);
        }
        catch (NumberFormatException e) {
            logger.error((Throwable)e);
            return Constants.ZERO;
        }
    }

    public static BigDecimal calculateEuroBsmTheta(BigDecimal Ao, BigDecimal Zq, BigDecimal F, BigDecimal T, BigDecimal K, BigDecimal \u03c3, BigDecimal D_K, BigDecimal r, BigDecimal r_f) {
        BigDecimal d1 = OptionsBizHelper.getD1(F, K, T, \u03c3);
        BigDecimal d2 = OptionsBizHelper.getD2(d1, \u03c3, T);
        BigDecimal Nd1 = OptionsBizHelper.getN_d(d1);
        BigDecimal formula1 = Constants._ONE.multiply(F).multiply(Nd1).multiply(\u03c3).divide(BigDecimal.valueOf(2L).multiply(BigDecimal.valueOf(Math.sqrt(T.doubleValue()))), 6, RoundingMode.HALF_UP);
        double nd1 = MathFormulaUtils.cumulativeProbability(D_K.multiply(d1).doubleValue());
        double nd2 = MathFormulaUtils.cumulativeProbability(D_K.multiply(d2).doubleValue());
        BigDecimal formula2 = D_K.multiply(r_f).multiply(F).multiply(BigDecimal.valueOf(nd1));
        BigDecimal formula3 = D_K.multiply(r).multiply(K).multiply(BigDecimal.valueOf(nd2));
        return Ao.multiply(Zq).multiply(formula1.add(formula2).add(Constants._ONE.multiply(formula3))).divide(BigDecimal.valueOf(365.25), 10, RoundingMode.HALF_UP);
    }

    public static TreePriceInfo[][] binaryTreePricing(BigDecimal dt, BigDecimal u, BigDecimal F, BigDecimal Ao, BigDecimal K, int N, String tradeType, String optionType, BigDecimal settleStep, BigDecimal yieldStep) {
        BigDecimal d = Constants.ONE.divide(u, 6, 4);
        BigDecimal p = Constants.ONE.subtract(d).divide(u.subtract(d), 6, 4);
        BigDecimal q = Constants.ONE.subtract(p);
        TreePriceInfo[][] treePriceInfos = new TreePriceInfo[N][N];
        for (int j = N - 1; j >= 0; --j) {
            for (int i = 0; i <= j; ++i) {
                TreePriceInfo info = new TreePriceInfo();
                BigDecimal interestPrice = F.multiply(BigDecimal.valueOf(Math.pow(u.doubleValue(), i))).multiply(BigDecimal.valueOf(Math.pow(d.doubleValue(), j - i))).multiply(BigDecimal.valueOf(Math.pow(settleStep.divide(yieldStep, 6, 4).doubleValue(), N - j)));
                info.setInterestPrice(interestPrice);
                if ("call".equals(tradeType)) {
                    info.setExercisePrice(Ao.multiply(BigDecimal.valueOf(Math.max(info.getInterestPrice().subtract(K).doubleValue(), 0.0))));
                } else if ("put".equals(tradeType)) {
                    info.setExercisePrice(Ao.multiply(BigDecimal.valueOf(Math.max(K.multiply(info.getInterestPrice()).doubleValue(), 0.0))));
                }
                if (j == N - 1) {
                    BigDecimal formula;
                    if ("call".equals(tradeType)) {
                        formula = Ao.multiply(F.multiply(BigDecimal.valueOf(Math.pow(u.doubleValue(), i))).multiply(BigDecimal.valueOf(Math.pow(d.doubleValue(), N - i))).subtract(K).max(Constants.ZERO));
                        info.setExpectPrice(formula);
                    } else if ("put".equals(tradeType)) {
                        formula = Ao.multiply(K.subtract(F.multiply(BigDecimal.valueOf(Math.pow(u.doubleValue(), i))).multiply(BigDecimal.valueOf(Math.pow(d.doubleValue(), N - i)))).max(Constants.ZERO));
                        info.setExpectPrice(formula);
                    }
                } else {
                    BigDecimal EP = settleStep.multiply(p).multiply(treePriceInfos[j + 1][i + 1].getExpectPrice()).add(q.multiply(treePriceInfos[j + 1][i].getExpectPrice()));
                    if ("american".equals(optionType)) {
                        EP = info.getExercisePrice().max(EP);
                    }
                    info.setExpectPrice(EP);
                }
                info.setPv(info.getExpectPrice());
                treePriceInfos[j][i] = info;
            }
        }
        return treePriceInfos;
    }

    public static BigDecimal calculateHedgeAmount(boolean isRight, BigDecimal S, BigDecimal delta, BigDecimal Zsq) {
        if (isRight) {
            return S.multiply(delta.divide(Zsq, 10, RoundingMode.HALF_UP)).multiply(Constants.TEN_THOUSAND);
        }
        return Constants._ONE.multiply(delta.divide(Zsq.multiply(S), 10, RoundingMode.HALF_UP)).multiply(Constants.TEN_THOUSAND);
    }

    public static BigDecimal calculateTreeDelta(TreePriceInfo[][] euroTreePrices) {
        return euroTreePrices[1][1].getPv().subtract(euroTreePrices[1][0].getPv()).divide(euroTreePrices[1][1].getInterestPrice().subtract(euroTreePrices[1][0].getInterestPrice()), 6, RoundingMode.HALF_UP);
    }

    public static BigDecimal calculateTreeGamma(TreePriceInfo[][] treePrices) {
        BigDecimal formula1 = treePrices[2][2].getPv().subtract(treePrices[2][1].getPv()).divide(treePrices[2][2].getInterestPrice().subtract(treePrices[2][1].getInterestPrice()), 6, 4);
        BigDecimal formula2 = treePrices[2][1].getPv().subtract(treePrices[2][0].getPv()).divide(treePrices[2][1].getInterestPrice().subtract(treePrices[2][0].getInterestPrice()), 6, 4);
        BigDecimal formula3 = treePrices[2][2].getInterestPrice().subtract(treePrices[2][0].getInterestPrice());
        return BigDecimal.valueOf(2L).multiply(formula1.subtract(formula2)).divide(formula3, 6, 4);
    }

    public static BigDecimal getFlagByTradeType(String tradeType) {
        return OptionsTradeTypeEnum.put.getValue().equals(tradeType) ? Constants._ONE : Constants.ONE;
    }

    public static BigDecimal americanGet_\u03b1(BigDecimal I, BigDecimal K, BigDecimal \u03b2) {
        return I.subtract(K).multiply(BigDecimal.valueOf(Math.pow(I.doubleValue(), Constants._ONE.multiply(\u03b2).doubleValue())));
    }

    public static BigDecimal americanGet_\u03b2(BigDecimal b, BigDecimal \u03c3, BigDecimal r) {
        BigDecimal half = Constants.ONE.divide(new BigDecimal(2), 10, RoundingMode.HALF_UP);
        BigDecimal div = b.divide(BigDecimal.valueOf(Math.pow(\u03c3.doubleValue(), 2.0)), 10, RoundingMode.HALF_UP);
        BigDecimal divide = new BigDecimal(2).multiply(r).divide(BigDecimal.valueOf(Math.pow(\u03c3.doubleValue(), 2.0)), 10, RoundingMode.HALF_UP);
        return half.subtract(div).add(BigDecimal.valueOf(Math.sqrt(BigDecimal.valueOf(Math.pow(div.subtract(half).doubleValue(), 2.0)).add(divide).doubleValue())));
    }

    public static BigDecimal americanGet_hT(BigDecimal b, BigDecimal \u03c3, BigDecimal T, BigDecimal B0, BigDecimal B8) {
        BigDecimal mult = b.multiply(T).add(new BigDecimal(2).multiply(\u03c3).multiply(BigDecimal.valueOf(Math.sqrt(T.doubleValue()))));
        return Constants._ONE.multiply(mult).multiply(B0.divide(B8.subtract(B0), 10, RoundingMode.HALF_UP));
    }

    public static BigDecimal americanGet_B8(BigDecimal \u03b2, BigDecimal K) {
        return \u03b2.divide(\u03b2.subtract(new BigDecimal(1)), 10, RoundingMode.HALF_UP).multiply(K);
    }

    public static BigDecimal americanGet_B0(BigDecimal K, BigDecimal r, BigDecimal b) {
        return BigDecimal.valueOf(Math.max(K.doubleValue(), r.divide(r.subtract(b), 10, RoundingMode.HALF_UP).multiply(K).doubleValue()));
    }

    public static BigDecimal americanGet_I(BigDecimal B0, BigDecimal B8, BigDecimal hT) {
        return B0.add(B8.subtract(B0).multiply(Constants.ONE.subtract(BigDecimal.valueOf(Math.pow(Math.E, hT.doubleValue())))));
    }

    public static BigDecimal americanGet_k(BigDecimal b, BigDecimal \u03c3, BigDecimal \u03b3) {
        return new BigDecimal(2).multiply(b).divide(BigDecimal.valueOf(Math.pow(\u03c3.doubleValue(), 2.0)), 10, RoundingMode.HALF_UP).add(new BigDecimal(2).multiply(\u03b3).subtract(Constants.ONE));
    }

    public static BigDecimal americanGet_d(BigDecimal S, BigDecimal H, BigDecimal b, BigDecimal \u03b3, BigDecimal \u03c3, BigDecimal T) {
        BigDecimal log = BigDecimal.valueOf(Math.log(S.divide(H, 10, RoundingMode.HALF_UP).doubleValue()));
        BigDecimal mult = b.add(\u03b3.subtract(Constants.ONE.divide(new BigDecimal(2), 10, RoundingMode.HALF_UP)).multiply(BigDecimal.valueOf(Math.pow(\u03c3.doubleValue(), 2.0)))).multiply(T);
        return Constants._ONE.multiply(log.add(mult).divide(\u03c3.multiply(BigDecimal.valueOf(Math.sqrt(T.doubleValue()))), 10, RoundingMode.HALF_UP));
    }

    public static BigDecimal americanGet_\u03bb(BigDecimal r, BigDecimal \u03b3, BigDecimal b, BigDecimal \u03c3, BigDecimal T) {
        BigDecimal mult = Constants.ONE.divide(new BigDecimal(2), 10, RoundingMode.HALF_UP).multiply(\u03b3).multiply(\u03b3.subtract(Constants.ONE)).multiply(BigDecimal.valueOf(Math.pow(\u03c3.doubleValue(), 2.0)));
        return Constants._ONE.multiply(r).add(\u03b3.multiply(b)).add(mult).multiply(T);
    }

    public static BigDecimal americanGet_\u03d5(BigDecimal \u03bb, BigDecimal S, BigDecimal \u03b3, BigDecimal d, BigDecimal I, BigDecimal k, BigDecimal \u03c3, BigDecimal T) {
        BigDecimal mult = BigDecimal.valueOf(Math.pow(Math.E, \u03bb.doubleValue())).multiply(BigDecimal.valueOf(Math.pow(S.doubleValue(), \u03b3.doubleValue())));
        BigDecimal Nd = BigDecimal.valueOf(MathFormulaUtils.cumulativeProbability(d.doubleValue()));
        BigDecimal div = BigDecimal.valueOf(Math.pow(I.divide(S, 10, RoundingMode.HALF_UP).doubleValue(), k.doubleValue()));
        BigDecimal subtract = d.subtract(new BigDecimal(2).multiply(BigDecimal.valueOf(Math.log(I.divide(S, 10, RoundingMode.HALF_UP).doubleValue())).divide(\u03c3.multiply(BigDecimal.valueOf(Math.sqrt(T.doubleValue()))), 10, RoundingMode.HALF_UP)));
        BigDecimal Ns = BigDecimal.valueOf(MathFormulaUtils.cumulativeProbability(subtract.doubleValue()));
        return mult.multiply(Nd.subtract(div.multiply(Ns)));
    }

    public static BigDecimal americanCal(BigDecimal Ao, BigDecimal Zd, BigDecimal K, BigDecimal S, BigDecimal T, BigDecimal r, BigDecimal b, BigDecimal \u03c3) {
        BigDecimal \u03b2 = OptionsBizHelper.americanGet_\u03b2(b, \u03c3, r);
        BigDecimal B0 = OptionsBizHelper.americanGet_B0(K, r, b);
        BigDecimal B8 = OptionsBizHelper.americanGet_B8(\u03b2, K);
        BigDecimal hT = OptionsBizHelper.americanGet_hT(b, \u03c3, T, B0, B8);
        BigDecimal I = OptionsBizHelper.americanGet_I(B0, B8, hT);
        BigDecimal \u03b1 = OptionsBizHelper.americanGet_\u03b1(I, K, \u03b2);
        BigDecimal \u03b2_I = OptionsBizHelper.americanCal_\u03d5(r, \u03b2, I, b, \u03c3, T, S, I);
        BigDecimal one_I = OptionsBizHelper.americanCal_\u03d5(r, Constants.ONE, I, b, \u03c3, T, S, I);
        BigDecimal one_K = OptionsBizHelper.americanCal_\u03d5(r, Constants.ONE, K, b, \u03c3, T, S, I);
        BigDecimal zero_I = OptionsBizHelper.americanCal_\u03d5(r, Constants.ZERO, I, b, \u03c3, T, S, I);
        BigDecimal zero_K = OptionsBizHelper.americanCal_\u03d5(r, Constants.ZERO, K, b, \u03c3, T, S, I);
        return Ao.multiply(Zd).multiply(\u03b1.multiply(BigDecimal.valueOf(Math.pow(S.doubleValue(), \u03b2.doubleValue()))).subtract(\u03b1.multiply(\u03b2_I)).add(one_I).subtract(one_K).subtract(K.multiply(zero_I)).add(K.multiply(zero_K)));
    }

    public static BigDecimal americanCal_\u03d5(BigDecimal r, BigDecimal \u03b3, BigDecimal H, BigDecimal b, BigDecimal \u03c3, BigDecimal T, BigDecimal S, BigDecimal I) {
        BigDecimal \u03bb = OptionsBizHelper.americanGet_\u03bb(r, \u03b3, b, \u03c3, T);
        BigDecimal d = OptionsBizHelper.americanGet_d(S, H, b, \u03b3, \u03c3, T);
        BigDecimal k = OptionsBizHelper.americanGet_k(b, \u03c3, \u03b3);
        return OptionsBizHelper.americanGet_\u03d5(\u03bb, S, \u03b3, d, I, k, \u03c3, T);
    }

    public static BigDecimal getReferPremiumOption(ModelAgent tradeBill, BigDecimal exRate, DynamicObject plInfo, BigDecimal ... rates) {
        BigDecimal Zd;
        BigDecimal Zq;
        BigDecimal r_f;
        BigDecimal r;
        boolean isSpecRate;
        BigDecimal volatility;
        DynamicObject forexOptions = TmcDataServiceHelper.loadSingle((Object)tradeBill.getValue("id"), (String)"tm_forex_options");
        BigDecimal pv = Constants.ZERO;
        String optionType = forexOptions.getString("optiontype");
        Date lastExerDate = forexOptions.getDate("adjexpiredate");
        Date referDate = plInfo.getDate("updatedate") != null ? plInfo.getDate("updatedate") : TcDateUtils.getCurrentDate();
        Date bizDate = forexOptions.getDate("bizdate");
        String forexTradeType = forexOptions.getString("tradetype");
        BigDecimal Ao = plInfo.getBigDecimal("bizrestamt");
        BigDecimal K = forexOptions.getBigDecimal("exchangerate");
        int settleDelay = forexOptions.getInt("settledelay");
        Date adjustSettleDate = forexOptions.getDate("adjustsettledate");
        String pair = forexOptions.getString("pair");
        String fxQuote = forexOptions.getString("fxquote");
        if (EmptyUtil.isAnyoneEmpty(optionType, lastExerDate, forexTradeType, K, referDate, pair, bizDate, adjustSettleDate, exRate)) {
            return pv;
        }
        if (!pair.equals(fxQuote)) {
            exRate = Constants.ONE.divide(exRate, 10, RoundingMode.HALF_UP);
            K = Constants.ONE.divide(K, 10, RoundingMode.HALF_UP);
        }
        DynamicObject calCurrency = plInfo == null ? forexOptions.getDynamicObject("calculatecurrency") : plInfo.getDynamicObject("plcurrency");
        DynamicObject termCurrency = forexOptions.getDynamicObject("sellcurrency");
        boolean isRight = true;
        if (!EmptyUtil.isAnyoneEmpty(calCurrency, termCurrency) && calCurrency.getLong("id") != termCurrency.getLong("id")) {
            isRight = false;
            exRate = Constants.ONE.divide(exRate, 10, RoundingMode.HALF_UP);
            Ao = Ao.multiply(K);
            K = Constants.ONE.divide(K, 10, RoundingMode.HALF_UP);
            forexTradeType = OptionsTradeTypeEnum.call.getValue().equals(forexTradeType) ? OptionsTradeTypeEnum.put.getValue() : OptionsTradeTypeEnum.call.getValue();
        }
        BigDecimal bigDecimal = volatility = EmptyUtil.isNoEmpty(rates) ? rates[0] : forexOptions.getBigDecimal("volatility");
        if (EmptyUtil.isEmpty(volatility)) {
            return pv;
        }
        BigDecimal \u03c3 = volatility.divide(Constants.ONE_HUNDRED, 6, RoundingMode.HALF_UP);
        BigDecimal T = BigDecimal.valueOf((double)TcDateUtils.getDiffDays(OptionsBizHelper.getMaxDate(referDate, bizDate), lastExerDate) / 365.25);
        Date maxRefBizDate = OptionsBizHelper.getMaxDate(referDate, bizDate);
        Date maxRefBizSetDate = TradeBusinessHelper.callSettleDelayDate(null, maxRefBizDate, settleDelay);
        boolean bl = isSpecRate = EmptyUtil.isNoEmpty(rates) ? true : forexOptions.getBoolean("isspecrate");
        if (isSpecRate) {
            r = EmptyUtil.isNoEmpty(rates) ? rates[2] : forexOptions.getBigDecimal("sellcurrencyrate");
            BigDecimal bigDecimal2 = r_f = EmptyUtil.isNoEmpty(rates) ? rates[1] : forexOptions.getBigDecimal("currencyrate");
            if (EmptyUtil.isAnyoneEmpty(r, r_f)) {
                return BigDecimal.ZERO;
            }
            if (!isRight) {
                r = EmptyUtil.isNoEmpty(rates) ? rates[1] : forexOptions.getBigDecimal("currencyrate");
                r_f = EmptyUtil.isNoEmpty(rates) ? rates[2] : forexOptions.getBigDecimal("sellcurrencyrate");
            }
            r = r.divide(Constants.ONE_HUNDRED, 6, RoundingMode.HALF_UP);
            r_f = r_f.divide(Constants.ONE_HUNDRED, 6, RoundingMode.HALF_UP);
            BigDecimal Ts = BigDecimal.valueOf((double)TcDateUtils.getDiffDays(maxRefBizDate, adjustSettleDate) / 365.25);
            logger.info("Ts={}", (Object)Ts);
            Zq = BigDecimal.valueOf(Math.pow(Math.E, Constants._ONE.multiply(r).multiply(Ts).doubleValue()));
            Zd = BigDecimal.valueOf(Math.pow(Math.E, Constants._ONE.multiply(r).multiply(BigDecimal.valueOf(TcDateUtils.getDiffDays(lastExerDate, adjustSettleDate))).doubleValue() / 365.25));
        } else {
            DynamicObject termMarket;
            DynamicObject baseMarket;
            DynamicObject priceRule = forexOptions.getDynamicObject("pricerule");
            if (EmptyUtil.isAnyoneEmpty(priceRule, baseMarket = forexOptions.getDynamicObject("buymarket"), termMarket = forexOptions.getDynamicObject("sellmarket"))) {
                return BigDecimal.ZERO;
            }
            Date[] queryList = new Date[]{adjustSettleDate, maxRefBizSetDate};
            PriceRuleInfo termPrInfo = MarketDataHelper.getDiscfactor(null, maxRefBizDate, priceRule, new Long[]{termMarket.getLong("id")}, queryList);
            Zq = OptionsBizHelper.getDfMapValue(termPrInfo.getYieldCurve()[0], adjustSettleDate);
            r = MarketDataHelper.getRateByYieldCurve(null, YieldTypeEnum.ref, priceRule, termMarket.getLong("id"), maxRefBizDate, new Date[]{maxRefBizSetDate}).get(maxRefBizSetDate);
            r_f = MarketDataHelper.getRateByYieldCurve(null, YieldTypeEnum.ref, priceRule, baseMarket.getLong("id"), maxRefBizDate, new Date[]{maxRefBizSetDate}).get(maxRefBizSetDate);
            r = r.divide(Constants.ONE_HUNDRED, 6, RoundingMode.HALF_UP);
            r_f = r_f.divide(Constants.ONE_HUNDRED, 6, RoundingMode.HALF_UP);
            PriceRuleInfo ZdPrInfo = MarketDataHelper.getDiscfactor(null, lastExerDate, priceRule, new Long[]{termMarket.getLong("id")}, queryList);
            Zd = OptionsBizHelper.getDfMapValue(ZdPrInfo.getYieldCurve()[0], adjustSettleDate);
        }
        if (T.compareTo(Constants.ZERO) <= 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal D_k = OptionsBizHelper.getFlagByTradeType(forexTradeType);
        if ("european".equals(optionType)) {
            pv = OptionsBizHelper.calculateOptionPV(exRate, K, T, \u03c3, Ao, Zq, D_k).multiply(D_k);
        } else if ("american".equals(optionType)) {
            BigDecimal b = r.subtract(r_f);
            BigDecimal normal = OptionsBizHelper.americanCal(Ao, Zd, K, exRate, T, r, b, \u03c3);
            pv = OptionsTradeTypeEnum.call.getValue().equals(forexTradeType) ? normal : OptionsBizHelper.americanCal(Ao, Zd, exRate, K, T, r.subtract(b), Constants._ONE.multiply(b), \u03c3);
        }
        logger.info("T={},Zq={}", (Object)T, (Object)Zq);
        return pv;
    }

    private static BigDecimal getFLagByTradeDirect(ModelAgent tradeBill) {
        String tradedirect = (String)tradeBill.getValue("tradedirect");
        return TradeDirectionEnum.sell.getValue().equals(tradedirect) ? Constants._ONE : Constants.ONE;
    }

    public static Date getMaxDate(Date date1, Date date2) {
        if (date2.after(date1)) {
            return date2;
        }
        return date1;
    }

    public static BigDecimal getDfMapValue(YieldCurveInfo yieldCurveInfo, Date date) {
        if (EmptyUtil.isEmpty(yieldCurveInfo) || EmptyUtil.isEmpty(yieldCurveInfo.getDfMap()) || EmptyUtil.isEmpty(yieldCurveInfo.getDfMap().get(date))) {
            return Constants.ZERO;
        }
        return yieldCurveInfo.getDfMap().get(date);
    }

    public static void main(String[] args) {
        BigDecimal a = OptionsBizHelper.americanCal(Constants.ONE, Constants.ONE, new BigDecimal(40), new BigDecimal(42), new BigDecimal("0.747262"), new BigDecimal("0.04"), new BigDecimal("-0.04"), new BigDecimal("0.35"));
        System.out.println(a);
    }
}

