/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper.service;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.tmc.fbp.common.bean.tc.ForexVolInfo;
import kd.tmc.fbp.common.bean.tc.PriceRuleInfo;
import kd.tmc.fbp.common.bean.tc.RateVolInfo;
import kd.tmc.fbp.common.bean.tc.YieldCurveInfo;
import kd.tmc.fbp.common.enums.MarkPriceEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.enums.YieldTypeEnum;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class MarketDataServiceHelper {
    private static final Log logger = LogFactory.getLog(MarketDataServiceHelper.class);
    private static final String SERVICE = "marketDataService";

    public static PriceRuleInfo getPriceRule(Long priceRuleId, PriceRuleInfo param) {
        return MarketDataServiceHelper.getPriceRule(null, priceRuleId, param);
    }

    public static PriceRuleInfo getPriceRule(IFormView view, Long priceRuleId, PriceRuleInfo param) {
        PriceRuleInfo priceRule = (PriceRuleInfo)MarketDataServiceHelper.invokeBizService("priceRule", priceRuleId, param);
        if (EmptyUtil.isNoEmpty(priceRule.getErr())) {
            throw new KDBizException(TmcErrorCode.COMMON, new Object[]{priceRule.getErr()});
        }
        return priceRule;
    }

    public static ForexQuoteInfo querySpotForexQuote(IFormView view, Long forexQuoteId, ForexQuoteInfo forexQuoteParam) {
        try {
            String result = (String)MarketDataServiceHelper.invokeBizService("getForexQuoteInfo", forexQuoteId, forexQuoteParam.getFxquote(), null, null);
            ForexQuoteInfo info = (ForexQuoteInfo)SerializationUtils.fromJsonString((String)result, ForexQuoteInfo.class);
            if (EmptyUtil.isNoEmpty(info.getErrMsg())) {
                throw new KDBizException(TmcErrorCode.COMMON, new Object[]{info.getErrMsg()});
            }
            return info;
        }
        catch (Exception e) {
            if (view != null) {
                view.showErrorNotification(e.getMessage());
                return forexQuoteParam;
            }
            throw e;
        }
    }

    public static ForexQuoteInfo querySpotForexQuote(Long forexQuoteId, ForexQuoteInfo forexQuoteParam) {
        return MarketDataServiceHelper.querySpotForexQuote(null, forexQuoteId, forexQuoteParam);
    }

    public static ForexVolInfo callForexVol(IFormView view, Long priceRuleId, ForexVolInfo param) {
        return (ForexVolInfo)MarketDataServiceHelper.invokeBizService("callForexVol", priceRuleId, param);
    }

    public static Long yieldCurve(IFormView view, Long priceRuleId, Long marketId, YieldTypeEnum yieldType) {
        return (Long)MarketDataServiceHelper.invokeBizService("yieldCurve", new Object[]{priceRuleId, marketId, yieldType});
    }

    public static Map<String, Object> queryForexForwardQuote(Long priceRuleId, String bCurrency, String tmcurrency, Date forwardDate, Date refDate) {
        return (Map)MarketDataServiceHelper.invokeBizService("queryForexForwardQuote", priceRuleId, bCurrency, tmcurrency, forwardDate, refDate);
    }

    public static Map<Date, BigDecimal> callRateVol(IFormView view, RateVolInfo rateVolInfo) {
        return (Map)MarketDataServiceHelper.invokeBizService("callRateVol", rateVolInfo);
    }

    public static BigDecimal index(String index, Date quoteDate, MarkPriceEnum markprice) {
        HashSet<Date> date = new HashSet<Date>();
        date.add(quoteDate);
        Map<Date, BigDecimal> referIndex = MarketDataServiceHelper.index(index, date, markprice);
        if (EmptyUtil.isNoEmpty(referIndex) && !referIndex.isEmpty() && referIndex.containsKey(quoteDate)) {
            return referIndex.get(quoteDate);
        }
        return null;
    }

    public static Map<Date, BigDecimal> index(String index, Set<Date> quoteDate, MarkPriceEnum markprice) {
        return (Map)MarketDataServiceHelper.invokeBizService("index", new Object[]{index, quoteDate, markprice, false});
    }

    public static BigDecimal referRate(String index, Date quoteDate) {
        quoteDate = DateUtils.truncateDate(quoteDate);
        HashSet<Date> date = new HashSet<Date>();
        date.add(quoteDate);
        Map<Date, BigDecimal> rate = MarketDataServiceHelper.referRate(index, date, false);
        if (rate != null && rate.containsKey(quoteDate)) {
            return rate.get(quoteDate);
        }
        return null;
    }

    public static BigDecimal referRate(String index, Date quoteDate, boolean isReturnEmpty) {
        quoteDate = DateUtils.truncateDate(quoteDate);
        HashSet<Date> date = new HashSet<Date>();
        date.add(quoteDate);
        Map<Date, BigDecimal> rate = MarketDataServiceHelper.referRate(index, date, isReturnEmpty);
        if (rate != null && rate.containsKey(quoteDate)) {
            return rate.get(quoteDate);
        }
        return null;
    }

    public static Map<Date, BigDecimal> referRate(String index, Set<Date> quoteDate, boolean isReturnEmpty) {
        return (Map)MarketDataServiceHelper.invokeBizService("referRate", index, quoteDate, isReturnEmpty);
    }

    public static ForexQuoteInfo getForexQuoteInfo(Long forexQuoteId, String currencyPair, Date issueTime, Date Dm) {
        String result = (String)MarketDataServiceHelper.invokeBizService("getForexQuoteInfo", forexQuoteId, currencyPair, issueTime, Dm);
        ForexQuoteInfo info = (ForexQuoteInfo)SerializationUtils.fromJsonString((String)result, ForexQuoteInfo.class);
        if (EmptyUtil.isNoEmpty(info.getErrMsg())) {
            throw new KDBizException(TmcErrorCode.COMMON, new Object[]{info.getErrMsg()});
        }
        logger.info("getForexQuoteInfo:\u5916\u6c47\u62a5\u4ef7\u65b9\u5f0f={}, \u4e70\u5165\u4ef7={}, \u5356\u51fa\u4ef7={}, \u4e2d\u95f4\u4ef7={}, \u53d1\u5e03\u65f6\u95f4={}", new Object[]{info.getFxquote(), info.getBuyPrice(), info.getSellPrice(), info.getMiddleprice(), info.getIssuetime()});
        return info;
    }

    public static ForexQuoteInfo getForexQuoteInfoWithoutThrow(Long forexQuoteId, String currencyPair, Date issueTime, Date Dm) {
        logger.info("getForexQuoteInfoWithoutThrow.params:forexQuoteId={}, currencyPair={}, issueTime={}, Dm={}", new Object[]{forexQuoteId, currencyPair, issueTime != null ? DateUtils.formatString(issueTime, "yyyy-MM-dd HH:mm:ss") : null, Dm});
        String result = (String)MarketDataServiceHelper.invokeBizService("getForexQuoteInfo", forexQuoteId, currencyPair, issueTime, Dm);
        ForexQuoteInfo info = (ForexQuoteInfo)SerializationUtils.fromJsonString((String)result, ForexQuoteInfo.class);
        if (EmptyUtil.isNoEmpty(info.getErrMsg())) {
            logger.info("getForexQuoteInfoWithoutThrow:" + info.getErrMsg());
            return null;
        }
        logger.info("getForexQuoteInfoWithoutThrow:\u5916\u6c47\u62a5\u4ef7\u65b9\u5f0f={}, \u4e70\u5165\u4ef7={}, \u5356\u51fa\u4ef7={}, \u4e2d\u95f4\u4ef7={}, \u53d1\u5e03\u65f6\u95f4={}", new Object[]{info.getFxquote(), info.getBuyPrice(), info.getSellPrice(), info.getMiddleprice(), DateUtils.formatString(info.getIssuetime(), "yyyy-MM-dd HH:mm:ss")});
        return info;
    }

    public static ForexQuoteInfo getForexQuoteInfoWithIssueTime(Long forexQuoteId, String currencyPair, Date issueTime, Date Dm) {
        String result = (String)MarketDataServiceHelper.invokeBizService("getForexQuoteInfoWithIssueTime", forexQuoteId, currencyPair, issueTime, Dm);
        ForexQuoteInfo info = (ForexQuoteInfo)SerializationUtils.fromJsonString((String)result, ForexQuoteInfo.class);
        if (EmptyUtil.isNoEmpty(info.getErrMsg())) {
            throw new KDBizException(TmcErrorCode.COMMON, new Object[]{info.getErrMsg()});
        }
        logger.info("getForexQuoteInfoWithIssueTime:\u5916\u6c47\u62a5\u4ef7\u65b9\u5f0f={}, \u4e70\u5165\u4ef7={}, \u5356\u51fa\u4ef7={}, \u4e2d\u95f4\u4ef7={}, \u53d1\u5e03\u65f6\u95f4={}", new Object[]{info.getFxquote(), info.getBuyPrice(), info.getSellPrice(), info.getMiddleprice(), info.getIssuetime()});
        return info;
    }

    private static Object invokeBizService(String method, Object ... param) {
        logger.info(JSON.toJSONString((Object)param));
        Object result = DispatchServiceHelper.invokeBizService((String)TmcAppEnum.tc.getValue(), (String)TmcAppEnum.MD.getValue(), (String)SERVICE, (String)method, (Object[])param);
        logger.info(JSON.toJSONString((Object)result));
        return result;
    }

    public static YieldCurveInfo yieldCurve(YieldCurveInfo yieldCurve) {
        YieldCurveInfo yieldCurveInfo = (YieldCurveInfo)MarketDataServiceHelper.invokeBizService("yieldCurve", yieldCurve);
        return yieldCurveInfo;
    }
}

