/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.log.builder;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.common.log.IPayTraceLogInfoBuilder;
import kd.tmc.fbp.common.log.bean.PayTraceLog;
import kd.tmc.fbp.common.log.enums.PayTraceLogSourceEnum;

public class PayTraceLogPayBillBuilder
implements IPayTraceLogInfoBuilder {
    private List<PayTraceLog> traceLogList;

    public PayTraceLogPayBillBuilder(List<DynamicObject> dataList, String level, String step, String tag, String info, Exception exception) {
        this.traceLogList = new ArrayList<PayTraceLog>(dataList.size());
        for (DynamicObject data : dataList) {
            PayTraceLog logInfo = new PayTraceLog();
            logInfo.setLogType("paytracelog");
            logInfo.setBillId(data.getLong("id"));
            logInfo.setBillNumber(data.getString("billno"));
            logInfo.setEntityType(data.getDynamicObjectType().getName());
            logInfo.setSource(PayTraceLogSourceEnum.PAY.getValue());
            logInfo.setStep(step);
            logInfo.setTag(tag);
            logInfo.setTime(new Date().getTime());
            logInfo.setInfo(info);
            logInfo.setLevel(level);
            logInfo.setTraceId(RequestContext.get().getTraceId());
            if (exception != null) {
                logInfo.setException(ExceptionUtils.getExceptionStackTraceMessage((Exception)exception));
            }
            this.traceLogList.add(logInfo);
        }
    }

    public PayTraceLogPayBillBuilder(int size) {
        this.traceLogList = new ArrayList<PayTraceLog>(size);
    }

    public void addLog(DynamicObject data, String info, String level, String step, String tag, Exception exception) {
        PayTraceLog logInfo = new PayTraceLog();
        logInfo.setLogType("paytracelog");
        logInfo.setBillId(data.getLong("id"));
        logInfo.setBillNumber(data.getString("billno"));
        logInfo.setEntityType(data.getDynamicObjectType().getName());
        logInfo.setSource(PayTraceLogSourceEnum.PAY.getValue());
        logInfo.setStep(step);
        logInfo.setTag(tag);
        logInfo.setTime(new Date().getTime());
        logInfo.setInfo(info);
        logInfo.setLevel(level);
        logInfo.setTraceId(RequestContext.get().getTraceId());
        if (exception != null) {
            logInfo.setException(ExceptionUtils.getExceptionStackTraceMessage((Exception)exception));
        }
        this.traceLogList.add(logInfo);
    }

    @Override
    public List<PayTraceLog> build() {
        return this.traceLogList;
    }
}

