/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.model.interest;

import java.math.BigDecimal;
import java.util.Date;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class IntBillDetailExtInfo
extends IntBillDetailInfo {
    private BigDecimal floatRate = BigDecimal.ZERO;
    private BigDecimal floatInt = BigDecimal.ZERO;
    private BigDecimal benchmarkInt = BigDecimal.ZERO;
    private Date beginConfirmDate;
    private Date endConfirmDate;
    private int observeOffsetDay = 0;

    public static IntBillDetailExtInfo build(IntBillDetailInfo detailInfo) {
        IntBillDetailExtInfo extInfo = new IntBillDetailExtInfo();
        extInfo.setBeginDate(detailInfo.getBeginDate());
        extInfo.setEndDate(detailInfo.getEndDate());
        extInfo.setDays(detailInfo.getDays());
        extInfo.setPrinciple(detailInfo.getPrinciple());
        extInfo.setRate(detailInfo.getRate());
        extInfo.setBasisDay(detailInfo.getBasisDay());
        extInfo.setIntType(detailInfo.getIntType());
        extInfo.setAmount(detailInfo.getAmount());
        extInfo.setLastTotalInt(detailInfo.getLastTotalInt());
        extInfo.setSeq(detailInfo.getSeq());
        return extInfo;
    }

    public int getConfirmDays() {
        return this.beginConfirmDate != null && this.endConfirmDate != null ? DateUtils.getDiffDays(this.beginConfirmDate, this.endConfirmDate) - this.observeOffsetDay : 0;
    }

    public BigDecimal getTotalInt() {
        return this.benchmarkInt.add(this.floatInt);
    }

    public BigDecimal getTotalRate() {
        return this.getRate();
    }

    public BigDecimal getFloatRate() {
        return this.floatRate;
    }

    public BigDecimal getBenchmarkRate() {
        return EmptyUtil.isNoEmpty(this.floatRate) ? this.getRate().subtract(this.floatRate) : this.getRate();
    }

    public IntBillDetailExtInfo setFloatRate(BigDecimal floatRate) {
        this.floatRate = floatRate;
        return this;
    }

    public BigDecimal getFloatInt() {
        return this.floatInt;
    }

    public IntBillDetailExtInfo setFloatInt(BigDecimal floatInt) {
        this.floatInt = floatInt;
        return this;
    }

    public BigDecimal getBenchmarkInt() {
        return this.benchmarkInt;
    }

    public IntBillDetailExtInfo setBenchmarkInt(BigDecimal benchmarkInt) {
        this.benchmarkInt = benchmarkInt;
        return this;
    }

    public Date getBeginConfirmDate() {
        return this.beginConfirmDate;
    }

    public IntBillDetailExtInfo setBeginConfirmDate(Date beginConfirmDate) {
        this.beginConfirmDate = beginConfirmDate;
        return this;
    }

    public Date getEndConfirmDate() {
        return this.endConfirmDate;
    }

    public IntBillDetailExtInfo setEndConfirmDate(Date endConfirmDate) {
        this.endConfirmDate = endConfirmDate;
        return this;
    }

    public IntBillDetailExtInfo setObserveOffsetDay(int observeOffsetDay) {
        this.observeOffsetDay = observeOffsetDay;
        return this;
    }
}

