/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.model.interest;

import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.RateCycleWayEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class WorkCalendarAdjustParam {
    private DynamicObjectCollection workCalendars;
    private AdjustMethodEnum adjustMethod;
    private RateCycleWayEnum rateCycleWay = RateCycleWayEnum.FixDate;

    public static WorkCalendarAdjustParam build(DynamicObjectCollection workCalendars, AdjustMethodEnum adjustMethod) {
        return new WorkCalendarAdjustParam().setWorkCalendars(workCalendars).setAdjustMethod(adjustMethod);
    }

    public static WorkCalendarAdjustParam build(DynamicObjectCollection workCalendars, String adjustMethod) {
        return new WorkCalendarAdjustParam().setWorkCalendars(workCalendars).setAdjustMethod(AdjustMethodEnum.getEnumByValue(adjustMethod));
    }

    public boolean isCanAdjust() {
        return !EmptyUtil.isEmpty(this.workCalendars) && this.adjustMethod != null && this.adjustMethod != AdjustMethodEnum.no_adjust;
    }

    public DynamicObjectCollection getWorkCalendars() {
        return this.workCalendars;
    }

    public WorkCalendarAdjustParam setWorkCalendars(DynamicObjectCollection workCalendars) {
        this.workCalendars = workCalendars;
        return this;
    }

    public AdjustMethodEnum getAdjustMethod() {
        return this.adjustMethod;
    }

    public WorkCalendarAdjustParam setAdjustMethod(AdjustMethodEnum adjustMethod) {
        this.adjustMethod = adjustMethod;
        return this;
    }

    public RateCycleWayEnum getRateCycleWay() {
        return this.rateCycleWay;
    }

    public WorkCalendarAdjustParam setRateCycleWay(RateCycleWayEnum rateCycleWay) {
        this.rateCycleWay = rateCycleWay;
        return this;
    }
}

