/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.model.tda.invest;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Row;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositRow {
    private Long id;
    private BigDecimal frate;
    private Date startDate;
    private Date endDate;
    private String customType;
    private String rateSign;
    private BigDecimal rateFloatPoint;
    private Map<Date, String> referRateDataMap;
    private List<Object[]> dateList;

    public DepositRow(Row row, Date startDate, Date endDate, String customType, Map<Date, String> referRateDataMap) {
        this.id = row.getLong("id");
        this.frate = row.getBigDecimal("frate");
        this.rateSign = row.getString("ratesign");
        this.rateFloatPoint = row.getBigDecimal("ratefloatpoint");
        this.startDate = startDate;
        this.endDate = endDate;
        this.customType = customType;
        this.referRateDataMap = referRateDataMap;
        this.initDateList();
    }

    private void initDateList() {
        if (EmptyUtil.isEmpty(this.referRateDataMap)) {
            return;
        }
        this.dateList = new ArrayList<Object[]>(32);
        Date lastEndDate = this.endDate;
        for (Map.Entry<Date, String> entry : this.referRateDataMap.entrySet()) {
            Date date = entry.getKey();
            if (date.compareTo(this.endDate) > 0) continue;
            BigDecimal rate = new BigDecimal(entry.getValue());
            if ("add".equals(this.rateSign) && this.rateFloatPoint != null) {
                rate = rate.add(this.rateFloatPoint.multiply(new BigDecimal("0.01")));
            } else if ("subtract".equals(this.rateSign) && this.rateFloatPoint != null) {
                rate = rate.subtract(this.rateFloatPoint.multiply(new BigDecimal("0.01")));
            }
            if (date.compareTo(this.startDate) > 0) {
                Date lastStartDate = date;
                this.dateList.add(new Object[]{lastStartDate, lastEndDate, rate});
                lastEndDate = DateUtils.getNextDay(lastStartDate, -1);
                continue;
            }
            this.setFrate(rate);
            break;
        }
        this.dateList.add(new Object[]{this.startDate, lastEndDate, this.getFrate()});
    }

    public String key() {
        return DepositRow.generateKey(this.id, this.customType, this.startDate);
    }

    public static String generateKey(Long id, String customType, Date bizDate) {
        return id.toString() + customType + DateUtils.formatString(bizDate, "yyyyMMdd");
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public BigDecimal getFrate() {
        return this.frate;
    }

    public void setFrate(BigDecimal frate) {
        this.frate = frate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public List<Object[]> getDateList() {
        return this.dateList;
    }
}

