/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.ofd;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.ofd.XmlUtil;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;

public class OfdReadUtil {
    private static final Log LOGGER = LogFactory.getLog(OfdReadUtil.class);

    public static Element parse(Element node, String type, String val) {
        Iterator iter = node.elementIterator();
        while (iter.hasNext()) {
            Element element = (Element)iter.next();
            Attribute name = element.attribute(type);
            if (name == null) continue;
            String value = name.getValue();
            if (value != null && val.equals(value)) {
                return element;
            }
            OfdReadUtil.parse(element, type, val);
        }
        return null;
    }

    public static Element getElementByPath(Map<String, byte[]> ofdFileMap, Element element, String dirPath) {
        String pagePath = dirPath + element.attributeValue("BaseLoc");
        return OfdReadUtil.getElementByByte(ofdFileMap.get(pagePath));
    }

    public static Element getElementByPath(Map<String, byte[]> ofdFileMap, String filePath) {
        return OfdReadUtil.getElementByByte(OfdReadUtil.getByteByPath(ofdFileMap, filePath));
    }

    public static byte[] getByteByPath(Map<String, byte[]> ofdFileMap, String filePath) {
        if (filePath != null && filePath.startsWith("/")) {
            filePath = filePath.substring(1);
        }
        return ofdFileMap.get(filePath);
    }

    public static Element getElementByByte(byte[] fileByte) {
        try {
            Document document = XmlUtil.loadXML(fileByte);
            return document.getRootElement();
        }
        catch (Exception e) {
            LOGGER.error("\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u52a0\u8f7d\u5931\u8d25:" + e.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u52a0\u8f7d\u5931\u8d25:%s\u3002", (String)"OfdReadUtil_0", (String)"tmc-fbp-common", (Object[])new Object[]{e.getMessage()}));
        }
    }

    public static StringBuilder getLastDirPath(String path) {
        String[] pathArr;
        StringBuilder buffer = new StringBuilder();
        for (String pathStr : pathArr = path.split("/")) {
            if (pathStr == null || pathStr.trim().equals("") || pathStr.contains(".")) continue;
            buffer.append(pathStr).append("/");
        }
        return buffer;
    }

    public static void getAllElementByElementName(Element parentElement, String elementName, String moreElementName, List<Element> targetList) {
        try {
            List moreElementList;
            List elementList = parentElement.elements(elementName);
            if (elementList != null && !elementList.isEmpty()) {
                targetList.addAll(elementList);
            }
            if ((moreElementList = parentElement.elements(moreElementName)) != null && !moreElementList.isEmpty()) {
                for (Element moreElement : moreElementList) {
                    OfdReadUtil.getAllElementByElementName(moreElement, elementName, moreElementName, targetList);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6587\u4ef6\u5185\u5bb9\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u83b7\u53d6\u6570\u636e\u5931\u8d25:" + e.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u83b7\u53d6\u6570\u636e\u5931\u8d25:%s\u3002", (String)"OfdReadUtil_1", (String)"tmc-fbp-common", (Object[])new Object[]{e.getMessage()}));
        }
    }

    public static String getDirPath(String path, String lastPath) {
        if (EmptyUtil.isNoEmpty(path)) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (EmptyUtil.isNoEmpty(lastPath) && !path.startsWith(lastPath = OfdReadUtil.getLastDirPath(lastPath).toString())) {
                path = lastPath + path;
            }
        }
        return path;
    }

    public static String getTextByPath(byte[] fileByte, String path) {
        String text;
        try {
            String[] dirArr;
            Element elementNow = OfdReadUtil.getElementByByte(fileByte);
            for (String dir : dirArr = path.split("/")) {
                String[] arr;
                boolean moreFlag = false;
                if (dir.contains("|||") && (arr = dir.split("\\|\\|\\|")).length == 2) {
                    List elementList = elementNow.elements(arr[0]);
                    for (Element e : elementList) {
                        if (!arr[1].equals(e.attributeValue("Name"))) continue;
                        elementNow = e;
                        moreFlag = true;
                        break;
                    }
                }
                if (moreFlag) continue;
                if (elementNow.element(dir) != null) {
                    elementNow = elementNow.element(dir);
                    continue;
                }
                return null;
            }
            text = elementNow.getText();
            text = OfdReadUtil.removeStartSymbol(text, "/");
        }
        catch (Exception e) {
            LOGGER.error("\u6587\u4ef6\u5185\u5bb9\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u83b7\u53d6\u6570\u636e\u5931\u8d25:" + e.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u83b7\u53d6\u6570\u636e\u5931\u8d25:%s\u3002", (String)"OfdReadUtil_1", (String)"tmc-fbp-common", (Object[])new Object[]{e.getMessage()}));
        }
        return text;
    }

    private static String removeStartSymbol(String str, String symbol) {
        while (EmptyUtil.isNoEmpty(str) && str.startsWith(symbol)) {
            str = str.substring(1);
        }
        return str;
    }
}

