/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.ofd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.ofd.GenImageString;
import kd.tmc.fbp.common.ofd.OfdReadUtil;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;

public class SvgUtil {
    public static Map<String, Object> getPageSvg(Element pageEle, String areaText, Map<String, Object> fontFamilyMap, StringBuilder svgBuffer, Map<String, Object> multiMediaMap, float offsetY, int pageNum, String signSvgString) {
        HashMap<String, Object> svgMap = new HashMap<String, Object>();
        if (pageEle == null) {
            return svgMap;
        }
        Element areaEle = pageEle.element("Area");
        if (areaEle != null) {
            areaText = areaEle.elementText("PhysicalBox");
        }
        if (!StringUtils.isEmpty((CharSequence)areaText)) {
            String[] areaArr = areaText.split(" ");
            if (svgBuffer == null || svgBuffer.length() == 0) {
                float areaHeight;
                float areaWidth = Float.parseFloat(areaArr[2]);
                if (areaWidth == 0.0f) {
                    areaWidth = 210.0f;
                }
                if ((areaHeight = Float.parseFloat(areaArr[3])) == 0.0f) {
                    areaHeight = pageNum == 0 ? 140.0f : 297.0f;
                }
                float offsetHeight = offsetY + areaHeight;
                svgMap.put("offsetY", Float.valueOf(offsetHeight));
                svgMap.put("offsetX", Float.valueOf(areaWidth));
                svgBuffer = new StringBuilder();
                svgBuffer.append("<svg width=\"").append(areaWidth).append("mm\" height=\" ").append(offsetHeight);
                svgBuffer.append("mm\">");
            }
        }
        if (pageEle != null) {
            Element contentEle = pageEle.element("Content");
            List layerEleList = contentEle.elements("Layer");
            for (Element layerEle : layerEleList) {
                String drawParamId = layerEle.attributeValue("DrawParam");
                ArrayList<Element> imageEleList = new ArrayList<Element>();
                OfdReadUtil.getAllElementByElementName(layerEle, "ImageObject", "PageBlock", imageEleList);
                if (!imageEleList.isEmpty()) {
                    svgBuffer.append((CharSequence)SvgUtil.getSvgImageByList(imageEleList, multiMediaMap, 0.0f, offsetY));
                }
                ArrayList<Element> pathObjectEleList = new ArrayList<Element>();
                OfdReadUtil.getAllElementByElementName(layerEle, "PathObject", "PageBlock", pathObjectEleList);
                ArrayList<Element> textEleList = new ArrayList<Element>();
                OfdReadUtil.getAllElementByElementName(layerEle, "TextObject", "PageBlock", textEleList);
                if (!pathObjectEleList.isEmpty()) {
                    svgBuffer.append(SvgUtil.getSvgLineByList(pathObjectEleList, fontFamilyMap, drawParamId, 0.0f, offsetY, 1.0f, 1.0f));
                }
                if (textEleList.isEmpty()) continue;
                SvgUtil.getSvgTextByList(textEleList, fontFamilyMap, svgBuffer, drawParamId, 0.0f, offsetY, 1.0f, 1.0f);
            }
        }
        if (!EmptyUtil.isEmpty(signSvgString)) {
            svgBuffer.append(signSvgString);
        }
        svgMap.put("svgBuffer", svgBuffer);
        return svgMap;
    }

    public static void appendAnnotation(Element annotationEle, Map<String, Object> fontFamilyMap, StringBuilder svgBuffer, Map<String, Object> multiMediaMap, float offsetY) {
        List annotList = annotationEle.elements("Annot");
        if (annotList == null) {
            return;
        }
        for (Element annotEle : annotList) {
            List imageEleList;
            List textEleList;
            Element appearanceEle = annotEle.element("Appearance");
            String boundary = appearanceEle.attributeValue("Boundary");
            float x = 0.0f;
            float y = 0.0f;
            if (!StringUtils.isEmpty((CharSequence)boundary)) {
                String[] boundaryArr = boundary.split(" ");
                x = Float.parseFloat(boundaryArr[0]);
                y = Float.parseFloat(boundaryArr[1]) + offsetY;
            }
            if ((textEleList = appearanceEle.elements("TextObject")) != null && !textEleList.isEmpty()) {
                SvgUtil.getSvgTextByList(textEleList, fontFamilyMap, svgBuffer, null, x, y, 1.0f, 1.0f);
            }
            if ((imageEleList = appearanceEle.elements("ImageObject")) == null || imageEleList.isEmpty()) continue;
            svgBuffer.append((CharSequence)SvgUtil.getSvgImageByList(imageEleList, multiMediaMap, x, y));
        }
    }

    public static StringBuilder getSvgTextByList(List<Element> textEleList, Map<String, Object> fontFamilyMap, StringBuilder svgBuffer, String commonDrawParamId, float pageOffsetX, float pageOffsetY, float zoomX, float zoomY) {
        for (Element textEleTag : textEleList) {
            String drawParamId = textEleTag.attributeValue("DrawParam");
            if (StringUtils.isEmpty((CharSequence)drawParamId)) {
                drawParamId = commonDrawParamId;
            }
            String fillColorStr = (String)fontFamilyMap.get("LINE_COLOR_" + drawParamId);
            String boundary = textEleTag.attributeValue("Boundary");
            String[] boundaryArr = boundary.split(" ");
            String fontFamily = (String)fontFamilyMap.get(textEleTag.attributeValue("Font"));
            String fontSizeStr = textEleTag.attributeValue("Size");
            float fontSize = Float.parseFloat(fontSizeStr);
            List textCodeEles = textEleTag.elements("TextCode");
            if (textCodeEles == null || textCodeEles.isEmpty()) continue;
            for (Element textCodeEle : textCodeEles) {
                String offsetYStr;
                if (textCodeEle == null) continue;
                String textStr = textCodeEle.getText();
                String offsetXStr = textCodeEle.attributeValue("X");
                if (StringUtils.isEmpty((CharSequence)offsetXStr)) {
                    offsetXStr = "0";
                }
                if (StringUtils.isEmpty((CharSequence)(offsetYStr = textCodeEle.attributeValue("Y")))) {
                    offsetYStr = "0";
                }
                float offsetX = Float.parseFloat(offsetXStr) * zoomX;
                float offsetY = Float.parseFloat(offsetYStr) * zoomY;
                String deltaX = textCodeEle.attributeValue("DeltaX");
                String deltaY = textCodeEle.attributeValue("DeltaY");
                String fontColor = "#000000";
                Element fontColorEle = textEleTag.element("FillColor");
                if (fontColorEle != null) {
                    fontColor = SvgUtil.getHexColorByRgb(fontColorEle.attributeValue("Value"));
                } else if (!EmptyUtil.isEmpty(fillColorStr)) {
                    fontColor = SvgUtil.getHexColorByRgb(fillColorStr);
                }
                String ctmStr = textEleTag.attributeValue("CTM");
                float x = Float.parseFloat(boundaryArr[0]) * zoomX;
                float y = Float.parseFloat(boundaryArr[1]) * zoomY;
                fontSize *= zoomX;
                String[] ctmArr = null;
                if (ctmStr != null && !"".equals(ctmStr)) {
                    ctmArr = ctmStr.split(" ");
                    float ctmX = x + pageOffsetX + Float.parseFloat(ctmArr[4]) * zoomX;
                    float ctmY = y + pageOffsetY + Float.parseFloat(ctmArr[5]) * zoomY;
                    ctmArr[4] = ctmX + "";
                    ctmArr[5] = ctmY + "";
                    x = offsetX;
                    y = offsetY;
                } else {
                    x = x + offsetX + pageOffsetX;
                    y = y + offsetY + pageOffsetY;
                }
                textStr = EmptyUtil.isEmpty(deltaX) && EmptyUtil.isEmpty(deltaY) ? SvgUtil.getCdataStr(textStr) : SvgUtil.getOffsetBuffer(textStr, x, y, deltaX, deltaY, zoomX, zoomY);
                svgBuffer.append("<text x=\"").append(x).append("mm\" y=\"").append(y).append("mm\" ");
                svgBuffer.append("fill=\"").append(fontColor).append("\" font-size=\"").append(fontSize).append("mm\" ");
                svgBuffer.append("font-family=\"").append(fontFamily).append("\" ");
                svgBuffer.append((CharSequence)SvgUtil.getTextCtmBuffer(ctmArr)).append(">").append(textStr).append("</text>");
            }
        }
        return svgBuffer;
    }

    public static String getSvgLineByList(List<Element> lineEleList, Map<String, Object> fontFamilyMap, String commonDrawParamId, float pageOffsetX, float pageOffsetY, float zoomX, float zoomY) {
        StringBuilder svgBuffer = new StringBuilder();
        for (Element lineEle : lineEleList) {
            String[] parts;
            String drawParamId = lineEle.attributeValue("DrawParam");
            if (StringUtils.isEmpty((CharSequence)drawParamId)) {
                drawParamId = commonDrawParamId;
            }
            String fillColorStr = (String)fontFamilyMap.get("LINE_COLOR_" + drawParamId);
            String lineWidthStr = (String)fontFamilyMap.get("LINE_WIDTH_" + drawParamId);
            String boundary = lineEle.attributeValue("Boundary");
            String[] boundaryArr = boundary.split(" ");
            float x = Float.parseFloat(boundaryArr[0]) + pageOffsetX;
            float y = Float.parseFloat(boundaryArr[1]) + pageOffsetY;
            String ctmMatrix = "";
            String ctmStr = lineEle.attributeValue("CTM");
            if (EmptyUtil.isNoEmpty(ctmStr)) {
                String[] ctmArr = ctmStr.split(" ");
                if (ctmArr.length == 6) {
                    ctmArr[4] = x + Float.parseFloat(ctmArr[4]) * zoomX + "";
                    ctmArr[5] = y + Float.parseFloat(ctmArr[5]) * zoomY + "";
                    ctmMatrix = SvgUtil.getTextCtmBuffer(ctmArr).toString();
                }
            } else {
                ctmMatrix = SvgUtil.getTranslateStr(x, y);
            }
            String stroke = lineEle.attributeValue("Stroke");
            String lineWidth = lineEle.attributeValue("LineWidth");
            if (EmptyUtil.isEmpty(lineWidth) && EmptyUtil.isNoEmpty(lineWidthStr)) {
                lineWidth = lineWidthStr;
            }
            if (EmptyUtil.isNoEmpty(lineWidth)) {
                float lineWidthFloat = Float.parseFloat(lineWidth) * zoomX;
                if (lineWidthFloat <= 0.0f) {
                    lineWidthFloat = 0.25f;
                }
                lineWidth = lineWidthFloat + "";
            }
            String fillFlag = lineEle.attributeValue("Fill");
            String strokeColor = "#000000";
            String fillColor = null;
            Element strokeColorEle = lineEle.element("StrokeColor");
            Element fillColorEle = lineEle.element("FillColor");
            if ("true".equals(fillFlag) && fillColorEle != null) {
                fillColor = SvgUtil.getHexColorByRgb(fillColorEle.attributeValue("Value"));
            }
            if (strokeColorEle != null) {
                strokeColor = SvgUtil.getHexColorByRgb(strokeColorEle.attributeValue("Value"));
            } else if (EmptyUtil.isNoEmpty(fillColorStr)) {
                strokeColor = SvgUtil.getHexColorByRgb(fillColorStr);
            }
            StringBuilder dBuffer = new StringBuilder();
            String abbreviatedData = SvgUtil.getPathAbbreviatedData(lineEle, stroke);
            abbreviatedData = abbreviatedData.replace("\n", "");
            block18: for (String part : parts = abbreviatedData.split(" (?=[SMLQBAC])")) {
                String[] temps = part.split(" ");
                switch (temps[0]) {
                    case "S": 
                    case "M": {
                        dBuffer.append("M ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[1])) * zoomX).append(" ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[2])) * zoomY).append(" ");
                        continue block18;
                    }
                    case "L": {
                        dBuffer.append("L ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[1])) * zoomX).append(" ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[2])) * zoomY).append(" ");
                        continue block18;
                    }
                    case "Q": {
                        dBuffer.append("Q ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[1]))).append(" ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[2]))).append(" ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[3]))).append(" ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[4]))).append(" ");
                        continue block18;
                    }
                    case "B": {
                        dBuffer.append("C ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[1]))).append(" ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[2]))).append(" ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[3]))).append(" ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[4]))).append(" ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[5]))).append(" ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[6]))).append(" ");
                        continue block18;
                    }
                    case "A": {
                        dBuffer.append("A ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[1]))).append(" ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[2]))).append(" ");
                        dBuffer.append(Integer.parseInt(temps[3])).append(" ");
                        dBuffer.append(Integer.parseInt(temps[4])).append(" ");
                        dBuffer.append(Integer.parseInt(temps[5])).append(" ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[6]))).append(" ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[7]))).append(" ");
                        continue block18;
                    }
                    case "C": {
                        dBuffer.append("Z ");
                        continue block18;
                    }
                }
            }
            svgBuffer.append((CharSequence)SvgUtil.getPathBuffer(strokeColor, fillColor, lineWidth, ctmMatrix, dBuffer.toString()));
        }
        return svgBuffer.toString();
    }

    private static String getPathAbbreviatedData(Element lineEle, String stroke) {
        String abbreviatedDataClib;
        Element path;
        Element area;
        Element clip;
        String abbreviatedData = lineEle.elementText("AbbreviatedData");
        Element clips = lineEle.element("Clips");
        if (!("true".equals(stroke) || clips == null || (clip = clips.element("Clip")) == null || (area = clip.element("Area")) == null || (path = area.element("Path")) == null || "NonZero".equals(path.attributeValue("Rule")) || StringUtils.isEmpty((CharSequence)(abbreviatedDataClib = path.elementText("AbbreviatedData"))) || abbreviatedDataClib.trim().endsWith("C"))) {
            abbreviatedData = abbreviatedDataClib;
        }
        return abbreviatedData;
    }

    private static StringBuilder getTextCtmBuffer(String[] ctmArr) {
        StringBuilder matrixBuffer = new StringBuilder();
        if (ctmArr != null && ctmArr.length == 6) {
            matrixBuffer.append(" transform=\"matrix(");
            matrixBuffer.append(ctmArr[0]).append(" ");
            matrixBuffer.append(ctmArr[1]).append(" ");
            matrixBuffer.append(ctmArr[2]).append(" ");
            matrixBuffer.append(ctmArr[3]).append(" ");
            matrixBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(ctmArr[4]))).append(" ");
            matrixBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(ctmArr[5])));
            matrixBuffer.append(")\" ");
        }
        return matrixBuffer;
    }

    private static String getTranslateStr(float x, float y) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(" transform=\"translate(");
        buffer.append(SvgUtil.getPxByMM(x)).append(",");
        buffer.append(SvgUtil.getPxByMM(y));
        buffer.append(")\" ");
        return buffer.toString();
    }

    public static float getPxByMM(float mmValue) {
        return mmValue * 96.0f / 25.4f;
    }

    private static StringBuilder getPathBuffer(String strokeColor, String fillColor, String lineWidth, String ctmMatrix, String d) {
        StringBuilder lineBuffer;
        if (EmptyUtil.isNoEmpty(fillColor)) {
            lineBuffer = new StringBuilder("<path ");
            lineBuffer.append("fill=\"").append(fillColor).append("\" ");
            if ("#FFFFFF".equalsIgnoreCase(fillColor)) {
                return new StringBuilder();
            }
        } else {
            lineBuffer = new StringBuilder("<path fill=\"none\" ");
            lineBuffer.append("stroke=\"").append(strokeColor).append("\" ");
            if (EmptyUtil.isNoEmpty(lineWidth)) {
                lineBuffer.append("stroke-width=\"").append(lineWidth).append("mm\" ");
            }
        }
        lineBuffer.append("d=\"").append(d).append("\" ");
        lineBuffer.append(ctmMatrix).append("/> ");
        return lineBuffer;
    }

    private static StringBuilder getSvgImageByList(List<Element> imageEleList, Map<String, Object> multiMediaMap, float offsetX, float offsetY) {
        StringBuilder imageBuffer = new StringBuilder();
        for (int i = 0; i < imageEleList.size(); ++i) {
            Element imageEle = imageEleList.get(i);
            String resourceID = imageEle.attributeValue("ResourceID");
            String boundary = imageEle.attributeValue("Boundary");
            String[] boundaryArr = boundary.split(" ");
            String imageName = (String)multiMediaMap.get(resourceID);
            if (imageName == null || "".equals(imageName)) continue;
            byte[] imageFileByte = (byte[])multiMediaMap.get(resourceID + "_BYTE");
            String imageBase64Str = GenImageString.getImageBase64(imageFileByte, imageName.split("\\.")[1]);
            imageBuffer.append("<image x=\"").append(offsetX + Float.parseFloat(boundaryArr[0])).append("mm\" ");
            imageBuffer.append("y=\"").append(offsetY + Float.parseFloat(boundaryArr[1])).append("mm\" ");
            imageBuffer.append("width=\"").append(boundaryArr[2]).append("mm\" ");
            imageBuffer.append("height=\"").append(boundaryArr[3]).append("mm\" xlink:href=\"data:image/png;base64,");
            imageBuffer.append(imageBase64Str.replaceAll("\r", "").replaceAll("\n", ""));
            imageBuffer.append("\"/>");
        }
        return imageBuffer;
    }

    private static String getOffsetBuffer(String textStr, float xIndex, float yIndex, String deltaX, String deltaY, float zoomX, float zoomY) {
        StringBuilder offsetYBuffer = new StringBuilder();
        float lastX = xIndex;
        float lastY = yIndex;
        if (!StringUtils.isEmpty((CharSequence)deltaX)) {
            deltaX = SvgUtil.deltaFormatter(deltaX);
        }
        if (!StringUtils.isEmpty((CharSequence)deltaY)) {
            deltaY = SvgUtil.deltaFormatter(deltaY);
        }
        String[] deltaXArr = null;
        if (!StringUtils.isEmpty((CharSequence)deltaX)) {
            deltaXArr = deltaX.split(" ");
        }
        String[] deltaYArr = null;
        if (!StringUtils.isEmpty((CharSequence)deltaY)) {
            deltaYArr = deltaY.split(" ");
        }
        for (int i = 0; i < textStr.length(); ++i) {
            offsetYBuffer.append("<tspan x=\"").append(lastX);
            offsetYBuffer.append("mm\" y=\"").append(lastY).append("mm\">");
            offsetYBuffer.append(SvgUtil.getCdataStr(textStr.substring(i, i + 1))).append("</tspan>");
            if (i >= textStr.length() - 1) continue;
            float offsetX = 0.0f;
            if (deltaXArr != null) {
                offsetX = i < deltaXArr.length - 1 ? Float.parseFloat(deltaXArr[i]) : Float.parseFloat(deltaXArr[deltaXArr.length - 1]);
            }
            float offsetY = 0.0f;
            if (deltaYArr != null) {
                offsetY = i < deltaYArr.length - 1 ? Float.parseFloat(deltaYArr[i]) : Float.parseFloat(deltaYArr[deltaYArr.length - 1]);
            }
            lastX += offsetX * zoomX;
            lastY += offsetY * zoomY;
        }
        return offsetYBuffer.toString();
    }

    private static String deltaFormatter(String delta) {
        if (!delta.contains("g")) {
            return delta;
        }
        List tempList = Arrays.stream(delta.split(" ")).collect(Collectors.toList());
        boolean gFlag = false;
        boolean gProcessing = false;
        int gItemCount = 0;
        ArrayList<String> floatList = new ArrayList<String>();
        for (String s : tempList) {
            if ("g".equals(s)) {
                gFlag = true;
                continue;
            }
            if (s == null || s.trim().length() == 0) continue;
            if (gFlag) {
                gItemCount = Integer.parseInt(s);
                gProcessing = true;
                gFlag = false;
                continue;
            }
            if (gProcessing) {
                for (int j = 0; j < gItemCount; ++j) {
                    floatList.add(s);
                }
                gProcessing = false;
                continue;
            }
            floatList.add(s);
        }
        StringBuilder sb = new StringBuilder();
        for (String item : floatList) {
            sb.append(' ').append(item);
        }
        return sb.toString().trim();
    }

    private static String getCdataStr(String str) {
        if (str != null) {
            str = str.replaceAll("&", "&amp;");
            str = str.replaceAll("  ", "&#160;");
            str = str.replaceAll("<", "&lt;");
            str = str.replaceAll(">", "&gt;");
        }
        return str;
    }

    private static String getHexColorByRgb(String rgbStr) {
        if ("0 0 0".equals(rgbStr) || rgbStr == null || "".equals(rgbStr)) {
            return "#000000";
        }
        if ("156 82 35".equals(rgbStr)) {
            return "#9C5223";
        }
        String[] rgbArr = rgbStr.split(" ");
        return String.format("#%02X%02X%02X", Integer.parseInt(rgbArr[0]), Integer.parseInt(rgbArr[1]), Integer.parseInt(rgbArr[2]));
    }
}

