/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.sign;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.MessageTypes;
import kd.bos.form.SignCallbackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.common.helper.BeiParameterHelper;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.sign.ISignExecutor;
import kd.tmc.fbp.common.sign.ISignInvoker;
import kd.tmc.fbp.common.sign.SignHandler;
import kd.tmc.fbp.common.util.EmptyUtil;

public abstract class CommitBeCrossBillSignBasePlugin
extends AbstractFormPlugin
implements ISignInvoker,
Serializable {
    private static Log logger = LogFactory.getLog(CommitBeCrossBillSignBasePlugin.class);
    public static final String KEY_SUCCESSIDLIST = "_KEY_SUCCESSIDLIST_";

    protected String getOpName() {
        return null;
    }

    protected String getOrgPropName() {
        return null;
    }

    protected List<ISignExecutor> getSignExecutors(List<DynamicObject> auditPayBillList, List<DynamicObject> submitPayBillList, List<Object> needCommitBeIdList) {
        return null;
    }

    protected void onSignSuccess(String errMsg) {
        String errorMessage = errMsg;
        if (errorMessage != null && errorMessage.length() > 0) {
            if (this.getPayBillIdList().size() > 1) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u63d0\u4ea4\u94f6\u4f01\u6210\u529f, \u4f46\u6709\u90e8\u5206\u9519\u8bef\u6d88\u606f\u9700\u8981\u786e\u8ba4\u3002", (String)"CommitBeCrossBillSignBasePlugin_0", (String)"tmc-fbp-common", (Object[])new Object[0]), errorMessage, MessageTypes.Default);
            } else {
                this.getView().showErrorNotification(errorMessage);
            }
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u94f6\u4f01\u6210\u529f\u3002", (String)"CommitBeCrossBillSignBasePlugin_1", (String)"tmc-fbp-common", (Object[])new Object[0]));
        }
    }

    protected void onSignError(Exception e) {
        String message = e instanceof KDException ? e.getMessage() : ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
        this.getView().showErrorNotification(message);
    }

    protected void sign() {
        this.sign(this.getPayBillIdList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sign(List<Object> payBillIdList) {
        String entityName = this.getEntityName();
        AtomicBoolean needSign = new AtomicBoolean(false);
        DynamicObject[] dataList = BusinessDataServiceHelper.load((Object[])payBillIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
        ArrayList<OperateErrorInfo> errors = new ArrayList<OperateErrorInfo>();
        List<String> idList = Arrays.stream(dataList).map(DataEntityBase::getPkValue).map(String::valueOf).collect(Collectors.toList());
        Map<String, Boolean> request = MutexServiceHelper.batchRequest(idList, entityName, this.getOpName());
        List<String> requestIds = MutexServiceHelper.getRequestResultList(dataList, errors, request);
        try {
            this.getPageCache().put(KEY_SUCCESSIDLIST, SerializationUtils.toJsonString(requestIds));
            SignHandler handler = this.createHandler(true);
            needSign.set(handler.sign());
            if (!needSign.get()) {
                this.onSignSuccess(handler.getErrorMessage());
            }
        }
        catch (Exception e) {
            needSign.set(false);
            this.onSignError(e);
        }
        finally {
            if (!needSign.get()) {
                MutexServiceHelper.batchRelease(requestIds, entityName, this.getOpName());
            }
        }
    }

    @Override
    public SignHandler createHandler(boolean isInit) {
        String entityName = this.getEntityName();
        String successIdList = this.getPageCache().get(KEY_SUCCESSIDLIST);
        List payBillIdList = (List)SerializationUtils.fromJsonString((String)successIdList, List.class);
        DynamicObject[] payBillArr = BusinessDataServiceHelper.load((Object[])payBillIdList.stream().map(Object::toString).map(Long::parseLong).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
        Map<Object, List<DynamicObject>> payBillGroupByOrg = Arrays.stream(payBillArr).collect(Collectors.groupingBy(o -> o.getDynamicObject(this.getOrgPropName()).getPkValue()));
        ArrayList<DynamicObject> submitPayBillList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> auditPayBillList = new ArrayList<DynamicObject>();
        ArrayList<Object> needCommitBeIdList = new ArrayList<Object>();
        for (Map.Entry<Object, List<DynamicObject>> entry : payBillGroupByOrg.entrySet()) {
            Object orgId = entry.getKey();
            boolean isBankBillAudit = BeiParameterHelper.getAppBoolParameter((Long)orgId, "bei002");
            boolean isNeedCommitBe = BeiParameterHelper.isBizBillCommitBe((Long)orgId);
            if (isNeedCommitBe) {
                auditPayBillList.addAll((Collection<DynamicObject>)entry.getValue());
                needCommitBeIdList.addAll(entry.getValue().stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
                continue;
            }
            if (isBankBillAudit) {
                submitPayBillList.addAll((Collection<DynamicObject>)entry.getValue());
                continue;
            }
            auditPayBillList.addAll((Collection<DynamicObject>)entry.getValue());
        }
        List<ISignExecutor> executors = this.getSignExecutors(auditPayBillList, submitPayBillList, needCommitBeIdList);
        if (!EmptyUtil.isEmpty(executors)) {
            return new SignHandler(this.getView(), this, isInit, executors.toArray(new ISignExecutor[0]));
        }
        throw new IllegalArgumentException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u7b7e\u540d\u6267\u884c\u5668\u3002", (String)"SignHandler_0", (String)"tmc-fbp-common", (Object[])new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signCallback(SignCallbackEvent evt) {
        try {
            SignHandler handler = this.createHandler(false);
            handler.signCallback(evt);
            this.onSignSuccess(handler.getErrorMessage());
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            this.onSignError(e);
        }
        finally {
            String successIdList = this.getPageCache().get(KEY_SUCCESSIDLIST);
            List requestIds = (List)SerializationUtils.fromJsonString((String)successIdList, List.class);
            MutexServiceHelper.batchRelease(requestIds, this.getEntityName(), this.getOpName());
        }
    }

    protected List<Object> getPayBillIdList() {
        ArrayList<Object> payBillIdList = new ArrayList<Object>();
        BillList billList = (BillList)this.getControl("billlistap");
        if (billList != null) {
            ListSelectedRowCollection selectRows = billList.getSelectedRows();
            if (selectRows.size() == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u63d0\u4ea4\u94f6\u4f01\u7684\u6570\u636e", (String)"PayBillCrossBillSignPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            Object[] pkArr = selectRows.getPrimaryKeyValues();
            payBillIdList.addAll(Arrays.asList(pkArr));
        } else {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            Object id = dataEntity.getPkValue();
            payBillIdList.add(id);
        }
        return payBillIdList;
    }

    protected String getEntityName() {
        String entityName;
        BillList billList = (BillList)this.getControl("billlistap");
        if (billList != null) {
            entityName = billList.getEntityType().getName();
        } else {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            entityName = dataEntity.getDataEntityType().getName();
        }
        return entityName;
    }
}

