/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DynamicObjectUtil {
    private static final String MULTI_LANGUAGE_TEXT = "multilanguagetext";

    private DynamicObjectUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static void copy(DynamicObject source, DynamicObject target, String ... ignoreProperties) {
        if (Objects.isNull(source) || Objects.isNull(target)) {
            return;
        }
        DataEntityPropertyCollection srcProps = source.getDataEntityType().getProperties();
        DataEntityPropertyCollection tgtProps = target.getDataEntityType().getProperties();
        if (EmptyUtil.isEmpty((Collection)srcProps) || EmptyUtil.isEmpty((Collection)tgtProps)) {
            return;
        }
        Map<String, Object> srcPropValMap = DynamicObjectUtil.convertToNameValMap(source);
        ISimpleProperty tgtPk = target.getDataEntityType().getPrimaryKey();
        Set ignoreSet = null;
        if (Objects.nonNull(ignoreProperties)) {
            ignoreSet = Arrays.stream(ignoreProperties).collect(Collectors.toSet());
        }
        for (IDataEntityProperty tgtProp : tgtProps) {
            boolean isIgnore;
            String tgtPropName = tgtProp.getName();
            boolean isPk = Objects.nonNull(tgtPk) && tgtPropName.equals(tgtPk.getName());
            boolean bl = isIgnore = ignoreSet != null && ignoreSet.contains(tgtPropName);
            if (isPk || isIgnore || MULTI_LANGUAGE_TEXT.equals(tgtPropName)) continue;
            DynamicObjectUtil.copyValue(srcPropValMap, target, tgtPropName);
        }
    }

    public static void copy(DynamicObjectCollection sourceEntry, DynamicObjectCollection targetEntry, String ... ignoreProperties) {
        if (Objects.isNull(targetEntry)) {
            return;
        }
        if (!targetEntry.isEmpty()) {
            targetEntry.clear();
        }
        if (Objects.nonNull(sourceEntry)) {
            sourceEntry.forEach(srcEntry -> DynamicObjectUtil.copy(srcEntry, targetEntry.addNew(), ignoreProperties));
        }
    }

    public static void copyProperties(DynamicObject source, DynamicObject target, String ... properties) {
        if (Objects.isNull(source) || Objects.isNull(target) || EmptyUtil.isEmpty(properties)) {
            return;
        }
        DataEntityPropertyCollection srcProps = source.getDataEntityType().getProperties();
        DataEntityPropertyCollection tgtProps = target.getDataEntityType().getProperties();
        if (EmptyUtil.isEmpty((Collection)srcProps) || EmptyUtil.isEmpty((Collection)tgtProps)) {
            return;
        }
        Map<String, Object> srcPropValMap = DynamicObjectUtil.convertToNameValMap(source);
        Set specifiedSet = Arrays.stream(properties).collect(Collectors.toSet());
        for (IDataEntityProperty tgtProp : tgtProps) {
            String tgtPropName = tgtProp.getName();
            if (!specifiedSet.contains(tgtPropName)) continue;
            DynamicObjectUtil.copyValue(srcPropValMap, target, tgtPropName);
        }
    }

    private static Map<String, Object> convertToNameValMap(DynamicObject source) {
        DataEntityPropertyCollection srcProps = source.getDataEntityType().getProperties();
        HashMap<String, Object> nameValMap = new HashMap<String, Object>(srcProps.size());
        for (IDataEntityProperty prop : srcProps) {
            Object value = source.get(prop.getName());
            if (!Objects.nonNull(value)) continue;
            nameValMap.put(prop.getName(), value);
        }
        return nameValMap;
    }

    private static void copyValue(Map<String, Object> srcPropValMap, DynamicObject target, String propName) {
        Object value = srcPropValMap.get(propName);
        if (value instanceof DynamicObjectCollection) {
            DynamicObjectUtil.copy((DynamicObjectCollection)value, target.getDynamicObjectCollection(propName), new String[0]);
        } else {
            target.set(propName, value);
        }
    }
}

