/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.codec.binary.Base64;

public class HttpCommonUtil {
    private static final Log logger = LogFactory.getLog(HttpCommonUtil.class);

    public static String getHostFromURL(String url) {
        if (url.startsWith("http://") || url.startsWith("https://")) {
            return url.substring(url.lastIndexOf("/") + 1);
        }
        return url;
    }

    public static String HMACSHA256(byte[] data, byte[] key) {
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key, "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(signingKey);
            return HttpCommonUtil.byte2hex(mac.doFinal(data));
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Throwable)e);
        }
        catch (InvalidKeyException e) {
            logger.error((Throwable)e);
        }
        return null;
    }

    public static String HMACSHA256(String data, String key) throws Exception {
        Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
        SecretKeySpec secret_key = new SecretKeySpec(key.getBytes("UTF-8"), "HmacSHA256");
        sha256_HMAC.init(secret_key);
        byte[] array = sha256_HMAC.doFinal(data.getBytes("UTF-8"));
        StringBuilder sb = new StringBuilder();
        for (byte item : array) {
            sb.append(Integer.toHexString(item & 0xFF | 0x100).substring(1, 3));
        }
        return sb.toString().toUpperCase();
    }

    public static String sign(String method, String url, TreeMap<String, String> params, TreeMap<String, String> headers, String key) throws Exception {
        String source = method.toUpperCase() + "\n";
        source = source + URLEncoder.encode(url, "utf-8") + "\n";
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            sb.append(URLEncoder.encode(entry.getKey(), "utf-8")).append('=').append(URLEncoder.encode(entry.getValue(), "utf-8")).append('&');
        }
        String paramsString = sb.toString();
        if (paramsString.length() > 0) {
            paramsString = paramsString.substring(0, paramsString.length() - 1);
            source = source + paramsString + "\n";
        } else {
            source = source + paramsString + "\n";
        }
        sb = new StringBuilder();
        for (Map.Entry<String, String> next : headers.entrySet()) {
            String header = next.getKey();
            sb.append(header.toLowerCase()).append(":").append(headers.get(header).trim()).append("\n");
        }
        StringBuilder ssb = new StringBuilder();
        ssb.append(source);
        ssb.append((CharSequence)sb);
        return HttpCommonUtil.hmac(ssb.toString(), key);
    }

    private static String bytesToHex(byte[] hashInBytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < hashInBytes.length; ++i) {
            String hex = Integer.toHexString(hashInBytes[i] & 0xFF);
            if (hex.length() < 2) {
                hex = "0" + hex;
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    private static String byte2hex(byte[] b) {
        StringBuilder hs = new StringBuilder();
        for (int n = 0; b != null && n < b.length; ++n) {
            String stmp = Integer.toHexString(b[n] & 0xFF);
            if (stmp.length() == 1) {
                hs.append('0');
            }
            hs.append(stmp);
        }
        return hs.toString().toUpperCase();
    }

    private static String hmac(String source, String key) throws Exception {
        byte[] keyBytes = key.getBytes();
        SecretKeySpec signingKey = new SecretKeySpec(keyBytes, "HmacSHA256");
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(signingKey);
        byte[] rawHmac = mac.doFinal(source.getBytes());
        return new String(Base64.decodeBase64((byte[])HttpCommonUtil.bytesToHex(rawHmac).getBytes()));
    }

    public static int writeToOutputStream(InputStream in, OutputStream out) throws IOException {
        int len = 0;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
        return 0;
    }
}

