/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ListUtils {
    private static final String SPLIT_REGEX = ",";

    public static <T> List<List<T>> splitList(List<T> list, long splitSize) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        long maxSize = ((long)list.size() + splitSize - 1L) / splitSize;
        return ((Stream)Stream.iterate(0, n -> n + 1).limit(maxSize).parallel()).map(a -> list.parallelStream().skip((long)a.intValue() * splitSize).limit(splitSize).collect(Collectors.toList())).filter(b -> !b.isEmpty()).collect(Collectors.toList());
    }

    public static List<Integer> strToIntList(String strs, String split) {
        if (EmptyUtil.isEmpty(strs)) {
            return Collections.emptyList();
        }
        return Arrays.stream(strs.split(split)).mapToInt(Integer::parseInt).boxed().collect(Collectors.toList());
    }

    public static List<Integer> strToIntList(String strs) {
        return ListUtils.strToIntList(strs, SPLIT_REGEX);
    }

    public static List<Long> strToLongList(String strs, String split) {
        if (EmptyUtil.isEmpty(strs)) {
            return Collections.emptyList();
        }
        return Arrays.stream(strs.split(split)).mapToLong(Long::parseLong).boxed().collect(Collectors.toList());
    }

    public static List<Long> strToLongList(String strs) {
        return ListUtils.strToLongList(strs, SPLIT_REGEX);
    }
}

