/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.util;

import java.io.IOException;
import java.util.Enumeration;
import javax.xml.parsers.DocumentBuilderFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.bean.Receipt;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OFDReceiptUtils {
    private static final Log logger = LogFactory.getLog(OFDReceiptUtils.class);

    public Receipt parseOFDStructuredData(String patchPath) throws IOException {
        Receipt receipt = new Receipt();
        ZipFile zipFile = new ZipFile(patchPath);
        logger.info("\u5f00\u59cb\u89e3\u6790OFD\u6587\u4ef6\uff1a{}", (Object)patchPath);
        Enumeration e = zipFile.getEntries();
        while (e.hasMoreElements()) {
            ZipEntry entry = (ZipEntry)e.nextElement();
            if (entry.isDirectory() || entry.getName().endsWith("Attachments.xml") || !entry.getName().startsWith("Doc_0/Attachs/")) continue;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance("com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl", null);
            try {
                factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                Document document = factory.newDocumentBuilder().parse(zipFile.getInputStream(entry));
                Element root = document.getDocumentElement();
                String IdCode = this.getIsCanNullData(root, "bker:IdentifyingCode");
                logger.info("\u7535\u5b50\u56de\u5355\u6821\u9a8c\u7801\uff1a" + IdCode);
                receipt.setValidcode(IdCode);
            }
            catch (Exception ex) {
                logger.error("OFDReceiptUtils-ex:" + ex);
            }
        }
        return receipt;
    }

    private String getIsCanNullData(Element root, String tagName) {
        Node item = root.getElementsByTagName(tagName).item(0);
        if (item == null) {
            return "";
        }
        return item.getTextContent();
    }
}

