/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.util;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.xml.parsers.DocumentBuilderFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.bean.Reconciliation;
import kd.tmc.fbp.common.bean.ReconciliationRecord;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OFDReconciliationUtils {
    private static final Log logger = LogFactory.getLog(OFDReconciliationUtils.class);

    public Reconciliation parseOFDStructuredData(String patchPath) throws IOException {
        ArrayList<ReconciliationRecord> reconciliationRecords = new ArrayList<ReconciliationRecord>(16);
        Reconciliation reconciliation = new Reconciliation();
        ZipFile zipFile = new ZipFile(patchPath);
        logger.info("\u5f00\u59cb\u89e3\u6790OFD\u6587\u4ef6\uff1a{}", (Object)patchPath);
        Enumeration e = zipFile.getEntries();
        while (e.hasMoreElements()) {
            ZipEntry entry = (ZipEntry)e.nextElement();
            if (entry.isDirectory() || entry.getName().endsWith("Attachments.xml") || !entry.getName().startsWith("Doc_0/Attachs/")) continue;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance("com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl", null);
            try {
                factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                Document document = factory.newDocumentBuilder().parse(zipFile.getInputStream(entry));
                Element root = document.getDocumentElement();
                String accNo = this.getIsCanNullData(root, "bkrs:CustomerSettlementBankAccount");
                String year = this.getIsCanNullData(root, "bkrs:YearOfBankReconciliationStatement");
                String month = this.getIsCanNullData(root, "bkrs:MonthOfBankReconciliationStatement");
                String headCurrency = this.getIsCanNullData(root, "bkrs:Currency");
                String bankBranch = this.getIsCanNullData(root, "bkrs:NumberOfBankBranch");
                String accName = this.getIsCanNullData(root, "bkrs:NameOfCustomerAccount");
                String identificationCode = this.getIsCanNullData(root, "bkrs:IdentificationCodeOfIssuer");
                String codeCustomer = this.getIsCanNullData(root, "bkrs:CodeOfBankCustomer");
                String reserveBalance = this.getIsCanNullData(root, "bkrs:ReserveBalanceAtTheEndOfReconciliationCycle");
                String headAccountBalance = this.getIsCanNullData(root, "bkrs:AccountBalanceAtTheEndOfReconciliationCycleAmount");
                String overdraftBalance = this.getIsCanNullData(root, "bkrs:OverdraftBalanceAtEndOfReconciliationCycle");
                String frozenBalance = this.getIsCanNullData(root, "bkrs:FrozenBalanceAtTheEndOfReconciliationCycle");
                String availableBalance = this.getIsCanNullData(root, "bkrs:AvailableBalanceAtTheEndOfReconciliationCycleAmount");
                reconciliation.setAccNo(accNo);
                reconciliation.setAccName(accName);
                reconciliation.setYear(EmptyUtil.isNoEmpty(year) ? year.substring(0, 4) : year);
                reconciliation.setMonth(EmptyUtil.isNoEmpty(month) ? month.substring(0, 2) : month);
                reconciliation.setCurrency(headCurrency);
                reconciliation.setBankBranch(bankBranch);
                reconciliation.setIdentificationCode(identificationCode);
                reconciliation.setCodeCustomer(codeCustomer);
                reconciliation.setReserveBalance(reserveBalance);
                reconciliation.setAccountBalance(headAccountBalance);
                reconciliation.setOverdraftBalance(overdraftBalance);
                reconciliation.setFrozenBalance(frozenBalance);
                reconciliation.setAvailableBalance(availableBalance);
                NodeList nodeList = root.getElementsByTagName("bkrs:InformationOfReconcileDetailsTuple");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element node = (Element)nodeList.item(i);
                    String transDate = this.getIsCanNullData(node, "bkrs:DateOfBookkeeping");
                    String remark = this.getIsCanNullData(node, "bkrs:NotesOfBankElectronicReceipt");
                    String transactionAmount = this.getIsCanNullData(node, "bkrs:TransactionAmount");
                    String accountBalance = this.getIsCanNullData(node, "bkrs:AccountBalance");
                    String currency = ((Element)node.getElementsByTagName("bkrs:AccountBalance").item(0)).getAttribute("unitRef");
                    String accountOfCounterparty = this.getIsCanNullData(node, "bkrs:AccountOfCounterparty");
                    String nameOfCounterparty = this.getIsCanNullData(node, "bkrs:NameOfCounterparty");
                    String timeOfBookkeeping = this.getIsCanNullData(node, "bkrs:TimeOfBookkeeping");
                    String journalAccountOfBookkeeping = this.getIsCanNullData(node, "bkrs:JournalAccountOfBookkeeping");
                    String numberOfSourceDocument = this.getIsCanNullData(node, "bkrs:NumberOfSourceDocument");
                    String typesOfBusinessProducts = this.getIsCanNullData(node, "bkrs:TypesOfBusinessProducts");
                    String typeOfSourceDocument = this.getIsCanNullData(node, "bkrs:TypeOfSourceDocument");
                    String identificationOfCreditOrDebit = this.getIsCanNullData(node, "bkrs:IdentificationOfCreditOrDebit");
                    String debitOrCreditOfBalance = this.getIsCanNullData(node, "bkrs:DebitOrCreditOfBalance");
                    String transactionCode = this.getIsCanNullData(node, "bkrs:TransactionCode");
                    String bookkeeper = this.getIsCanNullData(node, "bkrs:Bookkeeper");
                    String otherAccountingInformation = this.getIsCanNullData(node, "bkrs:OtherAccountingInformation");
                    String numberOfBankElectronicReceipt = this.getIsCanNullData(node, "bkrs:NumberOfBankElectronicReceipt");
                    String businessSerialNumber = this.getIsCanNullData(node, "bkrs:BusinessSerialNumber");
                    ReconciliationRecord detail = new ReconciliationRecord();
                    detail.setOppAccNo(accountOfCounterparty);
                    detail.setOppAccName(nameOfCounterparty);
                    detail.setAccNo(accNo);
                    detail.setCurrency(currency);
                    BigDecimal transBigAmount = BigDecimal.ZERO;
                    if (!EmptyUtil.isEmpty(transactionAmount)) {
                        transBigAmount = new BigDecimal(transactionAmount).setScale(2, RoundingMode.HALF_UP);
                    } else {
                        logger.info("{}-\u6d41\u6c34\u53f7\u4e3a\uff1a{}-\u8bb0\u5f55\u4e2d\u6ca1\u6709\u4ea4\u6613\u91d1\u989d-ofd\u6587\u4ef6\u5185\u5bb9\uff1a\n{}", (Object)detail.getAccNo(), (Object)detail.getJournalAccountOfBookkeeping());
                    }
                    detail.setTransactionAmount(transBigAmount);
                    detail.setTransDate(transDate);
                    detail.setTransTime(transDate + " " + timeOfBookkeeping);
                    detail.setTypesOfBusinessProducts(typesOfBusinessProducts);
                    detail.setTypeOfSourceDocument(typeOfSourceDocument);
                    detail.setNumberOfSourceDocument(numberOfSourceDocument);
                    detail.setJournalAccountOfBookkeeping(journalAccountOfBookkeeping);
                    detail.setIdentificationOfCreditOrDebit(identificationOfCreditOrDebit);
                    detail.setDebitOrCreditOfBalance(debitOrCreditOfBalance);
                    detail.setAccountBalance(accountBalance);
                    detail.setTransactionCode(transactionCode);
                    detail.setBookkeeper(bookkeeper);
                    detail.setOtherAccountingInformation(otherAccountingInformation);
                    detail.setNumberOfBankElectronicReceipt(numberOfBankElectronicReceipt);
                    detail.setBusinessSerialNumber(businessSerialNumber);
                    if (EmptyUtil.isEmpty(detail.getOppAccNo()) || EmptyUtil.isEmpty(detail.getOppAccName())) {
                        logger.info("\u94f6\u884cofd\u6587\u4ef6\u4e2d\u4e0d\u5305\u542b\u5bf9\u65b9\u8d26\u6237\u4fe1\u606f-\u8d26\u6237\uff1a{}-\u6587\u4ef6\u540d\uff1a{}-ofd\u6587\u4ef6\u5185\u5bb9\uff1a\n{}", (Object)detail.getAccNo());
                    }
                    detail.setNote(remark);
                    reconciliationRecords.add(detail);
                }
                logger.info("\u56de\u5199\u56de\u5355\u8bb0\u5f55---{}", (Object)JSONObject.toJSONString(reconciliationRecords));
                reconciliation.setDetails(reconciliationRecords);
            }
            catch (Exception ex) {
                logger.info("OFDReconciliationUtils-ex:" + ex);
            }
        }
        return reconciliation;
    }

    private String getIsCanNullData(Element root, String tagName) {
        Node item = root.getElementsByTagName(tagName).item(0);
        if (item == null) {
            return "";
        }
        return item.getTextContent();
    }
}

