/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.util;

import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.codec.binary.Base64;

public class StringUtils {
    public static final String SPLIT_DELIMITER = ",";
    public static final String JOIN_SYMBOL = ".";

    public static String formatString(String msg, Object[] params) {
        return MessageFormat.format(msg, params);
    }

    public static String setToString(Set valueSet) {
        if (EmptyUtil.isEmpty(valueSet)) {
            return "('null')";
        }
        return "(" + valueSet.stream().filter(v -> !EmptyUtil.isEmpty(v)).map(v -> "'" + v.toString() + "'").collect(Collectors.joining(SPLIT_DELIMITER)) + ")";
    }

    public static String splitString(String number, int step, String split) {
        String value = null;
        if (!EmptyUtil.isEmpty(number)) {
            while (number.length() > 0) {
                int cutStep = step;
                if (step > number.length()) {
                    cutStep = number.length();
                }
                value = EmptyUtil.isEmpty(value) ? number.substring(0, cutStep) : value + split + number.substring(0, cutStep);
                number = number.substring(cutStep);
            }
        }
        return value;
    }

    public static String listToString(List<String> fliedList) {
        if (fliedList.size() == 0) {
            throw new IllegalArgumentException("intList.size cannot be 0!");
        }
        return String.join((CharSequence)", ", fliedList);
    }

    public static String toBase64String(byte[] bytes) {
        String result = null;
        try {
            result = new String(Base64.encodeBase64((byte[])bytes), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result;
    }

    public static byte[] decodeBase64(String base64String) {
        return Base64.decodeBase64((String)base64String);
    }

    public static Object[] getPks(DynamicObject[] objArray) {
        if (objArray == null || objArray.length == 0) {
            return new Object[0];
        }
        Object[] pks = new Object[objArray.length];
        for (int i = 0; i < objArray.length; ++i) {
            pks[i] = objArray[i].getPkValue();
        }
        return pks;
    }

    public static Object[] getPks(DynamicObjectCollection objArray) {
        if (objArray == null || objArray.size() == 0) {
            return new Object[0];
        }
        Object[] pks = new Object[objArray.size()];
        for (int i = 0; i < objArray.size(); ++i) {
            pks[i] = ((DynamicObject)objArray.get(i)).getPkValue();
        }
        return pks;
    }

    public static String joinStr(String prefix, String ... elements) {
        return StringUtils.joinStr(prefix, Arrays.asList(elements));
    }

    public static String joinStr(String prefix, List<String> elements) {
        return elements.stream().map(s -> prefix + JOIN_SYMBOL + s).collect(Collectors.joining(SPLIT_DELIMITER));
    }

    public static String join(String ... elements) {
        return String.join((CharSequence)SPLIT_DELIMITER, elements);
    }
}

