/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.util;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TermUtils {
    public static final String YEAR = "y";
    public static final String MONTH = "m";
    public static final String DAY = "d";

    public static Matcher getMatcher(String value) {
        String pattern = "([0-9]{1,3}y)?([0-9]{1,4}m)?([0-9]{1,5}d)?";
        Pattern r = Pattern.compile(pattern);
        Matcher Matcher2 = r.matcher(value);
        return Matcher2;
    }

    public static boolean isRightFormat(IDataModel model, IFormView view, String value) {
        Matcher Matcher2 = TermUtils.getMatcher(value);
        if (!Matcher2.matches()) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u65e5\u671f\u95f4\u9694\u683c\u5f0f\u4e0d\u6b63\u786e:**y**m**d\u3002", (String)"TermUtils_0", (String)"tmc-fbp-common", (Object[])new Object[0]));
            return false;
        }
        BigDecimal year = Constants.ZERO;
        BigDecimal month = Constants.ZERO;
        BigDecimal day = Constants.ZERO;
        if (!EmptyUtil.isEmpty(Matcher2.group(1)) && (year = new BigDecimal(Matcher2.group(1).split(YEAR)[0])).compareTo(Constants.ONE_HUNDRED) > 0) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u671f\u9650\u4e0d\u80fd\u5927\u4e8e100y", (String)"TermUtils_1", (String)"tmc-fbp-common", (Object[])new Object[0]));
            return false;
        }
        if (!EmptyUtil.isEmpty(Matcher2.group(2)) && (month = new BigDecimal(Matcher2.group(2).split(MONTH)[0])).compareTo(new BigDecimal(1200)) > 0) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u671f\u9650\u4e0d\u80fd\u5927\u4e8e1200m", (String)"TermUtils_2", (String)"tmc-fbp-common", (Object[])new Object[0]));
            return false;
        }
        if (!EmptyUtil.isEmpty(Matcher2.group(3)) && (day = new BigDecimal(Matcher2.group(3).split(DAY)[0])).compareTo(new BigDecimal(36600)) > 0) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u671f\u9650\u4e0d\u80fd\u5927\u4e8e36600d", (String)"TermUtils_3", (String)"tmc-fbp-common", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public static Map<String, Integer> getYMD(String value) {
        Matcher Matcher2 = TermUtils.getMatcher(value.trim());
        int year = 0;
        int month = 0;
        int day = 0;
        if (Matcher2.find()) {
            if (!EmptyUtil.isEmpty(Matcher2.group(1))) {
                year = Integer.parseInt(Matcher2.group(1).split(YEAR)[0]);
            }
            if (!EmptyUtil.isEmpty(Matcher2.group(2))) {
                month = Integer.parseInt(Matcher2.group(2).split(MONTH)[0]);
            }
            if (!EmptyUtil.isEmpty(Matcher2.group(3))) {
                day = Integer.parseInt(Matcher2.group(3).split(DAY)[0]);
            }
            HashMap<String, Integer> result = new HashMap<String, Integer>();
            result.put(YEAR, year);
            result.put(MONTH, month);
            result.put(DAY, day);
            return result;
        }
        throw new TmcBizException(TmcErrorCode.COMMON, new Object[]{ResManager.loadKDString((String)"\u65f6\u95f4\u95f4\u9694\u683c\u5f0f\u6709\u8bef", (String)"TermUtils_4", (String)"tmc-fbp-common", (Object[])new Object[0])});
    }

    public static int transToMonth(String value) {
        Map<String, Integer> result = TermUtils.getYMD(value);
        int month = result.get(MONTH);
        int year = result.get(YEAR);
        return year * 12 + month;
    }

    public static String getFormatStr(int year, int month, int day) {
        StringBuilder str = new StringBuilder();
        if (year != 0) {
            str.append(year).append(YEAR);
        }
        if (month != 0) {
            str.append(month).append(MONTH);
        }
        if (day != 0) {
            str.append(day).append(DAY);
        }
        return str.toString();
    }

    public static Date getDateByBaseDate4ymd(String value, Date basedate) {
        Map<String, Integer> ymd = TermUtils.getYMD(value);
        Calendar temp = Calendar.getInstance();
        temp.setTime(basedate);
        temp.add(1, ymd.get(YEAR));
        temp.add(2, ymd.get(MONTH));
        temp.add(5, ymd.get(DAY));
        return temp.getTime();
    }

    public static Date getLastDateByBaseDate4ymd(String value, Date basedate) {
        Map<String, Integer> ymd = TermUtils.getYMD(value);
        Calendar temp = Calendar.getInstance();
        temp.setTime(basedate);
        temp.add(1, -ymd.get(YEAR).intValue());
        temp.add(2, -ymd.get(MONTH).intValue());
        temp.add(5, -ymd.get(DAY).intValue());
        return temp.getTime();
    }

    public static Date getNextDateByBaseDate4ymd(String value, Date basedate) {
        Map<String, Integer> ymd = TermUtils.getYMD(value);
        Calendar temp = Calendar.getInstance();
        temp.setTime(basedate);
        temp.add(1, ymd.get(YEAR));
        temp.add(2, ymd.get(MONTH));
        temp.add(5, ymd.get(DAY));
        return temp.getTime();
    }

    public static Date getDateByTerm(String termStr, Date date) {
        return TermUtils.getNextDateByBaseDate4ymd(termStr, date);
    }

    public static String getIntervalByTerm(String termStr) {
        Map<String, Integer> ymd = TermUtils.getYMD(termStr);
        if (EmptyUtil.isNoEmpty(ymd.get(DAY)) && ymd.get(DAY) != 0) {
            return "1d";
        }
        if (EmptyUtil.isNoEmpty(ymd.get(MONTH)) && ymd.get(MONTH) != 0 && ymd.get(MONTH) < 3) {
            return "1m";
        }
        if (EmptyUtil.isNoEmpty(ymd.get(MONTH)) && ymd.get(MONTH) != 0 && ymd.get(MONTH) >= 3 && ymd.get(MONTH) < 6) {
            return "3m";
        }
        return "6m";
    }

    public static int getFrequency(String termStr) {
        Map<String, Integer> ymd = TermUtils.getYMD(termStr);
        if (EmptyUtil.isNoEmpty(ymd.get(YEAR)) && ymd.get(YEAR) != 0) {
            return 1 / ymd.get(YEAR);
        }
        if (EmptyUtil.isNoEmpty(ymd.get(MONTH)) && ymd.get(MONTH) != 0) {
            return 12 / ymd.get(MONTH);
        }
        return 0;
    }
}

